package org.eclipse.che.plugin.java.languageserver.dto;
import org.eclipse.che.dto.server.DtoFactoryVisitor;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.dto.server.DtoProvider;
import org.eclipse.che.dto.server.JsonSerializable;
import java.io.Writer;
import java.io.IOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.util.Map.Entry;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.che.api.languageserver.util.EitherUtil;
import org.eclipse.che.api.languageserver.util.JsonUtil;
import org.eclipse.che.api.languageserver.shared.util.JsonDecision;
import org.eclipse.che.jdt.ls.extension.api.dto.CreateMoveParams;
import org.eclipse.che.jdt.ls.extension.api.dto.TestFindParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport;
import org.eclipse.che.jdt.ls.extension.api.dto.JavaProjectStructure;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation;
import org.eclipse.che.jdt.ls.extension.api.dto.ReImportMavenProjectsCommandParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot;
import org.eclipse.lsp4j.ResourceChange;
import org.eclipse.che.jdt.ls.extension.api.dto.LinearRange;
import org.eclipse.che.jdt.ls.extension.api.dto.JavaCoreOptions;
import org.eclipse.che.jdt.ls.extension.api.dto.SearchResult;
import org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit;
import org.eclipse.che.jdt.ls.extension.api.dto.RenameSettings;
import org.eclipse.che.jdt.ls.extension.api.dto.JarEntry;
import org.eclipse.che.jdt.ls.extension.api.dto.RenameSelectionParams;
import org.eclipse.che.jdt.ls.extension.api.dto.UpdateClasspathParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.Resource;
import org.eclipse.che.jdt.ls.extension.api.dto.JobResult;
import org.eclipse.che.jdt.ls.extension.api.dto.UpdateMavenModulesInfo;
import org.eclipse.che.jdt.ls.extension.api.dto.ExternalLibrariesParameters;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.che.jdt.ls.extension.api.dto.FileStructureCommandParameters;
import org.eclipse.che.jdt.ls.extension.api.dto.TestPosition;
import org.eclipse.che.jdt.ls.extension.api.dto.TestPositionParameters;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment;
import org.eclipse.che.jdt.ls.extension.api.dto.ImplementersResponse;
import org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry;
import org.eclipse.che.jdt.ls.extension.api.dto.MoveSettings;
import org.eclipse.che.jdt.ls.extension.api.dto.ResourceLocation;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.che.jdt.ls.extension.api.dto.Jar;
import org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportParams;
import org.eclipse.che.jdt.ls.extension.api.dto.RenamingElementInfo;
import org.eclipse.che.jdt.ls.extension.api.dto.RefactoringResult;
import org.eclipse.lsp4j.Range;
import org.eclipse.che.jdt.ls.extension.api.dto.StatusReport;
import org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus;
import org.eclipse.lsp4j.Position;
import org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportsResult;
import org.eclipse.che.jdt.ls.extension.api.dto.UsagesResponse;
import org.eclipse.che.jdt.ls.extension.api.dto.JdtLsPreferences;
import org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry;

@SuppressWarnings(value= {"serial", "deprecation"})
public class DtoServerImpls implements DtoFactoryVisitor {
    public static class CreateMoveParamsDto extends CreateMoveParams implements JsonSerializable {

        public CreateMoveParamsDto() {
        }

        public CreateMoveParamsDto(org.eclipse.che.jdt.ls.extension.api.dto.CreateMoveParams o) {
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
            if (o.getResources() == null) {
                setResources((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource> resourcesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.Resource resourcesValX : o.getResources()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.Resource resourcesValY = new ResourceDto(resourcesValX);
                        resourcesVal.add(resourcesValY);
                    }
                setResources((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)resourcesVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JsonElement projectUriVal = getProjectUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getProjectUri());;
                result.add("projectUri", projectUriVal);
            }
            if (getResources() == null) {
                setResources((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)null);
            } else {
                JsonArray resourcesVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.Resource resourcesValX : getResources()) {
                    JsonElement resourcesValY = resourcesValX == null ? JsonNull.INSTANCE : ((ResourceDto)resourcesValX).toJsonElement();;
                    resourcesVal.add(resourcesValY);
                }
                result.add("resources", resourcesVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static CreateMoveParamsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static CreateMoveParamsDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            CreateMoveParamsDto result= new CreateMoveParamsDto();
            JsonElement jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isJsonNull())) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.getAsString();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            JsonElement jsonresourcesJson = json.get("resources");
            if (jsonresourcesJson != null && !(jsonresourcesJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource> jsonresourcesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource>();
                JsonArray jsonresourcesVala = jsonresourcesJson.getAsJsonArray();
                for(int jsonresourcesValai= 0; jsonresourcesValai < jsonresourcesVala.size(); jsonresourcesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.Resource jsonresourcesValaX = ResourceDto.fromJson((JsonObject)jsonresourcesVala.get(jsonresourcesValai));;
                    jsonresourcesVal.add(jsonresourcesValaX);
                }
                result.setResources((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)jsonresourcesVal);
            }
            return result;
        }
    }

    public static class CreateMoveParamsDtoProvider implements DtoProvider<CreateMoveParamsDto> {
    	public Class<? extends CreateMoveParamsDto> getImplClass() {
    	  	return CreateMoveParamsDto.class;
    	}
    
    	public CreateMoveParamsDto newInstance() {
        	return new CreateMoveParamsDto();
    	}
    
    	public CreateMoveParamsDto fromJson(String json) {
    		return CreateMoveParamsDto.fromJson(json);
    	}
        public CreateMoveParamsDto fromJson(JsonElement json) {
    		return CreateMoveParamsDto.fromJson(json);
    	}
        public CreateMoveParamsDto clone(CreateMoveParamsDto dto) {
            return CreateMoveParamsDto.fromJson(dto.toJson());
    	}
    }

    public static class TestFindParametersDto extends TestFindParameters implements JsonSerializable {

        public TestFindParametersDto() {
        }

        public TestFindParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.TestFindParameters o) {
            if (o.getSourceUri() == null) {
                setSourceUri((java.lang.String)null);
            } else {
                java.lang.String sourceUriVal = (java.lang.String)makeDto(o.getSourceUri());;
                setSourceUri((java.lang.String)sourceUriVal);
            }
            if (o.getTestMethodAnnotation() == null) {
                setTestMethodAnnotation((java.lang.String)null);
            } else {
                java.lang.String testMethodAnnotationVal = (java.lang.String)makeDto(o.getTestMethodAnnotation());;
                setTestMethodAnnotation((java.lang.String)testMethodAnnotationVal);
            }
            if (o.getTestClassAnnotation() == null) {
                setTestClassAnnotation((java.lang.String)null);
            } else {
                java.lang.String testClassAnnotationVal = (java.lang.String)makeDto(o.getTestClassAnnotation());;
                setTestClassAnnotation((java.lang.String)testClassAnnotationVal);
            }
                int cursorOffsetVal = (int)makeDto(o.getCursorOffset());;
                setCursorOffset((int)cursorOffsetVal);
            if (o.getEntryClasses() == null) {
                setEntryClasses((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> entryClassesVal= new ArrayList<java.lang.String>();
                    for (java.lang.String entryClassesValX : o.getEntryClasses()) {
                        java.lang.String entryClassesValY = (java.lang.String)makeDto(entryClassesValX);;
                        entryClassesVal.add(entryClassesValY);
                    }
                setEntryClasses((java.util.List<java.lang.String>)entryClassesVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getSourceUri() == null) {
                setSourceUri((java.lang.String)null);
            } else {
                JsonElement sourceUriVal = getSourceUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getSourceUri());;
                result.add("sourceUri", sourceUriVal);
            }
            if (getTestMethodAnnotation() == null) {
                setTestMethodAnnotation((java.lang.String)null);
            } else {
                JsonElement testMethodAnnotationVal = getTestMethodAnnotation() == null ? JsonNull.INSTANCE : new JsonPrimitive(getTestMethodAnnotation());;
                result.add("testMethodAnnotation", testMethodAnnotationVal);
            }
            if (getTestClassAnnotation() == null) {
                setTestClassAnnotation((java.lang.String)null);
            } else {
                JsonElement testClassAnnotationVal = getTestClassAnnotation() == null ? JsonNull.INSTANCE : new JsonPrimitive(getTestClassAnnotation());;
                result.add("testClassAnnotation", testClassAnnotationVal);
            }
            JsonElement cursorOffsetVal = new JsonPrimitive(getCursorOffset());;
                result.add("cursorOffset", cursorOffsetVal);
            if (getEntryClasses() == null) {
                setEntryClasses((java.util.List<java.lang.String>)null);
            } else {
                JsonArray entryClassesVal = new JsonArray();
                for (java.lang.String entryClassesValX : getEntryClasses()) {
                    JsonElement entryClassesValY = entryClassesValX == null ? JsonNull.INSTANCE : new JsonPrimitive(entryClassesValX);;
                    entryClassesVal.add(entryClassesValY);
                }
                result.add("entryClasses", entryClassesVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static TestFindParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static TestFindParametersDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            TestFindParametersDto result= new TestFindParametersDto();
            JsonElement jsonsourceUriJson = json.get("sourceUri");
            if (jsonsourceUriJson != null && !(jsonsourceUriJson.isJsonNull())) {
                java.lang.String jsonsourceUriVal = jsonsourceUriJson.getAsString();;
                result.setSourceUri((java.lang.String)jsonsourceUriVal);
            }
            JsonElement jsontestMethodAnnotationJson = json.get("testMethodAnnotation");
            if (jsontestMethodAnnotationJson != null && !(jsontestMethodAnnotationJson.isJsonNull())) {
                java.lang.String jsontestMethodAnnotationVal = jsontestMethodAnnotationJson.getAsString();;
                result.setTestMethodAnnotation((java.lang.String)jsontestMethodAnnotationVal);
            }
            JsonElement jsontestClassAnnotationJson = json.get("testClassAnnotation");
            if (jsontestClassAnnotationJson != null && !(jsontestClassAnnotationJson.isJsonNull())) {
                java.lang.String jsontestClassAnnotationVal = jsontestClassAnnotationJson.getAsString();;
                result.setTestClassAnnotation((java.lang.String)jsontestClassAnnotationVal);
            }
            JsonElement jsoncursorOffsetJson = json.get("cursorOffset");
            if (jsoncursorOffsetJson != null && !(jsoncursorOffsetJson.isJsonNull())) {
                int jsoncursorOffsetVal = (int)jsoncursorOffsetJson.getAsDouble();;
                result.setCursorOffset((int)jsoncursorOffsetVal);
            }
            JsonElement jsonentryClassesJson = json.get("entryClasses");
            if (jsonentryClassesJson != null && !(jsonentryClassesJson.isJsonNull())) {
                ArrayList<java.lang.String> jsonentryClassesVal= new ArrayList<java.lang.String>();
                JsonArray jsonentryClassesVala = jsonentryClassesJson.getAsJsonArray();
                for(int jsonentryClassesValai= 0; jsonentryClassesValai < jsonentryClassesVala.size(); jsonentryClassesValai++) {
                    java.lang.String jsonentryClassesValaX = jsonentryClassesVala.get(jsonentryClassesValai).getAsString();;
                    jsonentryClassesVal.add(jsonentryClassesValaX);
                }
                result.setEntryClasses((java.util.List<java.lang.String>)jsonentryClassesVal);
            }
            return result;
        }
    }

    public static class TestFindParametersDtoProvider implements DtoProvider<TestFindParametersDto> {
    	public Class<? extends TestFindParametersDto> getImplClass() {
    	  	return TestFindParametersDto.class;
    	}
    
    	public TestFindParametersDto newInstance() {
        	return new TestFindParametersDto();
    	}
    
    	public TestFindParametersDto fromJson(String json) {
    		return TestFindParametersDto.fromJson(json);
    	}
        public TestFindParametersDto fromJson(JsonElement json) {
    		return TestFindParametersDto.fromJson(json);
    	}
        public TestFindParametersDto clone(TestFindParametersDto dto) {
            return TestFindParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class ProgressReportDto extends ProgressReport implements JsonSerializable {

        public ProgressReportDto() {
        }

        public ProgressReportDto(org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport o) {
            if (o.getTask() == null) {
                setTask((java.lang.String)null);
            } else {
                java.lang.String taskVal = (java.lang.String)makeDto(o.getTask());;
                setTask((java.lang.String)taskVal);
            }
                boolean completeVal = (boolean)makeDto(o.isComplete());;
                setComplete((boolean)completeVal);
                int totalWorkVal = (int)makeDto(o.getTotalWork());;
                setTotalWork((int)totalWorkVal);
                int workDoneVal = (int)makeDto(o.getWorkDone());;
                setWorkDone((int)workDoneVal);
            if (o.getSubTask() == null) {
                setSubTask((java.lang.String)null);
            } else {
                java.lang.String subTaskVal = (java.lang.String)makeDto(o.getSubTask());;
                setSubTask((java.lang.String)subTaskVal);
            }
            if (o.getId() == null) {
                setId((java.lang.String)null);
            } else {
                java.lang.String idVal = (java.lang.String)makeDto(o.getId());;
                setId((java.lang.String)idVal);
            }
            if (o.getStatus() == null) {
                setStatus((java.lang.String)null);
            } else {
                java.lang.String statusVal = (java.lang.String)makeDto(o.getStatus());;
                setStatus((java.lang.String)statusVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getTask() == null) {
                setTask((java.lang.String)null);
            } else {
                JsonElement taskVal = getTask() == null ? JsonNull.INSTANCE : new JsonPrimitive(getTask());;
                result.add("task", taskVal);
            }
            JsonElement completeVal = new JsonPrimitive(isComplete());;
                result.add("complete", completeVal);
            JsonElement totalWorkVal = new JsonPrimitive(getTotalWork());;
                result.add("totalWork", totalWorkVal);
            JsonElement workDoneVal = new JsonPrimitive(getWorkDone());;
                result.add("workDone", workDoneVal);
            if (getSubTask() == null) {
                setSubTask((java.lang.String)null);
            } else {
                JsonElement subTaskVal = getSubTask() == null ? JsonNull.INSTANCE : new JsonPrimitive(getSubTask());;
                result.add("subTask", subTaskVal);
            }
            if (getId() == null) {
                setId((java.lang.String)null);
            } else {
                JsonElement idVal = getId() == null ? JsonNull.INSTANCE : new JsonPrimitive(getId());;
                result.add("id", idVal);
            }
            if (getStatus() == null) {
                setStatus((java.lang.String)null);
            } else {
                JsonElement statusVal = getStatus() == null ? JsonNull.INSTANCE : new JsonPrimitive(getStatus());;
                result.add("status", statusVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ProgressReportDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static ProgressReportDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            ProgressReportDto result= new ProgressReportDto();
            JsonElement jsontaskJson = json.get("task");
            if (jsontaskJson != null && !(jsontaskJson.isJsonNull())) {
                java.lang.String jsontaskVal = jsontaskJson.getAsString();;
                result.setTask((java.lang.String)jsontaskVal);
            }
            JsonElement jsoncompleteJson = json.get("complete");
            if (jsoncompleteJson != null && !(jsoncompleteJson.isJsonNull())) {
                boolean jsoncompleteVal = jsoncompleteJson.getAsBoolean();
                result.setComplete((boolean)jsoncompleteVal);
            }
            JsonElement jsontotalWorkJson = json.get("totalWork");
            if (jsontotalWorkJson != null && !(jsontotalWorkJson.isJsonNull())) {
                int jsontotalWorkVal = (int)jsontotalWorkJson.getAsDouble();;
                result.setTotalWork((int)jsontotalWorkVal);
            }
            JsonElement jsonworkDoneJson = json.get("workDone");
            if (jsonworkDoneJson != null && !(jsonworkDoneJson.isJsonNull())) {
                int jsonworkDoneVal = (int)jsonworkDoneJson.getAsDouble();;
                result.setWorkDone((int)jsonworkDoneVal);
            }
            JsonElement jsonsubTaskJson = json.get("subTask");
            if (jsonsubTaskJson != null && !(jsonsubTaskJson.isJsonNull())) {
                java.lang.String jsonsubTaskVal = jsonsubTaskJson.getAsString();;
                result.setSubTask((java.lang.String)jsonsubTaskVal);
            }
            JsonElement jsonidJson = json.get("id");
            if (jsonidJson != null && !(jsonidJson.isJsonNull())) {
                java.lang.String jsonidVal = jsonidJson.getAsString();;
                result.setId((java.lang.String)jsonidVal);
            }
            JsonElement jsonstatusJson = json.get("status");
            if (jsonstatusJson != null && !(jsonstatusJson.isJsonNull())) {
                java.lang.String jsonstatusVal = jsonstatusJson.getAsString();;
                result.setStatus((java.lang.String)jsonstatusVal);
            }
            return result;
        }
    }

    public static class ProgressReportDtoProvider implements DtoProvider<ProgressReportDto> {
    	public Class<? extends ProgressReportDto> getImplClass() {
    	  	return ProgressReportDto.class;
    	}
    
    	public ProgressReportDto newInstance() {
        	return new ProgressReportDto();
    	}
    
    	public ProgressReportDto fromJson(String json) {
    		return ProgressReportDto.fromJson(json);
    	}
        public ProgressReportDto fromJson(JsonElement json) {
    		return ProgressReportDto.fromJson(json);
    	}
        public ProgressReportDto clone(ProgressReportDto dto) {
            return ProgressReportDto.fromJson(dto.toJson());
    	}
    }

    public static class JavaProjectStructureDto extends JavaProjectStructure implements JsonSerializable {

        public JavaProjectStructureDto() {
        }

        public JavaProjectStructureDto(org.eclipse.che.jdt.ls.extension.api.dto.JavaProjectStructure o) {
            if (o.getPackageRoots() == null) {
                setPackageRoots((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot> packageRootsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot packageRootsValX : o.getPackageRoots()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot packageRootsValY = new PackageFragmentRootDto(packageRootsValX);
                        packageRootsVal.add(packageRootsValY);
                    }
                setPackageRoots((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>)packageRootsVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getPackageRoots() == null) {
                setPackageRoots((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>)null);
            } else {
                JsonArray packageRootsVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot packageRootsValX : getPackageRoots()) {
                    JsonElement packageRootsValY = packageRootsValX == null ? JsonNull.INSTANCE : ((PackageFragmentRootDto)packageRootsValX).toJsonElement();;
                    packageRootsVal.add(packageRootsValY);
                }
                result.add("packageRoots", packageRootsVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JsonElement uriVal = getUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getUri());;
                result.add("uri", uriVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JsonElement nameVal = getName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getName());;
                result.add("name", nameVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JavaProjectStructureDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static JavaProjectStructureDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            JavaProjectStructureDto result= new JavaProjectStructureDto();
            JsonElement jsonpackageRootsJson = json.get("packageRoots");
            if (jsonpackageRootsJson != null && !(jsonpackageRootsJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot> jsonpackageRootsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>();
                JsonArray jsonpackageRootsVala = jsonpackageRootsJson.getAsJsonArray();
                for(int jsonpackageRootsValai= 0; jsonpackageRootsValai < jsonpackageRootsVala.size(); jsonpackageRootsValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot jsonpackageRootsValaX = PackageFragmentRootDto.fromJson((JsonObject)jsonpackageRootsVala.get(jsonpackageRootsValai));;
                    jsonpackageRootsVal.add(jsonpackageRootsValaX);
                }
                result.setPackageRoots((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot>)jsonpackageRootsVal);
            }
            JsonElement jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isJsonNull())) {
                java.lang.String jsonuriVal = jsonuriJson.getAsString();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            JsonElement jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isJsonNull())) {
                java.lang.String jsonnameVal = jsonnameJson.getAsString();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class JavaProjectStructureDtoProvider implements DtoProvider<JavaProjectStructureDto> {
    	public Class<? extends JavaProjectStructureDto> getImplClass() {
    	  	return JavaProjectStructureDto.class;
    	}
    
    	public JavaProjectStructureDto newInstance() {
        	return new JavaProjectStructureDto();
    	}
    
    	public JavaProjectStructureDto fromJson(String json) {
    		return JavaProjectStructureDto.fromJson(json);
    	}
        public JavaProjectStructureDto fromJson(JsonElement json) {
    		return JavaProjectStructureDto.fromJson(json);
    	}
        public JavaProjectStructureDto clone(JavaProjectStructureDto dto) {
            return JavaProjectStructureDto.fromJson(dto.toJson());
    	}
    }

    public static class WorkspaceEditDto extends WorkspaceEdit implements JsonSerializable {

        public WorkspaceEditDto() {
        }

        public WorkspaceEditDto(org.eclipse.lsp4j.WorkspaceEdit o) {
            if (o.getChanges() == null) {
                setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)null);
            } else {
                    java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>> changesVal= new HashMap<String, java.util.List<org.eclipse.lsp4j.TextEdit>>();
                    for (Entry<String, java.util.List<org.eclipse.lsp4j.TextEdit>> changesValX : o.getChanges().entrySet()) {
                            ArrayList<org.eclipse.lsp4j.TextEdit> changesValY= new ArrayList<org.eclipse.lsp4j.TextEdit>();
                            for (org.eclipse.lsp4j.TextEdit changesValYX : changesValX.getValue()) {
                                org.eclipse.lsp4j.TextEdit changesValYY = new TextEditDto(changesValYX);
                                changesValY.add(changesValYY);
                            }
                        changesVal.put(changesValX.getKey(), changesValY);
                    }
                setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)changesVal);
            }
            if (o.getDocumentChanges() == null) {
                setDocumentChanges((java.util.List<org.eclipse.lsp4j.TextDocumentEdit>)null);
            } else {
                    ArrayList<org.eclipse.lsp4j.TextDocumentEdit> documentChangesVal= new ArrayList<org.eclipse.lsp4j.TextDocumentEdit>();
                    for (org.eclipse.lsp4j.TextDocumentEdit documentChangesValX : o.getDocumentChanges()) {
                        org.eclipse.lsp4j.TextDocumentEdit documentChangesValY = new TextDocumentEditDto(documentChangesValX);
                        documentChangesVal.add(documentChangesValY);
                    }
                setDocumentChanges((java.util.List<org.eclipse.lsp4j.TextDocumentEdit>)documentChangesVal);
            }
            if (o.getResourceChanges() == null) {
                setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)null);
            } else {
                    ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>> resourceChangesVal= new ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>();
                    for (org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> resourceChangesValX : o.getResourceChanges()) {
                            org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> resourceChangesValY;
                            if (resourceChangesValX.getLeft() != null) {
                                org.eclipse.lsp4j.ResourceChange resourceChangesValYe = new ResourceChangeDto(resourceChangesValX.getLeft());
                                resourceChangesValY= Either.forLeft(resourceChangesValYe);
                            } else  {
                                org.eclipse.lsp4j.TextDocumentEdit resourceChangesValYe = new TextDocumentEditDto(resourceChangesValX.getRight());
                                resourceChangesValY= Either.forRight(resourceChangesValYe);
                            }
                        resourceChangesVal.add(resourceChangesValY);
                    }
                setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)resourceChangesVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getChanges() == null) {
                setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)null);
            } else {
                JsonObject changesVal = new JsonObject();
                for (Entry<String, java.util.List<org.eclipse.lsp4j.TextEdit>> changesValX : getChanges().entrySet()) {
                    JsonArray changesValY = new JsonArray();
                    for (org.eclipse.lsp4j.TextEdit changesValYX : changesValX.getValue()) {
                        JsonElement changesValYY = changesValYX == null ? JsonNull.INSTANCE : ((TextEditDto)changesValYX).toJsonElement();;
                        changesValY.add(changesValYY);
                    }
                    changesVal.add(changesValX.getKey().toString(), changesValY);
                }
                result.add("changes", changesVal);
            }
            if (getDocumentChanges() == null) {
                setDocumentChanges((java.util.List<org.eclipse.lsp4j.TextDocumentEdit>)null);
            } else {
                JsonArray documentChangesVal = new JsonArray();
                for (org.eclipse.lsp4j.TextDocumentEdit documentChangesValX : getDocumentChanges()) {
                    JsonElement documentChangesValY = documentChangesValX == null ? JsonNull.INSTANCE : ((TextDocumentEditDto)documentChangesValX).toJsonElement();;
                    documentChangesVal.add(documentChangesValY);
                }
                result.add("documentChanges", documentChangesVal);
            }
            if (getResourceChanges() == null) {
                setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)null);
            } else {
                JsonArray resourceChangesVal = new JsonArray();
                for (org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> resourceChangesValX : getResourceChanges()) {
                    JsonElement resourceChangesValY;
                    if (resourceChangesValX.getLeft() != null) {
                        JsonElement resourceChangesValYe = resourceChangesValX.getLeft() == null ? JsonNull.INSTANCE : ((ResourceChangeDto)resourceChangesValX.getLeft()).toJsonElement();;
                        resourceChangesValY= resourceChangesValYe;
                    } else  {
                        JsonElement resourceChangesValYe = resourceChangesValX.getRight() == null ? JsonNull.INSTANCE : ((TextDocumentEditDto)resourceChangesValX.getRight()).toJsonElement();;
                        resourceChangesValY= resourceChangesValYe;
                    }
                    resourceChangesVal.add(resourceChangesValY);
                }
                result.add("resourceChanges", resourceChangesVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static WorkspaceEditDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static WorkspaceEditDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            WorkspaceEditDto result= new WorkspaceEditDto();
            JsonElement jsonchangesJson = json.get("changes");
            if (jsonchangesJson != null && !(jsonchangesJson.isJsonNull())) {
                java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>> jsonchangesVal= new HashMap<String, java.util.List<org.eclipse.lsp4j.TextEdit>>();
                JsonObject jsonchangesValo = jsonchangesJson.getAsJsonObject();
                for(Entry<String, JsonElement> jsonchangesValoe : jsonchangesValo.entrySet()) {
                    ArrayList<org.eclipse.lsp4j.TextEdit> jsonchangesValoX= new ArrayList<org.eclipse.lsp4j.TextEdit>();
                    JsonArray jsonchangesValoXa = jsonchangesValoe.getValue().getAsJsonArray();
                    for(int jsonchangesValoXai= 0; jsonchangesValoXai < jsonchangesValoXa.size(); jsonchangesValoXai++) {
                        org.eclipse.lsp4j.TextEdit jsonchangesValoXaX = TextEditDto.fromJson((JsonObject)jsonchangesValoXa.get(jsonchangesValoXai));;
                        jsonchangesValoX.add(jsonchangesValoXaX);
                    }
                    jsonchangesVal.put(jsonchangesValoe.getKey(), jsonchangesValoX);
                }
                result.setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)jsonchangesVal);
            }
            JsonElement jsondocumentChangesJson = json.get("documentChanges");
            if (jsondocumentChangesJson != null && !(jsondocumentChangesJson.isJsonNull())) {
                ArrayList<org.eclipse.lsp4j.TextDocumentEdit> jsondocumentChangesVal= new ArrayList<org.eclipse.lsp4j.TextDocumentEdit>();
                JsonArray jsondocumentChangesVala = jsondocumentChangesJson.getAsJsonArray();
                for(int jsondocumentChangesValai= 0; jsondocumentChangesValai < jsondocumentChangesVala.size(); jsondocumentChangesValai++) {
                    org.eclipse.lsp4j.TextDocumentEdit jsondocumentChangesValaX = TextDocumentEditDto.fromJson((JsonObject)jsondocumentChangesVala.get(jsondocumentChangesValai));;
                    jsondocumentChangesVal.add(jsondocumentChangesValaX);
                }
                result.setDocumentChanges((java.util.List<org.eclipse.lsp4j.TextDocumentEdit>)jsondocumentChangesVal);
            }
            JsonElement jsonresourceChangesJson = json.get("resourceChanges");
            if (jsonresourceChangesJson != null && !(jsonresourceChangesJson.isJsonNull())) {
                ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>> jsonresourceChangesVal= new ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>();
                JsonArray jsonresourceChangesVala = jsonresourceChangesJson.getAsJsonArray();
                for(int jsonresourceChangesValai= 0; jsonresourceChangesValai < jsonresourceChangesVala.size(); jsonresourceChangesValai++) {
                    JsonDecision[] jsonresourceChangesValaXecls= new JsonDecision[] {
                        JsonDecision.OBJECT
                    };
                    org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> jsonresourceChangesValaX;
                    if (EitherUtil.matches(jsonresourceChangesVala.get(jsonresourceChangesValai), jsonresourceChangesValaXecls)) {
                        org.eclipse.lsp4j.ResourceChange jsonresourceChangesValaXe = ResourceChangeDto.fromJson((JsonObject)jsonresourceChangesVala.get(jsonresourceChangesValai));;
                        jsonresourceChangesValaX= Either.forLeft(jsonresourceChangesValaXe);
                    } else  {
                        org.eclipse.lsp4j.TextDocumentEdit jsonresourceChangesValaXe = TextDocumentEditDto.fromJson((JsonObject)jsonresourceChangesVala.get(jsonresourceChangesValai));;
                        jsonresourceChangesValaX= Either.forRight(jsonresourceChangesValaXe);
                    }
                    jsonresourceChangesVal.add(jsonresourceChangesValaX);
                }
                result.setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)jsonresourceChangesVal);
            }
            return result;
        }
    }

    public static class WorkspaceEditDtoProvider implements DtoProvider<WorkspaceEditDto> {
    	public Class<? extends WorkspaceEditDto> getImplClass() {
    	  	return WorkspaceEditDto.class;
    	}
    
    	public WorkspaceEditDto newInstance() {
        	return new WorkspaceEditDto();
    	}
    
    	public WorkspaceEditDto fromJson(String json) {
    		return WorkspaceEditDto.fromJson(json);
    	}
        public WorkspaceEditDto fromJson(JsonElement json) {
    		return WorkspaceEditDto.fromJson(json);
    	}
        public WorkspaceEditDto clone(WorkspaceEditDto dto) {
            return WorkspaceEditDto.fromJson(dto.toJson());
    	}
    }

    public static class ExtendedSymbolInformationDto extends ExtendedSymbolInformation implements JsonSerializable {

        public ExtendedSymbolInformationDto() {
        }

        public ExtendedSymbolInformationDto(org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation o) {
            if (o.getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation> childrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation childrenValX : o.getChildren()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation childrenValY = new ExtendedSymbolInformationDto(childrenValX);
                        childrenVal.add(childrenValY);
                    }
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>)childrenVal);
            }
            if (o.getInfo() == null) {
                setInfo((org.eclipse.lsp4j.SymbolInformation)null);
            } else {
                org.eclipse.lsp4j.SymbolInformation infoVal = new SymbolInformationDto(o.getInfo());
                setInfo((org.eclipse.lsp4j.SymbolInformation)infoVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>)null);
            } else {
                JsonArray childrenVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation childrenValX : getChildren()) {
                    JsonElement childrenValY = childrenValX == null ? JsonNull.INSTANCE : ((ExtendedSymbolInformationDto)childrenValX).toJsonElement();;
                    childrenVal.add(childrenValY);
                }
                result.add("children", childrenVal);
            }
            if (getInfo() == null) {
                setInfo((org.eclipse.lsp4j.SymbolInformation)null);
            } else {
                JsonElement infoVal = getInfo() == null ? JsonNull.INSTANCE : ((SymbolInformationDto)getInfo()).toJsonElement();;
                result.add("info", infoVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ExtendedSymbolInformationDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static ExtendedSymbolInformationDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            ExtendedSymbolInformationDto result= new ExtendedSymbolInformationDto();
            JsonElement jsonchildrenJson = json.get("children");
            if (jsonchildrenJson != null && !(jsonchildrenJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation> jsonchildrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>();
                JsonArray jsonchildrenVala = jsonchildrenJson.getAsJsonArray();
                for(int jsonchildrenValai= 0; jsonchildrenValai < jsonchildrenVala.size(); jsonchildrenValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation jsonchildrenValaX = ExtendedSymbolInformationDto.fromJson((JsonObject)jsonchildrenVala.get(jsonchildrenValai));;
                    jsonchildrenVal.add(jsonchildrenValaX);
                }
                result.setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation>)jsonchildrenVal);
            }
            JsonElement jsoninfoJson = json.get("info");
            if (jsoninfoJson != null && !(jsoninfoJson.isJsonNull())) {
                org.eclipse.lsp4j.SymbolInformation jsoninfoVal = SymbolInformationDto.fromJson((JsonObject)jsoninfoJson);;
                result.setInfo((org.eclipse.lsp4j.SymbolInformation)jsoninfoVal);
            }
            return result;
        }
    }

    public static class ExtendedSymbolInformationDtoProvider implements DtoProvider<ExtendedSymbolInformationDto> {
    	public Class<? extends ExtendedSymbolInformationDto> getImplClass() {
    	  	return ExtendedSymbolInformationDto.class;
    	}
    
    	public ExtendedSymbolInformationDto newInstance() {
        	return new ExtendedSymbolInformationDto();
    	}
    
    	public ExtendedSymbolInformationDto fromJson(String json) {
    		return ExtendedSymbolInformationDto.fromJson(json);
    	}
        public ExtendedSymbolInformationDto fromJson(JsonElement json) {
    		return ExtendedSymbolInformationDto.fromJson(json);
    	}
        public ExtendedSymbolInformationDto clone(ExtendedSymbolInformationDto dto) {
            return ExtendedSymbolInformationDto.fromJson(dto.toJson());
    	}
    }

    public static class ReImportMavenProjectsCommandParametersDto extends ReImportMavenProjectsCommandParameters implements JsonSerializable {

        public ReImportMavenProjectsCommandParametersDto() {
        }

        public ReImportMavenProjectsCommandParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.ReImportMavenProjectsCommandParameters o) {
            if (o.getProjectsToUpdate() == null) {
                setProjectsToUpdate((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> projectsToUpdateVal= new ArrayList<java.lang.String>();
                    for (java.lang.String projectsToUpdateValX : o.getProjectsToUpdate()) {
                        java.lang.String projectsToUpdateValY = (java.lang.String)makeDto(projectsToUpdateValX);;
                        projectsToUpdateVal.add(projectsToUpdateValY);
                    }
                setProjectsToUpdate((java.util.List<java.lang.String>)projectsToUpdateVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getProjectsToUpdate() == null) {
                setProjectsToUpdate((java.util.List<java.lang.String>)null);
            } else {
                JsonArray projectsToUpdateVal = new JsonArray();
                for (java.lang.String projectsToUpdateValX : getProjectsToUpdate()) {
                    JsonElement projectsToUpdateValY = projectsToUpdateValX == null ? JsonNull.INSTANCE : new JsonPrimitive(projectsToUpdateValX);;
                    projectsToUpdateVal.add(projectsToUpdateValY);
                }
                result.add("projectsToUpdate", projectsToUpdateVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ReImportMavenProjectsCommandParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static ReImportMavenProjectsCommandParametersDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            ReImportMavenProjectsCommandParametersDto result= new ReImportMavenProjectsCommandParametersDto();
            JsonElement jsonprojectsToUpdateJson = json.get("projectsToUpdate");
            if (jsonprojectsToUpdateJson != null && !(jsonprojectsToUpdateJson.isJsonNull())) {
                ArrayList<java.lang.String> jsonprojectsToUpdateVal= new ArrayList<java.lang.String>();
                JsonArray jsonprojectsToUpdateVala = jsonprojectsToUpdateJson.getAsJsonArray();
                for(int jsonprojectsToUpdateValai= 0; jsonprojectsToUpdateValai < jsonprojectsToUpdateVala.size(); jsonprojectsToUpdateValai++) {
                    java.lang.String jsonprojectsToUpdateValaX = jsonprojectsToUpdateVala.get(jsonprojectsToUpdateValai).getAsString();;
                    jsonprojectsToUpdateVal.add(jsonprojectsToUpdateValaX);
                }
                result.setProjectsToUpdate((java.util.List<java.lang.String>)jsonprojectsToUpdateVal);
            }
            return result;
        }
    }

    public static class ReImportMavenProjectsCommandParametersDtoProvider implements DtoProvider<ReImportMavenProjectsCommandParametersDto> {
    	public Class<? extends ReImportMavenProjectsCommandParametersDto> getImplClass() {
    	  	return ReImportMavenProjectsCommandParametersDto.class;
    	}
    
    	public ReImportMavenProjectsCommandParametersDto newInstance() {
        	return new ReImportMavenProjectsCommandParametersDto();
    	}
    
    	public ReImportMavenProjectsCommandParametersDto fromJson(String json) {
    		return ReImportMavenProjectsCommandParametersDto.fromJson(json);
    	}
        public ReImportMavenProjectsCommandParametersDto fromJson(JsonElement json) {
    		return ReImportMavenProjectsCommandParametersDto.fromJson(json);
    	}
        public ReImportMavenProjectsCommandParametersDto clone(ReImportMavenProjectsCommandParametersDto dto) {
            return ReImportMavenProjectsCommandParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class PackageFragmentRootDto extends PackageFragmentRoot implements JsonSerializable {

        public PackageFragmentRootDto() {
        }

        public PackageFragmentRootDto(org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot o) {
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
            if (o.getPackages() == null) {
                setPackages((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment> packagesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment packagesValX : o.getPackages()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment packagesValY = new PackageFragmentDto(packagesValX);
                        packagesVal.add(packagesValY);
                    }
                setPackages((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>)packagesVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JsonElement projectUriVal = getProjectUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getProjectUri());;
                result.add("projectUri", projectUriVal);
            }
            if (getPackages() == null) {
                setPackages((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>)null);
            } else {
                JsonArray packagesVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment packagesValX : getPackages()) {
                    JsonElement packagesValY = packagesValX == null ? JsonNull.INSTANCE : ((PackageFragmentDto)packagesValX).toJsonElement();;
                    packagesVal.add(packagesValY);
                }
                result.add("packages", packagesVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JsonElement uriVal = getUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getUri());;
                result.add("uri", uriVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static PackageFragmentRootDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static PackageFragmentRootDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            PackageFragmentRootDto result= new PackageFragmentRootDto();
            JsonElement jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isJsonNull())) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.getAsString();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            JsonElement jsonpackagesJson = json.get("packages");
            if (jsonpackagesJson != null && !(jsonpackagesJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment> jsonpackagesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>();
                JsonArray jsonpackagesVala = jsonpackagesJson.getAsJsonArray();
                for(int jsonpackagesValai= 0; jsonpackagesValai < jsonpackagesVala.size(); jsonpackagesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment jsonpackagesValaX = PackageFragmentDto.fromJson((JsonObject)jsonpackagesVala.get(jsonpackagesValai));;
                    jsonpackagesVal.add(jsonpackagesValaX);
                }
                result.setPackages((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment>)jsonpackagesVal);
            }
            JsonElement jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isJsonNull())) {
                java.lang.String jsonuriVal = jsonuriJson.getAsString();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            return result;
        }
    }

    public static class PackageFragmentRootDtoProvider implements DtoProvider<PackageFragmentRootDto> {
    	public Class<? extends PackageFragmentRootDto> getImplClass() {
    	  	return PackageFragmentRootDto.class;
    	}
    
    	public PackageFragmentRootDto newInstance() {
        	return new PackageFragmentRootDto();
    	}
    
    	public PackageFragmentRootDto fromJson(String json) {
    		return PackageFragmentRootDto.fromJson(json);
    	}
        public PackageFragmentRootDto fromJson(JsonElement json) {
    		return PackageFragmentRootDto.fromJson(json);
    	}
        public PackageFragmentRootDto clone(PackageFragmentRootDto dto) {
            return PackageFragmentRootDto.fromJson(dto.toJson());
    	}
    }

    public static class ResourceChangeDto extends ResourceChange implements JsonSerializable {

        public ResourceChangeDto() {
        }

        public ResourceChangeDto(org.eclipse.lsp4j.ResourceChange o) {
            if (o.getCurrent() == null) {
                setCurrent((java.lang.String)null);
            } else {
                java.lang.String currentVal = (java.lang.String)makeDto(o.getCurrent());;
                setCurrent((java.lang.String)currentVal);
            }
            if (o.getNewUri() == null) {
                setNewUri((java.lang.String)null);
            } else {
                java.lang.String newUriVal = (java.lang.String)makeDto(o.getNewUri());;
                setNewUri((java.lang.String)newUriVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getCurrent() == null) {
                setCurrent((java.lang.String)null);
            } else {
                JsonElement currentVal = getCurrent() == null ? JsonNull.INSTANCE : new JsonPrimitive(getCurrent());;
                result.add("current", currentVal);
            }
            if (getNewUri() == null) {
                setNewUri((java.lang.String)null);
            } else {
                JsonElement newUriVal = getNewUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getNewUri());;
                result.add("newUri", newUriVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ResourceChangeDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static ResourceChangeDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            ResourceChangeDto result= new ResourceChangeDto();
            JsonElement jsoncurrentJson = json.get("current");
            if (jsoncurrentJson != null && !(jsoncurrentJson.isJsonNull())) {
                java.lang.String jsoncurrentVal = jsoncurrentJson.getAsString();;
                result.setCurrent((java.lang.String)jsoncurrentVal);
            }
            JsonElement jsonnewUriJson = json.get("newUri");
            if (jsonnewUriJson != null && !(jsonnewUriJson.isJsonNull())) {
                java.lang.String jsonnewUriVal = jsonnewUriJson.getAsString();;
                result.setNewUri((java.lang.String)jsonnewUriVal);
            }
            return result;
        }
    }

    public static class ResourceChangeDtoProvider implements DtoProvider<ResourceChangeDto> {
    	public Class<? extends ResourceChangeDto> getImplClass() {
    	  	return ResourceChangeDto.class;
    	}
    
    	public ResourceChangeDto newInstance() {
        	return new ResourceChangeDto();
    	}
    
    	public ResourceChangeDto fromJson(String json) {
    		return ResourceChangeDto.fromJson(json);
    	}
        public ResourceChangeDto fromJson(JsonElement json) {
    		return ResourceChangeDto.fromJson(json);
    	}
        public ResourceChangeDto clone(ResourceChangeDto dto) {
            return ResourceChangeDto.fromJson(dto.toJson());
    	}
    }

    public static class LinearRangeDto extends LinearRange implements JsonSerializable {

        public LinearRangeDto() {
        }

        public LinearRangeDto(org.eclipse.che.jdt.ls.extension.api.dto.LinearRange o) {
                int lengthVal = (int)makeDto(o.getLength());;
                setLength((int)lengthVal);
                int offsetVal = (int)makeDto(o.getOffset());;
                setOffset((int)offsetVal);
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            JsonElement lengthVal = new JsonPrimitive(getLength());;
                result.add("length", lengthVal);
            JsonElement offsetVal = new JsonPrimitive(getOffset());;
                result.add("offset", offsetVal);
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static LinearRangeDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static LinearRangeDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            LinearRangeDto result= new LinearRangeDto();
            JsonElement jsonlengthJson = json.get("length");
            if (jsonlengthJson != null && !(jsonlengthJson.isJsonNull())) {
                int jsonlengthVal = (int)jsonlengthJson.getAsDouble();;
                result.setLength((int)jsonlengthVal);
            }
            JsonElement jsonoffsetJson = json.get("offset");
            if (jsonoffsetJson != null && !(jsonoffsetJson.isJsonNull())) {
                int jsonoffsetVal = (int)jsonoffsetJson.getAsDouble();;
                result.setOffset((int)jsonoffsetVal);
            }
            return result;
        }
    }

    public static class LinearRangeDtoProvider implements DtoProvider<LinearRangeDto> {
    	public Class<? extends LinearRangeDto> getImplClass() {
    	  	return LinearRangeDto.class;
    	}
    
    	public LinearRangeDto newInstance() {
        	return new LinearRangeDto();
    	}
    
    	public LinearRangeDto fromJson(String json) {
    		return LinearRangeDto.fromJson(json);
    	}
        public LinearRangeDto fromJson(JsonElement json) {
    		return LinearRangeDto.fromJson(json);
    	}
        public LinearRangeDto clone(LinearRangeDto dto) {
            return LinearRangeDto.fromJson(dto.toJson());
    	}
    }

    public static class JavaCoreOptionsDto extends JavaCoreOptions implements JsonSerializable {

        public JavaCoreOptionsDto() {
        }

        public JavaCoreOptionsDto(org.eclipse.che.jdt.ls.extension.api.dto.JavaCoreOptions o) {
            if (o.getOptions() == null) {
                setOptions((java.util.Map<java.lang.String, java.lang.String>)null);
            } else {
                    java.util.Map<java.lang.String, java.lang.String> optionsVal= new HashMap<String, java.lang.String>();
                    for (Entry<String, java.lang.String> optionsValX : o.getOptions().entrySet()) {
                        java.lang.String optionsValY = (java.lang.String)makeDto(optionsValX.getValue());;
                        optionsVal.put(optionsValX.getKey(), optionsValY);
                    }
                setOptions((java.util.Map<java.lang.String, java.lang.String>)optionsVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getOptions() == null) {
                setOptions((java.util.Map<java.lang.String, java.lang.String>)null);
            } else {
                JsonObject optionsVal = new JsonObject();
                for (Entry<String, java.lang.String> optionsValX : getOptions().entrySet()) {
                    JsonElement optionsValY = optionsValX.getValue() == null ? JsonNull.INSTANCE : new JsonPrimitive(optionsValX.getValue());;
                    optionsVal.add(optionsValX.getKey().toString(), optionsValY);
                }
                result.add("options", optionsVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JavaCoreOptionsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static JavaCoreOptionsDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            JavaCoreOptionsDto result= new JavaCoreOptionsDto();
            JsonElement jsonoptionsJson = json.get("options");
            if (jsonoptionsJson != null && !(jsonoptionsJson.isJsonNull())) {
                java.util.Map<java.lang.String, java.lang.String> jsonoptionsVal= new HashMap<String, java.lang.String>();
                JsonObject jsonoptionsValo = jsonoptionsJson.getAsJsonObject();
                for(Entry<String, JsonElement> jsonoptionsValoe : jsonoptionsValo.entrySet()) {
                    java.lang.String jsonoptionsValoX = jsonoptionsValoe.getValue().getAsString();;
                    jsonoptionsVal.put(jsonoptionsValoe.getKey(), jsonoptionsValoX);
                }
                result.setOptions((java.util.Map<java.lang.String, java.lang.String>)jsonoptionsVal);
            }
            return result;
        }
    }

    public static class JavaCoreOptionsDtoProvider implements DtoProvider<JavaCoreOptionsDto> {
    	public Class<? extends JavaCoreOptionsDto> getImplClass() {
    	  	return JavaCoreOptionsDto.class;
    	}
    
    	public JavaCoreOptionsDto newInstance() {
        	return new JavaCoreOptionsDto();
    	}
    
    	public JavaCoreOptionsDto fromJson(String json) {
    		return JavaCoreOptionsDto.fromJson(json);
    	}
        public JavaCoreOptionsDto fromJson(JsonElement json) {
    		return JavaCoreOptionsDto.fromJson(json);
    	}
        public JavaCoreOptionsDto clone(JavaCoreOptionsDto dto) {
            return JavaCoreOptionsDto.fromJson(dto.toJson());
    	}
    }

    public static class SearchResultDto extends SearchResult implements JsonSerializable {

        public SearchResultDto() {
        }

        public SearchResultDto(org.eclipse.che.jdt.ls.extension.api.dto.SearchResult o) {
            if (o.getMatches() == null) {
                setMatches((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange> matchesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.LinearRange matchesValX : o.getMatches()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.LinearRange matchesValY = new LinearRangeDto(matchesValX);
                        matchesVal.add(matchesValY);
                    }
                setMatches((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>)matchesVal);
            }
            if (o.getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult> childrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.SearchResult childrenValX : o.getChildren()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.SearchResult childrenValY = new SearchResultDto(childrenValX);
                        childrenVal.add(childrenValY);
                    }
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)childrenVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
            if (o.getKind() == null) {
                setKind((org.eclipse.lsp4j.SymbolKind)null);
            } else {
                org.eclipse.lsp4j.SymbolKind kindVal = (org.eclipse.lsp4j.SymbolKind)makeDto(o.getKind());;
                setKind((org.eclipse.lsp4j.SymbolKind)kindVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getMatches() == null) {
                setMatches((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>)null);
            } else {
                JsonArray matchesVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.LinearRange matchesValX : getMatches()) {
                    JsonElement matchesValY = matchesValX == null ? JsonNull.INSTANCE : ((LinearRangeDto)matchesValX).toJsonElement();;
                    matchesVal.add(matchesValY);
                }
                result.add("matches", matchesVal);
            }
            if (getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)null);
            } else {
                JsonArray childrenVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.SearchResult childrenValX : getChildren()) {
                    JsonElement childrenValY = childrenValX == null ? JsonNull.INSTANCE : ((SearchResultDto)childrenValX).toJsonElement();;
                    childrenVal.add(childrenValY);
                }
                result.add("children", childrenVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JsonElement uriVal = getUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getUri());;
                result.add("uri", uriVal);
            }
            if (getKind() == null) {
                setKind((org.eclipse.lsp4j.SymbolKind)null);
            } else {
                JsonElement kindVal = getKind() == null ? JsonNull.INSTANCE : new JsonPrimitive(getKind().name());;
                result.add("kind", kindVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JsonElement nameVal = getName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getName());;
                result.add("name", nameVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static SearchResultDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static SearchResultDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            SearchResultDto result= new SearchResultDto();
            JsonElement jsonmatchesJson = json.get("matches");
            if (jsonmatchesJson != null && !(jsonmatchesJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange> jsonmatchesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>();
                JsonArray jsonmatchesVala = jsonmatchesJson.getAsJsonArray();
                for(int jsonmatchesValai= 0; jsonmatchesValai < jsonmatchesVala.size(); jsonmatchesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.LinearRange jsonmatchesValaX = LinearRangeDto.fromJson((JsonObject)jsonmatchesVala.get(jsonmatchesValai));;
                    jsonmatchesVal.add(jsonmatchesValaX);
                }
                result.setMatches((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.LinearRange>)jsonmatchesVal);
            }
            JsonElement jsonchildrenJson = json.get("children");
            if (jsonchildrenJson != null && !(jsonchildrenJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult> jsonchildrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>();
                JsonArray jsonchildrenVala = jsonchildrenJson.getAsJsonArray();
                for(int jsonchildrenValai= 0; jsonchildrenValai < jsonchildrenVala.size(); jsonchildrenValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.SearchResult jsonchildrenValaX = SearchResultDto.fromJson((JsonObject)jsonchildrenVala.get(jsonchildrenValai));;
                    jsonchildrenVal.add(jsonchildrenValaX);
                }
                result.setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)jsonchildrenVal);
            }
            JsonElement jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isJsonNull())) {
                java.lang.String jsonuriVal = jsonuriJson.getAsString();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            JsonElement jsonkindJson = json.get("kind");
            if (jsonkindJson != null && !(jsonkindJson.isJsonNull())) {
                org.eclipse.lsp4j.SymbolKind jsonkindVal = org.eclipse.lsp4j.SymbolKind.valueOf(jsonkindJson.getAsString());;
                result.setKind((org.eclipse.lsp4j.SymbolKind)jsonkindVal);
            }
            JsonElement jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isJsonNull())) {
                java.lang.String jsonnameVal = jsonnameJson.getAsString();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class SearchResultDtoProvider implements DtoProvider<SearchResultDto> {
    	public Class<? extends SearchResultDto> getImplClass() {
    	  	return SearchResultDto.class;
    	}
    
    	public SearchResultDto newInstance() {
        	return new SearchResultDto();
    	}
    
    	public SearchResultDto fromJson(String json) {
    		return SearchResultDto.fromJson(json);
    	}
        public SearchResultDto fromJson(JsonElement json) {
    		return SearchResultDto.fromJson(json);
    	}
        public SearchResultDto clone(SearchResultDto dto) {
            return SearchResultDto.fromJson(dto.toJson());
    	}
    }

    public static class CheWorkspaceEditDto extends CheWorkspaceEdit implements JsonSerializable {

        public CheWorkspaceEditDto() {
        }

        public CheWorkspaceEditDto(org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit o) {
            if (o.getCheResourceChanges() == null) {
                setCheResourceChanges((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange> cheResourceChangesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange cheResourceChangesValX : o.getCheResourceChanges()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange cheResourceChangesValY = new CheResourceChangeDto(cheResourceChangesValX);
                        cheResourceChangesVal.add(cheResourceChangesValY);
                    }
                setCheResourceChanges((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>)cheResourceChangesVal);
            }
            if (o.getChanges() == null) {
                setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)null);
            } else {
                    java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>> changesVal= new HashMap<String, java.util.List<org.eclipse.lsp4j.TextEdit>>();
                    for (Entry<String, java.util.List<org.eclipse.lsp4j.TextEdit>> changesValX : o.getChanges().entrySet()) {
                            ArrayList<org.eclipse.lsp4j.TextEdit> changesValY= new ArrayList<org.eclipse.lsp4j.TextEdit>();
                            for (org.eclipse.lsp4j.TextEdit changesValYX : changesValX.getValue()) {
                                org.eclipse.lsp4j.TextEdit changesValYY = new TextEditDto(changesValYX);
                                changesValY.add(changesValYY);
                            }
                        changesVal.put(changesValX.getKey(), changesValY);
                    }
                setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)changesVal);
            }
            if (o.getDocumentChanges() == null) {
                setDocumentChanges((java.util.List<org.eclipse.lsp4j.TextDocumentEdit>)null);
            } else {
                    ArrayList<org.eclipse.lsp4j.TextDocumentEdit> documentChangesVal= new ArrayList<org.eclipse.lsp4j.TextDocumentEdit>();
                    for (org.eclipse.lsp4j.TextDocumentEdit documentChangesValX : o.getDocumentChanges()) {
                        org.eclipse.lsp4j.TextDocumentEdit documentChangesValY = new TextDocumentEditDto(documentChangesValX);
                        documentChangesVal.add(documentChangesValY);
                    }
                setDocumentChanges((java.util.List<org.eclipse.lsp4j.TextDocumentEdit>)documentChangesVal);
            }
            if (o.getResourceChanges() == null) {
                setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)null);
            } else {
                    ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>> resourceChangesVal= new ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>();
                    for (org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> resourceChangesValX : o.getResourceChanges()) {
                            org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> resourceChangesValY;
                            if (resourceChangesValX.getLeft() != null) {
                                org.eclipse.lsp4j.ResourceChange resourceChangesValYe = new ResourceChangeDto(resourceChangesValX.getLeft());
                                resourceChangesValY= Either.forLeft(resourceChangesValYe);
                            } else  {
                                org.eclipse.lsp4j.TextDocumentEdit resourceChangesValYe = new TextDocumentEditDto(resourceChangesValX.getRight());
                                resourceChangesValY= Either.forRight(resourceChangesValYe);
                            }
                        resourceChangesVal.add(resourceChangesValY);
                    }
                setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)resourceChangesVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getCheResourceChanges() == null) {
                setCheResourceChanges((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>)null);
            } else {
                JsonArray cheResourceChangesVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange cheResourceChangesValX : getCheResourceChanges()) {
                    JsonElement cheResourceChangesValY = cheResourceChangesValX == null ? JsonNull.INSTANCE : ((CheResourceChangeDto)cheResourceChangesValX).toJsonElement();;
                    cheResourceChangesVal.add(cheResourceChangesValY);
                }
                result.add("cheResourceChanges", cheResourceChangesVal);
            }
            if (getChanges() == null) {
                setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)null);
            } else {
                JsonObject changesVal = new JsonObject();
                for (Entry<String, java.util.List<org.eclipse.lsp4j.TextEdit>> changesValX : getChanges().entrySet()) {
                    JsonArray changesValY = new JsonArray();
                    for (org.eclipse.lsp4j.TextEdit changesValYX : changesValX.getValue()) {
                        JsonElement changesValYY = changesValYX == null ? JsonNull.INSTANCE : ((TextEditDto)changesValYX).toJsonElement();;
                        changesValY.add(changesValYY);
                    }
                    changesVal.add(changesValX.getKey().toString(), changesValY);
                }
                result.add("changes", changesVal);
            }
            if (getDocumentChanges() == null) {
                setDocumentChanges((java.util.List<org.eclipse.lsp4j.TextDocumentEdit>)null);
            } else {
                JsonArray documentChangesVal = new JsonArray();
                for (org.eclipse.lsp4j.TextDocumentEdit documentChangesValX : getDocumentChanges()) {
                    JsonElement documentChangesValY = documentChangesValX == null ? JsonNull.INSTANCE : ((TextDocumentEditDto)documentChangesValX).toJsonElement();;
                    documentChangesVal.add(documentChangesValY);
                }
                result.add("documentChanges", documentChangesVal);
            }
            if (getResourceChanges() == null) {
                setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)null);
            } else {
                JsonArray resourceChangesVal = new JsonArray();
                for (org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> resourceChangesValX : getResourceChanges()) {
                    JsonElement resourceChangesValY;
                    if (resourceChangesValX.getLeft() != null) {
                        JsonElement resourceChangesValYe = resourceChangesValX.getLeft() == null ? JsonNull.INSTANCE : ((ResourceChangeDto)resourceChangesValX.getLeft()).toJsonElement();;
                        resourceChangesValY= resourceChangesValYe;
                    } else  {
                        JsonElement resourceChangesValYe = resourceChangesValX.getRight() == null ? JsonNull.INSTANCE : ((TextDocumentEditDto)resourceChangesValX.getRight()).toJsonElement();;
                        resourceChangesValY= resourceChangesValYe;
                    }
                    resourceChangesVal.add(resourceChangesValY);
                }
                result.add("resourceChanges", resourceChangesVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static CheWorkspaceEditDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static CheWorkspaceEditDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            CheWorkspaceEditDto result= new CheWorkspaceEditDto();
            JsonElement jsoncheResourceChangesJson = json.get("cheResourceChanges");
            if (jsoncheResourceChangesJson != null && !(jsoncheResourceChangesJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange> jsoncheResourceChangesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>();
                JsonArray jsoncheResourceChangesVala = jsoncheResourceChangesJson.getAsJsonArray();
                for(int jsoncheResourceChangesValai= 0; jsoncheResourceChangesValai < jsoncheResourceChangesVala.size(); jsoncheResourceChangesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange jsoncheResourceChangesValaX = CheResourceChangeDto.fromJson((JsonObject)jsoncheResourceChangesVala.get(jsoncheResourceChangesValai));;
                    jsoncheResourceChangesVal.add(jsoncheResourceChangesValaX);
                }
                result.setCheResourceChanges((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange>)jsoncheResourceChangesVal);
            }
            JsonElement jsonchangesJson = json.get("changes");
            if (jsonchangesJson != null && !(jsonchangesJson.isJsonNull())) {
                java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>> jsonchangesVal= new HashMap<String, java.util.List<org.eclipse.lsp4j.TextEdit>>();
                JsonObject jsonchangesValo = jsonchangesJson.getAsJsonObject();
                for(Entry<String, JsonElement> jsonchangesValoe : jsonchangesValo.entrySet()) {
                    ArrayList<org.eclipse.lsp4j.TextEdit> jsonchangesValoX= new ArrayList<org.eclipse.lsp4j.TextEdit>();
                    JsonArray jsonchangesValoXa = jsonchangesValoe.getValue().getAsJsonArray();
                    for(int jsonchangesValoXai= 0; jsonchangesValoXai < jsonchangesValoXa.size(); jsonchangesValoXai++) {
                        org.eclipse.lsp4j.TextEdit jsonchangesValoXaX = TextEditDto.fromJson((JsonObject)jsonchangesValoXa.get(jsonchangesValoXai));;
                        jsonchangesValoX.add(jsonchangesValoXaX);
                    }
                    jsonchangesVal.put(jsonchangesValoe.getKey(), jsonchangesValoX);
                }
                result.setChanges((java.util.Map<java.lang.String, java.util.List<org.eclipse.lsp4j.TextEdit>>)jsonchangesVal);
            }
            JsonElement jsondocumentChangesJson = json.get("documentChanges");
            if (jsondocumentChangesJson != null && !(jsondocumentChangesJson.isJsonNull())) {
                ArrayList<org.eclipse.lsp4j.TextDocumentEdit> jsondocumentChangesVal= new ArrayList<org.eclipse.lsp4j.TextDocumentEdit>();
                JsonArray jsondocumentChangesVala = jsondocumentChangesJson.getAsJsonArray();
                for(int jsondocumentChangesValai= 0; jsondocumentChangesValai < jsondocumentChangesVala.size(); jsondocumentChangesValai++) {
                    org.eclipse.lsp4j.TextDocumentEdit jsondocumentChangesValaX = TextDocumentEditDto.fromJson((JsonObject)jsondocumentChangesVala.get(jsondocumentChangesValai));;
                    jsondocumentChangesVal.add(jsondocumentChangesValaX);
                }
                result.setDocumentChanges((java.util.List<org.eclipse.lsp4j.TextDocumentEdit>)jsondocumentChangesVal);
            }
            JsonElement jsonresourceChangesJson = json.get("resourceChanges");
            if (jsonresourceChangesJson != null && !(jsonresourceChangesJson.isJsonNull())) {
                ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>> jsonresourceChangesVal= new ArrayList<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>();
                JsonArray jsonresourceChangesVala = jsonresourceChangesJson.getAsJsonArray();
                for(int jsonresourceChangesValai= 0; jsonresourceChangesValai < jsonresourceChangesVala.size(); jsonresourceChangesValai++) {
                    JsonDecision[] jsonresourceChangesValaXecls= new JsonDecision[] {
                        JsonDecision.OBJECT
                    };
                    org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit> jsonresourceChangesValaX;
                    if (EitherUtil.matches(jsonresourceChangesVala.get(jsonresourceChangesValai), jsonresourceChangesValaXecls)) {
                        org.eclipse.lsp4j.ResourceChange jsonresourceChangesValaXe = ResourceChangeDto.fromJson((JsonObject)jsonresourceChangesVala.get(jsonresourceChangesValai));;
                        jsonresourceChangesValaX= Either.forLeft(jsonresourceChangesValaXe);
                    } else  {
                        org.eclipse.lsp4j.TextDocumentEdit jsonresourceChangesValaXe = TextDocumentEditDto.fromJson((JsonObject)jsonresourceChangesVala.get(jsonresourceChangesValai));;
                        jsonresourceChangesValaX= Either.forRight(jsonresourceChangesValaXe);
                    }
                    jsonresourceChangesVal.add(jsonresourceChangesValaX);
                }
                result.setResourceChanges((java.util.List<org.eclipse.lsp4j.jsonrpc.messages.Either<org.eclipse.lsp4j.ResourceChange, org.eclipse.lsp4j.TextDocumentEdit>>)jsonresourceChangesVal);
            }
            return result;
        }
    }

    public static class CheWorkspaceEditDtoProvider implements DtoProvider<CheWorkspaceEditDto> {
    	public Class<? extends CheWorkspaceEditDto> getImplClass() {
    	  	return CheWorkspaceEditDto.class;
    	}
    
    	public CheWorkspaceEditDto newInstance() {
        	return new CheWorkspaceEditDto();
    	}
    
    	public CheWorkspaceEditDto fromJson(String json) {
    		return CheWorkspaceEditDto.fromJson(json);
    	}
        public CheWorkspaceEditDto fromJson(JsonElement json) {
    		return CheWorkspaceEditDto.fromJson(json);
    	}
        public CheWorkspaceEditDto clone(CheWorkspaceEditDto dto) {
            return CheWorkspaceEditDto.fromJson(dto.toJson());
    	}
    }

    public static class RenameSettingsDto extends RenameSettings implements JsonSerializable {

        public RenameSettingsDto() {
        }

        public RenameSettingsDto(org.eclipse.che.jdt.ls.extension.api.dto.RenameSettings o) {
            if (o.getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.RenameKind renameKindVal = (org.eclipse.che.jdt.ls.extension.api.RenameKind)makeDto(o.getRenameKind());;
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)renameKindVal);
            }
                boolean deprecateDelegatesVal = (boolean)makeDto(o.isDeprecateDelegates());;
                setDeprecateDelegates((boolean)deprecateDelegatesVal);
                boolean updateSubpackagesVal = (boolean)makeDto(o.isUpdateSubpackages());;
                setUpdateSubpackages((boolean)updateSubpackagesVal);
                boolean updateSimilarDeclarationsVal = (boolean)makeDto(o.isUpdateSimilarDeclarations());;
                setUpdateSimilarDeclarations((boolean)updateSimilarDeclarationsVal);
            if (o.getMatchStrategy() == null) {
                setMatchStrategy((org.eclipse.che.jdt.ls.extension.api.MatchStrategy)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.MatchStrategy matchStrategyVal = (org.eclipse.che.jdt.ls.extension.api.MatchStrategy)makeDto(o.getMatchStrategy());;
                setMatchStrategy((org.eclipse.che.jdt.ls.extension.api.MatchStrategy)matchStrategyVal);
            }
                boolean updateTextualMatchesVal = (boolean)makeDto(o.isUpdateTextualMatches());;
                setUpdateTextualMatches((boolean)updateTextualMatchesVal);
                boolean updateReferencesVal = (boolean)makeDto(o.isUpdateReferences());;
                setUpdateReferences((boolean)updateReferencesVal);
                boolean updateQualifiedNamesVal = (boolean)makeDto(o.isUpdateQualifiedNames());;
                setUpdateQualifiedNames((boolean)updateQualifiedNamesVal);
            if (o.getFilePatterns() == null) {
                setFilePatterns((java.lang.String)null);
            } else {
                java.lang.String filePatternsVal = (java.lang.String)makeDto(o.getFilePatterns());;
                setFilePatterns((java.lang.String)filePatternsVal);
            }
            if (o.getRenameParams() == null) {
                setRenameParams((org.eclipse.lsp4j.RenameParams)null);
            } else {
                org.eclipse.lsp4j.RenameParams renameParamsVal = new RenameParamsDto(o.getRenameParams());
                setRenameParams((org.eclipse.lsp4j.RenameParams)renameParamsVal);
            }
                boolean delegateUpdatingVal = (boolean)makeDto(o.isDelegateUpdating());;
                setDelegateUpdating((boolean)delegateUpdatingVal);
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                JsonElement renameKindVal = getRenameKind() == null ? JsonNull.INSTANCE : new JsonPrimitive(getRenameKind().name());;
                result.add("renameKind", renameKindVal);
            }
            JsonElement deprecateDelegatesVal = new JsonPrimitive(isDeprecateDelegates());;
                result.add("deprecateDelegates", deprecateDelegatesVal);
            JsonElement updateSubpackagesVal = new JsonPrimitive(isUpdateSubpackages());;
                result.add("updateSubpackages", updateSubpackagesVal);
            JsonElement updateSimilarDeclarationsVal = new JsonPrimitive(isUpdateSimilarDeclarations());;
                result.add("updateSimilarDeclarations", updateSimilarDeclarationsVal);
            if (getMatchStrategy() == null) {
                setMatchStrategy((org.eclipse.che.jdt.ls.extension.api.MatchStrategy)null);
            } else {
                JsonElement matchStrategyVal = getMatchStrategy() == null ? JsonNull.INSTANCE : new JsonPrimitive(getMatchStrategy().name());;
                result.add("matchStrategy", matchStrategyVal);
            }
            JsonElement updateTextualMatchesVal = new JsonPrimitive(isUpdateTextualMatches());;
                result.add("updateTextualMatches", updateTextualMatchesVal);
            JsonElement updateReferencesVal = new JsonPrimitive(isUpdateReferences());;
                result.add("updateReferences", updateReferencesVal);
            JsonElement updateQualifiedNamesVal = new JsonPrimitive(isUpdateQualifiedNames());;
                result.add("updateQualifiedNames", updateQualifiedNamesVal);
            if (getFilePatterns() == null) {
                setFilePatterns((java.lang.String)null);
            } else {
                JsonElement filePatternsVal = getFilePatterns() == null ? JsonNull.INSTANCE : new JsonPrimitive(getFilePatterns());;
                result.add("filePatterns", filePatternsVal);
            }
            if (getRenameParams() == null) {
                setRenameParams((org.eclipse.lsp4j.RenameParams)null);
            } else {
                JsonElement renameParamsVal = getRenameParams() == null ? JsonNull.INSTANCE : ((RenameParamsDto)getRenameParams()).toJsonElement();;
                result.add("renameParams", renameParamsVal);
            }
            JsonElement delegateUpdatingVal = new JsonPrimitive(isDelegateUpdating());;
                result.add("delegateUpdating", delegateUpdatingVal);
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RenameSettingsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static RenameSettingsDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            RenameSettingsDto result= new RenameSettingsDto();
            JsonElement jsonrenameKindJson = json.get("renameKind");
            if (jsonrenameKindJson != null && !(jsonrenameKindJson.isJsonNull())) {
                org.eclipse.che.jdt.ls.extension.api.RenameKind jsonrenameKindVal = org.eclipse.che.jdt.ls.extension.api.RenameKind.valueOf(jsonrenameKindJson.getAsString());;
                result.setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)jsonrenameKindVal);
            }
            JsonElement jsondeprecateDelegatesJson = json.get("deprecateDelegates");
            if (jsondeprecateDelegatesJson != null && !(jsondeprecateDelegatesJson.isJsonNull())) {
                boolean jsondeprecateDelegatesVal = jsondeprecateDelegatesJson.getAsBoolean();
                result.setDeprecateDelegates((boolean)jsondeprecateDelegatesVal);
            }
            JsonElement jsonupdateSubpackagesJson = json.get("updateSubpackages");
            if (jsonupdateSubpackagesJson != null && !(jsonupdateSubpackagesJson.isJsonNull())) {
                boolean jsonupdateSubpackagesVal = jsonupdateSubpackagesJson.getAsBoolean();
                result.setUpdateSubpackages((boolean)jsonupdateSubpackagesVal);
            }
            JsonElement jsonupdateSimilarDeclarationsJson = json.get("updateSimilarDeclarations");
            if (jsonupdateSimilarDeclarationsJson != null && !(jsonupdateSimilarDeclarationsJson.isJsonNull())) {
                boolean jsonupdateSimilarDeclarationsVal = jsonupdateSimilarDeclarationsJson.getAsBoolean();
                result.setUpdateSimilarDeclarations((boolean)jsonupdateSimilarDeclarationsVal);
            }
            JsonElement jsonmatchStrategyJson = json.get("matchStrategy");
            if (jsonmatchStrategyJson != null && !(jsonmatchStrategyJson.isJsonNull())) {
                org.eclipse.che.jdt.ls.extension.api.MatchStrategy jsonmatchStrategyVal = org.eclipse.che.jdt.ls.extension.api.MatchStrategy.valueOf(jsonmatchStrategyJson.getAsString());;
                result.setMatchStrategy((org.eclipse.che.jdt.ls.extension.api.MatchStrategy)jsonmatchStrategyVal);
            }
            JsonElement jsonupdateTextualMatchesJson = json.get("updateTextualMatches");
            if (jsonupdateTextualMatchesJson != null && !(jsonupdateTextualMatchesJson.isJsonNull())) {
                boolean jsonupdateTextualMatchesVal = jsonupdateTextualMatchesJson.getAsBoolean();
                result.setUpdateTextualMatches((boolean)jsonupdateTextualMatchesVal);
            }
            JsonElement jsonupdateReferencesJson = json.get("updateReferences");
            if (jsonupdateReferencesJson != null && !(jsonupdateReferencesJson.isJsonNull())) {
                boolean jsonupdateReferencesVal = jsonupdateReferencesJson.getAsBoolean();
                result.setUpdateReferences((boolean)jsonupdateReferencesVal);
            }
            JsonElement jsonupdateQualifiedNamesJson = json.get("updateQualifiedNames");
            if (jsonupdateQualifiedNamesJson != null && !(jsonupdateQualifiedNamesJson.isJsonNull())) {
                boolean jsonupdateQualifiedNamesVal = jsonupdateQualifiedNamesJson.getAsBoolean();
                result.setUpdateQualifiedNames((boolean)jsonupdateQualifiedNamesVal);
            }
            JsonElement jsonfilePatternsJson = json.get("filePatterns");
            if (jsonfilePatternsJson != null && !(jsonfilePatternsJson.isJsonNull())) {
                java.lang.String jsonfilePatternsVal = jsonfilePatternsJson.getAsString();;
                result.setFilePatterns((java.lang.String)jsonfilePatternsVal);
            }
            JsonElement jsonrenameParamsJson = json.get("renameParams");
            if (jsonrenameParamsJson != null && !(jsonrenameParamsJson.isJsonNull())) {
                org.eclipse.lsp4j.RenameParams jsonrenameParamsVal = RenameParamsDto.fromJson((JsonObject)jsonrenameParamsJson);;
                result.setRenameParams((org.eclipse.lsp4j.RenameParams)jsonrenameParamsVal);
            }
            JsonElement jsondelegateUpdatingJson = json.get("delegateUpdating");
            if (jsondelegateUpdatingJson != null && !(jsondelegateUpdatingJson.isJsonNull())) {
                boolean jsondelegateUpdatingVal = jsondelegateUpdatingJson.getAsBoolean();
                result.setDelegateUpdating((boolean)jsondelegateUpdatingVal);
            }
            return result;
        }
    }

    public static class RenameSettingsDtoProvider implements DtoProvider<RenameSettingsDto> {
    	public Class<? extends RenameSettingsDto> getImplClass() {
    	  	return RenameSettingsDto.class;
    	}
    
    	public RenameSettingsDto newInstance() {
        	return new RenameSettingsDto();
    	}
    
    	public RenameSettingsDto fromJson(String json) {
    		return RenameSettingsDto.fromJson(json);
    	}
        public RenameSettingsDto fromJson(JsonElement json) {
    		return RenameSettingsDto.fromJson(json);
    	}
        public RenameSettingsDto clone(RenameSettingsDto dto) {
            return RenameSettingsDto.fromJson(dto.toJson());
    	}
    }

    public static class JarEntryDto extends JarEntry implements JsonSerializable {

        public JarEntryDto() {
        }

        public JarEntryDto(org.eclipse.che.jdt.ls.extension.api.dto.JarEntry o) {
            if (o.getEntryType() == null) {
                setEntryType((java.lang.String)null);
            } else {
                java.lang.String entryTypeVal = (java.lang.String)makeDto(o.getEntryType());;
                setEntryType((java.lang.String)entryTypeVal);
            }
            if (o.getPath() == null) {
                setPath((java.lang.String)null);
            } else {
                java.lang.String pathVal = (java.lang.String)makeDto(o.getPath());;
                setPath((java.lang.String)pathVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getEntryType() == null) {
                setEntryType((java.lang.String)null);
            } else {
                JsonElement entryTypeVal = getEntryType() == null ? JsonNull.INSTANCE : new JsonPrimitive(getEntryType());;
                result.add("entryType", entryTypeVal);
            }
            if (getPath() == null) {
                setPath((java.lang.String)null);
            } else {
                JsonElement pathVal = getPath() == null ? JsonNull.INSTANCE : new JsonPrimitive(getPath());;
                result.add("path", pathVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JsonElement uriVal = getUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getUri());;
                result.add("uri", uriVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JsonElement nameVal = getName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getName());;
                result.add("name", nameVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JarEntryDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static JarEntryDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            JarEntryDto result= new JarEntryDto();
            JsonElement jsonentryTypeJson = json.get("entryType");
            if (jsonentryTypeJson != null && !(jsonentryTypeJson.isJsonNull())) {
                java.lang.String jsonentryTypeVal = jsonentryTypeJson.getAsString();;
                result.setEntryType((java.lang.String)jsonentryTypeVal);
            }
            JsonElement jsonpathJson = json.get("path");
            if (jsonpathJson != null && !(jsonpathJson.isJsonNull())) {
                java.lang.String jsonpathVal = jsonpathJson.getAsString();;
                result.setPath((java.lang.String)jsonpathVal);
            }
            JsonElement jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isJsonNull())) {
                java.lang.String jsonuriVal = jsonuriJson.getAsString();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            JsonElement jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isJsonNull())) {
                java.lang.String jsonnameVal = jsonnameJson.getAsString();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class JarEntryDtoProvider implements DtoProvider<JarEntryDto> {
    	public Class<? extends JarEntryDto> getImplClass() {
    	  	return JarEntryDto.class;
    	}
    
    	public JarEntryDto newInstance() {
        	return new JarEntryDto();
    	}
    
    	public JarEntryDto fromJson(String json) {
    		return JarEntryDto.fromJson(json);
    	}
        public JarEntryDto fromJson(JsonElement json) {
    		return JarEntryDto.fromJson(json);
    	}
        public JarEntryDto clone(JarEntryDto dto) {
            return JarEntryDto.fromJson(dto.toJson());
    	}
    }

    public static class RenameSelectionParamsDto extends RenameSelectionParams implements JsonSerializable {

        public RenameSelectionParamsDto() {
        }

        public RenameSelectionParamsDto(org.eclipse.che.jdt.ls.extension.api.dto.RenameSelectionParams o) {
            if (o.getResourceUri() == null) {
                setResourceUri((java.lang.String)null);
            } else {
                java.lang.String resourceUriVal = (java.lang.String)makeDto(o.getResourceUri());;
                setResourceUri((java.lang.String)resourceUriVal);
            }
            if (o.getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.RenameKind renameKindVal = (org.eclipse.che.jdt.ls.extension.api.RenameKind)makeDto(o.getRenameKind());;
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)renameKindVal);
            }
            if (o.getPosition() == null) {
                setPosition((org.eclipse.lsp4j.Position)null);
            } else {
                org.eclipse.lsp4j.Position positionVal = new PositionDto(o.getPosition());
                setPosition((org.eclipse.lsp4j.Position)positionVal);
            }
            if (o.getNewName() == null) {
                setNewName((java.lang.String)null);
            } else {
                java.lang.String newNameVal = (java.lang.String)makeDto(o.getNewName());;
                setNewName((java.lang.String)newNameVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getResourceUri() == null) {
                setResourceUri((java.lang.String)null);
            } else {
                JsonElement resourceUriVal = getResourceUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getResourceUri());;
                result.add("resourceUri", resourceUriVal);
            }
            if (getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                JsonElement renameKindVal = getRenameKind() == null ? JsonNull.INSTANCE : new JsonPrimitive(getRenameKind().name());;
                result.add("renameKind", renameKindVal);
            }
            if (getPosition() == null) {
                setPosition((org.eclipse.lsp4j.Position)null);
            } else {
                JsonElement positionVal = getPosition() == null ? JsonNull.INSTANCE : ((PositionDto)getPosition()).toJsonElement();;
                result.add("position", positionVal);
            }
            if (getNewName() == null) {
                setNewName((java.lang.String)null);
            } else {
                JsonElement newNameVal = getNewName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getNewName());;
                result.add("newName", newNameVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RenameSelectionParamsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static RenameSelectionParamsDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            RenameSelectionParamsDto result= new RenameSelectionParamsDto();
            JsonElement jsonresourceUriJson = json.get("resourceUri");
            if (jsonresourceUriJson != null && !(jsonresourceUriJson.isJsonNull())) {
                java.lang.String jsonresourceUriVal = jsonresourceUriJson.getAsString();;
                result.setResourceUri((java.lang.String)jsonresourceUriVal);
            }
            JsonElement jsonrenameKindJson = json.get("renameKind");
            if (jsonrenameKindJson != null && !(jsonrenameKindJson.isJsonNull())) {
                org.eclipse.che.jdt.ls.extension.api.RenameKind jsonrenameKindVal = org.eclipse.che.jdt.ls.extension.api.RenameKind.valueOf(jsonrenameKindJson.getAsString());;
                result.setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)jsonrenameKindVal);
            }
            JsonElement jsonpositionJson = json.get("position");
            if (jsonpositionJson != null && !(jsonpositionJson.isJsonNull())) {
                org.eclipse.lsp4j.Position jsonpositionVal = PositionDto.fromJson((JsonObject)jsonpositionJson);;
                result.setPosition((org.eclipse.lsp4j.Position)jsonpositionVal);
            }
            JsonElement jsonnewNameJson = json.get("newName");
            if (jsonnewNameJson != null && !(jsonnewNameJson.isJsonNull())) {
                java.lang.String jsonnewNameVal = jsonnewNameJson.getAsString();;
                result.setNewName((java.lang.String)jsonnewNameVal);
            }
            return result;
        }
    }

    public static class RenameSelectionParamsDtoProvider implements DtoProvider<RenameSelectionParamsDto> {
    	public Class<? extends RenameSelectionParamsDto> getImplClass() {
    	  	return RenameSelectionParamsDto.class;
    	}
    
    	public RenameSelectionParamsDto newInstance() {
        	return new RenameSelectionParamsDto();
    	}
    
    	public RenameSelectionParamsDto fromJson(String json) {
    		return RenameSelectionParamsDto.fromJson(json);
    	}
        public RenameSelectionParamsDto fromJson(JsonElement json) {
    		return RenameSelectionParamsDto.fromJson(json);
    	}
        public RenameSelectionParamsDto clone(RenameSelectionParamsDto dto) {
            return RenameSelectionParamsDto.fromJson(dto.toJson());
    	}
    }

    public static class UpdateClasspathParametersDto extends UpdateClasspathParameters implements JsonSerializable {

        public UpdateClasspathParametersDto() {
        }

        public UpdateClasspathParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.UpdateClasspathParameters o) {
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
            if (o.getEntries() == null) {
                setEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry> entriesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry entriesValX : o.getEntries()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry entriesValY = new ClasspathEntryDto(entriesValX);
                        entriesVal.add(entriesValY);
                    }
                setEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)entriesVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JsonElement projectUriVal = getProjectUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getProjectUri());;
                result.add("projectUri", projectUriVal);
            }
            if (getEntries() == null) {
                setEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)null);
            } else {
                JsonArray entriesVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry entriesValX : getEntries()) {
                    JsonElement entriesValY = entriesValX == null ? JsonNull.INSTANCE : ((ClasspathEntryDto)entriesValX).toJsonElement();;
                    entriesVal.add(entriesValY);
                }
                result.add("entries", entriesVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static UpdateClasspathParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static UpdateClasspathParametersDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            UpdateClasspathParametersDto result= new UpdateClasspathParametersDto();
            JsonElement jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isJsonNull())) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.getAsString();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            JsonElement jsonentriesJson = json.get("entries");
            if (jsonentriesJson != null && !(jsonentriesJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry> jsonentriesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>();
                JsonArray jsonentriesVala = jsonentriesJson.getAsJsonArray();
                for(int jsonentriesValai= 0; jsonentriesValai < jsonentriesVala.size(); jsonentriesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry jsonentriesValaX = ClasspathEntryDto.fromJson((JsonObject)jsonentriesVala.get(jsonentriesValai));;
                    jsonentriesVal.add(jsonentriesValaX);
                }
                result.setEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)jsonentriesVal);
            }
            return result;
        }
    }

    public static class UpdateClasspathParametersDtoProvider implements DtoProvider<UpdateClasspathParametersDto> {
    	public Class<? extends UpdateClasspathParametersDto> getImplClass() {
    	  	return UpdateClasspathParametersDto.class;
    	}
    
    	public UpdateClasspathParametersDto newInstance() {
        	return new UpdateClasspathParametersDto();
    	}
    
    	public UpdateClasspathParametersDto fromJson(String json) {
    		return UpdateClasspathParametersDto.fromJson(json);
    	}
        public UpdateClasspathParametersDto fromJson(JsonElement json) {
    		return UpdateClasspathParametersDto.fromJson(json);
    	}
        public UpdateClasspathParametersDto clone(UpdateClasspathParametersDto dto) {
            return UpdateClasspathParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class ResourceDto extends Resource implements JsonSerializable {

        public ResourceDto() {
        }

        public ResourceDto(org.eclipse.che.jdt.ls.extension.api.dto.Resource o) {
                boolean packVal = (boolean)makeDto(o.isPack());;
                setPack((boolean)packVal);
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            JsonElement packVal = new JsonPrimitive(isPack());;
                result.add("pack", packVal);
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JsonElement uriVal = getUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getUri());;
                result.add("uri", uriVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ResourceDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static ResourceDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            ResourceDto result= new ResourceDto();
            JsonElement jsonpackJson = json.get("pack");
            if (jsonpackJson != null && !(jsonpackJson.isJsonNull())) {
                boolean jsonpackVal = jsonpackJson.getAsBoolean();
                result.setPack((boolean)jsonpackVal);
            }
            JsonElement jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isJsonNull())) {
                java.lang.String jsonuriVal = jsonuriJson.getAsString();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            return result;
        }
    }

    public static class ResourceDtoProvider implements DtoProvider<ResourceDto> {
    	public Class<? extends ResourceDto> getImplClass() {
    	  	return ResourceDto.class;
    	}
    
    	public ResourceDto newInstance() {
        	return new ResourceDto();
    	}
    
    	public ResourceDto fromJson(String json) {
    		return ResourceDto.fromJson(json);
    	}
        public ResourceDto fromJson(JsonElement json) {
    		return ResourceDto.fromJson(json);
    	}
        public ResourceDto clone(ResourceDto dto) {
            return ResourceDto.fromJson(dto.toJson());
    	}
    }

    public static class JobResultDto extends JobResult implements JsonSerializable {

        public JobResultDto() {
        }

        public JobResultDto(org.eclipse.che.jdt.ls.extension.api.dto.JobResult o) {
                int resultCodeVal = (int)makeDto(o.getResultCode());;
                setResultCode((int)resultCodeVal);
            if (o.getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                java.lang.String messageVal = (java.lang.String)makeDto(o.getMessage());;
                setMessage((java.lang.String)messageVal);
            }
            if (o.getSeverity() == null) {
                setSeverity((org.eclipse.che.jdt.ls.extension.api.Severity)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.Severity severityVal = (org.eclipse.che.jdt.ls.extension.api.Severity)makeDto(o.getSeverity());;
                setSeverity((org.eclipse.che.jdt.ls.extension.api.Severity)severityVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            JsonElement resultCodeVal = new JsonPrimitive(getResultCode());;
                result.add("resultCode", resultCodeVal);
            if (getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                JsonElement messageVal = getMessage() == null ? JsonNull.INSTANCE : new JsonPrimitive(getMessage());;
                result.add("message", messageVal);
            }
            if (getSeverity() == null) {
                setSeverity((org.eclipse.che.jdt.ls.extension.api.Severity)null);
            } else {
                JsonElement severityVal = getSeverity() == null ? JsonNull.INSTANCE : new JsonPrimitive(getSeverity().name());;
                result.add("severity", severityVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JobResultDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static JobResultDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            JobResultDto result= new JobResultDto();
            JsonElement jsonresultCodeJson = json.get("resultCode");
            if (jsonresultCodeJson != null && !(jsonresultCodeJson.isJsonNull())) {
                int jsonresultCodeVal = (int)jsonresultCodeJson.getAsDouble();;
                result.setResultCode((int)jsonresultCodeVal);
            }
            JsonElement jsonmessageJson = json.get("message");
            if (jsonmessageJson != null && !(jsonmessageJson.isJsonNull())) {
                java.lang.String jsonmessageVal = jsonmessageJson.getAsString();;
                result.setMessage((java.lang.String)jsonmessageVal);
            }
            JsonElement jsonseverityJson = json.get("severity");
            if (jsonseverityJson != null && !(jsonseverityJson.isJsonNull())) {
                org.eclipse.che.jdt.ls.extension.api.Severity jsonseverityVal = org.eclipse.che.jdt.ls.extension.api.Severity.valueOf(jsonseverityJson.getAsString());;
                result.setSeverity((org.eclipse.che.jdt.ls.extension.api.Severity)jsonseverityVal);
            }
            return result;
        }
    }

    public static class JobResultDtoProvider implements DtoProvider<JobResultDto> {
    	public Class<? extends JobResultDto> getImplClass() {
    	  	return JobResultDto.class;
    	}
    
    	public JobResultDto newInstance() {
        	return new JobResultDto();
    	}
    
    	public JobResultDto fromJson(String json) {
    		return JobResultDto.fromJson(json);
    	}
        public JobResultDto fromJson(JsonElement json) {
    		return JobResultDto.fromJson(json);
    	}
        public JobResultDto clone(JobResultDto dto) {
            return JobResultDto.fromJson(dto.toJson());
    	}
    }

    public static class UpdateMavenModulesInfoDto extends UpdateMavenModulesInfo implements JsonSerializable {

        public UpdateMavenModulesInfoDto() {
        }

        public UpdateMavenModulesInfoDto(org.eclipse.che.jdt.ls.extension.api.dto.UpdateMavenModulesInfo o) {
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
            if (o.getAdded() == null) {
                setAdded((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> addedVal= new ArrayList<java.lang.String>();
                    for (java.lang.String addedValX : o.getAdded()) {
                        java.lang.String addedValY = (java.lang.String)makeDto(addedValX);;
                        addedVal.add(addedValY);
                    }
                setAdded((java.util.List<java.lang.String>)addedVal);
            }
            if (o.getRemoved() == null) {
                setRemoved((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> removedVal= new ArrayList<java.lang.String>();
                    for (java.lang.String removedValX : o.getRemoved()) {
                        java.lang.String removedValY = (java.lang.String)makeDto(removedValX);;
                        removedVal.add(removedValY);
                    }
                setRemoved((java.util.List<java.lang.String>)removedVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JsonElement projectUriVal = getProjectUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getProjectUri());;
                result.add("projectUri", projectUriVal);
            }
            if (getAdded() == null) {
                setAdded((java.util.List<java.lang.String>)null);
            } else {
                JsonArray addedVal = new JsonArray();
                for (java.lang.String addedValX : getAdded()) {
                    JsonElement addedValY = addedValX == null ? JsonNull.INSTANCE : new JsonPrimitive(addedValX);;
                    addedVal.add(addedValY);
                }
                result.add("added", addedVal);
            }
            if (getRemoved() == null) {
                setRemoved((java.util.List<java.lang.String>)null);
            } else {
                JsonArray removedVal = new JsonArray();
                for (java.lang.String removedValX : getRemoved()) {
                    JsonElement removedValY = removedValX == null ? JsonNull.INSTANCE : new JsonPrimitive(removedValX);;
                    removedVal.add(removedValY);
                }
                result.add("removed", removedVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static UpdateMavenModulesInfoDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static UpdateMavenModulesInfoDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            UpdateMavenModulesInfoDto result= new UpdateMavenModulesInfoDto();
            JsonElement jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isJsonNull())) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.getAsString();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            JsonElement jsonaddedJson = json.get("added");
            if (jsonaddedJson != null && !(jsonaddedJson.isJsonNull())) {
                ArrayList<java.lang.String> jsonaddedVal= new ArrayList<java.lang.String>();
                JsonArray jsonaddedVala = jsonaddedJson.getAsJsonArray();
                for(int jsonaddedValai= 0; jsonaddedValai < jsonaddedVala.size(); jsonaddedValai++) {
                    java.lang.String jsonaddedValaX = jsonaddedVala.get(jsonaddedValai).getAsString();;
                    jsonaddedVal.add(jsonaddedValaX);
                }
                result.setAdded((java.util.List<java.lang.String>)jsonaddedVal);
            }
            JsonElement jsonremovedJson = json.get("removed");
            if (jsonremovedJson != null && !(jsonremovedJson.isJsonNull())) {
                ArrayList<java.lang.String> jsonremovedVal= new ArrayList<java.lang.String>();
                JsonArray jsonremovedVala = jsonremovedJson.getAsJsonArray();
                for(int jsonremovedValai= 0; jsonremovedValai < jsonremovedVala.size(); jsonremovedValai++) {
                    java.lang.String jsonremovedValaX = jsonremovedVala.get(jsonremovedValai).getAsString();;
                    jsonremovedVal.add(jsonremovedValaX);
                }
                result.setRemoved((java.util.List<java.lang.String>)jsonremovedVal);
            }
            return result;
        }
    }

    public static class UpdateMavenModulesInfoDtoProvider implements DtoProvider<UpdateMavenModulesInfoDto> {
    	public Class<? extends UpdateMavenModulesInfoDto> getImplClass() {
    	  	return UpdateMavenModulesInfoDto.class;
    	}
    
    	public UpdateMavenModulesInfoDto newInstance() {
        	return new UpdateMavenModulesInfoDto();
    	}
    
    	public UpdateMavenModulesInfoDto fromJson(String json) {
    		return UpdateMavenModulesInfoDto.fromJson(json);
    	}
        public UpdateMavenModulesInfoDto fromJson(JsonElement json) {
    		return UpdateMavenModulesInfoDto.fromJson(json);
    	}
        public UpdateMavenModulesInfoDto clone(UpdateMavenModulesInfoDto dto) {
            return UpdateMavenModulesInfoDto.fromJson(dto.toJson());
    	}
    }

    public static class ExternalLibrariesParametersDto extends ExternalLibrariesParameters implements JsonSerializable {

        public ExternalLibrariesParametersDto() {
        }

        public ExternalLibrariesParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.ExternalLibrariesParameters o) {
            if (o.getNodePath() == null) {
                setNodePath((java.lang.String)null);
            } else {
                java.lang.String nodePathVal = (java.lang.String)makeDto(o.getNodePath());;
                setNodePath((java.lang.String)nodePathVal);
            }
            if (o.getNodeId() == null) {
                setNodeId((java.lang.String)null);
            } else {
                java.lang.String nodeIdVal = (java.lang.String)makeDto(o.getNodeId());;
                setNodeId((java.lang.String)nodeIdVal);
            }
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getNodePath() == null) {
                setNodePath((java.lang.String)null);
            } else {
                JsonElement nodePathVal = getNodePath() == null ? JsonNull.INSTANCE : new JsonPrimitive(getNodePath());;
                result.add("nodePath", nodePathVal);
            }
            if (getNodeId() == null) {
                setNodeId((java.lang.String)null);
            } else {
                JsonElement nodeIdVal = getNodeId() == null ? JsonNull.INSTANCE : new JsonPrimitive(getNodeId());;
                result.add("nodeId", nodeIdVal);
            }
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JsonElement projectUriVal = getProjectUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getProjectUri());;
                result.add("projectUri", projectUriVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ExternalLibrariesParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static ExternalLibrariesParametersDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            ExternalLibrariesParametersDto result= new ExternalLibrariesParametersDto();
            JsonElement jsonnodePathJson = json.get("nodePath");
            if (jsonnodePathJson != null && !(jsonnodePathJson.isJsonNull())) {
                java.lang.String jsonnodePathVal = jsonnodePathJson.getAsString();;
                result.setNodePath((java.lang.String)jsonnodePathVal);
            }
            JsonElement jsonnodeIdJson = json.get("nodeId");
            if (jsonnodeIdJson != null && !(jsonnodeIdJson.isJsonNull())) {
                java.lang.String jsonnodeIdVal = jsonnodeIdJson.getAsString();;
                result.setNodeId((java.lang.String)jsonnodeIdVal);
            }
            JsonElement jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isJsonNull())) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.getAsString();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            return result;
        }
    }

    public static class ExternalLibrariesParametersDtoProvider implements DtoProvider<ExternalLibrariesParametersDto> {
    	public Class<? extends ExternalLibrariesParametersDto> getImplClass() {
    	  	return ExternalLibrariesParametersDto.class;
    	}
    
    	public ExternalLibrariesParametersDto newInstance() {
        	return new ExternalLibrariesParametersDto();
    	}
    
    	public ExternalLibrariesParametersDto fromJson(String json) {
    		return ExternalLibrariesParametersDto.fromJson(json);
    	}
        public ExternalLibrariesParametersDto fromJson(JsonElement json) {
    		return ExternalLibrariesParametersDto.fromJson(json);
    	}
        public ExternalLibrariesParametersDto clone(ExternalLibrariesParametersDto dto) {
            return ExternalLibrariesParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class TextDocumentIdentifierDto extends TextDocumentIdentifier implements JsonSerializable {

        public TextDocumentIdentifierDto() {
        }

        public TextDocumentIdentifierDto(org.eclipse.lsp4j.TextDocumentIdentifier o) {
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JsonElement uriVal = getUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getUri());;
                result.add("uri", uriVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static TextDocumentIdentifierDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static TextDocumentIdentifierDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            TextDocumentIdentifierDto result= new TextDocumentIdentifierDto();
            JsonElement jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isJsonNull())) {
                java.lang.String jsonuriVal = jsonuriJson.getAsString();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            return result;
        }
    }

    public static class TextDocumentIdentifierDtoProvider implements DtoProvider<TextDocumentIdentifierDto> {
    	public Class<? extends TextDocumentIdentifierDto> getImplClass() {
    	  	return TextDocumentIdentifierDto.class;
    	}
    
    	public TextDocumentIdentifierDto newInstance() {
        	return new TextDocumentIdentifierDto();
    	}
    
    	public TextDocumentIdentifierDto fromJson(String json) {
    		return TextDocumentIdentifierDto.fromJson(json);
    	}
        public TextDocumentIdentifierDto fromJson(JsonElement json) {
    		return TextDocumentIdentifierDto.fromJson(json);
    	}
        public TextDocumentIdentifierDto clone(TextDocumentIdentifierDto dto) {
            return TextDocumentIdentifierDto.fromJson(dto.toJson());
    	}
    }

    public static class FileStructureCommandParametersDto extends FileStructureCommandParameters implements JsonSerializable {

        public FileStructureCommandParametersDto() {
        }

        public FileStructureCommandParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.FileStructureCommandParameters o) {
                boolean showInheritedVal = (boolean)makeDto(o.getShowInherited());;
                setShowInherited((boolean)showInheritedVal);
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            JsonElement showInheritedVal = new JsonPrimitive(getShowInherited());;
                result.add("showInherited", showInheritedVal);
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JsonElement uriVal = getUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getUri());;
                result.add("uri", uriVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static FileStructureCommandParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static FileStructureCommandParametersDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            FileStructureCommandParametersDto result= new FileStructureCommandParametersDto();
            JsonElement jsonshowInheritedJson = json.get("showInherited");
            if (jsonshowInheritedJson != null && !(jsonshowInheritedJson.isJsonNull())) {
                boolean jsonshowInheritedVal = jsonshowInheritedJson.getAsBoolean();
                result.setShowInherited((boolean)jsonshowInheritedVal);
            }
            JsonElement jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isJsonNull())) {
                java.lang.String jsonuriVal = jsonuriJson.getAsString();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            return result;
        }
    }

    public static class FileStructureCommandParametersDtoProvider implements DtoProvider<FileStructureCommandParametersDto> {
    	public Class<? extends FileStructureCommandParametersDto> getImplClass() {
    	  	return FileStructureCommandParametersDto.class;
    	}
    
    	public FileStructureCommandParametersDto newInstance() {
        	return new FileStructureCommandParametersDto();
    	}
    
    	public FileStructureCommandParametersDto fromJson(String json) {
    		return FileStructureCommandParametersDto.fromJson(json);
    	}
        public FileStructureCommandParametersDto fromJson(JsonElement json) {
    		return FileStructureCommandParametersDto.fromJson(json);
    	}
        public FileStructureCommandParametersDto clone(FileStructureCommandParametersDto dto) {
            return FileStructureCommandParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class TestPositionDto extends TestPosition implements JsonSerializable {

        public TestPositionDto() {
        }

        public TestPositionDto(org.eclipse.che.jdt.ls.extension.api.dto.TestPosition o) {
            if (o.getTestName() == null) {
                setTestName((java.lang.String)null);
            } else {
                java.lang.String testNameVal = (java.lang.String)makeDto(o.getTestName());;
                setTestName((java.lang.String)testNameVal);
            }
                int testNameStartOffsetVal = (int)makeDto(o.getTestNameStartOffset());;
                setTestNameStartOffset((int)testNameStartOffsetVal);
                int testBodyLengthVal = (int)makeDto(o.getTestBodyLength());;
                setTestBodyLength((int)testBodyLengthVal);
                int testNameLengthVal = (int)makeDto(o.getTestNameLength());;
                setTestNameLength((int)testNameLengthVal);
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getTestName() == null) {
                setTestName((java.lang.String)null);
            } else {
                JsonElement testNameVal = getTestName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getTestName());;
                result.add("testName", testNameVal);
            }
            JsonElement testNameStartOffsetVal = new JsonPrimitive(getTestNameStartOffset());;
                result.add("testNameStartOffset", testNameStartOffsetVal);
            JsonElement testBodyLengthVal = new JsonPrimitive(getTestBodyLength());;
                result.add("testBodyLength", testBodyLengthVal);
            JsonElement testNameLengthVal = new JsonPrimitive(getTestNameLength());;
                result.add("testNameLength", testNameLengthVal);
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static TestPositionDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static TestPositionDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            TestPositionDto result= new TestPositionDto();
            JsonElement jsontestNameJson = json.get("testName");
            if (jsontestNameJson != null && !(jsontestNameJson.isJsonNull())) {
                java.lang.String jsontestNameVal = jsontestNameJson.getAsString();;
                result.setTestName((java.lang.String)jsontestNameVal);
            }
            JsonElement jsontestNameStartOffsetJson = json.get("testNameStartOffset");
            if (jsontestNameStartOffsetJson != null && !(jsontestNameStartOffsetJson.isJsonNull())) {
                int jsontestNameStartOffsetVal = (int)jsontestNameStartOffsetJson.getAsDouble();;
                result.setTestNameStartOffset((int)jsontestNameStartOffsetVal);
            }
            JsonElement jsontestBodyLengthJson = json.get("testBodyLength");
            if (jsontestBodyLengthJson != null && !(jsontestBodyLengthJson.isJsonNull())) {
                int jsontestBodyLengthVal = (int)jsontestBodyLengthJson.getAsDouble();;
                result.setTestBodyLength((int)jsontestBodyLengthVal);
            }
            JsonElement jsontestNameLengthJson = json.get("testNameLength");
            if (jsontestNameLengthJson != null && !(jsontestNameLengthJson.isJsonNull())) {
                int jsontestNameLengthVal = (int)jsontestNameLengthJson.getAsDouble();;
                result.setTestNameLength((int)jsontestNameLengthVal);
            }
            return result;
        }
    }

    public static class TestPositionDtoProvider implements DtoProvider<TestPositionDto> {
    	public Class<? extends TestPositionDto> getImplClass() {
    	  	return TestPositionDto.class;
    	}
    
    	public TestPositionDto newInstance() {
        	return new TestPositionDto();
    	}
    
    	public TestPositionDto fromJson(String json) {
    		return TestPositionDto.fromJson(json);
    	}
        public TestPositionDto fromJson(JsonElement json) {
    		return TestPositionDto.fromJson(json);
    	}
        public TestPositionDto clone(TestPositionDto dto) {
            return TestPositionDto.fromJson(dto.toJson());
    	}
    }

    public static class TestPositionParametersDto extends TestPositionParameters implements JsonSerializable {

        public TestPositionParametersDto() {
        }

        public TestPositionParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.TestPositionParameters o) {
                int cursorOffsetVal = (int)makeDto(o.getCursorOffset());;
                setCursorOffset((int)cursorOffsetVal);
            if (o.getTestAnnotation() == null) {
                setTestAnnotation((java.lang.String)null);
            } else {
                java.lang.String testAnnotationVal = (java.lang.String)makeDto(o.getTestAnnotation());;
                setTestAnnotation((java.lang.String)testAnnotationVal);
            }
            if (o.getFileUri() == null) {
                setFileUri((java.lang.String)null);
            } else {
                java.lang.String fileUriVal = (java.lang.String)makeDto(o.getFileUri());;
                setFileUri((java.lang.String)fileUriVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            JsonElement cursorOffsetVal = new JsonPrimitive(getCursorOffset());;
                result.add("cursorOffset", cursorOffsetVal);
            if (getTestAnnotation() == null) {
                setTestAnnotation((java.lang.String)null);
            } else {
                JsonElement testAnnotationVal = getTestAnnotation() == null ? JsonNull.INSTANCE : new JsonPrimitive(getTestAnnotation());;
                result.add("testAnnotation", testAnnotationVal);
            }
            if (getFileUri() == null) {
                setFileUri((java.lang.String)null);
            } else {
                JsonElement fileUriVal = getFileUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getFileUri());;
                result.add("fileUri", fileUriVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static TestPositionParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static TestPositionParametersDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            TestPositionParametersDto result= new TestPositionParametersDto();
            JsonElement jsoncursorOffsetJson = json.get("cursorOffset");
            if (jsoncursorOffsetJson != null && !(jsoncursorOffsetJson.isJsonNull())) {
                int jsoncursorOffsetVal = (int)jsoncursorOffsetJson.getAsDouble();;
                result.setCursorOffset((int)jsoncursorOffsetVal);
            }
            JsonElement jsontestAnnotationJson = json.get("testAnnotation");
            if (jsontestAnnotationJson != null && !(jsontestAnnotationJson.isJsonNull())) {
                java.lang.String jsontestAnnotationVal = jsontestAnnotationJson.getAsString();;
                result.setTestAnnotation((java.lang.String)jsontestAnnotationVal);
            }
            JsonElement jsonfileUriJson = json.get("fileUri");
            if (jsonfileUriJson != null && !(jsonfileUriJson.isJsonNull())) {
                java.lang.String jsonfileUriVal = jsonfileUriJson.getAsString();;
                result.setFileUri((java.lang.String)jsonfileUriVal);
            }
            return result;
        }
    }

    public static class TestPositionParametersDtoProvider implements DtoProvider<TestPositionParametersDto> {
    	public Class<? extends TestPositionParametersDto> getImplClass() {
    	  	return TestPositionParametersDto.class;
    	}
    
    	public TestPositionParametersDto newInstance() {
        	return new TestPositionParametersDto();
    	}
    
    	public TestPositionParametersDto fromJson(String json) {
    		return TestPositionParametersDto.fromJson(json);
    	}
        public TestPositionParametersDto fromJson(JsonElement json) {
    		return TestPositionParametersDto.fromJson(json);
    	}
        public TestPositionParametersDto clone(TestPositionParametersDto dto) {
            return TestPositionParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class TextDocumentEditDto extends TextDocumentEdit implements JsonSerializable {

        public TextDocumentEditDto() {
        }

        public TextDocumentEditDto(org.eclipse.lsp4j.TextDocumentEdit o) {
            if (o.getTextDocument() == null) {
                setTextDocument((org.eclipse.lsp4j.VersionedTextDocumentIdentifier)null);
            } else {
                org.eclipse.lsp4j.VersionedTextDocumentIdentifier textDocumentVal = new VersionedTextDocumentIdentifierDto(o.getTextDocument());
                setTextDocument((org.eclipse.lsp4j.VersionedTextDocumentIdentifier)textDocumentVal);
            }
            if (o.getEdits() == null) {
                setEdits((java.util.List<org.eclipse.lsp4j.TextEdit>)null);
            } else {
                    ArrayList<org.eclipse.lsp4j.TextEdit> editsVal= new ArrayList<org.eclipse.lsp4j.TextEdit>();
                    for (org.eclipse.lsp4j.TextEdit editsValX : o.getEdits()) {
                        org.eclipse.lsp4j.TextEdit editsValY = new TextEditDto(editsValX);
                        editsVal.add(editsValY);
                    }
                setEdits((java.util.List<org.eclipse.lsp4j.TextEdit>)editsVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getTextDocument() == null) {
                setTextDocument((org.eclipse.lsp4j.VersionedTextDocumentIdentifier)null);
            } else {
                JsonElement textDocumentVal = getTextDocument() == null ? JsonNull.INSTANCE : ((VersionedTextDocumentIdentifierDto)getTextDocument()).toJsonElement();;
                result.add("textDocument", textDocumentVal);
            }
            if (getEdits() == null) {
                setEdits((java.util.List<org.eclipse.lsp4j.TextEdit>)null);
            } else {
                JsonArray editsVal = new JsonArray();
                for (org.eclipse.lsp4j.TextEdit editsValX : getEdits()) {
                    JsonElement editsValY = editsValX == null ? JsonNull.INSTANCE : ((TextEditDto)editsValX).toJsonElement();;
                    editsVal.add(editsValY);
                }
                result.add("edits", editsVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static TextDocumentEditDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static TextDocumentEditDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            TextDocumentEditDto result= new TextDocumentEditDto();
            JsonElement jsontextDocumentJson = json.get("textDocument");
            if (jsontextDocumentJson != null && !(jsontextDocumentJson.isJsonNull())) {
                org.eclipse.lsp4j.VersionedTextDocumentIdentifier jsontextDocumentVal = VersionedTextDocumentIdentifierDto.fromJson((JsonObject)jsontextDocumentJson);;
                result.setTextDocument((org.eclipse.lsp4j.VersionedTextDocumentIdentifier)jsontextDocumentVal);
            }
            JsonElement jsoneditsJson = json.get("edits");
            if (jsoneditsJson != null && !(jsoneditsJson.isJsonNull())) {
                ArrayList<org.eclipse.lsp4j.TextEdit> jsoneditsVal= new ArrayList<org.eclipse.lsp4j.TextEdit>();
                JsonArray jsoneditsVala = jsoneditsJson.getAsJsonArray();
                for(int jsoneditsValai= 0; jsoneditsValai < jsoneditsVala.size(); jsoneditsValai++) {
                    org.eclipse.lsp4j.TextEdit jsoneditsValaX = TextEditDto.fromJson((JsonObject)jsoneditsVala.get(jsoneditsValai));;
                    jsoneditsVal.add(jsoneditsValaX);
                }
                result.setEdits((java.util.List<org.eclipse.lsp4j.TextEdit>)jsoneditsVal);
            }
            return result;
        }
    }

    public static class TextDocumentEditDtoProvider implements DtoProvider<TextDocumentEditDto> {
    	public Class<? extends TextDocumentEditDto> getImplClass() {
    	  	return TextDocumentEditDto.class;
    	}
    
    	public TextDocumentEditDto newInstance() {
        	return new TextDocumentEditDto();
    	}
    
    	public TextDocumentEditDto fromJson(String json) {
    		return TextDocumentEditDto.fromJson(json);
    	}
        public TextDocumentEditDto fromJson(JsonElement json) {
    		return TextDocumentEditDto.fromJson(json);
    	}
        public TextDocumentEditDto clone(TextDocumentEditDto dto) {
            return TextDocumentEditDto.fromJson(dto.toJson());
    	}
    }

    public static class TextEditDto extends TextEdit implements JsonSerializable {

        public TextEditDto() {
        }

        public TextEditDto(org.eclipse.lsp4j.TextEdit o) {
            if (o.getNewText() == null) {
                setNewText((java.lang.String)null);
            } else {
                java.lang.String newTextVal = (java.lang.String)makeDto(o.getNewText());;
                setNewText((java.lang.String)newTextVal);
            }
            if (o.getRange() == null) {
                setRange((org.eclipse.lsp4j.Range)null);
            } else {
                org.eclipse.lsp4j.Range rangeVal = new RangeDto(o.getRange());
                setRange((org.eclipse.lsp4j.Range)rangeVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getNewText() == null) {
                setNewText((java.lang.String)null);
            } else {
                JsonElement newTextVal = getNewText() == null ? JsonNull.INSTANCE : new JsonPrimitive(getNewText());;
                result.add("newText", newTextVal);
            }
            if (getRange() == null) {
                setRange((org.eclipse.lsp4j.Range)null);
            } else {
                JsonElement rangeVal = getRange() == null ? JsonNull.INSTANCE : ((RangeDto)getRange()).toJsonElement();;
                result.add("range", rangeVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static TextEditDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static TextEditDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            TextEditDto result= new TextEditDto();
            JsonElement jsonnewTextJson = json.get("newText");
            if (jsonnewTextJson != null && !(jsonnewTextJson.isJsonNull())) {
                java.lang.String jsonnewTextVal = jsonnewTextJson.getAsString();;
                result.setNewText((java.lang.String)jsonnewTextVal);
            }
            JsonElement jsonrangeJson = json.get("range");
            if (jsonrangeJson != null && !(jsonrangeJson.isJsonNull())) {
                org.eclipse.lsp4j.Range jsonrangeVal = RangeDto.fromJson((JsonObject)jsonrangeJson);;
                result.setRange((org.eclipse.lsp4j.Range)jsonrangeVal);
            }
            return result;
        }
    }

    public static class TextEditDtoProvider implements DtoProvider<TextEditDto> {
    	public Class<? extends TextEditDto> getImplClass() {
    	  	return TextEditDto.class;
    	}
    
    	public TextEditDto newInstance() {
        	return new TextEditDto();
    	}
    
    	public TextEditDto fromJson(String json) {
    		return TextEditDto.fromJson(json);
    	}
        public TextEditDto fromJson(JsonElement json) {
    		return TextEditDto.fromJson(json);
    	}
        public TextEditDto clone(TextEditDto dto) {
            return TextEditDto.fromJson(dto.toJson());
    	}
    }

    public static class CheResourceChangeDto extends CheResourceChange implements JsonSerializable {

        public CheResourceChangeDto() {
        }

        public CheResourceChangeDto(org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange o) {
            if (o.getResourceKind() == null) {
                setResourceKind((org.eclipse.che.jdt.ls.extension.api.ResourceKind)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.ResourceKind resourceKindVal = (org.eclipse.che.jdt.ls.extension.api.ResourceKind)makeDto(o.getResourceKind());;
                setResourceKind((org.eclipse.che.jdt.ls.extension.api.ResourceKind)resourceKindVal);
            }
            if (o.getDescription() == null) {
                setDescription((java.lang.String)null);
            } else {
                java.lang.String descriptionVal = (java.lang.String)makeDto(o.getDescription());;
                setDescription((java.lang.String)descriptionVal);
            }
            if (o.getCurrent() == null) {
                setCurrent((java.lang.String)null);
            } else {
                java.lang.String currentVal = (java.lang.String)makeDto(o.getCurrent());;
                setCurrent((java.lang.String)currentVal);
            }
            if (o.getNewUri() == null) {
                setNewUri((java.lang.String)null);
            } else {
                java.lang.String newUriVal = (java.lang.String)makeDto(o.getNewUri());;
                setNewUri((java.lang.String)newUriVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getResourceKind() == null) {
                setResourceKind((org.eclipse.che.jdt.ls.extension.api.ResourceKind)null);
            } else {
                JsonElement resourceKindVal = getResourceKind() == null ? JsonNull.INSTANCE : new JsonPrimitive(getResourceKind().name());;
                result.add("resourceKind", resourceKindVal);
            }
            if (getDescription() == null) {
                setDescription((java.lang.String)null);
            } else {
                JsonElement descriptionVal = getDescription() == null ? JsonNull.INSTANCE : new JsonPrimitive(getDescription());;
                result.add("description", descriptionVal);
            }
            if (getCurrent() == null) {
                setCurrent((java.lang.String)null);
            } else {
                JsonElement currentVal = getCurrent() == null ? JsonNull.INSTANCE : new JsonPrimitive(getCurrent());;
                result.add("current", currentVal);
            }
            if (getNewUri() == null) {
                setNewUri((java.lang.String)null);
            } else {
                JsonElement newUriVal = getNewUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getNewUri());;
                result.add("newUri", newUriVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static CheResourceChangeDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static CheResourceChangeDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            CheResourceChangeDto result= new CheResourceChangeDto();
            JsonElement jsonresourceKindJson = json.get("resourceKind");
            if (jsonresourceKindJson != null && !(jsonresourceKindJson.isJsonNull())) {
                org.eclipse.che.jdt.ls.extension.api.ResourceKind jsonresourceKindVal = org.eclipse.che.jdt.ls.extension.api.ResourceKind.valueOf(jsonresourceKindJson.getAsString());;
                result.setResourceKind((org.eclipse.che.jdt.ls.extension.api.ResourceKind)jsonresourceKindVal);
            }
            JsonElement jsondescriptionJson = json.get("description");
            if (jsondescriptionJson != null && !(jsondescriptionJson.isJsonNull())) {
                java.lang.String jsondescriptionVal = jsondescriptionJson.getAsString();;
                result.setDescription((java.lang.String)jsondescriptionVal);
            }
            JsonElement jsoncurrentJson = json.get("current");
            if (jsoncurrentJson != null && !(jsoncurrentJson.isJsonNull())) {
                java.lang.String jsoncurrentVal = jsoncurrentJson.getAsString();;
                result.setCurrent((java.lang.String)jsoncurrentVal);
            }
            JsonElement jsonnewUriJson = json.get("newUri");
            if (jsonnewUriJson != null && !(jsonnewUriJson.isJsonNull())) {
                java.lang.String jsonnewUriVal = jsonnewUriJson.getAsString();;
                result.setNewUri((java.lang.String)jsonnewUriVal);
            }
            return result;
        }
    }

    public static class CheResourceChangeDtoProvider implements DtoProvider<CheResourceChangeDto> {
    	public Class<? extends CheResourceChangeDto> getImplClass() {
    	  	return CheResourceChangeDto.class;
    	}
    
    	public CheResourceChangeDto newInstance() {
        	return new CheResourceChangeDto();
    	}
    
    	public CheResourceChangeDto fromJson(String json) {
    		return CheResourceChangeDto.fromJson(json);
    	}
        public CheResourceChangeDto fromJson(JsonElement json) {
    		return CheResourceChangeDto.fromJson(json);
    	}
        public CheResourceChangeDto clone(CheResourceChangeDto dto) {
            return CheResourceChangeDto.fromJson(dto.toJson());
    	}
    }

    public static class SymbolInformationDto extends SymbolInformation implements JsonSerializable {

        public SymbolInformationDto() {
        }

        public SymbolInformationDto(org.eclipse.lsp4j.SymbolInformation o) {
            if (o.getLocation() == null) {
                setLocation((org.eclipse.lsp4j.Location)null);
            } else {
                org.eclipse.lsp4j.Location locationVal = new LocationDto(o.getLocation());
                setLocation((org.eclipse.lsp4j.Location)locationVal);
            }
            if (o.getDeprecated() == null) {
                setDeprecated((java.lang.Boolean)null);
            } else {
                java.lang.Boolean deprecatedVal = (java.lang.Boolean)makeDto(o.getDeprecated());;
                setDeprecated((java.lang.Boolean)deprecatedVal);
            }
            if (o.getKind() == null) {
                setKind((org.eclipse.lsp4j.SymbolKind)null);
            } else {
                org.eclipse.lsp4j.SymbolKind kindVal = (org.eclipse.lsp4j.SymbolKind)makeDto(o.getKind());;
                setKind((org.eclipse.lsp4j.SymbolKind)kindVal);
            }
            if (o.getContainerName() == null) {
                setContainerName((java.lang.String)null);
            } else {
                java.lang.String containerNameVal = (java.lang.String)makeDto(o.getContainerName());;
                setContainerName((java.lang.String)containerNameVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getLocation() == null) {
                setLocation((org.eclipse.lsp4j.Location)null);
            } else {
                JsonElement locationVal = getLocation() == null ? JsonNull.INSTANCE : ((LocationDto)getLocation()).toJsonElement();;
                result.add("location", locationVal);
            }
            if (getDeprecated() == null) {
                setDeprecated((java.lang.Boolean)null);
            } else {
                JsonElement deprecatedVal = getDeprecated() == null ? JsonNull.INSTANCE : new JsonPrimitive(getDeprecated());;
                result.add("deprecated", deprecatedVal);
            }
            if (getKind() == null) {
                setKind((org.eclipse.lsp4j.SymbolKind)null);
            } else {
                JsonElement kindVal = getKind() == null ? JsonNull.INSTANCE : new JsonPrimitive(getKind().name());;
                result.add("kind", kindVal);
            }
            if (getContainerName() == null) {
                setContainerName((java.lang.String)null);
            } else {
                JsonElement containerNameVal = getContainerName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getContainerName());;
                result.add("containerName", containerNameVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JsonElement nameVal = getName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getName());;
                result.add("name", nameVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static SymbolInformationDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static SymbolInformationDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            SymbolInformationDto result= new SymbolInformationDto();
            JsonElement jsonlocationJson = json.get("location");
            if (jsonlocationJson != null && !(jsonlocationJson.isJsonNull())) {
                org.eclipse.lsp4j.Location jsonlocationVal = LocationDto.fromJson((JsonObject)jsonlocationJson);;
                result.setLocation((org.eclipse.lsp4j.Location)jsonlocationVal);
            }
            JsonElement jsondeprecatedJson = json.get("deprecated");
            if (jsondeprecatedJson != null && !(jsondeprecatedJson.isJsonNull())) {
                java.lang.Boolean jsondeprecatedVal = jsondeprecatedJson.getAsBoolean();
                result.setDeprecated((java.lang.Boolean)jsondeprecatedVal);
            }
            JsonElement jsonkindJson = json.get("kind");
            if (jsonkindJson != null && !(jsonkindJson.isJsonNull())) {
                org.eclipse.lsp4j.SymbolKind jsonkindVal = org.eclipse.lsp4j.SymbolKind.valueOf(jsonkindJson.getAsString());;
                result.setKind((org.eclipse.lsp4j.SymbolKind)jsonkindVal);
            }
            JsonElement jsoncontainerNameJson = json.get("containerName");
            if (jsoncontainerNameJson != null && !(jsoncontainerNameJson.isJsonNull())) {
                java.lang.String jsoncontainerNameVal = jsoncontainerNameJson.getAsString();;
                result.setContainerName((java.lang.String)jsoncontainerNameVal);
            }
            JsonElement jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isJsonNull())) {
                java.lang.String jsonnameVal = jsonnameJson.getAsString();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class SymbolInformationDtoProvider implements DtoProvider<SymbolInformationDto> {
    	public Class<? extends SymbolInformationDto> getImplClass() {
    	  	return SymbolInformationDto.class;
    	}
    
    	public SymbolInformationDto newInstance() {
        	return new SymbolInformationDto();
    	}
    
    	public SymbolInformationDto fromJson(String json) {
    		return SymbolInformationDto.fromJson(json);
    	}
        public SymbolInformationDto fromJson(JsonElement json) {
    		return SymbolInformationDto.fromJson(json);
    	}
        public SymbolInformationDto clone(SymbolInformationDto dto) {
            return SymbolInformationDto.fromJson(dto.toJson());
    	}
    }

    public static class PackageFragmentDto extends PackageFragment implements JsonSerializable {

        public PackageFragmentDto() {
        }

        public PackageFragmentDto(org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment o) {
                boolean defaultPackageVal = (boolean)makeDto(o.isDefaultPackage());;
                setDefaultPackage((boolean)defaultPackageVal);
            if (o.getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                java.lang.String projectUriVal = (java.lang.String)makeDto(o.getProjectUri());;
                setProjectUri((java.lang.String)projectUriVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            JsonElement defaultPackageVal = new JsonPrimitive(isDefaultPackage());;
                result.add("defaultPackage", defaultPackageVal);
            if (getProjectUri() == null) {
                setProjectUri((java.lang.String)null);
            } else {
                JsonElement projectUriVal = getProjectUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getProjectUri());;
                result.add("projectUri", projectUriVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JsonElement uriVal = getUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getUri());;
                result.add("uri", uriVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JsonElement nameVal = getName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getName());;
                result.add("name", nameVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static PackageFragmentDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static PackageFragmentDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            PackageFragmentDto result= new PackageFragmentDto();
            JsonElement jsondefaultPackageJson = json.get("defaultPackage");
            if (jsondefaultPackageJson != null && !(jsondefaultPackageJson.isJsonNull())) {
                boolean jsondefaultPackageVal = jsondefaultPackageJson.getAsBoolean();
                result.setDefaultPackage((boolean)jsondefaultPackageVal);
            }
            JsonElement jsonprojectUriJson = json.get("projectUri");
            if (jsonprojectUriJson != null && !(jsonprojectUriJson.isJsonNull())) {
                java.lang.String jsonprojectUriVal = jsonprojectUriJson.getAsString();;
                result.setProjectUri((java.lang.String)jsonprojectUriVal);
            }
            JsonElement jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isJsonNull())) {
                java.lang.String jsonuriVal = jsonuriJson.getAsString();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            JsonElement jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isJsonNull())) {
                java.lang.String jsonnameVal = jsonnameJson.getAsString();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class PackageFragmentDtoProvider implements DtoProvider<PackageFragmentDto> {
    	public Class<? extends PackageFragmentDto> getImplClass() {
    	  	return PackageFragmentDto.class;
    	}
    
    	public PackageFragmentDto newInstance() {
        	return new PackageFragmentDto();
    	}
    
    	public PackageFragmentDto fromJson(String json) {
    		return PackageFragmentDto.fromJson(json);
    	}
        public PackageFragmentDto fromJson(JsonElement json) {
    		return PackageFragmentDto.fromJson(json);
    	}
        public PackageFragmentDto clone(PackageFragmentDto dto) {
            return PackageFragmentDto.fromJson(dto.toJson());
    	}
    }

    public static class ImplementersResponseDto extends ImplementersResponse implements JsonSerializable {

        public ImplementersResponseDto() {
        }

        public ImplementersResponseDto(org.eclipse.che.jdt.ls.extension.api.dto.ImplementersResponse o) {
            if (o.getSearchedElement() == null) {
                setSearchedElement((java.lang.String)null);
            } else {
                java.lang.String searchedElementVal = (java.lang.String)makeDto(o.getSearchedElement());;
                setSearchedElement((java.lang.String)searchedElementVal);
            }
            if (o.getImplementers() == null) {
                setImplementers((java.util.List<org.eclipse.lsp4j.SymbolInformation>)null);
            } else {
                    ArrayList<org.eclipse.lsp4j.SymbolInformation> implementersVal= new ArrayList<org.eclipse.lsp4j.SymbolInformation>();
                    for (org.eclipse.lsp4j.SymbolInformation implementersValX : o.getImplementers()) {
                        org.eclipse.lsp4j.SymbolInformation implementersValY = new SymbolInformationDto(implementersValX);
                        implementersVal.add(implementersValY);
                    }
                setImplementers((java.util.List<org.eclipse.lsp4j.SymbolInformation>)implementersVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getSearchedElement() == null) {
                setSearchedElement((java.lang.String)null);
            } else {
                JsonElement searchedElementVal = getSearchedElement() == null ? JsonNull.INSTANCE : new JsonPrimitive(getSearchedElement());;
                result.add("searchedElement", searchedElementVal);
            }
            if (getImplementers() == null) {
                setImplementers((java.util.List<org.eclipse.lsp4j.SymbolInformation>)null);
            } else {
                JsonArray implementersVal = new JsonArray();
                for (org.eclipse.lsp4j.SymbolInformation implementersValX : getImplementers()) {
                    JsonElement implementersValY = implementersValX == null ? JsonNull.INSTANCE : ((SymbolInformationDto)implementersValX).toJsonElement();;
                    implementersVal.add(implementersValY);
                }
                result.add("implementers", implementersVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ImplementersResponseDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static ImplementersResponseDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            ImplementersResponseDto result= new ImplementersResponseDto();
            JsonElement jsonsearchedElementJson = json.get("searchedElement");
            if (jsonsearchedElementJson != null && !(jsonsearchedElementJson.isJsonNull())) {
                java.lang.String jsonsearchedElementVal = jsonsearchedElementJson.getAsString();;
                result.setSearchedElement((java.lang.String)jsonsearchedElementVal);
            }
            JsonElement jsonimplementersJson = json.get("implementers");
            if (jsonimplementersJson != null && !(jsonimplementersJson.isJsonNull())) {
                ArrayList<org.eclipse.lsp4j.SymbolInformation> jsonimplementersVal= new ArrayList<org.eclipse.lsp4j.SymbolInformation>();
                JsonArray jsonimplementersVala = jsonimplementersJson.getAsJsonArray();
                for(int jsonimplementersValai= 0; jsonimplementersValai < jsonimplementersVala.size(); jsonimplementersValai++) {
                    org.eclipse.lsp4j.SymbolInformation jsonimplementersValaX = SymbolInformationDto.fromJson((JsonObject)jsonimplementersVala.get(jsonimplementersValai));;
                    jsonimplementersVal.add(jsonimplementersValaX);
                }
                result.setImplementers((java.util.List<org.eclipse.lsp4j.SymbolInformation>)jsonimplementersVal);
            }
            return result;
        }
    }

    public static class ImplementersResponseDtoProvider implements DtoProvider<ImplementersResponseDto> {
    	public Class<? extends ImplementersResponseDto> getImplClass() {
    	  	return ImplementersResponseDto.class;
    	}
    
    	public ImplementersResponseDto newInstance() {
        	return new ImplementersResponseDto();
    	}
    
    	public ImplementersResponseDto fromJson(String json) {
    		return ImplementersResponseDto.fromJson(json);
    	}
        public ImplementersResponseDto fromJson(JsonElement json) {
    		return ImplementersResponseDto.fromJson(json);
    	}
        public ImplementersResponseDto clone(ImplementersResponseDto dto) {
            return ImplementersResponseDto.fromJson(dto.toJson());
    	}
    }

    public static class ClasspathEntryDto extends ClasspathEntry implements JsonSerializable {

        public ClasspathEntryDto() {
        }

        public ClasspathEntryDto(org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry o) {
                int entryKindVal = (int)makeDto(o.getEntryKind());;
                setEntryKind((int)entryKindVal);
            if (o.getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry> childrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry childrenValX : o.getChildren()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry childrenValY = new ClasspathEntryDto(childrenValX);
                        childrenVal.add(childrenValY);
                    }
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)childrenVal);
            }
            if (o.getPath() == null) {
                setPath((java.lang.String)null);
            } else {
                java.lang.String pathVal = (java.lang.String)makeDto(o.getPath());;
                setPath((java.lang.String)pathVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            JsonElement entryKindVal = new JsonPrimitive(getEntryKind());;
                result.add("entryKind", entryKindVal);
            if (getChildren() == null) {
                setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)null);
            } else {
                JsonArray childrenVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry childrenValX : getChildren()) {
                    JsonElement childrenValY = childrenValX == null ? JsonNull.INSTANCE : ((ClasspathEntryDto)childrenValX).toJsonElement();;
                    childrenVal.add(childrenValY);
                }
                result.add("children", childrenVal);
            }
            if (getPath() == null) {
                setPath((java.lang.String)null);
            } else {
                JsonElement pathVal = getPath() == null ? JsonNull.INSTANCE : new JsonPrimitive(getPath());;
                result.add("path", pathVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ClasspathEntryDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static ClasspathEntryDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            ClasspathEntryDto result= new ClasspathEntryDto();
            JsonElement jsonentryKindJson = json.get("entryKind");
            if (jsonentryKindJson != null && !(jsonentryKindJson.isJsonNull())) {
                int jsonentryKindVal = (int)jsonentryKindJson.getAsDouble();;
                result.setEntryKind((int)jsonentryKindVal);
            }
            JsonElement jsonchildrenJson = json.get("children");
            if (jsonchildrenJson != null && !(jsonchildrenJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry> jsonchildrenVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>();
                JsonArray jsonchildrenVala = jsonchildrenJson.getAsJsonArray();
                for(int jsonchildrenValai= 0; jsonchildrenValai < jsonchildrenVala.size(); jsonchildrenValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry jsonchildrenValaX = ClasspathEntryDto.fromJson((JsonObject)jsonchildrenVala.get(jsonchildrenValai));;
                    jsonchildrenVal.add(jsonchildrenValaX);
                }
                result.setChildren((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry>)jsonchildrenVal);
            }
            JsonElement jsonpathJson = json.get("path");
            if (jsonpathJson != null && !(jsonpathJson.isJsonNull())) {
                java.lang.String jsonpathVal = jsonpathJson.getAsString();;
                result.setPath((java.lang.String)jsonpathVal);
            }
            return result;
        }
    }

    public static class ClasspathEntryDtoProvider implements DtoProvider<ClasspathEntryDto> {
    	public Class<? extends ClasspathEntryDto> getImplClass() {
    	  	return ClasspathEntryDto.class;
    	}
    
    	public ClasspathEntryDto newInstance() {
        	return new ClasspathEntryDto();
    	}
    
    	public ClasspathEntryDto fromJson(String json) {
    		return ClasspathEntryDto.fromJson(json);
    	}
        public ClasspathEntryDto fromJson(JsonElement json) {
    		return ClasspathEntryDto.fromJson(json);
    	}
        public ClasspathEntryDto clone(ClasspathEntryDto dto) {
            return ClasspathEntryDto.fromJson(dto.toJson());
    	}
    }

    public static class MoveSettingsDto extends MoveSettings implements JsonSerializable {

        public MoveSettingsDto() {
        }

        public MoveSettingsDto(org.eclipse.che.jdt.ls.extension.api.dto.MoveSettings o) {
            if (o.getDestination() == null) {
                setDestination((java.lang.String)null);
            } else {
                java.lang.String destinationVal = (java.lang.String)makeDto(o.getDestination());;
                setDestination((java.lang.String)destinationVal);
            }
            if (o.getElements() == null) {
                setElements((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource> elementsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.Resource elementsValX : o.getElements()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.Resource elementsValY = new ResourceDto(elementsValX);
                        elementsVal.add(elementsValY);
                    }
                setElements((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)elementsVal);
            }
                boolean updateReferencesVal = (boolean)makeDto(o.isUpdateReferences());;
                setUpdateReferences((boolean)updateReferencesVal);
                boolean updateQualifiedNamesVal = (boolean)makeDto(o.isUpdateQualifiedNames());;
                setUpdateQualifiedNames((boolean)updateQualifiedNamesVal);
            if (o.getFilePatterns() == null) {
                setFilePatterns((java.lang.String)null);
            } else {
                java.lang.String filePatternsVal = (java.lang.String)makeDto(o.getFilePatterns());;
                setFilePatterns((java.lang.String)filePatternsVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getDestination() == null) {
                setDestination((java.lang.String)null);
            } else {
                JsonElement destinationVal = getDestination() == null ? JsonNull.INSTANCE : new JsonPrimitive(getDestination());;
                result.add("destination", destinationVal);
            }
            if (getElements() == null) {
                setElements((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)null);
            } else {
                JsonArray elementsVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.Resource elementsValX : getElements()) {
                    JsonElement elementsValY = elementsValX == null ? JsonNull.INSTANCE : ((ResourceDto)elementsValX).toJsonElement();;
                    elementsVal.add(elementsValY);
                }
                result.add("elements", elementsVal);
            }
            JsonElement updateReferencesVal = new JsonPrimitive(isUpdateReferences());;
                result.add("updateReferences", updateReferencesVal);
            JsonElement updateQualifiedNamesVal = new JsonPrimitive(isUpdateQualifiedNames());;
                result.add("updateQualifiedNames", updateQualifiedNamesVal);
            if (getFilePatterns() == null) {
                setFilePatterns((java.lang.String)null);
            } else {
                JsonElement filePatternsVal = getFilePatterns() == null ? JsonNull.INSTANCE : new JsonPrimitive(getFilePatterns());;
                result.add("filePatterns", filePatternsVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static MoveSettingsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static MoveSettingsDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            MoveSettingsDto result= new MoveSettingsDto();
            JsonElement jsondestinationJson = json.get("destination");
            if (jsondestinationJson != null && !(jsondestinationJson.isJsonNull())) {
                java.lang.String jsondestinationVal = jsondestinationJson.getAsString();;
                result.setDestination((java.lang.String)jsondestinationVal);
            }
            JsonElement jsonelementsJson = json.get("elements");
            if (jsonelementsJson != null && !(jsonelementsJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource> jsonelementsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.Resource>();
                JsonArray jsonelementsVala = jsonelementsJson.getAsJsonArray();
                for(int jsonelementsValai= 0; jsonelementsValai < jsonelementsVala.size(); jsonelementsValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.Resource jsonelementsValaX = ResourceDto.fromJson((JsonObject)jsonelementsVala.get(jsonelementsValai));;
                    jsonelementsVal.add(jsonelementsValaX);
                }
                result.setElements((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.Resource>)jsonelementsVal);
            }
            JsonElement jsonupdateReferencesJson = json.get("updateReferences");
            if (jsonupdateReferencesJson != null && !(jsonupdateReferencesJson.isJsonNull())) {
                boolean jsonupdateReferencesVal = jsonupdateReferencesJson.getAsBoolean();
                result.setUpdateReferences((boolean)jsonupdateReferencesVal);
            }
            JsonElement jsonupdateQualifiedNamesJson = json.get("updateQualifiedNames");
            if (jsonupdateQualifiedNamesJson != null && !(jsonupdateQualifiedNamesJson.isJsonNull())) {
                boolean jsonupdateQualifiedNamesVal = jsonupdateQualifiedNamesJson.getAsBoolean();
                result.setUpdateQualifiedNames((boolean)jsonupdateQualifiedNamesVal);
            }
            JsonElement jsonfilePatternsJson = json.get("filePatterns");
            if (jsonfilePatternsJson != null && !(jsonfilePatternsJson.isJsonNull())) {
                java.lang.String jsonfilePatternsVal = jsonfilePatternsJson.getAsString();;
                result.setFilePatterns((java.lang.String)jsonfilePatternsVal);
            }
            return result;
        }
    }

    public static class MoveSettingsDtoProvider implements DtoProvider<MoveSettingsDto> {
    	public Class<? extends MoveSettingsDto> getImplClass() {
    	  	return MoveSettingsDto.class;
    	}
    
    	public MoveSettingsDto newInstance() {
        	return new MoveSettingsDto();
    	}
    
    	public MoveSettingsDto fromJson(String json) {
    		return MoveSettingsDto.fromJson(json);
    	}
        public MoveSettingsDto fromJson(JsonElement json) {
    		return MoveSettingsDto.fromJson(json);
    	}
        public MoveSettingsDto clone(MoveSettingsDto dto) {
            return MoveSettingsDto.fromJson(dto.toJson());
    	}
    }

    public static class ResourceLocationDto extends ResourceLocation implements JsonSerializable {

        public ResourceLocationDto() {
        }

        public ResourceLocationDto(org.eclipse.che.jdt.ls.extension.api.dto.ResourceLocation o) {
            if (o.getLibId() == null) {
                setLibId((java.lang.String)null);
            } else {
                java.lang.String libIdVal = (java.lang.String)makeDto(o.getLibId());;
                setLibId((java.lang.String)libIdVal);
            }
            if (o.getFqn() == null) {
                setFqn((java.lang.String)null);
            } else {
                java.lang.String fqnVal = (java.lang.String)makeDto(o.getFqn());;
                setFqn((java.lang.String)fqnVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getLibId() == null) {
                setLibId((java.lang.String)null);
            } else {
                JsonElement libIdVal = getLibId() == null ? JsonNull.INSTANCE : new JsonPrimitive(getLibId());;
                result.add("libId", libIdVal);
            }
            if (getFqn() == null) {
                setFqn((java.lang.String)null);
            } else {
                JsonElement fqnVal = getFqn() == null ? JsonNull.INSTANCE : new JsonPrimitive(getFqn());;
                result.add("fqn", fqnVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static ResourceLocationDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static ResourceLocationDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            ResourceLocationDto result= new ResourceLocationDto();
            JsonElement jsonlibIdJson = json.get("libId");
            if (jsonlibIdJson != null && !(jsonlibIdJson.isJsonNull())) {
                java.lang.String jsonlibIdVal = jsonlibIdJson.getAsString();;
                result.setLibId((java.lang.String)jsonlibIdVal);
            }
            JsonElement jsonfqnJson = json.get("fqn");
            if (jsonfqnJson != null && !(jsonfqnJson.isJsonNull())) {
                java.lang.String jsonfqnVal = jsonfqnJson.getAsString();;
                result.setFqn((java.lang.String)jsonfqnVal);
            }
            return result;
        }
    }

    public static class ResourceLocationDtoProvider implements DtoProvider<ResourceLocationDto> {
    	public Class<? extends ResourceLocationDto> getImplClass() {
    	  	return ResourceLocationDto.class;
    	}
    
    	public ResourceLocationDto newInstance() {
        	return new ResourceLocationDto();
    	}
    
    	public ResourceLocationDto fromJson(String json) {
    		return ResourceLocationDto.fromJson(json);
    	}
        public ResourceLocationDto fromJson(JsonElement json) {
    		return ResourceLocationDto.fromJson(json);
    	}
        public ResourceLocationDto clone(ResourceLocationDto dto) {
            return ResourceLocationDto.fromJson(dto.toJson());
    	}
    }

    public static class LocationDto extends Location implements JsonSerializable {

        public LocationDto() {
        }

        public LocationDto(org.eclipse.lsp4j.Location o) {
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
            if (o.getRange() == null) {
                setRange((org.eclipse.lsp4j.Range)null);
            } else {
                org.eclipse.lsp4j.Range rangeVal = new RangeDto(o.getRange());
                setRange((org.eclipse.lsp4j.Range)rangeVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JsonElement uriVal = getUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getUri());;
                result.add("uri", uriVal);
            }
            if (getRange() == null) {
                setRange((org.eclipse.lsp4j.Range)null);
            } else {
                JsonElement rangeVal = getRange() == null ? JsonNull.INSTANCE : ((RangeDto)getRange()).toJsonElement();;
                result.add("range", rangeVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static LocationDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static LocationDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            LocationDto result= new LocationDto();
            JsonElement jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isJsonNull())) {
                java.lang.String jsonuriVal = jsonuriJson.getAsString();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            JsonElement jsonrangeJson = json.get("range");
            if (jsonrangeJson != null && !(jsonrangeJson.isJsonNull())) {
                org.eclipse.lsp4j.Range jsonrangeVal = RangeDto.fromJson((JsonObject)jsonrangeJson);;
                result.setRange((org.eclipse.lsp4j.Range)jsonrangeVal);
            }
            return result;
        }
    }

    public static class LocationDtoProvider implements DtoProvider<LocationDto> {
    	public Class<? extends LocationDto> getImplClass() {
    	  	return LocationDto.class;
    	}
    
    	public LocationDto newInstance() {
        	return new LocationDto();
    	}
    
    	public LocationDto fromJson(String json) {
    		return LocationDto.fromJson(json);
    	}
        public LocationDto fromJson(JsonElement json) {
    		return LocationDto.fromJson(json);
    	}
        public LocationDto clone(LocationDto dto) {
            return LocationDto.fromJson(dto.toJson());
    	}
    }

    public static class VersionedTextDocumentIdentifierDto extends VersionedTextDocumentIdentifier implements JsonSerializable {

        public VersionedTextDocumentIdentifierDto() {
        }

        public VersionedTextDocumentIdentifierDto(org.eclipse.lsp4j.VersionedTextDocumentIdentifier o) {
            if (o.getVersion() == null) {
                setVersion((java.lang.Integer)null);
            } else {
                java.lang.Integer versionVal = (java.lang.Integer)makeDto(o.getVersion());;
                setVersion((java.lang.Integer)versionVal);
            }
            if (o.getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                java.lang.String uriVal = (java.lang.String)makeDto(o.getUri());;
                setUri((java.lang.String)uriVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getVersion() == null) {
                setVersion((java.lang.Integer)null);
            } else {
                JsonElement versionVal = getVersion() == null ? JsonNull.INSTANCE : new JsonPrimitive(getVersion().doubleValue());;
                result.add("version", versionVal);
            }
            if (getUri() == null) {
                setUri((java.lang.String)null);
            } else {
                JsonElement uriVal = getUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getUri());;
                result.add("uri", uriVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static VersionedTextDocumentIdentifierDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static VersionedTextDocumentIdentifierDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            VersionedTextDocumentIdentifierDto result= new VersionedTextDocumentIdentifierDto();
            JsonElement jsonversionJson = json.get("version");
            if (jsonversionJson != null && !(jsonversionJson.isJsonNull())) {
                java.lang.Integer jsonversionVal = (int)jsonversionJson.getAsDouble();;
                result.setVersion((java.lang.Integer)jsonversionVal);
            }
            JsonElement jsonuriJson = json.get("uri");
            if (jsonuriJson != null && !(jsonuriJson.isJsonNull())) {
                java.lang.String jsonuriVal = jsonuriJson.getAsString();;
                result.setUri((java.lang.String)jsonuriVal);
            }
            return result;
        }
    }

    public static class VersionedTextDocumentIdentifierDtoProvider implements DtoProvider<VersionedTextDocumentIdentifierDto> {
    	public Class<? extends VersionedTextDocumentIdentifierDto> getImplClass() {
    	  	return VersionedTextDocumentIdentifierDto.class;
    	}
    
    	public VersionedTextDocumentIdentifierDto newInstance() {
        	return new VersionedTextDocumentIdentifierDto();
    	}
    
    	public VersionedTextDocumentIdentifierDto fromJson(String json) {
    		return VersionedTextDocumentIdentifierDto.fromJson(json);
    	}
        public VersionedTextDocumentIdentifierDto fromJson(JsonElement json) {
    		return VersionedTextDocumentIdentifierDto.fromJson(json);
    	}
        public VersionedTextDocumentIdentifierDto clone(VersionedTextDocumentIdentifierDto dto) {
            return VersionedTextDocumentIdentifierDto.fromJson(dto.toJson());
    	}
    }

    public static class JarDto extends Jar implements JsonSerializable {

        public JarDto() {
        }

        public JarDto(org.eclipse.che.jdt.ls.extension.api.dto.Jar o) {
            if (o.getId() == null) {
                setId((java.lang.String)null);
            } else {
                java.lang.String idVal = (java.lang.String)makeDto(o.getId());;
                setId((java.lang.String)idVal);
            }
            if (o.getName() == null) {
                setName((java.lang.String)null);
            } else {
                java.lang.String nameVal = (java.lang.String)makeDto(o.getName());;
                setName((java.lang.String)nameVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getId() == null) {
                setId((java.lang.String)null);
            } else {
                JsonElement idVal = getId() == null ? JsonNull.INSTANCE : new JsonPrimitive(getId());;
                result.add("id", idVal);
            }
            if (getName() == null) {
                setName((java.lang.String)null);
            } else {
                JsonElement nameVal = getName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getName());;
                result.add("name", nameVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JarDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static JarDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            JarDto result= new JarDto();
            JsonElement jsonidJson = json.get("id");
            if (jsonidJson != null && !(jsonidJson.isJsonNull())) {
                java.lang.String jsonidVal = jsonidJson.getAsString();;
                result.setId((java.lang.String)jsonidVal);
            }
            JsonElement jsonnameJson = json.get("name");
            if (jsonnameJson != null && !(jsonnameJson.isJsonNull())) {
                java.lang.String jsonnameVal = jsonnameJson.getAsString();;
                result.setName((java.lang.String)jsonnameVal);
            }
            return result;
        }
    }

    public static class JarDtoProvider implements DtoProvider<JarDto> {
    	public Class<? extends JarDto> getImplClass() {
    	  	return JarDto.class;
    	}
    
    	public JarDto newInstance() {
        	return new JarDto();
    	}
    
    	public JarDto fromJson(String json) {
    		return JarDto.fromJson(json);
    	}
        public JarDto fromJson(JsonElement json) {
    		return JarDto.fromJson(json);
    	}
        public JarDto clone(JarDto dto) {
            return JarDto.fromJson(dto.toJson());
    	}
    }

    public static class OrganizeImportParamsDto extends OrganizeImportParams implements JsonSerializable {

        public OrganizeImportParamsDto() {
        }

        public OrganizeImportParamsDto(org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportParams o) {
            if (o.getResourceUri() == null) {
                setResourceUri((java.lang.String)null);
            } else {
                java.lang.String resourceUriVal = (java.lang.String)makeDto(o.getResourceUri());;
                setResourceUri((java.lang.String)resourceUriVal);
            }
            if (o.getChoices() == null) {
                setChoices((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> choicesVal= new ArrayList<java.lang.String>();
                    for (java.lang.String choicesValX : o.getChoices()) {
                        java.lang.String choicesValY = (java.lang.String)makeDto(choicesValX);;
                        choicesVal.add(choicesValY);
                    }
                setChoices((java.util.List<java.lang.String>)choicesVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getResourceUri() == null) {
                setResourceUri((java.lang.String)null);
            } else {
                JsonElement resourceUriVal = getResourceUri() == null ? JsonNull.INSTANCE : new JsonPrimitive(getResourceUri());;
                result.add("resourceUri", resourceUriVal);
            }
            if (getChoices() == null) {
                setChoices((java.util.List<java.lang.String>)null);
            } else {
                JsonArray choicesVal = new JsonArray();
                for (java.lang.String choicesValX : getChoices()) {
                    JsonElement choicesValY = choicesValX == null ? JsonNull.INSTANCE : new JsonPrimitive(choicesValX);;
                    choicesVal.add(choicesValY);
                }
                result.add("choices", choicesVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static OrganizeImportParamsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static OrganizeImportParamsDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            OrganizeImportParamsDto result= new OrganizeImportParamsDto();
            JsonElement jsonresourceUriJson = json.get("resourceUri");
            if (jsonresourceUriJson != null && !(jsonresourceUriJson.isJsonNull())) {
                java.lang.String jsonresourceUriVal = jsonresourceUriJson.getAsString();;
                result.setResourceUri((java.lang.String)jsonresourceUriVal);
            }
            JsonElement jsonchoicesJson = json.get("choices");
            if (jsonchoicesJson != null && !(jsonchoicesJson.isJsonNull())) {
                ArrayList<java.lang.String> jsonchoicesVal= new ArrayList<java.lang.String>();
                JsonArray jsonchoicesVala = jsonchoicesJson.getAsJsonArray();
                for(int jsonchoicesValai= 0; jsonchoicesValai < jsonchoicesVala.size(); jsonchoicesValai++) {
                    java.lang.String jsonchoicesValaX = jsonchoicesVala.get(jsonchoicesValai).getAsString();;
                    jsonchoicesVal.add(jsonchoicesValaX);
                }
                result.setChoices((java.util.List<java.lang.String>)jsonchoicesVal);
            }
            return result;
        }
    }

    public static class OrganizeImportParamsDtoProvider implements DtoProvider<OrganizeImportParamsDto> {
    	public Class<? extends OrganizeImportParamsDto> getImplClass() {
    	  	return OrganizeImportParamsDto.class;
    	}
    
    	public OrganizeImportParamsDto newInstance() {
        	return new OrganizeImportParamsDto();
    	}
    
    	public OrganizeImportParamsDto fromJson(String json) {
    		return OrganizeImportParamsDto.fromJson(json);
    	}
        public OrganizeImportParamsDto fromJson(JsonElement json) {
    		return OrganizeImportParamsDto.fromJson(json);
    	}
        public OrganizeImportParamsDto clone(OrganizeImportParamsDto dto) {
            return OrganizeImportParamsDto.fromJson(dto.toJson());
    	}
    }

    public static class RenamingElementInfoDto extends RenamingElementInfo implements JsonSerializable {

        public RenamingElementInfoDto() {
        }

        public RenamingElementInfoDto(org.eclipse.che.jdt.ls.extension.api.dto.RenamingElementInfo o) {
            if (o.getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.RenameKind renameKindVal = (org.eclipse.che.jdt.ls.extension.api.RenameKind)makeDto(o.getRenameKind());;
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)renameKindVal);
            }
            if (o.getElementName() == null) {
                setElementName((java.lang.String)null);
            } else {
                java.lang.String elementNameVal = (java.lang.String)makeDto(o.getElementName());;
                setElementName((java.lang.String)elementNameVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getRenameKind() == null) {
                setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)null);
            } else {
                JsonElement renameKindVal = getRenameKind() == null ? JsonNull.INSTANCE : new JsonPrimitive(getRenameKind().name());;
                result.add("renameKind", renameKindVal);
            }
            if (getElementName() == null) {
                setElementName((java.lang.String)null);
            } else {
                JsonElement elementNameVal = getElementName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getElementName());;
                result.add("elementName", elementNameVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RenamingElementInfoDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static RenamingElementInfoDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            RenamingElementInfoDto result= new RenamingElementInfoDto();
            JsonElement jsonrenameKindJson = json.get("renameKind");
            if (jsonrenameKindJson != null && !(jsonrenameKindJson.isJsonNull())) {
                org.eclipse.che.jdt.ls.extension.api.RenameKind jsonrenameKindVal = org.eclipse.che.jdt.ls.extension.api.RenameKind.valueOf(jsonrenameKindJson.getAsString());;
                result.setRenameKind((org.eclipse.che.jdt.ls.extension.api.RenameKind)jsonrenameKindVal);
            }
            JsonElement jsonelementNameJson = json.get("elementName");
            if (jsonelementNameJson != null && !(jsonelementNameJson.isJsonNull())) {
                java.lang.String jsonelementNameVal = jsonelementNameJson.getAsString();;
                result.setElementName((java.lang.String)jsonelementNameVal);
            }
            return result;
        }
    }

    public static class RenamingElementInfoDtoProvider implements DtoProvider<RenamingElementInfoDto> {
    	public Class<? extends RenamingElementInfoDto> getImplClass() {
    	  	return RenamingElementInfoDto.class;
    	}
    
    	public RenamingElementInfoDto newInstance() {
        	return new RenamingElementInfoDto();
    	}
    
    	public RenamingElementInfoDto fromJson(String json) {
    		return RenamingElementInfoDto.fromJson(json);
    	}
        public RenamingElementInfoDto fromJson(JsonElement json) {
    		return RenamingElementInfoDto.fromJson(json);
    	}
        public RenamingElementInfoDto clone(RenamingElementInfoDto dto) {
            return RenamingElementInfoDto.fromJson(dto.toJson());
    	}
    }

    public static class RefactoringResultDto extends RefactoringResult implements JsonSerializable {

        public RefactoringResultDto() {
        }

        public RefactoringResultDto(org.eclipse.che.jdt.ls.extension.api.dto.RefactoringResult o) {
            if (o.getRefactoringStatus() == null) {
                setRefactoringStatus((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus refactoringStatusVal = new RefactoringStatusDto(o.getRefactoringStatus());
                setRefactoringStatus((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus)refactoringStatusVal);
            }
            if (o.getCheWorkspaceEdit() == null) {
                setCheWorkspaceEdit((org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit cheWorkspaceEditVal = new CheWorkspaceEditDto(o.getCheWorkspaceEdit());
                setCheWorkspaceEdit((org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit)cheWorkspaceEditVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getRefactoringStatus() == null) {
                setRefactoringStatus((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus)null);
            } else {
                JsonElement refactoringStatusVal = getRefactoringStatus() == null ? JsonNull.INSTANCE : ((RefactoringStatusDto)getRefactoringStatus()).toJsonElement();;
                result.add("refactoringStatus", refactoringStatusVal);
            }
            if (getCheWorkspaceEdit() == null) {
                setCheWorkspaceEdit((org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit)null);
            } else {
                JsonElement cheWorkspaceEditVal = getCheWorkspaceEdit() == null ? JsonNull.INSTANCE : ((CheWorkspaceEditDto)getCheWorkspaceEdit()).toJsonElement();;
                result.add("cheWorkspaceEdit", cheWorkspaceEditVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RefactoringResultDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static RefactoringResultDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            RefactoringResultDto result= new RefactoringResultDto();
            JsonElement jsonrefactoringStatusJson = json.get("refactoringStatus");
            if (jsonrefactoringStatusJson != null && !(jsonrefactoringStatusJson.isJsonNull())) {
                org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus jsonrefactoringStatusVal = RefactoringStatusDto.fromJson((JsonObject)jsonrefactoringStatusJson);;
                result.setRefactoringStatus((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus)jsonrefactoringStatusVal);
            }
            JsonElement jsoncheWorkspaceEditJson = json.get("cheWorkspaceEdit");
            if (jsoncheWorkspaceEditJson != null && !(jsoncheWorkspaceEditJson.isJsonNull())) {
                org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit jsoncheWorkspaceEditVal = CheWorkspaceEditDto.fromJson((JsonObject)jsoncheWorkspaceEditJson);;
                result.setCheWorkspaceEdit((org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit)jsoncheWorkspaceEditVal);
            }
            return result;
        }
    }

    public static class RefactoringResultDtoProvider implements DtoProvider<RefactoringResultDto> {
    	public Class<? extends RefactoringResultDto> getImplClass() {
    	  	return RefactoringResultDto.class;
    	}
    
    	public RefactoringResultDto newInstance() {
        	return new RefactoringResultDto();
    	}
    
    	public RefactoringResultDto fromJson(String json) {
    		return RefactoringResultDto.fromJson(json);
    	}
        public RefactoringResultDto fromJson(JsonElement json) {
    		return RefactoringResultDto.fromJson(json);
    	}
        public RefactoringResultDto clone(RefactoringResultDto dto) {
            return RefactoringResultDto.fromJson(dto.toJson());
    	}
    }

    public static class RangeDto extends Range implements JsonSerializable {

        public RangeDto() {
        }

        public RangeDto(org.eclipse.lsp4j.Range o) {
            if (o.getStart() == null) {
                setStart((org.eclipse.lsp4j.Position)null);
            } else {
                org.eclipse.lsp4j.Position startVal = new PositionDto(o.getStart());
                setStart((org.eclipse.lsp4j.Position)startVal);
            }
            if (o.getEnd() == null) {
                setEnd((org.eclipse.lsp4j.Position)null);
            } else {
                org.eclipse.lsp4j.Position endVal = new PositionDto(o.getEnd());
                setEnd((org.eclipse.lsp4j.Position)endVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getStart() == null) {
                setStart((org.eclipse.lsp4j.Position)null);
            } else {
                JsonElement startVal = getStart() == null ? JsonNull.INSTANCE : ((PositionDto)getStart()).toJsonElement();;
                result.add("start", startVal);
            }
            if (getEnd() == null) {
                setEnd((org.eclipse.lsp4j.Position)null);
            } else {
                JsonElement endVal = getEnd() == null ? JsonNull.INSTANCE : ((PositionDto)getEnd()).toJsonElement();;
                result.add("end", endVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RangeDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static RangeDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            RangeDto result= new RangeDto();
            JsonElement jsonstartJson = json.get("start");
            if (jsonstartJson != null && !(jsonstartJson.isJsonNull())) {
                org.eclipse.lsp4j.Position jsonstartVal = PositionDto.fromJson((JsonObject)jsonstartJson);;
                result.setStart((org.eclipse.lsp4j.Position)jsonstartVal);
            }
            JsonElement jsonendJson = json.get("end");
            if (jsonendJson != null && !(jsonendJson.isJsonNull())) {
                org.eclipse.lsp4j.Position jsonendVal = PositionDto.fromJson((JsonObject)jsonendJson);;
                result.setEnd((org.eclipse.lsp4j.Position)jsonendVal);
            }
            return result;
        }
    }

    public static class RangeDtoProvider implements DtoProvider<RangeDto> {
    	public Class<? extends RangeDto> getImplClass() {
    	  	return RangeDto.class;
    	}
    
    	public RangeDto newInstance() {
        	return new RangeDto();
    	}
    
    	public RangeDto fromJson(String json) {
    		return RangeDto.fromJson(json);
    	}
        public RangeDto fromJson(JsonElement json) {
    		return RangeDto.fromJson(json);
    	}
        public RangeDto clone(RangeDto dto) {
            return RangeDto.fromJson(dto.toJson());
    	}
    }

    public static class StatusReportDto extends StatusReport implements JsonSerializable {

        public StatusReportDto() {
        }

        public StatusReportDto(org.eclipse.che.jdt.ls.extension.api.dto.StatusReport o) {
            if (o.getType() == null) {
                setType((java.lang.String)null);
            } else {
                java.lang.String typeVal = (java.lang.String)makeDto(o.getType());;
                setType((java.lang.String)typeVal);
            }
            if (o.getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                java.lang.String messageVal = (java.lang.String)makeDto(o.getMessage());;
                setMessage((java.lang.String)messageVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getType() == null) {
                setType((java.lang.String)null);
            } else {
                JsonElement typeVal = getType() == null ? JsonNull.INSTANCE : new JsonPrimitive(getType());;
                result.add("type", typeVal);
            }
            if (getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                JsonElement messageVal = getMessage() == null ? JsonNull.INSTANCE : new JsonPrimitive(getMessage());;
                result.add("message", messageVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static StatusReportDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static StatusReportDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            StatusReportDto result= new StatusReportDto();
            JsonElement jsontypeJson = json.get("type");
            if (jsontypeJson != null && !(jsontypeJson.isJsonNull())) {
                java.lang.String jsontypeVal = jsontypeJson.getAsString();;
                result.setType((java.lang.String)jsontypeVal);
            }
            JsonElement jsonmessageJson = json.get("message");
            if (jsonmessageJson != null && !(jsonmessageJson.isJsonNull())) {
                java.lang.String jsonmessageVal = jsonmessageJson.getAsString();;
                result.setMessage((java.lang.String)jsonmessageVal);
            }
            return result;
        }
    }

    public static class StatusReportDtoProvider implements DtoProvider<StatusReportDto> {
    	public Class<? extends StatusReportDto> getImplClass() {
    	  	return StatusReportDto.class;
    	}
    
    	public StatusReportDto newInstance() {
        	return new StatusReportDto();
    	}
    
    	public StatusReportDto fromJson(String json) {
    		return StatusReportDto.fromJson(json);
    	}
        public StatusReportDto fromJson(JsonElement json) {
    		return StatusReportDto.fromJson(json);
    	}
        public StatusReportDto clone(StatusReportDto dto) {
            return StatusReportDto.fromJson(dto.toJson());
    	}
    }

    public static class RefactoringStatusDto extends RefactoringStatus implements JsonSerializable {

        public RefactoringStatusDto() {
        }

        public RefactoringStatusDto(org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus o) {
            if (o.getRefactoringStatusEntries() == null) {
                setRefactoringStatusEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry> refactoringStatusEntriesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry refactoringStatusEntriesValX : o.getRefactoringStatusEntries()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry refactoringStatusEntriesValY = new RefactoringStatusEntryDto(refactoringStatusEntriesValX);
                        refactoringStatusEntriesVal.add(refactoringStatusEntriesValY);
                    }
                setRefactoringStatusEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>)refactoringStatusEntriesVal);
            }
            if (o.getRefactoringSeverity() == null) {
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity refactoringSeverityVal = (org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)makeDto(o.getRefactoringSeverity());;
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)refactoringSeverityVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getRefactoringStatusEntries() == null) {
                setRefactoringStatusEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>)null);
            } else {
                JsonArray refactoringStatusEntriesVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry refactoringStatusEntriesValX : getRefactoringStatusEntries()) {
                    JsonElement refactoringStatusEntriesValY = refactoringStatusEntriesValX == null ? JsonNull.INSTANCE : ((RefactoringStatusEntryDto)refactoringStatusEntriesValX).toJsonElement();;
                    refactoringStatusEntriesVal.add(refactoringStatusEntriesValY);
                }
                result.add("refactoringStatusEntries", refactoringStatusEntriesVal);
            }
            if (getRefactoringSeverity() == null) {
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)null);
            } else {
                JsonElement refactoringSeverityVal = getRefactoringSeverity() == null ? JsonNull.INSTANCE : new JsonPrimitive(getRefactoringSeverity().name());;
                result.add("refactoringSeverity", refactoringSeverityVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RefactoringStatusDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static RefactoringStatusDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            RefactoringStatusDto result= new RefactoringStatusDto();
            JsonElement jsonrefactoringStatusEntriesJson = json.get("refactoringStatusEntries");
            if (jsonrefactoringStatusEntriesJson != null && !(jsonrefactoringStatusEntriesJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry> jsonrefactoringStatusEntriesVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>();
                JsonArray jsonrefactoringStatusEntriesVala = jsonrefactoringStatusEntriesJson.getAsJsonArray();
                for(int jsonrefactoringStatusEntriesValai= 0; jsonrefactoringStatusEntriesValai < jsonrefactoringStatusEntriesVala.size(); jsonrefactoringStatusEntriesValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry jsonrefactoringStatusEntriesValaX = RefactoringStatusEntryDto.fromJson((JsonObject)jsonrefactoringStatusEntriesVala.get(jsonrefactoringStatusEntriesValai));;
                    jsonrefactoringStatusEntriesVal.add(jsonrefactoringStatusEntriesValaX);
                }
                result.setRefactoringStatusEntries((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry>)jsonrefactoringStatusEntriesVal);
            }
            JsonElement jsonrefactoringSeverityJson = json.get("refactoringSeverity");
            if (jsonrefactoringSeverityJson != null && !(jsonrefactoringSeverityJson.isJsonNull())) {
                org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity jsonrefactoringSeverityVal = org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity.valueOf(jsonrefactoringSeverityJson.getAsString());;
                result.setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)jsonrefactoringSeverityVal);
            }
            return result;
        }
    }

    public static class RefactoringStatusDtoProvider implements DtoProvider<RefactoringStatusDto> {
    	public Class<? extends RefactoringStatusDto> getImplClass() {
    	  	return RefactoringStatusDto.class;
    	}
    
    	public RefactoringStatusDto newInstance() {
        	return new RefactoringStatusDto();
    	}
    
    	public RefactoringStatusDto fromJson(String json) {
    		return RefactoringStatusDto.fromJson(json);
    	}
        public RefactoringStatusDto fromJson(JsonElement json) {
    		return RefactoringStatusDto.fromJson(json);
    	}
        public RefactoringStatusDto clone(RefactoringStatusDto dto) {
            return RefactoringStatusDto.fromJson(dto.toJson());
    	}
    }

    public static class PositionDto extends Position implements JsonSerializable {

        public PositionDto() {
        }

        public PositionDto(org.eclipse.lsp4j.Position o) {
                int lineVal = (int)makeDto(o.getLine());;
                setLine((int)lineVal);
                int characterVal = (int)makeDto(o.getCharacter());;
                setCharacter((int)characterVal);
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            JsonElement lineVal = new JsonPrimitive(getLine());;
                result.add("line", lineVal);
            JsonElement characterVal = new JsonPrimitive(getCharacter());;
                result.add("character", characterVal);
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static PositionDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static PositionDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            PositionDto result= new PositionDto();
            JsonElement jsonlineJson = json.get("line");
            if (jsonlineJson != null && !(jsonlineJson.isJsonNull())) {
                int jsonlineVal = (int)jsonlineJson.getAsDouble();;
                result.setLine((int)jsonlineVal);
            }
            JsonElement jsoncharacterJson = json.get("character");
            if (jsoncharacterJson != null && !(jsoncharacterJson.isJsonNull())) {
                int jsoncharacterVal = (int)jsoncharacterJson.getAsDouble();;
                result.setCharacter((int)jsoncharacterVal);
            }
            return result;
        }
    }

    public static class PositionDtoProvider implements DtoProvider<PositionDto> {
    	public Class<? extends PositionDto> getImplClass() {
    	  	return PositionDto.class;
    	}
    
    	public PositionDto newInstance() {
        	return new PositionDto();
    	}
    
    	public PositionDto fromJson(String json) {
    		return PositionDto.fromJson(json);
    	}
        public PositionDto fromJson(JsonElement json) {
    		return PositionDto.fromJson(json);
    	}
        public PositionDto clone(PositionDto dto) {
            return PositionDto.fromJson(dto.toJson());
    	}
    }

    public static class OrganizeImportsResultDto extends OrganizeImportsResult implements JsonSerializable {

        public OrganizeImportsResultDto() {
        }

        public OrganizeImportsResultDto(org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportsResult o) {
            if (o.getAmbiguousTypes() == null) {
                setAmbiguousTypes((java.util.List<java.util.List<java.lang.String>>)null);
            } else {
                    ArrayList<java.util.List<java.lang.String>> ambiguousTypesVal= new ArrayList<java.util.List<java.lang.String>>();
                    for (java.util.List<java.lang.String> ambiguousTypesValX : o.getAmbiguousTypes()) {
                            ArrayList<java.lang.String> ambiguousTypesValY= new ArrayList<java.lang.String>();
                            for (java.lang.String ambiguousTypesValYX : ambiguousTypesValX) {
                                java.lang.String ambiguousTypesValYY = (java.lang.String)makeDto(ambiguousTypesValYX);;
                                ambiguousTypesValY.add(ambiguousTypesValYY);
                            }
                        ambiguousTypesVal.add(ambiguousTypesValY);
                    }
                setAmbiguousTypes((java.util.List<java.util.List<java.lang.String>>)ambiguousTypesVal);
            }
            if (o.getWorkspaceEdit() == null) {
                setWorkspaceEdit((org.eclipse.lsp4j.WorkspaceEdit)null);
            } else {
                org.eclipse.lsp4j.WorkspaceEdit workspaceEditVal = new WorkspaceEditDto(o.getWorkspaceEdit());
                setWorkspaceEdit((org.eclipse.lsp4j.WorkspaceEdit)workspaceEditVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getAmbiguousTypes() == null) {
                setAmbiguousTypes((java.util.List<java.util.List<java.lang.String>>)null);
            } else {
                JsonArray ambiguousTypesVal = new JsonArray();
                for (java.util.List<java.lang.String> ambiguousTypesValX : getAmbiguousTypes()) {
                    JsonArray ambiguousTypesValY = new JsonArray();
                    for (java.lang.String ambiguousTypesValYX : ambiguousTypesValX) {
                        JsonElement ambiguousTypesValYY = ambiguousTypesValYX == null ? JsonNull.INSTANCE : new JsonPrimitive(ambiguousTypesValYX);;
                        ambiguousTypesValY.add(ambiguousTypesValYY);
                    }
                    ambiguousTypesVal.add(ambiguousTypesValY);
                }
                result.add("ambiguousTypes", ambiguousTypesVal);
            }
            if (getWorkspaceEdit() == null) {
                setWorkspaceEdit((org.eclipse.lsp4j.WorkspaceEdit)null);
            } else {
                JsonElement workspaceEditVal = getWorkspaceEdit() == null ? JsonNull.INSTANCE : ((WorkspaceEditDto)getWorkspaceEdit()).toJsonElement();;
                result.add("workspaceEdit", workspaceEditVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static OrganizeImportsResultDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static OrganizeImportsResultDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            OrganizeImportsResultDto result= new OrganizeImportsResultDto();
            JsonElement jsonambiguousTypesJson = json.get("ambiguousTypes");
            if (jsonambiguousTypesJson != null && !(jsonambiguousTypesJson.isJsonNull())) {
                ArrayList<java.util.List<java.lang.String>> jsonambiguousTypesVal= new ArrayList<java.util.List<java.lang.String>>();
                JsonArray jsonambiguousTypesVala = jsonambiguousTypesJson.getAsJsonArray();
                for(int jsonambiguousTypesValai= 0; jsonambiguousTypesValai < jsonambiguousTypesVala.size(); jsonambiguousTypesValai++) {
                    ArrayList<java.lang.String> jsonambiguousTypesValaX= new ArrayList<java.lang.String>();
                    JsonArray jsonambiguousTypesValaXa = jsonambiguousTypesVala.get(jsonambiguousTypesValai).getAsJsonArray();
                    for(int jsonambiguousTypesValaXai= 0; jsonambiguousTypesValaXai < jsonambiguousTypesValaXa.size(); jsonambiguousTypesValaXai++) {
                        java.lang.String jsonambiguousTypesValaXaX = jsonambiguousTypesValaXa.get(jsonambiguousTypesValaXai).getAsString();;
                        jsonambiguousTypesValaX.add(jsonambiguousTypesValaXaX);
                    }
                    jsonambiguousTypesVal.add(jsonambiguousTypesValaX);
                }
                result.setAmbiguousTypes((java.util.List<java.util.List<java.lang.String>>)jsonambiguousTypesVal);
            }
            JsonElement jsonworkspaceEditJson = json.get("workspaceEdit");
            if (jsonworkspaceEditJson != null && !(jsonworkspaceEditJson.isJsonNull())) {
                org.eclipse.lsp4j.WorkspaceEdit jsonworkspaceEditVal = WorkspaceEditDto.fromJson((JsonObject)jsonworkspaceEditJson);;
                result.setWorkspaceEdit((org.eclipse.lsp4j.WorkspaceEdit)jsonworkspaceEditVal);
            }
            return result;
        }
    }

    public static class OrganizeImportsResultDtoProvider implements DtoProvider<OrganizeImportsResultDto> {
    	public Class<? extends OrganizeImportsResultDto> getImplClass() {
    	  	return OrganizeImportsResultDto.class;
    	}
    
    	public OrganizeImportsResultDto newInstance() {
        	return new OrganizeImportsResultDto();
    	}
    
    	public OrganizeImportsResultDto fromJson(String json) {
    		return OrganizeImportsResultDto.fromJson(json);
    	}
        public OrganizeImportsResultDto fromJson(JsonElement json) {
    		return OrganizeImportsResultDto.fromJson(json);
    	}
        public OrganizeImportsResultDto clone(OrganizeImportsResultDto dto) {
            return OrganizeImportsResultDto.fromJson(dto.toJson());
    	}
    }

    public static class UsagesResponseDto extends UsagesResponse implements JsonSerializable {

        public UsagesResponseDto() {
        }

        public UsagesResponseDto(org.eclipse.che.jdt.ls.extension.api.dto.UsagesResponse o) {
            if (o.getSearchedElement() == null) {
                setSearchedElement((java.lang.String)null);
            } else {
                java.lang.String searchedElementVal = (java.lang.String)makeDto(o.getSearchedElement());;
                setSearchedElement((java.lang.String)searchedElementVal);
            }
            if (o.getElementKind() == null) {
                setElementKind((org.eclipse.lsp4j.SymbolKind)null);
            } else {
                org.eclipse.lsp4j.SymbolKind elementKindVal = (org.eclipse.lsp4j.SymbolKind)makeDto(o.getElementKind());;
                setElementKind((org.eclipse.lsp4j.SymbolKind)elementKindVal);
            }
            if (o.getSearchResults() == null) {
                setSearchResults((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)null);
            } else {
                    ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult> searchResultsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>();
                    for (org.eclipse.che.jdt.ls.extension.api.dto.SearchResult searchResultsValX : o.getSearchResults()) {
                        org.eclipse.che.jdt.ls.extension.api.dto.SearchResult searchResultsValY = new SearchResultDto(searchResultsValX);
                        searchResultsVal.add(searchResultsValY);
                    }
                setSearchResults((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)searchResultsVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getSearchedElement() == null) {
                setSearchedElement((java.lang.String)null);
            } else {
                JsonElement searchedElementVal = getSearchedElement() == null ? JsonNull.INSTANCE : new JsonPrimitive(getSearchedElement());;
                result.add("searchedElement", searchedElementVal);
            }
            if (getElementKind() == null) {
                setElementKind((org.eclipse.lsp4j.SymbolKind)null);
            } else {
                JsonElement elementKindVal = getElementKind() == null ? JsonNull.INSTANCE : new JsonPrimitive(getElementKind().name());;
                result.add("elementKind", elementKindVal);
            }
            if (getSearchResults() == null) {
                setSearchResults((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)null);
            } else {
                JsonArray searchResultsVal = new JsonArray();
                for (org.eclipse.che.jdt.ls.extension.api.dto.SearchResult searchResultsValX : getSearchResults()) {
                    JsonElement searchResultsValY = searchResultsValX == null ? JsonNull.INSTANCE : ((SearchResultDto)searchResultsValX).toJsonElement();;
                    searchResultsVal.add(searchResultsValY);
                }
                result.add("searchResults", searchResultsVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static UsagesResponseDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static UsagesResponseDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            UsagesResponseDto result= new UsagesResponseDto();
            JsonElement jsonsearchedElementJson = json.get("searchedElement");
            if (jsonsearchedElementJson != null && !(jsonsearchedElementJson.isJsonNull())) {
                java.lang.String jsonsearchedElementVal = jsonsearchedElementJson.getAsString();;
                result.setSearchedElement((java.lang.String)jsonsearchedElementVal);
            }
            JsonElement jsonelementKindJson = json.get("elementKind");
            if (jsonelementKindJson != null && !(jsonelementKindJson.isJsonNull())) {
                org.eclipse.lsp4j.SymbolKind jsonelementKindVal = org.eclipse.lsp4j.SymbolKind.valueOf(jsonelementKindJson.getAsString());;
                result.setElementKind((org.eclipse.lsp4j.SymbolKind)jsonelementKindVal);
            }
            JsonElement jsonsearchResultsJson = json.get("searchResults");
            if (jsonsearchResultsJson != null && !(jsonsearchResultsJson.isJsonNull())) {
                ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult> jsonsearchResultsVal= new ArrayList<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>();
                JsonArray jsonsearchResultsVala = jsonsearchResultsJson.getAsJsonArray();
                for(int jsonsearchResultsValai= 0; jsonsearchResultsValai < jsonsearchResultsVala.size(); jsonsearchResultsValai++) {
                    org.eclipse.che.jdt.ls.extension.api.dto.SearchResult jsonsearchResultsValaX = SearchResultDto.fromJson((JsonObject)jsonsearchResultsVala.get(jsonsearchResultsValai));;
                    jsonsearchResultsVal.add(jsonsearchResultsValaX);
                }
                result.setSearchResults((java.util.List<org.eclipse.che.jdt.ls.extension.api.dto.SearchResult>)jsonsearchResultsVal);
            }
            return result;
        }
    }

    public static class UsagesResponseDtoProvider implements DtoProvider<UsagesResponseDto> {
    	public Class<? extends UsagesResponseDto> getImplClass() {
    	  	return UsagesResponseDto.class;
    	}
    
    	public UsagesResponseDto newInstance() {
        	return new UsagesResponseDto();
    	}
    
    	public UsagesResponseDto fromJson(String json) {
    		return UsagesResponseDto.fromJson(json);
    	}
        public UsagesResponseDto fromJson(JsonElement json) {
    		return UsagesResponseDto.fromJson(json);
    	}
        public UsagesResponseDto clone(UsagesResponseDto dto) {
            return UsagesResponseDto.fromJson(dto.toJson());
    	}
    }

    public static class JdtLsPreferencesDto extends JdtLsPreferences implements JsonSerializable {

        public JdtLsPreferencesDto() {
        }

        public JdtLsPreferencesDto(org.eclipse.che.jdt.ls.extension.api.dto.JdtLsPreferences o) {
            if (o.getPreferences() == null) {
                setPreferences((java.util.Map<java.lang.String, java.lang.String>)null);
            } else {
                    java.util.Map<java.lang.String, java.lang.String> preferencesVal= new HashMap<String, java.lang.String>();
                    for (Entry<String, java.lang.String> preferencesValX : o.getPreferences().entrySet()) {
                        java.lang.String preferencesValY = (java.lang.String)makeDto(preferencesValX.getValue());;
                        preferencesVal.put(preferencesValX.getKey(), preferencesValY);
                    }
                setPreferences((java.util.Map<java.lang.String, java.lang.String>)preferencesVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getPreferences() == null) {
                setPreferences((java.util.Map<java.lang.String, java.lang.String>)null);
            } else {
                JsonObject preferencesVal = new JsonObject();
                for (Entry<String, java.lang.String> preferencesValX : getPreferences().entrySet()) {
                    JsonElement preferencesValY = preferencesValX.getValue() == null ? JsonNull.INSTANCE : new JsonPrimitive(preferencesValX.getValue());;
                    preferencesVal.add(preferencesValX.getKey().toString(), preferencesValY);
                }
                result.add("preferences", preferencesVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static JdtLsPreferencesDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static JdtLsPreferencesDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            JdtLsPreferencesDto result= new JdtLsPreferencesDto();
            JsonElement jsonpreferencesJson = json.get("preferences");
            if (jsonpreferencesJson != null && !(jsonpreferencesJson.isJsonNull())) {
                java.util.Map<java.lang.String, java.lang.String> jsonpreferencesVal= new HashMap<String, java.lang.String>();
                JsonObject jsonpreferencesValo = jsonpreferencesJson.getAsJsonObject();
                for(Entry<String, JsonElement> jsonpreferencesValoe : jsonpreferencesValo.entrySet()) {
                    java.lang.String jsonpreferencesValoX = jsonpreferencesValoe.getValue().getAsString();;
                    jsonpreferencesVal.put(jsonpreferencesValoe.getKey(), jsonpreferencesValoX);
                }
                result.setPreferences((java.util.Map<java.lang.String, java.lang.String>)jsonpreferencesVal);
            }
            return result;
        }
    }

    public static class JdtLsPreferencesDtoProvider implements DtoProvider<JdtLsPreferencesDto> {
    	public Class<? extends JdtLsPreferencesDto> getImplClass() {
    	  	return JdtLsPreferencesDto.class;
    	}
    
    	public JdtLsPreferencesDto newInstance() {
        	return new JdtLsPreferencesDto();
    	}
    
    	public JdtLsPreferencesDto fromJson(String json) {
    		return JdtLsPreferencesDto.fromJson(json);
    	}
        public JdtLsPreferencesDto fromJson(JsonElement json) {
    		return JdtLsPreferencesDto.fromJson(json);
    	}
        public JdtLsPreferencesDto clone(JdtLsPreferencesDto dto) {
            return JdtLsPreferencesDto.fromJson(dto.toJson());
    	}
    }

    public static class UpdateWorkspaceParametersDto extends UpdateWorkspaceParameters implements JsonSerializable {

        public UpdateWorkspaceParametersDto() {
        }

        public UpdateWorkspaceParametersDto(org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters o) {
            if (o.getRemovedProjectsUri() == null) {
                setRemovedProjectsUri((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> removedProjectsUriVal= new ArrayList<java.lang.String>();
                    for (java.lang.String removedProjectsUriValX : o.getRemovedProjectsUri()) {
                        java.lang.String removedProjectsUriValY = (java.lang.String)makeDto(removedProjectsUriValX);;
                        removedProjectsUriVal.add(removedProjectsUriValY);
                    }
                setRemovedProjectsUri((java.util.List<java.lang.String>)removedProjectsUriVal);
            }
            if (o.getAddedProjectsUri() == null) {
                setAddedProjectsUri((java.util.List<java.lang.String>)null);
            } else {
                    ArrayList<java.lang.String> addedProjectsUriVal= new ArrayList<java.lang.String>();
                    for (java.lang.String addedProjectsUriValX : o.getAddedProjectsUri()) {
                        java.lang.String addedProjectsUriValY = (java.lang.String)makeDto(addedProjectsUriValX);;
                        addedProjectsUriVal.add(addedProjectsUriValY);
                    }
                setAddedProjectsUri((java.util.List<java.lang.String>)addedProjectsUriVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getRemovedProjectsUri() == null) {
                setRemovedProjectsUri((java.util.List<java.lang.String>)null);
            } else {
                JsonArray removedProjectsUriVal = new JsonArray();
                for (java.lang.String removedProjectsUriValX : getRemovedProjectsUri()) {
                    JsonElement removedProjectsUriValY = removedProjectsUriValX == null ? JsonNull.INSTANCE : new JsonPrimitive(removedProjectsUriValX);;
                    removedProjectsUriVal.add(removedProjectsUriValY);
                }
                result.add("removedProjectsUri", removedProjectsUriVal);
            }
            if (getAddedProjectsUri() == null) {
                setAddedProjectsUri((java.util.List<java.lang.String>)null);
            } else {
                JsonArray addedProjectsUriVal = new JsonArray();
                for (java.lang.String addedProjectsUriValX : getAddedProjectsUri()) {
                    JsonElement addedProjectsUriValY = addedProjectsUriValX == null ? JsonNull.INSTANCE : new JsonPrimitive(addedProjectsUriValX);;
                    addedProjectsUriVal.add(addedProjectsUriValY);
                }
                result.add("addedProjectsUri", addedProjectsUriVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static UpdateWorkspaceParametersDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static UpdateWorkspaceParametersDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            UpdateWorkspaceParametersDto result= new UpdateWorkspaceParametersDto();
            JsonElement jsonremovedProjectsUriJson = json.get("removedProjectsUri");
            if (jsonremovedProjectsUriJson != null && !(jsonremovedProjectsUriJson.isJsonNull())) {
                ArrayList<java.lang.String> jsonremovedProjectsUriVal= new ArrayList<java.lang.String>();
                JsonArray jsonremovedProjectsUriVala = jsonremovedProjectsUriJson.getAsJsonArray();
                for(int jsonremovedProjectsUriValai= 0; jsonremovedProjectsUriValai < jsonremovedProjectsUriVala.size(); jsonremovedProjectsUriValai++) {
                    java.lang.String jsonremovedProjectsUriValaX = jsonremovedProjectsUriVala.get(jsonremovedProjectsUriValai).getAsString();;
                    jsonremovedProjectsUriVal.add(jsonremovedProjectsUriValaX);
                }
                result.setRemovedProjectsUri((java.util.List<java.lang.String>)jsonremovedProjectsUriVal);
            }
            JsonElement jsonaddedProjectsUriJson = json.get("addedProjectsUri");
            if (jsonaddedProjectsUriJson != null && !(jsonaddedProjectsUriJson.isJsonNull())) {
                ArrayList<java.lang.String> jsonaddedProjectsUriVal= new ArrayList<java.lang.String>();
                JsonArray jsonaddedProjectsUriVala = jsonaddedProjectsUriJson.getAsJsonArray();
                for(int jsonaddedProjectsUriValai= 0; jsonaddedProjectsUriValai < jsonaddedProjectsUriVala.size(); jsonaddedProjectsUriValai++) {
                    java.lang.String jsonaddedProjectsUriValaX = jsonaddedProjectsUriVala.get(jsonaddedProjectsUriValai).getAsString();;
                    jsonaddedProjectsUriVal.add(jsonaddedProjectsUriValaX);
                }
                result.setAddedProjectsUri((java.util.List<java.lang.String>)jsonaddedProjectsUriVal);
            }
            return result;
        }
    }

    public static class UpdateWorkspaceParametersDtoProvider implements DtoProvider<UpdateWorkspaceParametersDto> {
    	public Class<? extends UpdateWorkspaceParametersDto> getImplClass() {
    	  	return UpdateWorkspaceParametersDto.class;
    	}
    
    	public UpdateWorkspaceParametersDto newInstance() {
        	return new UpdateWorkspaceParametersDto();
    	}
    
    	public UpdateWorkspaceParametersDto fromJson(String json) {
    		return UpdateWorkspaceParametersDto.fromJson(json);
    	}
        public UpdateWorkspaceParametersDto fromJson(JsonElement json) {
    		return UpdateWorkspaceParametersDto.fromJson(json);
    	}
        public UpdateWorkspaceParametersDto clone(UpdateWorkspaceParametersDto dto) {
            return UpdateWorkspaceParametersDto.fromJson(dto.toJson());
    	}
    }

    public static class RenameParamsDto extends RenameParams implements JsonSerializable {

        public RenameParamsDto() {
        }

        public RenameParamsDto(org.eclipse.lsp4j.RenameParams o) {
            if (o.getPosition() == null) {
                setPosition((org.eclipse.lsp4j.Position)null);
            } else {
                org.eclipse.lsp4j.Position positionVal = new PositionDto(o.getPosition());
                setPosition((org.eclipse.lsp4j.Position)positionVal);
            }
            if (o.getTextDocument() == null) {
                setTextDocument((org.eclipse.lsp4j.TextDocumentIdentifier)null);
            } else {
                org.eclipse.lsp4j.TextDocumentIdentifier textDocumentVal = new TextDocumentIdentifierDto(o.getTextDocument());
                setTextDocument((org.eclipse.lsp4j.TextDocumentIdentifier)textDocumentVal);
            }
            if (o.getNewName() == null) {
                setNewName((java.lang.String)null);
            } else {
                java.lang.String newNameVal = (java.lang.String)makeDto(o.getNewName());;
                setNewName((java.lang.String)newNameVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getPosition() == null) {
                setPosition((org.eclipse.lsp4j.Position)null);
            } else {
                JsonElement positionVal = getPosition() == null ? JsonNull.INSTANCE : ((PositionDto)getPosition()).toJsonElement();;
                result.add("position", positionVal);
            }
            if (getTextDocument() == null) {
                setTextDocument((org.eclipse.lsp4j.TextDocumentIdentifier)null);
            } else {
                JsonElement textDocumentVal = getTextDocument() == null ? JsonNull.INSTANCE : ((TextDocumentIdentifierDto)getTextDocument()).toJsonElement();;
                result.add("textDocument", textDocumentVal);
            }
            if (getNewName() == null) {
                setNewName((java.lang.String)null);
            } else {
                JsonElement newNameVal = getNewName() == null ? JsonNull.INSTANCE : new JsonPrimitive(getNewName());;
                result.add("newName", newNameVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RenameParamsDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static RenameParamsDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            RenameParamsDto result= new RenameParamsDto();
            JsonElement jsonpositionJson = json.get("position");
            if (jsonpositionJson != null && !(jsonpositionJson.isJsonNull())) {
                org.eclipse.lsp4j.Position jsonpositionVal = PositionDto.fromJson((JsonObject)jsonpositionJson);;
                result.setPosition((org.eclipse.lsp4j.Position)jsonpositionVal);
            }
            JsonElement jsontextDocumentJson = json.get("textDocument");
            if (jsontextDocumentJson != null && !(jsontextDocumentJson.isJsonNull())) {
                org.eclipse.lsp4j.TextDocumentIdentifier jsontextDocumentVal = TextDocumentIdentifierDto.fromJson((JsonObject)jsontextDocumentJson);;
                result.setTextDocument((org.eclipse.lsp4j.TextDocumentIdentifier)jsontextDocumentVal);
            }
            JsonElement jsonnewNameJson = json.get("newName");
            if (jsonnewNameJson != null && !(jsonnewNameJson.isJsonNull())) {
                java.lang.String jsonnewNameVal = jsonnewNameJson.getAsString();;
                result.setNewName((java.lang.String)jsonnewNameVal);
            }
            return result;
        }
    }

    public static class RenameParamsDtoProvider implements DtoProvider<RenameParamsDto> {
    	public Class<? extends RenameParamsDto> getImplClass() {
    	  	return RenameParamsDto.class;
    	}
    
    	public RenameParamsDto newInstance() {
        	return new RenameParamsDto();
    	}
    
    	public RenameParamsDto fromJson(String json) {
    		return RenameParamsDto.fromJson(json);
    	}
        public RenameParamsDto fromJson(JsonElement json) {
    		return RenameParamsDto.fromJson(json);
    	}
        public RenameParamsDto clone(RenameParamsDto dto) {
            return RenameParamsDto.fromJson(dto.toJson());
    	}
    }

    public static class RefactoringStatusEntryDto extends RefactoringStatusEntry implements JsonSerializable {

        public RefactoringStatusEntryDto() {
        }

        public RefactoringStatusEntryDto(org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry o) {
            if (o.getRefactoringSeverity() == null) {
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)null);
            } else {
                org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity refactoringSeverityVal = (org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)makeDto(o.getRefactoringSeverity());;
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)refactoringSeverityVal);
            }
            if (o.getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                java.lang.String messageVal = (java.lang.String)makeDto(o.getMessage());;
                setMessage((java.lang.String)messageVal);
            }
        }

        public JsonElement toJsonElement() {
            JsonObject result = new JsonObject();
            if (getRefactoringSeverity() == null) {
                setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)null);
            } else {
                JsonElement refactoringSeverityVal = getRefactoringSeverity() == null ? JsonNull.INSTANCE : new JsonPrimitive(getRefactoringSeverity().name());;
                result.add("refactoringSeverity", refactoringSeverityVal);
            }
            if (getMessage() == null) {
                setMessage((java.lang.String)null);
            } else {
                JsonElement messageVal = getMessage() == null ? JsonNull.INSTANCE : new JsonPrimitive(getMessage());;
                result.add("message", messageVal);
            }
            return result;

        }

        public void toJson(Writer w) {
            try {
                w.write(toJson());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toJson() {
            return toJsonElement().toString();
        }

        public static RefactoringStatusEntryDto fromJson(String json) {
            if (json == null) {
                return null;
            }
            return fromJson(new JsonParser().parse(json));
        }
        public static RefactoringStatusEntryDto fromJson(JsonElement jsonVal) {
            if (jsonVal == null) {
                return null;
            }
            JsonObject json= jsonVal.getAsJsonObject();
            RefactoringStatusEntryDto result= new RefactoringStatusEntryDto();
            JsonElement jsonrefactoringSeverityJson = json.get("refactoringSeverity");
            if (jsonrefactoringSeverityJson != null && !(jsonrefactoringSeverityJson.isJsonNull())) {
                org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity jsonrefactoringSeverityVal = org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity.valueOf(jsonrefactoringSeverityJson.getAsString());;
                result.setRefactoringSeverity((org.eclipse.che.jdt.ls.extension.api.RefactoringSeverity)jsonrefactoringSeverityVal);
            }
            JsonElement jsonmessageJson = json.get("message");
            if (jsonmessageJson != null && !(jsonmessageJson.isJsonNull())) {
                java.lang.String jsonmessageVal = jsonmessageJson.getAsString();;
                result.setMessage((java.lang.String)jsonmessageVal);
            }
            return result;
        }
    }

    public static class RefactoringStatusEntryDtoProvider implements DtoProvider<RefactoringStatusEntryDto> {
    	public Class<? extends RefactoringStatusEntryDto> getImplClass() {
    	  	return RefactoringStatusEntryDto.class;
    	}
    
    	public RefactoringStatusEntryDto newInstance() {
        	return new RefactoringStatusEntryDto();
    	}
    
    	public RefactoringStatusEntryDto fromJson(String json) {
    		return RefactoringStatusEntryDto.fromJson(json);
    	}
        public RefactoringStatusEntryDto fromJson(JsonElement json) {
    		return RefactoringStatusEntryDto.fromJson(json);
    	}
        public RefactoringStatusEntryDto clone(RefactoringStatusEntryDto dto) {
            return RefactoringStatusEntryDto.fromJson(dto.toJson());
    	}
    }

    public void accept(DtoFactory dtoFactory) {
        dtoFactory.registerProvider(CreateMoveParams.class, new CreateMoveParamsDtoProvider());
        dtoFactory.registerProvider(TestFindParameters.class, new TestFindParametersDtoProvider());
        dtoFactory.registerProvider(ProgressReport.class, new ProgressReportDtoProvider());
        dtoFactory.registerProvider(JavaProjectStructure.class, new JavaProjectStructureDtoProvider());
        dtoFactory.registerProvider(WorkspaceEdit.class, new WorkspaceEditDtoProvider());
        dtoFactory.registerProvider(ExtendedSymbolInformation.class, new ExtendedSymbolInformationDtoProvider());
        dtoFactory.registerProvider(ReImportMavenProjectsCommandParameters.class, new ReImportMavenProjectsCommandParametersDtoProvider());
        dtoFactory.registerProvider(PackageFragmentRoot.class, new PackageFragmentRootDtoProvider());
        dtoFactory.registerProvider(ResourceChange.class, new ResourceChangeDtoProvider());
        dtoFactory.registerProvider(LinearRange.class, new LinearRangeDtoProvider());
        dtoFactory.registerProvider(JavaCoreOptions.class, new JavaCoreOptionsDtoProvider());
        dtoFactory.registerProvider(SearchResult.class, new SearchResultDtoProvider());
        dtoFactory.registerProvider(CheWorkspaceEdit.class, new CheWorkspaceEditDtoProvider());
        dtoFactory.registerProvider(RenameSettings.class, new RenameSettingsDtoProvider());
        dtoFactory.registerProvider(JarEntry.class, new JarEntryDtoProvider());
        dtoFactory.registerProvider(RenameSelectionParams.class, new RenameSelectionParamsDtoProvider());
        dtoFactory.registerProvider(UpdateClasspathParameters.class, new UpdateClasspathParametersDtoProvider());
        dtoFactory.registerProvider(Resource.class, new ResourceDtoProvider());
        dtoFactory.registerProvider(JobResult.class, new JobResultDtoProvider());
        dtoFactory.registerProvider(UpdateMavenModulesInfo.class, new UpdateMavenModulesInfoDtoProvider());
        dtoFactory.registerProvider(ExternalLibrariesParameters.class, new ExternalLibrariesParametersDtoProvider());
        dtoFactory.registerProvider(TextDocumentIdentifier.class, new TextDocumentIdentifierDtoProvider());
        dtoFactory.registerProvider(FileStructureCommandParameters.class, new FileStructureCommandParametersDtoProvider());
        dtoFactory.registerProvider(TestPosition.class, new TestPositionDtoProvider());
        dtoFactory.registerProvider(TestPositionParameters.class, new TestPositionParametersDtoProvider());
        dtoFactory.registerProvider(TextDocumentEdit.class, new TextDocumentEditDtoProvider());
        dtoFactory.registerProvider(TextEdit.class, new TextEditDtoProvider());
        dtoFactory.registerProvider(CheResourceChange.class, new CheResourceChangeDtoProvider());
        dtoFactory.registerProvider(SymbolInformation.class, new SymbolInformationDtoProvider());
        dtoFactory.registerProvider(PackageFragment.class, new PackageFragmentDtoProvider());
        dtoFactory.registerProvider(ImplementersResponse.class, new ImplementersResponseDtoProvider());
        dtoFactory.registerProvider(ClasspathEntry.class, new ClasspathEntryDtoProvider());
        dtoFactory.registerProvider(MoveSettings.class, new MoveSettingsDtoProvider());
        dtoFactory.registerProvider(ResourceLocation.class, new ResourceLocationDtoProvider());
        dtoFactory.registerProvider(Location.class, new LocationDtoProvider());
        dtoFactory.registerProvider(VersionedTextDocumentIdentifier.class, new VersionedTextDocumentIdentifierDtoProvider());
        dtoFactory.registerProvider(Jar.class, new JarDtoProvider());
        dtoFactory.registerProvider(OrganizeImportParams.class, new OrganizeImportParamsDtoProvider());
        dtoFactory.registerProvider(RenamingElementInfo.class, new RenamingElementInfoDtoProvider());
        dtoFactory.registerProvider(RefactoringResult.class, new RefactoringResultDtoProvider());
        dtoFactory.registerProvider(Range.class, new RangeDtoProvider());
        dtoFactory.registerProvider(StatusReport.class, new StatusReportDtoProvider());
        dtoFactory.registerProvider(RefactoringStatus.class, new RefactoringStatusDtoProvider());
        dtoFactory.registerProvider(Position.class, new PositionDtoProvider());
        dtoFactory.registerProvider(OrganizeImportsResult.class, new OrganizeImportsResultDtoProvider());
        dtoFactory.registerProvider(UsagesResponse.class, new UsagesResponseDtoProvider());
        dtoFactory.registerProvider(JdtLsPreferences.class, new JdtLsPreferencesDtoProvider());
        dtoFactory.registerProvider(UpdateWorkspaceParameters.class, new UpdateWorkspaceParametersDtoProvider());
        dtoFactory.registerProvider(RenameParams.class, new RenameParamsDtoProvider());
        dtoFactory.registerProvider(RefactoringStatusEntry.class, new RefactoringStatusEntryDtoProvider());
    }
    public static final Object makeDto(Object obj) {
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.CreateMoveParams) {
            return new CreateMoveParamsDto((org.eclipse.che.jdt.ls.extension.api.dto.CreateMoveParams)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.TestFindParameters) {
            return new TestFindParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.TestFindParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport) {
            return new ProgressReportDto((org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.JavaProjectStructure) {
            return new JavaProjectStructureDto((org.eclipse.che.jdt.ls.extension.api.dto.JavaProjectStructure)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.WorkspaceEdit) {
            return new WorkspaceEditDto((org.eclipse.lsp4j.WorkspaceEdit)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation) {
            return new ExtendedSymbolInformationDto((org.eclipse.che.jdt.ls.extension.api.dto.ExtendedSymbolInformation)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ReImportMavenProjectsCommandParameters) {
            return new ReImportMavenProjectsCommandParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.ReImportMavenProjectsCommandParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot) {
            return new PackageFragmentRootDto((org.eclipse.che.jdt.ls.extension.api.dto.PackageFragmentRoot)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.ResourceChange) {
            return new ResourceChangeDto((org.eclipse.lsp4j.ResourceChange)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.LinearRange) {
            return new LinearRangeDto((org.eclipse.che.jdt.ls.extension.api.dto.LinearRange)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.JavaCoreOptions) {
            return new JavaCoreOptionsDto((org.eclipse.che.jdt.ls.extension.api.dto.JavaCoreOptions)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.SearchResult) {
            return new SearchResultDto((org.eclipse.che.jdt.ls.extension.api.dto.SearchResult)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit) {
            return new CheWorkspaceEditDto((org.eclipse.che.jdt.ls.extension.api.dto.CheWorkspaceEdit)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RenameSettings) {
            return new RenameSettingsDto((org.eclipse.che.jdt.ls.extension.api.dto.RenameSettings)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.JarEntry) {
            return new JarEntryDto((org.eclipse.che.jdt.ls.extension.api.dto.JarEntry)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RenameSelectionParams) {
            return new RenameSelectionParamsDto((org.eclipse.che.jdt.ls.extension.api.dto.RenameSelectionParams)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.UpdateClasspathParameters) {
            return new UpdateClasspathParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.UpdateClasspathParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.Resource) {
            return new ResourceDto((org.eclipse.che.jdt.ls.extension.api.dto.Resource)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.JobResult) {
            return new JobResultDto((org.eclipse.che.jdt.ls.extension.api.dto.JobResult)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.UpdateMavenModulesInfo) {
            return new UpdateMavenModulesInfoDto((org.eclipse.che.jdt.ls.extension.api.dto.UpdateMavenModulesInfo)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ExternalLibrariesParameters) {
            return new ExternalLibrariesParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.ExternalLibrariesParameters)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.TextDocumentIdentifier) {
            return new TextDocumentIdentifierDto((org.eclipse.lsp4j.TextDocumentIdentifier)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.FileStructureCommandParameters) {
            return new FileStructureCommandParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.FileStructureCommandParameters)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.TestPosition) {
            return new TestPositionDto((org.eclipse.che.jdt.ls.extension.api.dto.TestPosition)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.TestPositionParameters) {
            return new TestPositionParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.TestPositionParameters)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.TextDocumentEdit) {
            return new TextDocumentEditDto((org.eclipse.lsp4j.TextDocumentEdit)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.TextEdit) {
            return new TextEditDto((org.eclipse.lsp4j.TextEdit)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange) {
            return new CheResourceChangeDto((org.eclipse.che.jdt.ls.extension.api.dto.CheResourceChange)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.SymbolInformation) {
            return new SymbolInformationDto((org.eclipse.lsp4j.SymbolInformation)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment) {
            return new PackageFragmentDto((org.eclipse.che.jdt.ls.extension.api.dto.PackageFragment)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ImplementersResponse) {
            return new ImplementersResponseDto((org.eclipse.che.jdt.ls.extension.api.dto.ImplementersResponse)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry) {
            return new ClasspathEntryDto((org.eclipse.che.jdt.ls.extension.api.dto.ClasspathEntry)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.MoveSettings) {
            return new MoveSettingsDto((org.eclipse.che.jdt.ls.extension.api.dto.MoveSettings)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.ResourceLocation) {
            return new ResourceLocationDto((org.eclipse.che.jdt.ls.extension.api.dto.ResourceLocation)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.Location) {
            return new LocationDto((org.eclipse.lsp4j.Location)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.VersionedTextDocumentIdentifier) {
            return new VersionedTextDocumentIdentifierDto((org.eclipse.lsp4j.VersionedTextDocumentIdentifier)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.Jar) {
            return new JarDto((org.eclipse.che.jdt.ls.extension.api.dto.Jar)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportParams) {
            return new OrganizeImportParamsDto((org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportParams)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RenamingElementInfo) {
            return new RenamingElementInfoDto((org.eclipse.che.jdt.ls.extension.api.dto.RenamingElementInfo)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RefactoringResult) {
            return new RefactoringResultDto((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringResult)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.Range) {
            return new RangeDto((org.eclipse.lsp4j.Range)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.StatusReport) {
            return new StatusReportDto((org.eclipse.che.jdt.ls.extension.api.dto.StatusReport)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus) {
            return new RefactoringStatusDto((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatus)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.Position) {
            return new PositionDto((org.eclipse.lsp4j.Position)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportsResult) {
            return new OrganizeImportsResultDto((org.eclipse.che.jdt.ls.extension.api.dto.OrganizeImportsResult)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.UsagesResponse) {
            return new UsagesResponseDto((org.eclipse.che.jdt.ls.extension.api.dto.UsagesResponse)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.JdtLsPreferences) {
            return new JdtLsPreferencesDto((org.eclipse.che.jdt.ls.extension.api.dto.JdtLsPreferences)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters) {
            return new UpdateWorkspaceParametersDto((org.eclipse.che.jdt.ls.extension.api.dto.UpdateWorkspaceParameters)obj);
        }
        if (obj instanceof org.eclipse.lsp4j.RenameParams) {
            return new RenameParamsDto((org.eclipse.lsp4j.RenameParams)obj);
        }
        if (obj instanceof org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry) {
            return new RefactoringStatusEntryDto((org.eclipse.che.jdt.ls.extension.api.dto.RefactoringStatusEntry)obj);
        }
        return obj;
    }
}
