/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import com.google.gson.JsonSyntaxException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.che.api.core.BadRequestException;
import org.eclipse.che.api.core.ConflictException;
import org.eclipse.che.api.core.ForbiddenException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.core.model.workspace.config.ProjectConfig;
import org.eclipse.che.api.core.notification.EventService;
import org.eclipse.che.api.project.server.ProjectManager;
import org.eclipse.che.api.project.server.notification.ProjectUpdatedEvent;
import org.eclipse.che.api.workspace.server.model.impl.ProjectConfigImpl;
import org.eclipse.che.api.workspace.server.model.impl.SourceStorageImpl;
import org.eclipse.che.plugin.java.languageserver.JavaLanguageServerExtensionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProjectsSynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectsSynchronizer.class);
    private final JavaLanguageServerExtensionService service;
    private final EventService eventService;
    private final ProjectManager projectManager;

    @Inject
    public ProjectsSynchronizer(JavaLanguageServerExtensionService service, EventService eventService, ProjectManager projectManager) {
        this.service = service;
        this.eventService = eventService;
        this.projectManager = projectManager;
    }

    public void synchronize(String rootPath) {
        try {
            HashSet<String> mavenProjects = new HashSet<String>(this.service.getMavenProjects(rootPath, 1, TimeUnit.HOURS));
            for (String mavenProjectPath : mavenProjects) {
                Optional project = this.projectManager.get(mavenProjectPath);
                if (project.isPresent()) continue;
                this.doCreateProject(mavenProjectPath);
            }
        }
        catch (JsonSyntaxException | InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Error getting maven projects", e);
        }
    }

    private void doCreateProject(String projectPath) {
        ProjectConfigImpl projectConfig = new ProjectConfigImpl();
        projectConfig.setSource(new SourceStorageImpl());
        projectConfig.setType("maven");
        projectConfig.setPath(projectPath);
        projectConfig.setName(projectPath.substring(projectPath.lastIndexOf("/") + 1));
        try {
            this.projectManager.update((ProjectConfig)projectConfig);
            this.eventService.publish((Object)new ProjectUpdatedEvent(projectPath));
        }
        catch (BadRequestException | ConflictException | ForbiddenException | NotFoundException | ServerException e) {
            LOG.error(String.format("Failed to update project '%s'", projectConfig.getPath()));
        }
    }
}

