/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.che.api.core.BadRequestException;
import org.eclipse.che.api.core.ConflictException;
import org.eclipse.che.api.core.ForbiddenException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.core.model.workspace.config.ProjectConfig;
import org.eclipse.che.api.core.notification.EventService;
import org.eclipse.che.api.languageserver.LanguageServerConfig;
import org.eclipse.che.api.languageserver.LanguageServiceUtils;
import org.eclipse.che.api.languageserver.ProcessCommunicationProvider;
import org.eclipse.che.api.languageserver.service.FileContentAccess;
import org.eclipse.che.api.languageserver.util.DynamicWrapper;
import org.eclipse.che.api.languageserver.util.JsonUtil;
import org.eclipse.che.api.project.server.ProjectManager;
import org.eclipse.che.api.project.server.impl.RootDirPathProvider;
import org.eclipse.che.api.project.server.notification.ProjectUpdatedEvent;
import org.eclipse.che.jdt.ls.extension.api.dto.ProgressReport;
import org.eclipse.che.jdt.ls.extension.api.dto.StatusReport;
import org.eclipse.che.plugin.java.languageserver.ExecuteClientCommandJsonRpcTransmitter;
import org.eclipse.che.plugin.java.languageserver.JavaLSWrapper;
import org.eclipse.che.plugin.java.languageserver.JavaLanguageClient;
import org.eclipse.che.plugin.java.languageserver.JavaLanguageServer;
import org.eclipse.che.plugin.java.languageserver.NotifyJsonRpcTransmitter;
import org.eclipse.che.plugin.java.languageserver.ProcessorJsonRpcCommunication;
import org.eclipse.che.plugin.java.languageserver.ProjectsSynchronizer;
import org.eclipse.che.plugin.java.languageserver.dto.DtoServerImpls;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JavaLanguageServerLauncher
implements LanguageServerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(JavaLanguageServerLauncher.class);
    private final Path launchScript;
    private final RootDirPathProvider rootDirPathProvider;
    private final ProcessorJsonRpcCommunication processorJsonRpcCommunication;
    private final ExecuteClientCommandJsonRpcTransmitter executeCliendCommandTransmitter;
    private final NotifyJsonRpcTransmitter notifyTransmitter;
    private final EventService eventService;
    private final ProjectManager projectManager;
    private final ProjectsSynchronizer projectSynchronizer;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    @Inject
    public JavaLanguageServerLauncher(RootDirPathProvider rootDirPathProvider, ProcessorJsonRpcCommunication processorJsonRpcCommunication, ExecuteClientCommandJsonRpcTransmitter executeCliendCommandTransmitter, NotifyJsonRpcTransmitter notifyTransmitter, EventService eventService, ProjectManager projectManager, ProjectsSynchronizer projectSynchronizer) {
        this.rootDirPathProvider = rootDirPathProvider;
        this.processorJsonRpcCommunication = processorJsonRpcCommunication;
        this.executeCliendCommandTransmitter = executeCliendCommandTransmitter;
        this.notifyTransmitter = notifyTransmitter;
        this.eventService = eventService;
        this.projectManager = projectManager;
        this.projectSynchronizer = projectSynchronizer;
        this.launchScript = Paths.get(System.getenv("HOME"), "che/ls-java/launch.sh");
    }

    public void sendStatusReport(StatusReport report) {
        LOG.info("{}: {}", (Object)report.getType(), (Object)report.getMessage());
        if ("Started".equals(report.getType())) {
            this.isStarted.set(true);
            this.updateWorkspaceOnLSStarted();
        }
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    private void updateWorkspaceOnLSStarted() {
        this.projectManager.getAll().forEach(registeredProject -> {
            if (new StringTokenizer(registeredProject.getPath(), "/", false).countTokens() == 1) {
                CompletableFuture.runAsync(() -> this.projectSynchronizer.synchronize(registeredProject.getPath()));
            }
            if (!registeredProject.getProblems().isEmpty()) {
                try {
                    this.projectManager.update((ProjectConfig)registeredProject);
                    this.eventService.publish((Object)new ProjectUpdatedEvent(registeredProject.getPath()));
                }
                catch (BadRequestException | ConflictException | ForbiddenException | NotFoundException | ServerException e) {
                    LOG.error(String.format("Failed to update project '%s' configuration", registeredProject.getName()), e);
                }
            }
        });
    }

    public void sendProgressReport(ProgressReport report) {
        this.processorJsonRpcCommunication.sendProgressNotification(report);
    }

    public CompletableFuture<Object> executeClientCommand(ExecuteCommandParams params) {
        return this.executeCliendCommandTransmitter.executeClientCommand(this.analyzeParams(params));
    }

    public void sendNotification(ExecuteCommandParams params) {
        this.notifyTransmitter.sendNotification(this.analyzeParams(params));
    }

    private ExecuteCommandParams analyzeParams(ExecuteCommandParams params) {
        String command = params.getCommand();
        List arguments = params.getArguments();
        switch (command) {
            case "che.jdt.ls.extension.workspace.clientUpdateProjectsClasspath": 
            case "che.jdt.ls.extension.workspace.clientUpdateOnProjectClasspathChanged": {
                ArrayList<String> fixedPathList = new ArrayList<String>(arguments.size());
                for (Object uri : arguments) {
                    fixedPathList.add(LanguageServiceUtils.removePrefixUri((String)JsonUtil.convertToJson(uri).getAsString()));
                }
                params.setArguments(fixedPathList);
                break;
            }
            case "che.jdt.ls.extension.workspace.clientUpdateProject": 
            case "che.jdt.ls.extension.workspace.clientUpdateProjectConfig": {
                Object projectUri = arguments.get(0);
                params.setArguments(Collections.singletonList(LanguageServiceUtils.removePrefixUri((String)JsonUtil.convertToJson(projectUri).getAsString())));
                break;
            }
            case "che.jdt.ls.extension.workspace.clientUpdateMavenModule": {
                this.updateMavenModules(params, arguments);
                break;
            }
        }
        return params;
    }

    private void updateMavenModules(ExecuteCommandParams params, List<Object> arguments) {
        LinkedList<Object> newParameters = new LinkedList<Object>();
        DtoServerImpls.UpdateMavenModulesInfoDto updateModulesInfo = DtoServerImpls.UpdateMavenModulesInfoDto.fromJson(arguments.get(0).toString());
        String projectUri = LanguageServiceUtils.removePrefixUri((String)updateModulesInfo.getProjectUri());
        for (String uri : updateModulesInfo.getAdded()) {
            this.addMavenProjectType(Paths.get(projectUri, uri).toString(), newParameters);
        }
        for (String uri : updateModulesInfo.getRemoved()) {
            this.removeMavenProjectType(Paths.get(projectUri, uri).toString(), newParameters);
        }
        params.setCommand("che.jdt.ls.extension.workspace.clientUpdateProject");
        params.setArguments(newParameters);
    }

    private void removeMavenProjectType(String projectPath, List<Object> parameters) {
        try {
            if (this.projectManager.getOrNull(projectPath) != null) {
                this.projectManager.removeType(projectPath, "maven");
                parameters.add(projectPath);
            }
        }
        catch (BadRequestException | ConflictException | ForbiddenException | NotFoundException | ServerException e) {
            LOG.error("Can't remove project: " + projectPath, e);
        }
    }

    private void addMavenProjectType(String projectPath, List<Object> parameters) {
        try {
            this.projectManager.setType(projectPath, "maven", false);
            parameters.add(projectPath);
        }
        catch (BadRequestException | ConflictException | ForbiddenException | NotFoundException | ServerException e) {
            LOG.error("Can't add new project: " + projectPath, e);
        }
    }

    public LanguageServerConfig.RegexProvider getRegexpProvider() {
        return new LanguageServerConfig.RegexProvider(){

            public Map<String, String> getLanguageRegexes() {
                HashMap<String, String> regex = new HashMap<String, String>();
                regex.put("java", "(^jdt://.*|^chelib://.*|.*\\.java|.*\\.class)");
                return regex;
            }

            public Set<String> getFileWatchPatterns() {
                HashSet<String> regex = new HashSet<String>();
                regex.add("glob:**/*.java");
                regex.add("glob:**/pom.xml");
                regex.add("glob:**/*.gradle");
                regex.add("glob:**/.project");
                regex.add("glob:**/.classpath");
                regex.add("glob:**/settings/*.prefs");
                return regex;
            }
        };
    }

    public String getProjectsRoot() {
        return this.rootDirPathProvider.get();
    }

    public LanguageServerConfig.CommunicationProvider getCommunicationProvider() {
        ProcessBuilder processBuilder = new ProcessBuilder(this.launchScript.toString());
        processBuilder.directory(this.launchScript.getParent().toFile());
        processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        return new ProcessCommunicationProvider(processBuilder, "Che-LS-JDT");
    }

    public LanguageServerConfig.InstallerStatusProvider getInstallerStatusProvider() {
        return new LanguageServerConfig.InstallerStatusProvider(){

            public boolean isSuccessfullyInstalled() {
                return JavaLanguageServerLauncher.this.launchScript.toFile().exists();
            }

            public String getCause() {
                return this.isSuccessfullyInstalled() ? null : "Launch script file does not exist";
            }
        };
    }

    public LanguageServerConfig.InstanceProvider getInstanceProvider() {
        return new LanguageServerConfig.InstanceProvider(){

            public LanguageServer get(LanguageClient client, InputStream in, OutputStream out) {
                Object javaLangClient = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LanguageClient.class, JavaLanguageClient.class}, (InvocationHandler)new DynamicWrapper((Object)JavaLanguageServerLauncher.this, (Object)client));
                Launcher launcher = Launcher.createLauncher((Object)javaLangClient, JavaLanguageServer.class, (InputStream)in, (OutputStream)out);
                launcher.startListening();
                JavaLanguageServer proxy = (JavaLanguageServer)launcher.getRemoteProxy();
                LanguageServer wrapped = (LanguageServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{LanguageServer.class, FileContentAccess.class}, (InvocationHandler)new DynamicWrapper((Object)new JavaLSWrapper(proxy), (Object)proxy));
                return wrapped;
            }
        };
    }
}

