/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.languageserver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.che.api.fs.server.WsPathUtils;
import org.eclipse.che.api.languageserver.LanguageServerException;
import org.eclipse.che.api.languageserver.LanguageServiceUtils;
import org.eclipse.che.plugin.java.languageserver.XMLParser;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JavaTextDocumentServiceWraper {
    private static final Logger LOG = LoggerFactory.getLogger(JavaTextDocumentServiceWraper.class);
    private TextDocumentService wrapped;

    public JavaTextDocumentServiceWraper(TextDocumentService wrapped) {
        this.wrapped = wrapped;
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        CompletableFuture result = this.wrapped.codeAction(params);
        return result.thenApply(commands -> {
            commands.forEach(cmd -> {
                if (cmd.isLeft() && "java.apply.workspaceEdit".equals(((Command)cmd.getLeft()).getCommand())) {
                    ((Command)cmd.getLeft()).setCommand("lsp.applyWorkspaceEdit");
                }
            });
            return commands;
        });
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) throws LanguageServerException {
        String fileUri = params.getTextDocument().getUri();
        FormattingOptions options = params.getOptions();
        if (options == null) {
            options = new FormattingOptions();
            params.setOptions(options);
        }
        this.updateFormatterOptions(params, fileUri);
        return this.wrapped.formatting(params);
    }

    private void updateFormatterOptions(DocumentFormattingParams params, String fileUri) throws LanguageServerException {
        String projectPath = WsPathUtils.absolutize((String)LanguageServiceUtils.extractProjectPath((String)fileUri));
        String formatterPathSuffix = ".che/che-formatter.xml";
        Path projectFormatterPath = Paths.get(projectPath, formatterPathSuffix);
        Path wsFormatterPath = Paths.get("/projects", formatterPathSuffix);
        if (Files.exists(projectFormatterPath, new LinkOption[0])) {
            this.updateFormatterOptions(params, JavaTextDocumentServiceWraper.getFormatSettingsFromFile(projectFormatterPath.toFile()));
        } else if (Files.exists(wsFormatterPath, new LinkOption[0])) {
            this.updateFormatterOptions(params, JavaTextDocumentServiceWraper.getFormatSettingsFromFile(wsFormatterPath.toFile()));
        }
    }

    private void updateFormatterOptions(DocumentFormattingParams params, Map<String, String> options) {
        for (String key : options.keySet()) {
            params.getOptions().putString(key, options.get(key));
        }
    }

    private static Map<String, String> getFormatSettingsFromFile(File file) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        XMLParser parserXML = new XMLParser();
        try (FileInputStream fis = new FileInputStream(file);){
            SAXParser parser = factory.newSAXParser();
            parser.parse((InputStream)fis, (DefaultHandler)parserXML);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.error("It is not possible to parse file " + file.getName(), (Throwable)e);
        }
        return parserXML.getSettings();
    }
}

