/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.nodejsdbg.server;

import com.google.common.base.Strings;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.che.api.debugger.server.Debugger;
import org.eclipse.che.api.debugger.server.DebuggerFactory;
import org.eclipse.che.api.debugger.server.exceptions.DebuggerException;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsDebugger;

public class NodeJsDebuggerFactory
implements DebuggerFactory {
    private static final String TYPE = "nodejsdbg";

    public String getType() {
        return TYPE;
    }

    public Debugger create(Map<String, String> properties, Debugger.DebuggerCallback debuggerCallback) throws DebuggerException {
        String script;
        String uriStr;
        Map<String, String> normalizedProps = properties.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), Map.Entry::getValue));
        Integer pid = null;
        URI uri = null;
        String pidStr = normalizedProps.get("pid");
        if (!Strings.isNullOrEmpty((String)pidStr)) {
            try {
                pid = Integer.valueOf(pidStr);
            }
            catch (NumberFormatException e2) {
                throw new DebuggerException(String.format("Illegal 'pid' format %s. Debugger can't be started.", pidStr));
            }
        }
        if (!Strings.isNullOrEmpty((String)(uriStr = normalizedProps.get("uri")))) {
            try {
                uri = URI.create(uriStr);
            }
            catch (IllegalArgumentException e3) {
                throw new DebuggerException(String.format("Illegal 'uri' format %s. Debugger can't be started.", uriStr));
            }
        }
        if (!Strings.isNullOrEmpty((String)(script = normalizedProps.get("script"))) && !Files.exists(Paths.get(script, new String[0]), new LinkOption[0])) {
            throw new DebuggerException(String.format("Script '%s' to debug not found. Debugger can't be started.", script));
        }
        if (Strings.isNullOrEmpty((String)pidStr) && Strings.isNullOrEmpty((String)uriStr) && Strings.isNullOrEmpty((String)script)) {
            throw new DebuggerException("Unrecognized debug connection options. Allowed only: pid, uri or script.");
        }
        return NodeJsDebugger.newInstance(pid, uri, script, debuggerCallback);
    }
}

