/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.nodejsdbg.server.command;

import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.eclipse.che.api.debug.shared.model.Breakpoint;
import org.eclipse.che.api.debug.shared.model.Location;
import org.eclipse.che.api.debug.shared.model.impl.BreakpointImpl;
import org.eclipse.che.api.debug.shared.model.impl.LocationImpl;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsDebugProcess;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsDebugger;
import org.eclipse.che.plugin.nodejsdbg.server.command.NodeJsDebugCommand;
import org.eclipse.che.plugin.nodejsdbg.server.command.NodeJsDebugCommandImpl;
import org.eclipse.che.plugin.nodejsdbg.server.exception.NodeJsDebuggerException;
import org.eclipse.che.plugin.nodejsdbg.server.parser.NodeJsBreakpointsParser;
import org.eclipse.che.plugin.nodejsdbg.server.parser.NodeJsOutputParser;
import org.eclipse.che.plugin.nodejsdbg.server.parser.NodeJsScriptsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsDebugCommandsLibrary {
    private static final Logger LOG = LoggerFactory.getLogger(NodeJsDebugger.class);
    private static final Pattern PROCESS_TITLE_COMMAND_OUTPUT_PATTERN = Pattern.compile("^'?(node|nodejs)'?$");
    private static final Pattern PROCESS_VERSION_COMMAND_OUTPUT_PATTERN = Pattern.compile("^'?(v|)[0-9\\.]+'?$");
    private static final Pattern PROCESS_PID_COMMAND_OUTPUT_PATTERN = Pattern.compile("^[0-9]+$");
    private static final Pattern RUN_COMMAND_OUTPUT_PATTERN = Pattern.compile("Debugger attached.");
    private final NodeJsDebugProcess process;
    private final String name;
    private final String version;
    private final int pid;

    public NodeJsDebugCommandsLibrary(NodeJsDebugProcess process) throws NodeJsDebuggerException {
        this.process = process;
        this.run();
        this.name = this.detectName();
        this.version = this.detectVersion();
        this.pid = this.detectPid();
    }

    public Void backtrace() throws NodeJsDebuggerException {
        this.doExecute(this.createCommand("bt", NodeJsOutputParser.VOID));
        return null;
    }

    public Void setBreakpoint(String scriptPath, int lineNumber) throws NodeJsDebuggerException {
        String scriptName = Paths.get(scriptPath, new String[0]).getFileName().toString();
        String input = String.format("sb('%s', %d)", scriptName, lineNumber);
        NodeJsDebugCommand<Void> command = this.createCommand(input, NodeJsOutputParser.VOID);
        return this.doExecute(command);
    }

    public List<Breakpoint> getBreakpoints() throws NodeJsDebuggerException {
        NodeJsDebugCommand<NodeJsBreakpointsParser.Breakpoints> breakpointsCommand = this.createCommand("breakpoints", NodeJsBreakpointsParser.INSTANCE);
        List<Breakpoint> breakpoints = this.doExecute(breakpointsCommand).getAll();
        NodeJsDebugCommand<NodeJsScriptsParser.Scripts> scriptsCommand = this.createCommand("scripts", NodeJsScriptsParser.INSTANCE);
        Map<Integer, String> scripts = this.doExecute(scriptsCommand).getAll();
        for (int i = 0; i < breakpoints.size(); ++i) {
            Breakpoint breakpoint = breakpoints.get(i);
            Location location = breakpoint.getLocation();
            String[] target = location.getTarget().split(":");
            if (target.length != 2) {
                LOG.error(String.format("Illegal breakpoint location format %s", target[0]));
                continue;
            }
            String newTarget = target[0].equals("scriptId") ? scripts.get((int)Double.parseDouble(target[1])) : target[1];
            LocationImpl newLocation = new LocationImpl(newTarget, location.getLineNumber());
            BreakpointImpl newBreakpoint = new BreakpointImpl((Location)newLocation, breakpoint.isEnabled(), breakpoint.getBreakpointConfiguration());
            breakpoints.set(i, (Breakpoint)newBreakpoint);
        }
        return breakpoints;
    }

    public Void clearBreakpoint(String script, int lineNumber) throws NodeJsDebuggerException {
        String input = String.format("cb('%s', %d)", script, lineNumber);
        NodeJsDebugCommand<Void> command = this.createCommand(input, NodeJsOutputParser.VOID);
        return this.doExecute(command);
    }

    public String run() throws NodeJsDebuggerException {
        NodeJsDebugCommand<String> nextCommand = this.createCommand("run", new NodeJsOutputParser.NodeJsOutputRegExpParser(RUN_COMMAND_OUTPUT_PATTERN));
        return this.doExecute(nextCommand);
    }

    public Void next() throws NodeJsDebuggerException {
        this.doExecute(this.createCommand("next", NodeJsOutputParser.VOID));
        return null;
    }

    public Void cont() throws NodeJsDebuggerException {
        this.doExecute(this.createCommand("cont", NodeJsOutputParser.VOID));
        return null;
    }

    public Void stepIn() throws NodeJsDebuggerException {
        this.doExecute(this.createCommand("step", NodeJsOutputParser.VOID));
        return null;
    }

    public Void stepOut() throws NodeJsDebuggerException {
        this.doExecute(this.createCommand("out", NodeJsOutputParser.VOID));
        return null;
    }

    public Void setVar(String varName, String newValue) throws NodeJsDebuggerException {
        String input = String.format("exec %s=%s", varName, newValue);
        NodeJsDebugCommand<Void> command = this.createCommand(input, NodeJsOutputParser.VOID);
        return this.doExecute(command);
    }

    public String getVar(String varName) throws NodeJsDebuggerException {
        String line = String.format("exec %s", varName);
        NodeJsDebugCommand<String> command = this.createCommand(line, NodeJsOutputParser.DEFAULT);
        return this.doExecute(command);
    }

    public String evaluate(String expression) throws NodeJsDebuggerException {
        String line = String.format("exec %s", expression);
        NodeJsDebugCommand<String> command = this.createCommand(line, NodeJsOutputParser.DEFAULT);
        return this.doExecute(command);
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public int getPid() {
        return this.pid;
    }

    private String detectVersion() throws NodeJsDebuggerException {
        NodeJsDebugCommand<String> command = this.createCommand("process.version", new NodeJsOutputParser.NodeJsOutputRegExpParser(PROCESS_VERSION_COMMAND_OUTPUT_PATTERN));
        return this.doExecute(command);
    }

    private int detectPid() throws NodeJsDebuggerException {
        NodeJsDebugCommand<String> command = this.createCommand("process.pid", new NodeJsOutputParser.NodeJsOutputRegExpParser(PROCESS_PID_COMMAND_OUTPUT_PATTERN));
        return Integer.parseInt(this.doExecute(command));
    }

    private String detectName() throws NodeJsDebuggerException {
        NodeJsDebugCommand<String> command = this.createCommand("process.title", new NodeJsOutputParser.NodeJsOutputRegExpParser(PROCESS_TITLE_COMMAND_OUTPUT_PATTERN));
        return this.doExecute(command);
    }

    private <V> V doExecute(NodeJsDebugCommand<V> command) throws NodeJsDebuggerException {
        this.process.addObserver(command);
        try {
            Future<V> result = command.execute(this.process);
            V v = result.get();
            return v;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new NodeJsDebuggerException(e.getMessage(), e);
        }
        finally {
            this.process.removeObserver(command);
        }
    }

    private <T> NodeJsDebugCommand<T> createCommand(String input, NodeJsOutputParser<T> outputParser) {
        return new NodeJsDebugCommandImpl<T>(outputParser, input);
    }
}

