/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.nodejsdbg.server.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsOutput;
import org.eclipse.che.plugin.nodejsdbg.server.parser.NodeJsOutputParser;

public class NodeJsScriptsParser
implements NodeJsOutputParser<Scripts> {
    private static final Pattern SCRIPT = Pattern.compile(".* ([0-9]*): (.*)");
    public static final NodeJsScriptsParser INSTANCE = new NodeJsScriptsParser();

    @Override
    public boolean match(NodeJsOutput nodeJsOutput) {
        for (String line : nodeJsOutput.getOutput().split("\n")) {
            Matcher matcher = SCRIPT.matcher(line);
            if (matcher.find()) continue;
            return false;
        }
        return !nodeJsOutput.isEmpty();
    }

    @Override
    public Scripts parse(NodeJsOutput nodeJsOutput) {
        HashMap<Integer, String> scripts = new HashMap<Integer, String>();
        for (String line : nodeJsOutput.getOutput().split("\n")) {
            Matcher matcher = SCRIPT.matcher(line);
            if (!matcher.find()) continue;
            int number = Integer.parseInt(matcher.group(1));
            String script = matcher.group(2);
            scripts.put(number, script);
        }
        return new Scripts(scripts);
    }

    public static class Scripts {
        private final Map<Integer, String> scripts;

        public Scripts(Map<Integer, String> scripts) {
            this.scripts = scripts;
        }

        public Map<Integer, String> getAll() {
            return this.scripts;
        }
    }
}

