/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.nodejsdbg.server;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.eclipse.che.api.debug.shared.model.Breakpoint;
import org.eclipse.che.api.debug.shared.model.DebuggerInfo;
import org.eclipse.che.api.debug.shared.model.Location;
import org.eclipse.che.api.debug.shared.model.SimpleValue;
import org.eclipse.che.api.debug.shared.model.StackFrameDump;
import org.eclipse.che.api.debug.shared.model.SuspendPolicy;
import org.eclipse.che.api.debug.shared.model.Variable;
import org.eclipse.che.api.debug.shared.model.VariablePath;
import org.eclipse.che.api.debug.shared.model.action.ResumeAction;
import org.eclipse.che.api.debug.shared.model.action.StartAction;
import org.eclipse.che.api.debug.shared.model.action.StepIntoAction;
import org.eclipse.che.api.debug.shared.model.action.StepOutAction;
import org.eclipse.che.api.debug.shared.model.action.StepOverAction;
import org.eclipse.che.api.debug.shared.model.event.DebuggerEvent;
import org.eclipse.che.api.debug.shared.model.impl.DebuggerInfoImpl;
import org.eclipse.che.api.debug.shared.model.impl.SimpleValueImpl;
import org.eclipse.che.api.debug.shared.model.impl.StackFrameDumpImpl;
import org.eclipse.che.api.debug.shared.model.impl.event.BreakpointActivatedEventImpl;
import org.eclipse.che.api.debug.shared.model.impl.event.DisconnectEventImpl;
import org.eclipse.che.api.debug.shared.model.impl.event.SuspendEventImpl;
import org.eclipse.che.api.debugger.server.Debugger;
import org.eclipse.che.api.debugger.server.exceptions.DebuggerException;
import org.eclipse.che.commons.annotation.Nullable;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsDebugProcess;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsOutput;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsProcessObserver;
import org.eclipse.che.plugin.nodejsdbg.server.command.NodeJsDebugCommandsLibrary;
import org.eclipse.che.plugin.nodejsdbg.server.exception.NodeJsDebuggerException;
import org.eclipse.che.plugin.nodejsdbg.server.exception.NodeJsDebuggerTerminatedException;
import org.eclipse.che.plugin.nodejsdbg.server.parser.NodeJsBackTraceParser;
import org.eclipse.che.plugin.nodejsdbg.server.parser.NodeJsStepParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsDebugger
implements Debugger,
NodeJsProcessObserver {
    private static final Logger LOG = LoggerFactory.getLogger(NodeJsDebugger.class);
    private final Integer pid;
    private final URI uri;
    private final String name;
    private final String version;
    private final String script;
    private final NodeJsDebugProcess nodeJsDebugProcess;
    private final Debugger.DebuggerCallback debuggerCallback;
    private final NodeJsDebugCommandsLibrary library;

    NodeJsDebugger(@Nullable Integer pid, @Nullable URI uri, @Nullable String script, NodeJsDebugProcess nodeJsDebugProcess, Debugger.DebuggerCallback debuggerCallback) throws NodeJsDebuggerException {
        this.pid = pid;
        this.uri = uri;
        this.script = script;
        this.nodeJsDebugProcess = nodeJsDebugProcess;
        this.library = new NodeJsDebugCommandsLibrary(nodeJsDebugProcess);
        this.name = this.library.getName();
        this.version = this.library.getVersion();
        this.debuggerCallback = debuggerCallback;
        this.nodeJsDebugProcess.addObserver(this);
    }

    public static NodeJsDebugger newInstance(@Nullable Integer pid, @Nullable URI uri, String file, Debugger.DebuggerCallback debuggerCallback) throws DebuggerException {
        NodeJsDebugProcess nodeJsDebugProcess = NodeJsDebugProcess.start(file);
        return new NodeJsDebugger(pid, uri, file, nodeJsDebugProcess, debuggerCallback);
    }

    public DebuggerInfo getInfo() throws DebuggerException {
        return new DebuggerInfoImpl(this.uri == null ? "" : this.uri.getHost(), this.uri == null ? -1 : this.uri.getPort(), this.name, this.version, this.pid == null ? -1 : this.pid, this.script);
    }

    public void disconnect() {
        this.debuggerCallback.onEvent((DebuggerEvent)new DisconnectEventImpl());
        this.nodeJsDebugProcess.stop();
    }

    public void addBreakpoint(Breakpoint breakpoint) throws DebuggerException {
        try {
            Location location = breakpoint.getLocation();
            this.library.setBreakpoint(location.getTarget(), location.getLineNumber());
            this.debuggerCallback.onEvent((DebuggerEvent)new BreakpointActivatedEventImpl(breakpoint));
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
            throw e;
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Can't add breakpoint: " + breakpoint + ". " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void deleteBreakpoint(Location location) throws DebuggerException {
        try {
            this.library.clearBreakpoint(location.getTarget(), location.getLineNumber());
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
            throw e;
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Can't delete breakpoint: " + location + ". " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void deleteAllBreakpoints() throws DebuggerException {
        try {
            for (Breakpoint breakpoint : this.library.getBreakpoints()) {
                try {
                    this.deleteBreakpoint(breakpoint.getLocation());
                }
                catch (NodeJsDebuggerException e) {
                    LOG.error("Can't delete breakpoint: {}", (Object)breakpoint.getLocation(), (Object)e);
                }
            }
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
            throw e;
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Can't delete all breakpoints. " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public List<Breakpoint> getAllBreakpoints() throws DebuggerException {
        try {
            return this.library.getBreakpoints();
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
            throw e;
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Can't get all breakpoints. " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void start(StartAction action) throws DebuggerException {
        try {
            for (Breakpoint breakpoint : action.getBreakpoints()) {
                Location location = breakpoint.getLocation();
                this.library.setBreakpoint(location.getTarget(), location.getLineNumber());
                this.debuggerCallback.onEvent((DebuggerEvent)new BreakpointActivatedEventImpl(breakpoint));
            }
            this.library.backtrace();
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
            throw e;
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Start error. " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void stepOver(StepOverAction action) throws DebuggerException {
        try {
            this.library.next();
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Step over error. " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void stepInto(StepIntoAction action) throws DebuggerException {
        try {
            this.library.stepIn();
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Step into error. " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void stepOut(StepOutAction action) throws DebuggerException {
        try {
            this.library.stepOut();
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Step out error. " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void resume(ResumeAction action) throws DebuggerException {
        try {
            this.library.cont();
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Resume error. " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void setValue(Variable variable) throws DebuggerException {
        try {
            List path = variable.getVariablePath().getPath();
            if (path.isEmpty()) {
                throw new DebuggerException("Variable path is empty");
            }
            this.library.setVar((String)path.get(0), variable.getValue().getString());
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
            throw e;
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Can't set value for " + variable.getName() + ". " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public SimpleValue getValue(VariablePath variablePath) throws DebuggerException {
        try {
            List path = variablePath.getPath();
            if (path.isEmpty()) {
                throw new DebuggerException("Variable path is empty");
            }
            return new SimpleValueImpl(Collections.emptyList(), this.library.getVar((String)path.get(0)));
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
            throw e;
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Can't get value for " + variablePath + ". " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public String evaluate(String expression) throws DebuggerException {
        try {
            return this.library.evaluate(expression);
        }
        catch (NodeJsDebuggerTerminatedException e) {
            this.disconnect();
            throw e;
        }
        catch (NodeJsDebuggerException e) {
            throw new DebuggerException("Can't evaluate '" + expression + "'. " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public StackFrameDump dumpStackFrame() throws DebuggerException {
        return new StackFrameDumpImpl(Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public boolean onOutputProduced(NodeJsOutput nodeJsOutput) throws NodeJsDebuggerException {
        if (NodeJsStepParser.INSTANCE.match(nodeJsOutput)) {
            SuspendEventImpl suspendEvent = new SuspendEventImpl(NodeJsStepParser.INSTANCE.parse(nodeJsOutput), SuspendPolicy.ALL);
            this.debuggerCallback.onEvent((DebuggerEvent)suspendEvent);
        } else if (NodeJsBackTraceParser.INSTANCE.match(nodeJsOutput)) {
            SuspendEventImpl suspendEvent = new SuspendEventImpl(NodeJsBackTraceParser.INSTANCE.parse(nodeJsOutput), SuspendPolicy.ALL);
            this.debuggerCallback.onEvent((DebuggerEvent)suspendEvent);
        } else if ("_DEBUG_TIMED_OUT_".equals(nodeJsOutput.getOutput())) {
            this.disconnect();
        } else {
            return false;
        }
        return true;
    }
}

