/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.nodejsdbg.server.command;

import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Future;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsDebugProcess;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsOutput;
import org.eclipse.che.plugin.nodejsdbg.server.command.NodeJsDebugCommand;
import org.eclipse.che.plugin.nodejsdbg.server.exception.NodeJsDebuggerException;
import org.eclipse.che.plugin.nodejsdbg.server.exception.NodeJsDebuggerParseException;
import org.eclipse.che.plugin.nodejsdbg.server.parser.NodeJsOutputParser;

public class NodeJsDebugCommandImpl<T>
implements NodeJsDebugCommand<T> {
    private final SettableFuture<T> result;
    public final NodeJsOutputParser<T> parser;
    private final String input;

    public NodeJsDebugCommandImpl(NodeJsOutputParser<T> parser, String input) {
        this.parser = parser;
        this.input = input;
        this.result = SettableFuture.create();
    }

    @Override
    public Future<T> execute(NodeJsDebugProcess process) throws NodeJsDebuggerException {
        process.send(this.input);
        return this.result;
    }

    @Override
    public boolean onOutputProduced(NodeJsOutput nodeJsOutput) throws NodeJsDebuggerParseException {
        if (this.parser.match(nodeJsOutput)) {
            T t = this.parser.parse(nodeJsOutput);
            return this.result.set(t);
        }
        return false;
    }
}

