/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.nodejsdbg.server;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.che.commons.lang.IoUtil;
import org.eclipse.che.commons.lang.concurrent.LoggingUncaughtExceptionHandler;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsOutput;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsProcessObservable;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsProcessObserver;
import org.eclipse.che.plugin.nodejsdbg.server.OutputReader;
import org.eclipse.che.plugin.nodejsdbg.server.exception.NodeJsDebuggerException;
import org.eclipse.che.plugin.nodejsdbg.server.exception.NodeJsDebuggerTerminatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJsDebugProcess
implements NodeJsProcessObservable {
    private static final Logger LOG = LoggerFactory.getLogger(NodeJsDebugProcess.class);
    private static final String NODEJS_COMMAND = NodeJsDebugProcess.detectNodeJsCommand();
    private final Process process;
    private final String outputSeparator;
    private final ScheduledExecutorService executor;
    private final BufferedWriter processWriter;
    private final List<NodeJsProcessObserver> observers = new CopyOnWriteArrayList<NodeJsProcessObserver>();

    private NodeJsDebugProcess(String outputSeparator, String ... options) throws NodeJsDebuggerException {
        this.outputSeparator = outputSeparator;
        this.process = this.initializeNodeJsDebugProcess(options);
        this.processWriter = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
        this.executor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("nodejs-debugger-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)LoggingUncaughtExceptionHandler.getInstance()).setDaemon(true).build());
        OutputReader outputReader = new OutputReader(this.process, outputSeparator, this::notifyObservers);
        this.executor.scheduleWithFixedDelay(outputReader, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    public static NodeJsDebugProcess start(String file) throws NodeJsDebuggerException {
        return new NodeJsDebugProcess("debug> ", "inspect", "--inspect-brk", file);
    }

    private Process initializeNodeJsDebugProcess(String[] options) throws NodeJsDebuggerException {
        ArrayList<String> commands = new ArrayList<String>(1 + options.length);
        commands.add(NODEJS_COMMAND);
        commands.addAll(Arrays.asList(options));
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        try {
            return processBuilder.start();
        }
        catch (IOException e) {
            throw new NodeJsDebuggerException("NodeJs process initialization failed.", e);
        }
    }

    public void stop() {
        boolean interrupted;
        block13: {
            block12: {
                interrupted = false;
                this.observers.clear();
                try {
                    this.send("quit");
                }
                catch (NodeJsDebuggerException e) {
                    LOG.warn("Failed to execute 'quit' command. " + e.getMessage());
                }
                try {
                    this.processWriter.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.executor.shutdown();
                try {
                    if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                        this.executor.shutdownNow();
                        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                            LOG.error("Unable to terminate pool of NodeJs debugger tasks.");
                        }
                    }
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    if (this.executor.isShutdown()) break block12;
                    LOG.error("Unable to terminate pool of NodeJs debugger tasks.");
                }
            }
            this.process.destroy();
            try {
                if (!this.process.waitFor(10L, TimeUnit.SECONDS)) {
                    LOG.error("Unable to terminate NodeJs process.");
                }
            }
            catch (InterruptedException e) {
                interrupted = true;
                if (this.process.isAlive()) break block13;
                LOG.error("Unable to terminate NodeJs process.");
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void send(String command) throws NodeJsDebuggerException {
        LOG.debug("Execute: {}", (Object)command);
        if (!this.process.isAlive()) {
            throw new NodeJsDebuggerTerminatedException("NodeJs process has been terminated.");
        }
        try {
            this.processWriter.write(command);
            this.processWriter.newLine();
            this.processWriter.flush();
        }
        catch (IOException e) {
            throw new NodeJsDebuggerException(e.getMessage(), e);
        }
    }

    private static String detectNodeJsCommand() {
        String detectionCommand = "if command -v nodejs >/dev/null 2>&1; then echo -n 'nodejs'; else echo -n 'node'; fi";
        ProcessBuilder builder = new ProcessBuilder("sh", "-c", detectionCommand);
        try {
            Process process = builder.start();
            int resultCode = process.waitFor();
            if (resultCode != 0) {
                String errMsg = IoUtil.readAndCloseQuietly((InputStream)process.getErrorStream());
                throw new IllegalStateException("NodeJs not found. " + errMsg);
            }
            return IoUtil.readAndCloseQuietly((InputStream)process.getInputStream());
        }
        catch (IOException | InterruptedException e) {
            throw new IllegalStateException("NodeJs not found", e);
        }
    }

    private void notifyObservers(NodeJsOutput nodeJsOutput) {
        LOG.debug("{}{}", (Object)this.outputSeparator, (Object)nodeJsOutput.getOutput());
        if ("_CONNECTIVITY_TEST_NEEDED_".equals(nodeJsOutput.getOutput())) {
            this.testConnectivity();
            return;
        }
        for (NodeJsProcessObserver observer : this.observers) {
            try {
                if (!observer.onOutputProduced(nodeJsOutput)) continue;
                break;
            }
            catch (NodeJsDebuggerException e) {
                LOG.error(e.getMessage(), (Throwable)((Object)e));
            }
        }
    }

    private void testConnectivity() {
        try {
            this.send("version");
        }
        catch (NodeJsDebuggerException nodeJsDebuggerException) {
            // empty catch block
        }
    }

    @Override
    public void addObserver(NodeJsProcessObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(NodeJsProcessObserver observer) {
        this.observers.remove(observer);
    }
}

