/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.nodejsdbg.server.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.che.api.debug.shared.model.Location;
import org.eclipse.che.api.debug.shared.model.impl.LocationImpl;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsOutput;
import org.eclipse.che.plugin.nodejsdbg.server.exception.NodeJsDebuggerParseException;
import org.eclipse.che.plugin.nodejsdbg.server.parser.NodeJsOutputParser;

public class NodeJsBackTraceParser
implements NodeJsOutputParser<Location> {
    public static final NodeJsBackTraceParser INSTANCE = new NodeJsBackTraceParser();
    public static final Pattern PATTERN = Pattern.compile("#0(.*) (.*):(.*):(.*)");

    private NodeJsBackTraceParser() {
    }

    @Override
    public boolean match(NodeJsOutput nodeJsOutput) {
        return nodeJsOutput.getOutput().startsWith("#0");
    }

    @Override
    public Location parse(NodeJsOutput nodeJsOutput) throws NodeJsDebuggerParseException {
        String output = nodeJsOutput.getOutput();
        for (String line : output.split("\n")) {
            Matcher matcher = PATTERN.matcher(line);
            if (!matcher.find()) continue;
            String file = matcher.group(2);
            String lineNumber = matcher.group(3);
            return new LocationImpl(file, Integer.parseInt(lineNumber));
        }
        throw new NodeJsDebuggerParseException(Location.class, output);
    }
}

