/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.nodejsdbg.server.parser;

import java.util.regex.Pattern;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsOutput;
import org.eclipse.che.plugin.nodejsdbg.server.exception.NodeJsDebuggerParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface NodeJsOutputParser<T> {
    public static final NodeJsOutputParser<String> DEFAULT = new NodeJsOutputParser<String>(){

        @Override
        public boolean match(NodeJsOutput nodeJsOutput) {
            return true;
        }

        @Override
        public String parse(NodeJsOutput nodeJsOutput) throws NodeJsDebuggerParseException {
            return nodeJsOutput.getOutput();
        }
    };
    public static final NodeJsOutputParser<Void> VOID = new NodeJsOutputParser<Void>(){

        @Override
        public boolean match(NodeJsOutput nodeJsOutput) {
            return true;
        }

        @Override
        public Void parse(NodeJsOutput nodeJsOutput) throws NodeJsDebuggerParseException {
            return null;
        }
    };

    public boolean match(NodeJsOutput var1);

    public T parse(NodeJsOutput var1) throws NodeJsDebuggerParseException;

    public static class NodeJsOutputRegExpParser
    implements NodeJsOutputParser<String> {
        private static final Logger LOG = LoggerFactory.getLogger(NodeJsOutputRegExpParser.class);
        private final Pattern pattern;

        public NodeJsOutputRegExpParser(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean match(NodeJsOutput nodeJsOutput) {
            return this.pattern.matcher(nodeJsOutput.getOutput()).find();
        }

        @Override
        public String parse(NodeJsOutput nodeJsOutput) throws NodeJsDebuggerParseException {
            LOG.debug("{} parse {}", (Object)this.pattern.pattern(), (Object)nodeJsOutput.getOutput());
            return nodeJsOutput.getOutput();
        }
    }
}

