/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.nodejsdbg.server.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.che.api.debug.shared.model.Breakpoint;
import org.eclipse.che.api.debug.shared.model.Location;
import org.eclipse.che.api.debug.shared.model.impl.BreakpointImpl;
import org.eclipse.che.api.debug.shared.model.impl.LocationImpl;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsOutput;
import org.eclipse.che.plugin.nodejsdbg.server.parser.NodeJsOutputParser;

public class NodeJsBreakpointsParser
implements NodeJsOutputParser<Breakpoints> {
    public static final NodeJsBreakpointsParser INSTANCE = new NodeJsBreakpointsParser();
    public static final String NO_BREAKPOINTS_MESSAGE = "No breakpoints yet";

    @Override
    public boolean match(NodeJsOutput nodeJsOutput) {
        String output = nodeJsOutput.getOutput();
        return output.startsWith("#0 ") || output.equals(NO_BREAKPOINTS_MESSAGE);
    }

    @Override
    public Breakpoints parse(NodeJsOutput nodeJsOutput) {
        ArrayList<BreakpointImpl> breakpoints = new ArrayList<BreakpointImpl>();
        if (!nodeJsOutput.getOutput().equals(NO_BREAKPOINTS_MESSAGE)) {
            for (String item : nodeJsOutput.getOutput().split("\n")) {
                breakpoints.add(new BreakpointImpl((Location)new LocationImpl(item.substring(item.indexOf(" ") + 1, item.indexOf(":")), Integer.valueOf(item.substring(item.indexOf(":") + 1)).intValue())));
            }
        }
        return new Breakpoints(breakpoints);
    }

    public static class Breakpoints {
        private final List<Breakpoint> breakpoints;

        private Breakpoints(List<Breakpoint> breakpoints) {
            this.breakpoints = breakpoints;
        }

        public List<Breakpoint> getAll() {
            return this.breakpoints;
        }
    }
}

