/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.nodejsdbg.server;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.che.plugin.nodejsdbg.server.NodeJsOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputReader
implements Runnable {
    public static final String CONNECTIVITY_TEST_NEEDED_MSG = "_CONNECTIVITY_TEST_NEEDED_";
    public static final String DEBUG_TIMED_OUT_MSG = "_DEBUG_TIMED_OUT_";
    public static final int CONNECTIVITY_TEST_NEEDED = 10;
    public static final int DEBUG_TIMED_OUT = 20;
    private static final Logger LOG = LoggerFactory.getLogger(OutputReader.class);
    private static final int MAX_OUTPUT = 4096;
    private final StringBuffer outputBuffer;
    private final Process process;
    private final String outputSeparator;
    private final ProcessCallback callback;
    private int noResponseTimes;

    public OutputReader(Process process, String outputSeparator, ProcessCallback callback) {
        this.process = process;
        this.outputBuffer = new StringBuffer();
        this.outputSeparator = outputSeparator;
        this.callback = callback;
    }

    @Override
    public void run() {
        try {
            InputStream in = this.getInputStream();
            if (in != null) {
                this.noResponseTimes = 0;
                this.proceedResponse(in);
            } else {
                ++this.noResponseTimes;
                this.checkConnectivityState();
            }
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void proceedResponse(InputStream in) throws IOException {
        String outputData = this.read(in);
        if (!outputData.isEmpty()) {
            this.outputBuffer.append(outputData);
            if (this.outputBuffer.length() > 4096) {
                this.outputBuffer.delete(0, this.outputBuffer.length() - 4096);
            }
            this.extractOutputs();
        }
    }

    private String read(InputStream in) throws IOException {
        int available = Math.min(in.available(), 4096);
        byte[] buf = new byte[available];
        int read = in.read(buf, 0, available);
        return new String(buf, 0, read, StandardCharsets.UTF_8);
    }

    private InputStream getInputStream() throws IOException {
        return this.hasError() ? this.process.getErrorStream() : (this.hasInput() ? (this.hasError() ? this.process.getErrorStream() : this.process.getInputStream()) : null);
    }

    private void extractOutputs() {
        int indexOf;
        while ((indexOf = this.outputBuffer.indexOf(this.outputSeparator)) >= 0) {
            NodeJsOutput nodeJsOutput = NodeJsOutput.of(this.outputBuffer.substring(0, indexOf));
            this.outputBuffer.delete(0, indexOf + this.outputSeparator.length());
            this.callback.onOutputProduced(nodeJsOutput);
        }
    }

    private boolean hasError() throws IOException {
        return this.process.getErrorStream().available() != 0;
    }

    private boolean hasInput() throws IOException {
        return this.process.getInputStream().available() != 0;
    }

    private void checkConnectivityState() {
        if (this.noResponseTimes == 10) {
            this.callback.onOutputProduced(NodeJsOutput.of(CONNECTIVITY_TEST_NEEDED_MSG));
        } else if (this.noResponseTimes == 20) {
            this.callback.onOutputProduced(NodeJsOutput.of(DEBUG_TIMED_OUT_MSG));
        }
    }

    public static interface ProcessCallback {
        public void onOutputProduced(NodeJsOutput var1);
    }
}

