/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.pullrequest.server;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.eclipse.che.api.core.BadRequestException;
import org.eclipse.che.api.core.ConflictException;
import org.eclipse.che.api.core.ForbiddenException;
import org.eclipse.che.api.core.NotFoundException;
import org.eclipse.che.api.core.ServerException;
import org.eclipse.che.api.core.model.workspace.config.ProjectConfig;
import org.eclipse.che.api.core.notification.EventService;
import org.eclipse.che.api.core.notification.EventSubscriber;
import org.eclipse.che.api.git.shared.event.GitRepositoryDeletedEvent;
import org.eclipse.che.api.project.server.ProjectManager;
import org.eclipse.che.api.project.server.impl.NewProjectConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ContributionProjectTypeCleaner
implements EventSubscriber<GitRepositoryDeletedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ContributionProjectTypeCleaner.class);
    private EventService eventService;
    private Provider<ProjectManager> projectManagerProvider;

    @Inject
    public ContributionProjectTypeCleaner(EventService eventService, Provider<ProjectManager> projectManagerProvider) {
        this.eventService = eventService;
        this.projectManagerProvider = projectManagerProvider;
    }

    @PostConstruct
    private void subscribe() {
        this.eventService.subscribe((EventSubscriber)this);
    }

    @PreDestroy
    private void unsubscribe() {
        this.eventService.unsubscribe((EventSubscriber)this);
    }

    private void onGitRepositoryDeletedEventReceived(String projectPath) {
        try {
            ProjectManager projectManager = (ProjectManager)this.projectManagerProvider.get();
            projectManager.removeType(projectPath, "pullrequest");
            ProjectConfig project = (ProjectConfig)projectManager.get(projectPath).get();
            Map attributes = project.getAttributes();
            attributes.remove("local_branch");
            attributes.remove("contribute_to_branch");
            NewProjectConfigImpl projectConfig = new NewProjectConfigImpl(project.getPath(), project.getType(), project.getMixins(), project.getName(), project.getDescription(), attributes, null, project.getSource());
            projectManager.update((ProjectConfig)projectConfig);
        }
        catch (NotFoundException e) {
            LOG.error("Project {} not found for removing {} type", new Object[]{projectPath, "pullrequest", e});
        }
        catch (ServerException e) {
            LOG.error("Exception occurred during removing {} project type for project ", new Object[]{"pullrequest", projectPath, e});
        }
        catch (BadRequestException | ConflictException | ForbiddenException ignore) {
            LOG.warn("Usually should not occur. But exception occurred during removing {} project type", (Object)"pullrequest", (Object)ignore);
        }
    }

    public void onEvent(GitRepositoryDeletedEvent event) {
        this.onGitRepositoryDeletedEventReceived(event.getProjectPath());
    }
}

