/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.python.languageserver;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.che.api.languageserver.DefaultInstanceProvider;
import org.eclipse.che.api.languageserver.LanguageServerConfig;
import org.eclipse.che.api.languageserver.ProcessCommunicationProvider;
import org.eclipse.che.plugin.python.shared.ProjectAttributes;

@Singleton
public class PythonLanguageSeverConfig
implements LanguageServerConfig {
    private static final String REGEX = ".*\\.py";
    private final Path launchScript = Paths.get(System.getenv("HOME"), "che/ls-python/launch.sh");

    @Inject
    public PythonLanguageSeverConfig() {
    }

    public LanguageServerConfig.RegexProvider getRegexpProvider() {
        return new LanguageServerConfig.RegexProvider(){

            public Map<String, String> getLanguageRegexes() {
                return ImmutableMap.of((Object)ProjectAttributes.PYTHON_ID, (Object)PythonLanguageSeverConfig.REGEX);
            }

            public Set<String> getFileWatchPatterns() {
                return ImmutableSet.of();
            }
        };
    }

    public LanguageServerConfig.CommunicationProvider getCommunicationProvider() {
        ProcessBuilder processBuilder = new ProcessBuilder(this.launchScript.toString());
        processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE);
        processBuilder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        return new ProcessCommunicationProvider(processBuilder, ProjectAttributes.PYTHON_ID);
    }

    public LanguageServerConfig.InstanceProvider getInstanceProvider() {
        return DefaultInstanceProvider.getInstance();
    }

    public LanguageServerConfig.InstallerStatusProvider getInstallerStatusProvider() {
        return new LanguageServerConfig.InstallerStatusProvider(){

            public boolean isSuccessfullyInstalled() {
                return PythonLanguageSeverConfig.this.launchScript.toFile().exists();
            }

            public String getCause() {
                return this.isSuccessfullyInstalled() ? null : "Launch script file does not exist";
            }
        };
    }
}

