/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.testing;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.eclipse.che.api.testing.server.framework.TestRunner;
import org.eclipse.che.api.testing.shared.TestDetectionContext;
import org.eclipse.che.api.testing.shared.TestExecutionContext;
import org.eclipse.che.api.testing.shared.TestPosition;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.plugin.java.testing.JavaTestFinder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaTestRunner
implements TestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJavaTestRunner.class);
    private static final String TEST_OUTPUT_FOLDER = "/test-output";
    private int debugPort = -1;
    private String workspacePath;
    private JavaTestFinder javaTestFinder;

    public AbstractJavaTestRunner(String workspacePath, JavaTestFinder javaTestFinder) {
        this.workspacePath = workspacePath;
        this.javaTestFinder = javaTestFinder;
    }

    public List<TestPosition> detectTests(TestDetectionContext context) {
        IJavaProject javaProject = this.getJavaProject(context.getProjectPath());
        if (javaProject == null || !javaProject.exists()) {
            return Collections.emptyList();
        }
        IProject project = javaProject.getProject();
        if (project == null || !JavaProject.hasJavaNature((IProject)project)) {
            return Collections.emptyList();
        }
        ArrayList<TestPosition> result = new ArrayList<TestPosition>();
        String filePath = context.getFilePath();
        if (filePath.endsWith(".xml")) {
            if (this.isTestSuite(filePath, javaProject)) {
                TestPosition testPosition = ((TestPosition)DtoFactory.newDto(TestPosition.class)).withFrameworkName(this.getName());
                result.add(testPosition);
            }
            return result;
        }
        try {
            ICompilationUnit compilationUnit = this.findCompilationUnitByPath(javaProject, filePath);
            if (context.getOffset() == -1) {
                this.addAllTestsMethod(result, compilationUnit);
            } else {
                IJavaElement element = compilationUnit.getElementAt(context.getOffset());
                if (element != null && element.getElementType() == 9) {
                    if (this.isTestMethod((IMethod)element, compilationUnit)) {
                        result.add(this.createTestPosition((IMethod)element));
                    }
                } else {
                    this.addAllTestsMethod(result, compilationUnit);
                }
            }
        }
        catch (JavaModelException e) {
            LOG.debug("Can't read all methods.", (Throwable)e);
        }
        return result;
    }

    private void addAllTestsMethod(List<TestPosition> result, ICompilationUnit compilationUnit) throws JavaModelException {
        for (IType type : compilationUnit.getAllTypes()) {
            for (IMethod method : type.getMethods()) {
                if (!this.isTestMethod(method, compilationUnit)) continue;
                result.add(this.createTestPosition(method));
            }
        }
    }

    private TestPosition createTestPosition(IMethod method) throws JavaModelException {
        ISourceRange nameRange = method.getNameRange();
        ISourceRange sourceRange = method.getSourceRange();
        return ((TestPosition)DtoFactory.newDto(TestPosition.class)).withFrameworkName(this.getName()).withTestName(method.getElementName()).withTestNameStartOffset(nameRange.getOffset()).withTestNameLength(nameRange.getLength()).withTestBodyLength(sourceRange.getLength());
    }

    protected abstract boolean isTestMethod(IMethod var1, ICompilationUnit var2);

    protected abstract boolean isTestSuite(String var1, IJavaProject var2);

    protected IJavaProject getJavaProject(String projectPath) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath);
        return JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject((IResource)project);
    }

    protected String getOutputDirectory(IJavaProject javaProject) {
        String path = this.workspacePath + javaProject.getPath() + TEST_OUTPUT_FOLDER;
        try {
            IClasspathEntry[] resolvedClasspath;
            for (IClasspathEntry iClasspathEntry : resolvedClasspath = javaProject.getResolvedClasspath(true)) {
                IPath outputLocation;
                if (iClasspathEntry.getEntryKind() != 3 || (outputLocation = iClasspathEntry.getOutputLocation()) == null) continue;
                return this.workspacePath + outputLocation.removeLastSegments(1).append(TEST_OUTPUT_FOLDER);
            }
        }
        catch (JavaModelException e) {
            return path;
        }
        return path;
    }

    private ICompilationUnit findCompilationUnitByPath(IJavaProject javaProject, String filePath) {
        try {
            String pathToClass;
            IJavaElement element;
            IClasspathEntry[] resolvedClasspath = javaProject.getResolvedClasspath(false);
            IPath packageRootPath = null;
            for (IClasspathEntry classpathEntry : resolvedClasspath) {
                if (!filePath.startsWith(classpathEntry.getPath().toOSString())) continue;
                packageRootPath = classpathEntry.getPath();
                break;
            }
            if (packageRootPath == null) {
                throw this.getRuntimeException(filePath);
            }
            String packagePath = packageRootPath.toOSString();
            if (!packagePath.endsWith("/")) {
                packagePath = packagePath + '/';
            }
            if ((element = javaProject.findElement((IPath)new Path(pathToClass = filePath.substring(packagePath.length())))) != null && element.getElementType() == 5) {
                return (ICompilationUnit)element;
            }
            throw this.getRuntimeException(filePath);
        }
        catch (JavaModelException e) {
            throw new RuntimeException("Can't find Compilation Unit.", e);
        }
    }

    protected List<String> findTests(TestExecutionContext context, IJavaProject javaProject, String methodAnnotation, String classAnnotation) {
        switch (context.getContextType()) {
            case FILE: {
                return this.javaTestFinder.findTestClassDeclaration(this.findCompilationUnitByPath(javaProject, context.getFilePath()));
            }
            case FOLDER: {
                return this.javaTestFinder.findClassesInPackage(javaProject, context.getFilePath(), methodAnnotation, classAnnotation);
            }
            case SET: {
                return this.convertClassesPathsToFqns(context.getListOfTestClasses(), javaProject);
            }
            case PROJECT: {
                return this.javaTestFinder.findClassesInProject(javaProject, methodAnnotation, classAnnotation);
            }
            case CURSOR_POSITION: {
                return this.javaTestFinder.findTestMethodDeclaration(this.findCompilationUnitByPath(javaProject, context.getFilePath()), context.getCursorOffset());
            }
        }
        return Collections.emptyList();
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    protected void generateDebuggerPort() {
        Random random = new Random();
        int port = random.nextInt(65535);
        if (AbstractJavaTestRunner.isPortAvailable(port)) {
            this.debugPort = port;
        } else {
            this.generateDebuggerPort();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPortAvailable(int port) {
        try (Socket ignored = new Socket("localhost", port);){
            boolean bl = false;
            return bl;
        }
        catch (IOException ignored2) {
            return true;
        }
    }

    private RuntimeException getRuntimeException(String filePath) {
        return new RuntimeException("Can't find IClasspathEntry for path " + filePath);
    }

    private List<String> convertClassesPathsToFqns(List<String> testClasses, IJavaProject javaProject) {
        if (testClasses == null) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        for (String classPath : testClasses) {
            ICompilationUnit compilationUnit = this.findCompilationUnitByPath(javaProject, classPath);
            if (compilationUnit == null) continue;
            IType primaryType = compilationUnit.findPrimaryType();
            result.add(primaryType.getFullyQualifiedName());
        }
        return result;
    }
}

