/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.testing;

import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchRequestor;

public class AnnotationSearchRequestor
extends SearchRequestor {
    private final Collection<IType> fResult;
    private final ITypeHierarchy fHierarchy;

    AnnotationSearchRequestor(ITypeHierarchy hierarchy, Collection<IType> result) {
        this.fHierarchy = hierarchy;
        this.fResult = result;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        Object element;
        if (match.getAccuracy() == 0 && !match.isInsideDocComment() && ((element = match.getElement()) instanceof IType || element instanceof IMethod)) {
            IMember member = (IMember)element;
            IType type = member.getElementType() == 7 ? (IType)member : member.getDeclaringType();
            this.addTypeAndSubtypes(type);
        }
    }

    private void addTypeAndSubtypes(IType type) {
        if (this.fResult.add(type)) {
            IType[] subclasses;
            for (IType subclass : subclasses = this.fHierarchy.getSubclasses(type)) {
                this.addTypeAndSubtypes(subclass);
            }
        }
    }
}

