/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.testing;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.CodeSource;

public class ClasspathUtil {
    public static String getJarPathForClass(Class<?> clazz) {
        try {
            File jarFile;
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource.getLocation() != null) {
                jarFile = new File(codeSource.getLocation().toURI());
            } else {
                String path = clazz.getResource(clazz.getSimpleName() + ".class").getPath();
                String jarFilePath = path.substring(path.indexOf(":") + 1, path.indexOf("!"));
                jarFilePath = URLDecoder.decode(jarFilePath, "UTF-8");
                jarFile = new File(jarFilePath);
            }
            return jarFile.getAbsolutePath();
        }
        catch (UnsupportedEncodingException | URISyntaxException exception) {
            return null;
        }
    }
}

