/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.testing;

import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class JavaTestAnnotations {
    public static final JavaTestAnnotations TESTNG_TEST = new JavaTestAnnotations("org.testng.annotations.Test");
    public static final JavaTestAnnotations JUNIT4X_RUN_WITH = new JavaTestAnnotations("org.junit.runner.RunWith");
    public static final JavaTestAnnotations JUNIT4X_TEST = new JavaTestAnnotations("org.junit.Test");
    private final String fName;

    private JavaTestAnnotations(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    private boolean annotates(IAnnotationBinding[] annotations) {
        for (IAnnotationBinding annotation : annotations) {
            ITypeBinding annotationType = annotation.getAnnotationType();
            if (annotationType == null || !annotationType.getQualifiedName().equals(this.fName)) continue;
            return true;
        }
        return false;
    }

    public boolean annotatesTypeOrSuperTypes(ITypeBinding type) {
        while (type != null) {
            if (this.annotates(type.getAnnotations())) {
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean annotatesAtLeastOneMethod(ITypeBinding type) {
        while (type != null) {
            IMethodBinding[] declaredMethods = type.getDeclaredMethods();
            for (int i = 0; i < declaredMethods.length; ++i) {
                IMethodBinding curr = declaredMethods[i];
                if (!this.annotates(curr.getAnnotations())) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }
}

