/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.testing;

import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.che.plugin.java.testing.AnnotationSearchRequestor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JavaTestFinder {
    private static final Logger LOG = LoggerFactory.getLogger(JavaTestFinder.class);

    public List<String> findTestMethodDeclaration(ICompilationUnit compilationUnit, int cursorOffset) {
        IType primaryType = compilationUnit.findPrimaryType();
        String qualifiedName = primaryType.getFullyQualifiedName();
        try {
            IJavaElement element = compilationUnit.getElementAt(cursorOffset);
            if (element instanceof IMethod) {
                IMethod method = (IMethod)element;
                qualifiedName = qualifiedName + '#' + method.getElementName();
            }
        }
        catch (JavaModelException e) {
            LOG.debug("Can't read a method.", (Throwable)e);
        }
        return Collections.singletonList(qualifiedName);
    }

    public List<String> findTestClassDeclaration(ICompilationUnit compilationUnit) {
        IType primaryType = compilationUnit.findPrimaryType();
        return Collections.singletonList(primaryType.getFullyQualifiedName());
    }

    public List<String> findClassesInPackage(IJavaProject javaProject, String packagePath, String testMethodAnnotation, String testClassAnnotation) {
        IPackageFragment packageFragment = null;
        try {
            packageFragment = javaProject.findPackageFragment((IPath)new Path(packagePath));
        }
        catch (JavaModelException e) {
            LOG.info("Can't find package.", (Throwable)e);
        }
        return packageFragment == null ? Collections.emptyList() : this.findClassesInContainer((IJavaElement)packageFragment, testMethodAnnotation, testClassAnnotation);
    }

    public List<String> findClassesInProject(IJavaProject project, String testMethodAnnotation, String testClassAnnotation) {
        return this.findClassesInContainer((IJavaElement)project, testMethodAnnotation, testClassAnnotation);
    }

    public boolean isTest(IMethod method, ICompilationUnit compilationUnit, String testAnnotation) {
        try {
            IAnnotation[] annotations = method.getAnnotations();
            IAnnotation test = null;
            for (IAnnotation annotation : annotations) {
                String annotationElementName = annotation.getElementName();
                if ("Test".equals(annotationElementName)) {
                    test = annotation;
                    break;
                }
                if (!testAnnotation.equals(annotationElementName)) continue;
                return true;
            }
            return test != null && this.isImportOfTestAnnotationExist(compilationUnit, testAnnotation);
        }
        catch (JavaModelException e) {
            LOG.info("Can't read method's annotations.", (Throwable)e);
            return false;
        }
    }

    private boolean isImportOfTestAnnotationExist(ICompilationUnit compilationUnit, String testAnnotation) {
        try {
            IImportDeclaration[] imports;
            for (IImportDeclaration importDeclaration : imports = compilationUnit.getImports()) {
                String elementName = importDeclaration.getElementName();
                if (testAnnotation.equals(elementName)) {
                    return true;
                }
                if (!importDeclaration.isOnDemand() || !testAnnotation.startsWith(elementName.substring(0, elementName.length() - 3))) continue;
                return true;
            }
        }
        catch (JavaModelException e) {
            LOG.info("Can't read class imports.", (Throwable)e);
            return false;
        }
        return false;
    }

    private List<String> findClassesInContainer(IJavaElement container, String testMethodAnnotation, String testClassAnnotation) {
        LinkedList<String> result = new LinkedList<String>();
        IRegion region = this.getRegion(container);
        try {
            ITypeHierarchy hierarchy = JavaCore.newTypeHierarchy((IRegion)region, null, null);
            IType[] allClasses = hierarchy.getAllClasses();
            HashSet<IType> candidates = new HashSet<IType>(allClasses.length);
            AnnotationSearchRequestor requestor = new AnnotationSearchRequestor(hierarchy, candidates);
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])allClasses, (int)1);
            int matchRule = 8;
            SearchPattern testPattern = SearchPattern.createPattern((String)testMethodAnnotation, (int)8, (int)65536, (int)matchRule);
            SearchPattern runWithPattern = Strings.isNullOrEmpty((String)testClassAnnotation) ? testPattern : SearchPattern.createPattern((String)testClassAnnotation, (int)8, (int)65536, (int)matchRule);
            SearchPattern annotationsPattern = SearchPattern.createOrPattern((SearchPattern)runWithPattern, (SearchPattern)testPattern);
            SearchParticipant[] searchParticipants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            new SearchEngine().search(annotationsPattern, searchParticipants, scope, (SearchRequestor)requestor, null);
            for (IType candidate : candidates) {
                if (!JavaTestFinder.isAccessibleClass(candidate) || Flags.isAbstract((int)candidate.getFlags()) || !region.contains((IJavaElement)candidate)) continue;
                result.add(candidate.getFullyQualifiedName());
            }
        }
        catch (CoreException e) {
            LOG.info("Can't build project hierarchy.", (Throwable)e);
        }
        return result;
    }

    private IRegion getRegion(IJavaElement element) {
        IRegion result = JavaCore.newRegion();
        if (element.getElementType() == 2) {
            try {
                IPackageFragmentRoot[] packageFragmentRoots;
                for (IPackageFragmentRoot packageFragmentRoot : packageFragmentRoots = ((IJavaProject)element).getPackageFragmentRoots()) {
                    if (packageFragmentRoot.isArchive()) continue;
                    result.add((IJavaElement)packageFragmentRoot);
                }
            }
            catch (JavaModelException e) {
                LOG.info("Can't read source folders.", (Throwable)e);
            }
        } else {
            result.add(element);
        }
        return result;
    }

    private static boolean isAccessibleClass(IType type) throws JavaModelException {
        int flags = type.getFlags();
        if (Flags.isInterface((int)flags)) {
            return false;
        }
        IJavaElement parent = type.getParent();
        while (!(parent instanceof ICompilationUnit) && !(parent instanceof IClassFile)) {
            if (!(parent instanceof IType && Flags.isStatic((int)flags) && Flags.isPublic((int)flags))) {
                return false;
            }
            flags = ((IType)parent).getFlags();
            parent = parent.getParent();
        }
        return true;
    }
}

