/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.java.testing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.che.api.project.server.impl.RootDirPathProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProjectClasspathProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectClasspathProvider.class);
    private final String workspacePath;

    @Inject
    public ProjectClasspathProvider(RootDirPathProvider pathProvider) {
        this.workspacePath = pathProvider.get();
    }

    public Set<String> getProjectClassPath(IJavaProject javaProject) {
        try {
            IClasspathEntry[] resolvedClasspath = javaProject.getResolvedClasspath(false);
            HashSet<String> result = new HashSet<String>();
            block7: for (IClasspathEntry classpathEntry : resolvedClasspath) {
                switch (classpathEntry.getEntryKind()) {
                    case 1: {
                        IPath path = classpathEntry.getPath();
                        result.add(path.toOSString());
                        continue block7;
                    }
                    case 3: {
                        IPath outputLocation = classpathEntry.getOutputLocation();
                        if (outputLocation == null) continue block7;
                        result.add(this.workspacePath + outputLocation.toOSString());
                        continue block7;
                    }
                    case 2: {
                        IPath projectPath = classpathEntry.getPath();
                        JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
                        IJavaProject project = javaModel.getJavaProject(projectPath.toOSString());
                        result.addAll(this.getProjectClassPath(project));
                    }
                }
            }
            return result;
        }
        catch (JavaModelException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            return Collections.emptySet();
        }
    }
}

