/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.testing.phpunit.server;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTestCase;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTestException;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTestRoot;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTestSuite;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTestWarning;

public class PHPUnitMessageParser {
    public static final String CALL_DYNAMIC = "->";
    public static final String CALL_STATIC = "::";
    private static final String ELEMENT_EVENT = "event";
    private static final String ELEMENT_EXCEPTION = "exception";
    private static final String ELEMENT_TARGET_TESTSUITE = "testsuite";
    private static final String ELEMENT_TARGET_TESTCASE = "testcase";
    private static final String ELEMENT_TEST = "test";
    private static final String ELEMENT_WARNINGS = "warnings";
    public static final String PROPERTY_CLASS = "class";
    public static final String PROPERTY_CODE = "code";
    public static final String PROPERTY_COUNT = "tests";
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_FILTERED = "filtered";
    public static final String PROPERTY_LINE = "line";
    public static final String PROPERTY_MESSAGE = "message";
    public static final String PROPERTY_DIFF = "diff";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_TIME = "time";
    public static final String PROPERTY_TARGET = "target";
    public static final String PROPERTY_TRACE = "trace";
    public static final String STATUS_ERROR = "error";
    public static final String STATUS_WARNING = "warning";
    public static final String STATUS_FAIL = "fail";
    public static final String STATUS_INCOMPLETE = "incomplete";
    public static final String STATUS_PASS = "pass";
    public static final String STATUS_SKIP = "skip";
    public static final String TAG_END = "end";
    public static final String TAG_START = "start";
    private PHPUnitTestSuite currentGroup;
    private PHPUnitTestCase currentTestCase;

    public PHPUnitMessageParser(PHPUnitTestRoot testRoot) {
        this.currentGroup = testRoot;
    }

    public void parse(Map<?, ?> message) {
        if (message == null) {
            return;
        }
        String target = (String)message.get(PROPERTY_TARGET);
        String event = (String)message.get(ELEMENT_EVENT);
        Map mTest = (Map)message.get(ELEMENT_TEST);
        if (target.equals(ELEMENT_TARGET_TESTSUITE)) {
            this.parseGroupStart(event, mTest);
            if (event.equals(TAG_END)) {
                this.parseGroupEnd();
            }
        } else if (target.equals(ELEMENT_TARGET_TESTCASE)) {
            if (event.equals(TAG_START)) {
                this.parseTestStart(event, mTest);
            } else {
                this.parseTestEnd(message, event, mTest);
            }
        }
    }

    private void parseGroupStart(String event, Map<?, ?> mTest) {
        if (event.equals(TAG_START)) {
            PHPUnitTestSuite group = new PHPUnitTestSuite(mTest, this.currentGroup);
            this.currentGroup.addChild(group, false);
            group.setParent(this.currentGroup);
            this.currentGroup = group;
        }
    }

    private void parseGroupEnd() {
        PHPUnitTestSuite group = this.currentGroup;
        this.currentGroup = (PHPUnitTestSuite)this.currentGroup.getParent();
        this.currentGroup.addChild(group, true);
    }

    private void parseTestStart(String event, Map<?, ?> mTest) {
        PHPUnitTestCase testCase;
        this.currentTestCase = testCase = new PHPUnitTestCase(mTest, this.currentGroup, event);
        this.currentGroup.addChild(testCase, false);
    }

    private void parseTestEnd(Map<?, ?> message, String event, Map<?, ?> mTest) {
        Map warnings;
        PHPUnitTestCase testCase = this.currentTestCase;
        testCase.updateStatus(event);
        Map exception = (Map)message.get(ELEMENT_EXCEPTION);
        if (exception != null) {
            this.parseException(testCase, exception);
        }
        if ((warnings = (Map)message.get(ELEMENT_WARNINGS)) != null) {
            this.parseWarnings(testCase, warnings);
        }
        String time = (String)message.get(PROPERTY_TIME);
        testCase.setTime(Double.valueOf(time));
        this.currentGroup.addChild(testCase, true);
    }

    private void parseException(PHPUnitTestCase testCase, Map<?, ?> exception) {
        testCase.setException(new PHPUnitTestException(exception, testCase));
    }

    private void parseWarnings(PHPUnitTestCase testCase, Map<?, ?> warnings) {
        Map mWarning;
        int i = 0;
        while ((mWarning = (Map)warnings.get(String.valueOf(i))) != null) {
            if (testCase.getWarnings() == null) {
                testCase.setWarnings(new ArrayList<PHPUnitTestWarning>(warnings.size()));
            }
            PHPUnitTestWarning warning = new PHPUnitTestWarning(mWarning, testCase);
            testCase.getWarnings().add(i, warning);
            ++i;
        }
    }
}

