/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.testing.phpunit.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.che.api.core.util.CommandLine;
import org.eclipse.che.api.testing.shared.TestExecutionContext;
import org.eclipse.che.commons.lang.execution.ProcessHandler;
import org.eclipse.che.plugin.testing.phpunit.server.PHPUnitTestRunner;
import org.eclipse.core.resources.ResourcesPlugin;

public class PHPUnitTestEngine {
    private static final String PRINTER_NAME = "ZendPHPUnitLogger";
    private static final String PRINTER_DIRECTORY = "phpunit-printer";
    private static final String PHPUNIT_GLOBAL = "phpunit";
    private static final String PHPUNIT_COMPOSER = "/vendor/bin/phpunit";
    private static final int PRINTER_PORT = 7478;
    private Path projectsRoot;

    public PHPUnitTestEngine(File projectsRoot) {
        this.projectsRoot = projectsRoot.toPath().normalize().toAbsolutePath();
    }

    public ProcessHandler executeTests(TestExecutionContext context) {
        String projectAbsolutePath;
        String projectPath = context.getProjectPath();
        String testTargetRelativePath = context.getFilePath();
        File testTargetFile = this.getTestTargetFile(testTargetRelativePath, projectAbsolutePath = ResourcesPlugin.getPathToWorkspace() + projectPath);
        File testTargetWorkingDirectory = testTargetFile.isDirectory() ? testTargetFile : testTargetFile.getParentFile();
        String phpUnitExecutable = PHPUNIT_GLOBAL;
        if (this.hasComposerRunner(projectPath)) {
            phpUnitExecutable = projectAbsolutePath + PHPUNIT_COMPOSER;
        }
        File printerFile = this.getPrinterFile();
        String printerDirAbsolutePath = printerFile.getParentFile().getAbsolutePath();
        CommandLine cmdRunTests = new CommandLine(new String[]{phpUnitExecutable, "--include-path", printerDirAbsolutePath, "--printer", PRINTER_NAME, this.getTestTarget(testTargetFile)});
        ProcessBuilder pb = new ProcessBuilder(new String[0]).redirectErrorStream(true).directory(testTargetWorkingDirectory).command(cmdRunTests.toShellCommand());
        pb.environment().put("ZEND_PHPUNIT_PORT", String.valueOf(7478));
        try {
            return new ProcessHandler(pb.start());
        }
        catch (IOException e) {
            PHPUnitTestRunner.LOG.error("Can't run PHPUnit", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getPrinterFile() {
        String phpLoggerLocation = "phpunit-printer/ZendPHPUnitLogger.php";
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File tmpPrinterFile = new File(tmpDir, "phpunit-printer/ZendPHPUnitLogger.php");
        if (!tmpPrinterFile.exists()) {
            try {
                tmpPrinterFile.getParentFile().mkdir();
                tmpPrinterFile.createNewFile();
                InputStream printerFileContent = this.getClass().getClassLoader().getResourceAsStream("phpunit-printer/ZendPHPUnitLogger.php");
                FileUtils.copyInputStreamToFile((InputStream)printerFileContent, (File)tmpPrinterFile);
            }
            catch (Exception e) {
                PHPUnitTestRunner.LOG.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (tmpPrinterFile.exists()) {
                    tmpPrinterFile.getParentFile().deleteOnExit();
                    tmpPrinterFile.deleteOnExit();
                }
            }
        }
        return tmpPrinterFile;
    }

    private File getTestTargetFile(String testTargetRelativePath, String projectAbsolutePath) {
        String[] segments = testTargetRelativePath.split("/");
        if (segments.length > 1) {
            return Paths.get(projectAbsolutePath, segments[1]).toFile();
        }
        return new File(projectAbsolutePath);
    }

    private String getTestTarget(File testTargetFile) {
        if (testTargetFile.isDirectory()) {
            if (new File(testTargetFile, "phpunit.xml").exists() || new File(testTargetFile, "phpunit.xml.dist").exists()) {
                return "";
            }
            return testTargetFile.getAbsolutePath();
        }
        return FilenameUtils.removeExtension((String)testTargetFile.getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasComposerRunner(String projectPath) {
        if (!Files.exists(this.projectsRoot.resolve(projectPath + "/composer.json"), new LinkOption[0])) {
            return false;
        }
        try (InputStream inputStream = Files.newInputStream(this.projectsRoot.resolve(projectPath + "/composer.json"), new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(inputStream);){
            Gson gson = new GsonBuilder().create();
            Map composerJsonMap = (Map)gson.fromJson((Reader)reader, LinkedTreeMap.class);
            Map requireDev = (Map)composerJsonMap.get("require-dev");
            if (requireDev != null && requireDev.get("phpunit/phpunit") != null) {
                boolean bl = true;
                return bl;
            }
            Map require = (Map)composerJsonMap.get("require");
            if (require == null) return false;
            if (require.get("phpunit/phpunit") == null) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            PHPUnitTestRunner.LOG.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

