/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.testing.phpunit.server;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.che.api.testing.shared.common.TestResultStatus;
import org.eclipse.che.api.testing.shared.common.TestResultType;
import org.eclipse.che.api.testing.shared.dto.SimpleLocationDto;
import org.eclipse.che.api.testing.shared.dto.TestResultDto;
import org.eclipse.che.api.testing.shared.dto.TestResultRootDto;
import org.eclipse.che.api.testing.shared.dto.TestResultTraceDto;
import org.eclipse.che.api.testing.shared.dto.TestResultTraceFrameDto;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.plugin.testing.phpunit.server.model.AbstractPHPUnitTestResult;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTestCase;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTestException;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTestRoot;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTestSuite;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTraceFrame;

class PHPUnitTestResultsProvider {
    private final Map<String, AbstractPHPUnitTestResult> testResultsCache = new HashMap<String, AbstractPHPUnitTestResult>();

    PHPUnitTestResultsProvider() {
    }

    public TestResultRootDto getTestResultsRoot(PHPUnitTestRoot resultsRoot) {
        TestResultRootDto testResultRootDto = (TestResultRootDto)DtoFactory.getInstance().createDto(TestResultRootDto.class);
        testResultRootDto.setTestFrameworkName("PHPUnit");
        testResultRootDto.setStatus(this.getStatus(resultsRoot.getStatus()));
        testResultRootDto.setResultPath(Collections.singletonList("php-tests-root"));
        testResultRootDto.setName(this.getRootLabel(resultsRoot.getStatus()));
        testResultRootDto.setInfoText(this.getTimeString(resultsRoot.getTime()));
        testResultRootDto.setEmpty(resultsRoot.getChildren() == null);
        this.testResultsCache.put(this.getKey(testResultRootDto.getResultPath()), resultsRoot);
        return testResultRootDto;
    }

    public List<TestResultDto> getTestResults(List<String> testResultsPath) {
        String key = this.getKey(testResultsPath);
        AbstractPHPUnitTestResult phpTestResult = this.testResultsCache.get(key);
        int testChildCounter = 0;
        ArrayList<TestResultDto> testResults = new ArrayList<TestResultDto>();
        for (AbstractPHPUnitTestResult phpChildResult : phpTestResult.getChildren()) {
            ArrayList<String> childResultsPath = new ArrayList<String>(testResultsPath);
            childResultsPath.add(String.valueOf(testChildCounter++));
            TestResultDto testResultDto = this.getTestResult(phpChildResult, childResultsPath);
            testResults.add(testResultDto);
        }
        return testResults;
    }

    private TestResultDto getTestResult(AbstractPHPUnitTestResult phpTestResult, List<String> testResultPath) {
        TestResultDto testResultDto = (TestResultDto)DtoFactory.getInstance().createDto(TestResultDto.class);
        testResultDto.setStatus(this.getStatus(phpTestResult.getStatus()));
        testResultDto.setResultPath(testResultPath);
        testResultDto.setName(phpTestResult.getName());
        testResultDto.setTrace(this.getTestTrace(phpTestResult));
        testResultDto.setInfoText(this.getTimeString(phpTestResult.getTime()));
        testResultDto.setType(phpTestResult instanceof PHPUnitTestSuite ? TestResultType.TEST_SUITE : TestResultType.TEST_CASE);
        SimpleLocationDto simpleLocationDto = (SimpleLocationDto)DtoFactory.getInstance().createDto(SimpleLocationDto.class);
        simpleLocationDto.setResourcePath(phpTestResult.getFile());
        simpleLocationDto.setLineNumber(phpTestResult.getLine() - 1);
        testResultDto.setTestLocation(simpleLocationDto);
        this.testResultsCache.put(this.getKey(testResultDto.getResultPath()), phpTestResult);
        return testResultDto;
    }

    private TestResultTraceDto getTestTrace(AbstractPHPUnitTestResult phpTestResult) {
        PHPUnitTestCase phpTestCase;
        PHPUnitTestException phpTestEvent;
        TestResultTraceDto testResultTraceDto = (TestResultTraceDto)DtoFactory.getInstance().createDto(TestResultTraceDto.class);
        if (phpTestResult instanceof PHPUnitTestCase && (phpTestEvent = (phpTestCase = (PHPUnitTestCase)phpTestResult).getException()) != null) {
            testResultTraceDto.setMessage(phpTestEvent.getExceptionClass() + ": " + phpTestEvent.getMessage());
            ArrayList<TestResultTraceFrameDto> traceFrames = new ArrayList<TestResultTraceFrameDto>();
            for (PHPUnitTraceFrame phpTraceFrame : phpTestEvent.getTrace()) {
                TestResultTraceFrameDto testResultTraceFrameDto = (TestResultTraceFrameDto)DtoFactory.getInstance().createDto(TestResultTraceFrameDto.class);
                testResultTraceFrameDto.setTraceFrame(phpTraceFrame.toString());
                SimpleLocationDto simpleLocationDto = (SimpleLocationDto)DtoFactory.getInstance().createDto(SimpleLocationDto.class);
                simpleLocationDto.setResourcePath(phpTraceFrame.getFile());
                simpleLocationDto.setLineNumber(phpTraceFrame.getLine() - 1);
                testResultTraceFrameDto.setLocation(simpleLocationDto);
                traceFrames.add(testResultTraceFrameDto);
            }
            testResultTraceDto.setTraceFrames(traceFrames);
            return testResultTraceDto;
        }
        return null;
    }

    private String getKey(List<String> resultsPath) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> resultsPathIterator = resultsPath.iterator();
        sb.append(resultsPathIterator.next());
        while (resultsPathIterator.hasNext()) {
            sb.append("->" + resultsPathIterator.next());
        }
        return sb.toString();
    }

    private TestResultStatus getStatus(int phpStatus) {
        switch (phpStatus) {
            case 1: {
                return TestResultStatus.SUCCESS;
            }
            case 4: {
                return TestResultStatus.WARNING;
            }
            case 5: {
                return TestResultStatus.FAILURE;
            }
            case 6: {
                return TestResultStatus.ERROR;
            }
            case 2: 
            case 3: {
                return TestResultStatus.SKIPPED;
            }
        }
        return null;
    }

    private String getRootLabel(int phpStatus) {
        switch (phpStatus) {
            case 1: {
                return "Tests Passed";
            }
            case 5: 
            case 6: {
                return "Tests Failed";
            }
            case 2: 
            case 3: {
                return "Tests Skipped";
            }
        }
        return "Test Results";
    }

    private String getTimeString(double time) {
        return "(" + new DecimalFormat("0.000").format(time) + " ms)";
    }
}

