/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.testing.phpunit.server.model;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.che.plugin.testing.phpunit.server.model.AbstractPHPUnitTestResult;
import org.eclipse.che.plugin.testing.phpunit.server.model.PHPUnitTestCase;

public class PHPUnitTestSuite
extends AbstractPHPUnitTestResult {
    protected final StatusCount statusCount = new StatusCount();
    private Set<AbstractPHPUnitTestResult> children = null;
    private int runCount = 0;
    private int totalCount;

    public PHPUnitTestSuite(Map<?, ?> test, PHPUnitTestSuite parent) {
        super(test, parent);
        this.totalCount = test == null ? 0 : Integer.parseInt((String)test.get("tests"));
    }

    @Override
    public Set<AbstractPHPUnitTestResult> getChildren() {
        return this.children;
    }

    @Override
    public int getRunCount() {
        return this.runCount;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        int n = status;
        this.statusCount.counts[n] = this.statusCount.counts[n] + 1;
        this.status = Math.max(this.status, status);
        if (this.parent != null) {
            ((PHPUnitTestSuite)this.parent).setStatus(status);
        }
    }

    public void addChild(AbstractPHPUnitTestResult test, boolean finished) {
        if (this.children == null) {
            this.children = new LinkedHashSet<AbstractPHPUnitTestResult>();
        }
        this.children.add(test);
        if (test instanceof PHPUnitTestCase && finished) {
            this.addRunCount(1);
        }
        this.time += test.getTime();
        this.setStatus(test.getStatus());
    }

    public int getStatusCount(int status) {
        return this.statusCount.counts[status];
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setParent(PHPUnitTestSuite group) {
        this.parent = group;
    }

    private void addRunCount(int count) {
        this.runCount += count;
        if (this.parent != null) {
            ((PHPUnitTestSuite)this.parent).addRunCount(count);
        }
    }

    protected class StatusCount {
        public int[] counts = new int[]{0, 0, 0, 0, 0, 0, 0};

        protected StatusCount() {
        }
    }
}

