/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.testing.phpunit.server.model;

import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.che.plugin.testing.phpunit.server.model.AbstractPHPUnitElement;
import org.eclipse.che.plugin.testing.phpunit.server.model.AbstractPHPUnitTestEvent;

public class PHPUnitTraceFrame
extends AbstractPHPUnitElement {
    private String traceFunction = "";
    private String traceClass = "";
    private String traceType = "->";

    public PHPUnitTraceFrame(Map<?, ?> frame, AbstractPHPUnitTestEvent parent) {
        super(frame, parent);
        this.traceFunction = (String)frame.get("function");
        this.traceClass = (String)frame.get("class");
        this.traceType = (String)frame.get("type");
    }

    public String getFunction() {
        return this.traceFunction;
    }

    public String getClassName() {
        return this.traceClass;
    }

    public String getTraceType() {
        return this.traceType;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(1);
        if (this.traceClass != null) {
            result.append(this.traceClass);
        }
        if (this.traceType != null) {
            result.append(this.traceType);
        }
        result.append(this.traceFunction);
        if (this.file != null) {
            String fileName = Paths.get(this.file, new String[0]).getFileName().toString();
            result.append('(' + fileName + ':' + this.line + ')');
        } else {
            result.append("()");
        }
        return result.toString();
    }
}

