/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.che.plugin.testing.phpunit.server;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.che.api.project.server.impl.RootDirPathProvider;
import org.eclipse.che.api.testing.server.framework.TestRunner;
import org.eclipse.che.api.testing.shared.TestDetectionContext;
import org.eclipse.che.api.testing.shared.TestExecutionContext;
import org.eclipse.che.api.testing.shared.TestPosition;
import org.eclipse.che.commons.lang.execution.ProcessHandler;
import org.eclipse.che.dto.server.DtoFactory;
import org.eclipse.che.plugin.testing.phpunit.server.PHPUnitTestEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PHPUnitTestRunner
implements TestRunner {
    public static final Logger LOG = LoggerFactory.getLogger(PHPUnitTestRunner.class);
    public static final String RUNNER_ID = "PHPUnit";
    private final PHPUnitTestEngine testEngine;

    @Inject
    public PHPUnitTestRunner(RootDirPathProvider pathProvider) {
        this.testEngine = new PHPUnitTestEngine(new File(pathProvider.get()));
    }

    public String getName() {
        return RUNNER_ID;
    }

    public int getDebugPort() {
        return -1;
    }

    public List<TestPosition> detectTests(TestDetectionContext context) {
        ArrayList<TestPosition> result = new ArrayList<TestPosition>();
        String filePath = context.getFilePath();
        if (filePath.endsWith(".php") || filePath.endsWith(".phtml")) {
            TestPosition testPosition = ((TestPosition)DtoFactory.newDto(TestPosition.class)).withFrameworkName(this.getName());
            result.add(testPosition);
        }
        return result;
    }

    public ProcessHandler execute(TestExecutionContext context) throws IOException {
        return this.testEngine.executeTests(context);
    }
}

