/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.handlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import java.nio.ByteOrder;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.client.handlers.UaRequestFuture;
import org.eclipse.milo.opcua.stack.client.handlers.UaTcpClientAcknowledgeHandler;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaRuntimeException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.UaServiceFaultException;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.channel.ChunkDecoder;
import org.eclipse.milo.opcua.stack.core.channel.ChunkEncoder;
import org.eclipse.milo.opcua.stack.core.channel.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.MessageAbortedException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.headers.AsymmetricSecurityHeader;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageDecoder;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.SecurityTokenRequestType;
import org.eclipse.milo.opcua.stack.core.types.structured.ChannelSecurityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.OpenSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.OpenSecureChannelResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.LongSequence;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTcpClientMessageHandler
extends ByteToMessageCodec<UaRequestFuture>
implements HeaderDecoder {
    public static final AttributeKey<Map<Long, UaRequestFuture>> KEY_PENDING_REQUEST_FUTURES = AttributeKey.valueOf((String)"pending-request-futures");
    public static final int SECURE_CHANNEL_TIMEOUT_SECONDS = 10;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<ByteBuf> chunkBuffers = new LinkedList<ByteBuf>();
    private final AtomicReference<AsymmetricSecurityHeader> headerRef = new AtomicReference();
    private ScheduledFuture renewFuture;
    private Timeout secureChannelTimeout;
    private final Map<Long, UaRequestFuture> pending;
    private final LongSequence requestIdSequence;
    private final UaTcpStackClient client;
    private final ClientSecureChannel secureChannel;
    private final SerializationQueue serializationQueue;
    private final CompletableFuture<ClientSecureChannel> handshakeFuture;

    public UaTcpClientMessageHandler(UaTcpStackClient client, ClientSecureChannel secureChannel, SerializationQueue serializationQueue, CompletableFuture<ClientSecureChannel> handshakeFuture) {
        this.client = client;
        this.secureChannel = secureChannel;
        this.serializationQueue = serializationQueue;
        this.handshakeFuture = handshakeFuture;
        secureChannel.attr(KEY_PENDING_REQUEST_FUTURES).setIfAbsent((Object)Maps.newConcurrentMap());
        this.pending = (Map)secureChannel.attr(KEY_PENDING_REQUEST_FUTURES).get();
        secureChannel.attr(ClientSecureChannel.KEY_REQUEST_ID_SEQUENCE).setIfAbsent((Object)new LongSequence(1L, 0xFFFFFFFFL));
        this.requestIdSequence = (LongSequence)secureChannel.attr(ClientSecureChannel.KEY_REQUEST_ID_SEQUENCE).get();
        handshakeFuture.thenAccept(sc -> {
            Channel channel = sc.getChannel();
            channel.eventLoop().execute(() -> {
                List awaitingHandshake = (List)channel.attr(UaTcpClientAcknowledgeHandler.KEY_AWAITING_HANDSHAKE).get();
                if (awaitingHandshake != null) {
                    channel.attr(UaTcpClientAcknowledgeHandler.KEY_AWAITING_HANDSHAKE).remove();
                    this.logger.debug("{} message(s) queued before handshake completed; sending now.", (Object)awaitingHandshake.size());
                    awaitingHandshake.forEach(arg_0 -> ((Channel)channel).writeAndFlush(arg_0));
                }
            });
        });
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        SecurityTokenRequestType requestType = this.secureChannel.getChannelId() == 0L ? SecurityTokenRequestType.Issue : SecurityTokenRequestType.Renew;
        this.secureChannelTimeout = this.client.getConfig().getWheelTimer().newTimeout(timeout -> {
            if (!timeout.isCancelled()) {
                this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for secure channel"));
                ctx.close();
            }
        }, 10L, TimeUnit.SECONDS);
        this.logger.debug("OpenSecureChannel timeout scheduled for +5s");
        this.sendOpenSecureChannelRequest(ctx, requestType);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.renewFuture != null) {
            this.renewFuture.cancel(false);
        }
        this.handshakeFuture.completeExceptionally(new UaException(2158886912L, "connection closed"));
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.error("[remote={}] Exception caught: {}", new Object[]{ctx.channel().remoteAddress(), cause.getMessage(), cause});
        this.chunkBuffers.forEach(ReferenceCountUtil::safeRelease);
        this.chunkBuffers.clear();
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof CloseSecureChannelRequest) {
            this.sendCloseSecureChannelRequest(ctx, (CloseSecureChannelRequest)evt);
        }
    }

    private void sendOpenSecureChannelRequest(final ChannelHandlerContext ctx, SecurityTokenRequestType requestType) {
        ByteString clientNonce = this.secureChannel.isSymmetricSigningEnabled() ? NonceUtil.generateNonce((SecurityPolicy)this.secureChannel.getSecurityPolicy()) : ByteString.NULL_VALUE;
        this.secureChannel.setLocalNonce(clientNonce);
        final OpenSecureChannelRequest request = new OpenSecureChannelRequest(new RequestHeader(null, DateTime.now(), Unsigned.uint((int)0), Unsigned.uint((int)0), null, Unsigned.uint((int)0), null), Unsigned.uint((long)0L), requestType, this.secureChannel.getMessageSecurityMode(), this.secureChannel.getLocalNonce(), this.client.getChannelLifetime());
        this.serializationQueue.encode((binaryEncoder, chunkEncoder) -> {
            ByteBuf messageBuffer = BufferUtil.buffer();
            try {
                binaryEncoder.setBuffer(messageBuffer);
                binaryEncoder.writeMessage(null, (UaMessage)request);
                this.checkMessageSize(messageBuffer);
                chunkEncoder.encodeAsymmetric((SecureChannel)this.secureChannel, this.requestIdSequence.getAndIncrement().longValue(), messageBuffer, MessageType.OpenSecureChannel, new ChunkEncoder.Callback(){

                    public void onEncodingError(UaException ex) {
                        UaTcpClientMessageHandler.this.logger.error("Error encoding {}: {}", new Object[]{request, ex.getMessage(), ex});
                        ctx.close();
                    }

                    public void onMessageEncoded(List<ByteBuf> messageChunks, long requestId) {
                        CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
                        for (ByteBuf chunk : messageChunks) {
                            chunkComposite.addComponent(chunk);
                            chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
                        }
                        ctx.writeAndFlush((Object)chunkComposite, ctx.voidPromise());
                        ChannelSecurity channelSecurity = UaTcpClientMessageHandler.this.secureChannel.getChannelSecurity();
                        long currentTokenId = -1L;
                        if (channelSecurity != null) {
                            currentTokenId = channelSecurity.getCurrentToken().getTokenId().longValue();
                        }
                        long previousTokenId = -1L;
                        if (channelSecurity != null) {
                            previousTokenId = channelSecurity.getPreviousToken().map(token -> token.getTokenId().longValue()).orElse(-1L);
                        }
                        UaTcpClientMessageHandler.this.logger.debug("Sent OpenSecureChannelRequest ({}, id={}, currentToken={}, previousToken={}).", new Object[]{request.getRequestType(), UaTcpClientMessageHandler.this.secureChannel.getChannelId(), currentTokenId, previousTokenId});
                    }
                });
            }
            finally {
                messageBuffer.release();
            }
        });
    }

    private void checkMessageSize(ByteBuf messageBuffer) throws UaSerializationException {
        int messageSize = messageBuffer.readableBytes();
        int remoteMaxMessageSize = this.serializationQueue.getParameters().getRemoteMaxMessageSize();
        if (remoteMaxMessageSize > 0 && messageSize > remoteMaxMessageSize) {
            throw new UaSerializationException(0x80B80000L, "request exceeds remote max message size: " + messageSize + " > " + remoteMaxMessageSize);
        }
    }

    private void sendCloseSecureChannelRequest(final ChannelHandlerContext ctx, final CloseSecureChannelRequest request) {
        this.serializationQueue.encode((binaryEncoder, chunkEncoder) -> {
            ByteBuf messageBuffer = BufferUtil.buffer();
            try {
                binaryEncoder.setBuffer(messageBuffer);
                binaryEncoder.writeMessage(null, (UaMessage)request);
                this.checkMessageSize(messageBuffer);
                chunkEncoder.encodeSymmetric((SecureChannel)this.secureChannel, this.requestIdSequence.getAndIncrement().longValue(), messageBuffer, MessageType.CloseSecureChannel, new ChunkEncoder.Callback(){

                    public void onEncodingError(UaException ex) {
                        UaTcpClientMessageHandler.this.logger.error("Error encoding {}: {}", new Object[]{request, ex.getMessage(), ex});
                        ctx.close();
                    }

                    public void onMessageEncoded(List<ByteBuf> messageChunks, long requestId) {
                        CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
                        for (ByteBuf chunk : messageChunks) {
                            chunkComposite.addComponent(chunk);
                            chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
                        }
                        ctx.writeAndFlush((Object)chunkComposite).addListener(future -> ctx.close());
                        UaTcpClientMessageHandler.this.secureChannel.setChannelId(0L);
                    }
                });
            }
            catch (UaSerializationException e) {
                this.handshakeFuture.completeExceptionally(e);
                ctx.close();
            }
            finally {
                messageBuffer.release();
            }
        });
    }

    protected void encode(final ChannelHandlerContext ctx, final UaRequestFuture request, ByteBuf buffer) throws Exception {
        this.serializationQueue.encode((binaryEncoder, chunkEncoder) -> {
            ByteBuf messageBuffer = BufferUtil.buffer();
            try {
                binaryEncoder.setBuffer(messageBuffer);
                binaryEncoder.writeMessage(null, (UaMessage)request.getRequest());
                this.checkMessageSize(messageBuffer);
                chunkEncoder.encodeSymmetric((SecureChannel)this.secureChannel, this.requestIdSequence.getAndIncrement().longValue(), messageBuffer, MessageType.SecureMessage, new ChunkEncoder.Callback(){

                    public void onEncodingError(UaException ex) {
                        UaTcpClientMessageHandler.this.logger.error("Error encoding {}: {}", new Object[]{request.getRequest(), ex.getMessage(), ex});
                        ctx.close();
                    }

                    public void onMessageEncoded(List<ByteBuf> messageChunks, long requestId) {
                        UaTcpClientMessageHandler.this.pending.put(requestId, request);
                        request.getFuture().whenComplete((r, x) -> {
                            UaRequestFuture cfr_ignored_0 = (UaRequestFuture)UaTcpClientMessageHandler.this.pending.remove(requestId);
                        });
                        CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
                        for (ByteBuf chunk : messageChunks) {
                            chunkComposite.addComponent(chunk);
                            chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
                        }
                        ctx.writeAndFlush((Object)chunkComposite, ctx.voidPromise());
                    }
                });
            }
            catch (UaSerializationException e) {
                request.getFuture().completeExceptionally(e);
            }
            finally {
                messageBuffer.release();
            }
        });
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.readableBytes() >= 8 && (buffer = buffer.order(ByteOrder.LITTLE_ENDIAN)).readableBytes() >= this.getMessageLength(buffer)) {
            this.decodeMessage(ctx, buffer);
        }
    }

    private void decodeMessage(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        int messageLength = this.getMessageLength(buffer);
        MessageType messageType = MessageType.fromMediumInt((int)buffer.getMedium(buffer.readerIndex()));
        switch (messageType) {
            case OpenSecureChannel: {
                this.onOpenSecureChannel(ctx, buffer.readSlice(messageLength));
                break;
            }
            case SecureMessage: {
                this.onSecureMessage(ctx, buffer.readSlice(messageLength));
                break;
            }
            case Error: {
                this.onError(ctx, buffer.readSlice(messageLength));
                break;
            }
            default: {
                throw new UaException(2155741184L, "unexpected MessageType: " + messageType);
            }
        }
    }

    private boolean accumulateChunk(ByteBuf buffer) throws UaException {
        int maxChunkCount = this.serializationQueue.getParameters().getLocalMaxChunkCount();
        int maxChunkSize = this.serializationQueue.getParameters().getLocalReceiveBufferSize();
        int chunkSize = buffer.readerIndex(0).readableBytes();
        if (chunkSize > maxChunkSize) {
            throw new UaException(0x80800000L, String.format("max chunk size exceeded (%s)", maxChunkSize));
        }
        this.chunkBuffers.add(buffer.retain());
        if (maxChunkCount > 0 && this.chunkBuffers.size() > maxChunkCount) {
            throw new UaException(0x80800000L, String.format("max chunk count exceeded (%s)", maxChunkCount));
        }
        char chunkType = (char)buffer.getByte(3);
        return chunkType == 'A' || chunkType == 'F';
    }

    private void onOpenSecureChannel(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        if (this.secureChannelTimeout != null) {
            if (this.secureChannelTimeout.cancel()) {
                this.logger.debug("OpenSecureChannel timeout canceled");
                this.secureChannelTimeout = null;
            } else {
                this.logger.warn("timed out waiting for secure channel");
                this.handshakeFuture.completeExceptionally(new UaException(0x800A0000L, "timed out waiting for secure channel"));
                ctx.close();
                return;
            }
        }
        buffer.skipBytes(12);
        AsymmetricSecurityHeader securityHeader = AsymmetricSecurityHeader.decode((ByteBuf)buffer);
        if (this.headerRef.compareAndSet(null, securityHeader)) {
            CertificateValidator certificateValidator = this.client.getConfig().getCertificateValidator();
            SecurityPolicy securityPolicy = SecurityPolicy.fromUri((String)securityHeader.getSecurityPolicyUri());
            if (securityPolicy != SecurityPolicy.None) {
                ByteString serverCertificateBytes = securityHeader.getSenderCertificate();
                List serverCertificateChain = CertificateUtil.decodeCertificates((byte[])serverCertificateBytes.bytesOrEmpty());
                certificateValidator.validate((X509Certificate)serverCertificateChain.get(0));
                certificateValidator.verifyTrustChain(serverCertificateChain);
            }
        } else if (!securityHeader.equals((Object)this.headerRef.get())) {
            throw new UaException(2148728832L, "subsequent AsymmetricSecurityHeader did not match");
        }
        if (this.accumulateChunk(buffer)) {
            ImmutableList buffersToDecode = ImmutableList.copyOf(this.chunkBuffers);
            this.chunkBuffers = new LinkedList<ByteBuf>();
            this.serializationQueue.decode((arg_0, arg_1) -> this.lambda$onOpenSecureChannel$6((List)buffersToDecode, ctx, arg_0, arg_1));
        }
    }

    private void installSecurityToken(ChannelHandlerContext ctx, OpenSecureChannelResponse response) {
        ChannelSecurity oldSecrets;
        ChannelSecurity.SecuritySecrets newKeys = null;
        if (response.getServerProtocolVersion().longValue() < 0L) {
            throw new UaRuntimeException(2159935488L, "server protocol version unsupported: " + response.getServerProtocolVersion());
        }
        ChannelSecurityToken newToken = response.getSecurityToken();
        if (this.secureChannel.isSymmetricSigningEnabled()) {
            this.secureChannel.setRemoteNonce(response.getServerNonce());
            newKeys = ChannelSecurity.generateKeyPair((SecureChannel)this.secureChannel, (ByteString)this.secureChannel.getLocalNonce(), (ByteString)this.secureChannel.getRemoteNonce());
        }
        ChannelSecurity.SecuritySecrets oldKeys = (oldSecrets = this.secureChannel.getChannelSecurity()) != null ? oldSecrets.getCurrentKeys() : null;
        ChannelSecurityToken oldToken = oldSecrets != null ? oldSecrets.getCurrentToken() : null;
        this.secureChannel.setChannelSecurity(new ChannelSecurity(newKeys, newToken, oldKeys, oldToken));
        DateTime createdAt = response.getSecurityToken().getCreatedAt();
        long revisedLifetime = response.getSecurityToken().getRevisedLifetime().longValue();
        if (revisedLifetime > 0L) {
            long renewAt = (long)((double)revisedLifetime * 0.75);
            this.renewFuture = ctx.executor().schedule(() -> this.sendOpenSecureChannelRequest(ctx, SecurityTokenRequestType.Renew), renewAt, TimeUnit.MILLISECONDS);
        } else {
            this.logger.warn("Server revised secure channel lifetime to 0; renewal will not occur.");
        }
        ctx.executor().execute(() -> {
            if (ctx.pipeline().get(UaTcpClientAcknowledgeHandler.class) != null) {
                ctx.pipeline().remove(UaTcpClientAcknowledgeHandler.class);
            }
        });
        ChannelSecurity channelSecurity = this.secureChannel.getChannelSecurity();
        long currentTokenId = channelSecurity.getCurrentToken().getTokenId().longValue();
        long previousTokenId = channelSecurity.getPreviousToken().map(t -> t.getTokenId().longValue()).orElse(-1L);
        this.logger.debug("SecureChannel id={}, currentTokenId={}, previousTokenId={}, lifetime={}ms, createdAt={}", new Object[]{this.secureChannel.getChannelId(), currentTokenId, previousTokenId, revisedLifetime, createdAt});
    }

    private void onSecureMessage(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        buffer.skipBytes(8);
        long secureChannelId = buffer.readUnsignedInt();
        if (secureChannelId != this.secureChannel.getChannelId()) {
            throw new UaException(0x80220000L, "invalid secure channel id: " + secureChannelId);
        }
        if (this.accumulateChunk(buffer)) {
            ImmutableList buffersToDecode = ImmutableList.copyOf(this.chunkBuffers);
            this.chunkBuffers = new LinkedList<ByteBuf>();
            this.serializationQueue.decode((arg_0, arg_1) -> this.lambda$onSecureMessage$10((List)buffersToDecode, ctx, arg_0, arg_1));
        }
    }

    private void validateChunkHeaders(List<ByteBuf> chunkBuffers) throws UaException {
        ChannelSecurity channelSecurity = this.secureChannel.getChannelSecurity();
        long currentTokenId = channelSecurity.getCurrentToken().getTokenId().longValue();
        long previousTokenId = channelSecurity.getPreviousToken().map(t -> t.getTokenId().longValue()).orElse(-1L);
        for (ByteBuf chunkBuffer : chunkBuffers) {
            long tokenId = chunkBuffer.getUnsignedInt(12);
            if (tokenId == currentTokenId || tokenId == previousTokenId) continue;
            String message = String.format("received unknown secure channel token: tokenId=%s currentTokenId=%s previousTokenId=%s", tokenId, currentTokenId, previousTokenId);
            throw new UaException(0x80870000L, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(ChannelHandlerContext ctx, ByteBuf buffer) {
        try {
            ErrorMessage errorMessage = TcpMessageDecoder.decodeError((ByteBuf)buffer);
            StatusCode statusCode = errorMessage.getError();
            this.logger.error("[remote={}] errorMessage={}", (Object)ctx.channel().remoteAddress(), (Object)errorMessage);
            this.handshakeFuture.completeExceptionally(new UaException(statusCode, errorMessage.getReason()));
        }
        catch (UaException e) {
            this.logger.error("[remote={}] An exception occurred while decoding an error message: {}", new Object[]{ctx.channel().remoteAddress(), e.getMessage(), e});
            this.handshakeFuture.completeExceptionally(e);
        }
        finally {
            ctx.close();
        }
    }

    private /* synthetic */ void lambda$onSecureMessage$10(List buffersToDecode, final ChannelHandlerContext ctx, final OpcUaBinaryStreamDecoder decoder, ChunkDecoder chunkDecoder) {
        try {
            this.validateChunkHeaders(buffersToDecode);
        }
        catch (UaException e) {
            this.logger.error("Error validating chunk headers: {}", (Object)e.getMessage(), (Object)e);
            buffersToDecode.forEach(ReferenceCountUtil::safeRelease);
            ctx.close();
            return;
        }
        chunkDecoder.decodeSymmetric((SecureChannel)this.secureChannel, buffersToDecode, new ChunkDecoder.Callback(){

            public void onDecodingError(UaException ex) {
                UaTcpClientMessageHandler.this.logger.error("Error decoding symmetric message: {}", (Object)ex.getMessage(), (Object)ex);
                ctx.close();
            }

            public void onMessageAborted(MessageAbortedException ex) {
                UaTcpClientMessageHandler.this.logger.warn("Received message abort chunk; error={}, reason={}", (Object)ex.getStatusCode(), (Object)ex.getMessage());
                long requestId = ex.getRequestId();
                UaRequestFuture request = (UaRequestFuture)UaTcpClientMessageHandler.this.pending.remove(requestId);
                if (request != null) {
                    UaTcpClientMessageHandler.this.client.getExecutorService().execute(() -> request.getFuture().completeExceptionally((Throwable)ex));
                } else {
                    UaTcpClientMessageHandler.this.logger.warn("No UaRequestFuture for requestId={}", (Object)requestId);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessageDecoded(ByteBuf message, long requestId) {
                UaRequestFuture request = (UaRequestFuture)UaTcpClientMessageHandler.this.pending.remove(requestId);
                try {
                    if (request != null) {
                        UaResponseMessage response = (UaResponseMessage)decoder.setBuffer(message).readMessage(null);
                        request.getFuture().complete(response);
                    } else {
                        UaTcpClientMessageHandler.this.logger.warn("No UaRequestFuture for requestId={}", (Object)requestId);
                    }
                }
                catch (Throwable t) {
                    UaTcpClientMessageHandler.this.logger.error("Error decoding UaResponseMessage", t);
                    if (request != null) {
                        request.getFuture().completeExceptionally(t);
                    }
                }
                finally {
                    message.release();
                }
            }
        });
    }

    private /* synthetic */ void lambda$onOpenSecureChannel$6(List buffersToDecode, final ChannelHandlerContext ctx, final OpcUaBinaryStreamDecoder binaryDecoder, ChunkDecoder chunkDecoder) {
        chunkDecoder.decodeAsymmetric((SecureChannel)this.secureChannel, buffersToDecode, new ChunkDecoder.Callback(){

            public void onDecodingError(UaException ex) {
                UaTcpClientMessageHandler.this.logger.error("Error decoding asymmetric message: {}", (Object)ex.getMessage(), (Object)ex);
                UaTcpClientMessageHandler.this.handshakeFuture.completeExceptionally(ex);
                ctx.close();
            }

            public void onMessageAborted(MessageAbortedException ex) {
                UaTcpClientMessageHandler.this.logger.warn("Asymmetric message aborted. error={} reason={}", (Object)ex.getStatusCode(), (Object)ex.getMessage());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessageDecoded(ByteBuf message, long requestId) {
                try {
                    UaResponseMessage response = (UaResponseMessage)binaryDecoder.setBuffer(message).readMessage(null);
                    StatusCode serviceResult = response.getResponseHeader().getServiceResult();
                    if (serviceResult.isGood()) {
                        OpenSecureChannelResponse oscr = (OpenSecureChannelResponse)response;
                        UaTcpClientMessageHandler.this.secureChannel.setChannelId(oscr.getSecurityToken().getChannelId().longValue());
                        UaTcpClientMessageHandler.this.logger.debug("Received OpenSecureChannelResponse.");
                        UaTcpClientMessageHandler.this.installSecurityToken(ctx, oscr);
                        UaTcpClientMessageHandler.this.handshakeFuture.complete(UaTcpClientMessageHandler.this.secureChannel);
                    } else {
                        ServiceFault serviceFault = response instanceof ServiceFault ? (ServiceFault)response : new ServiceFault(response.getResponseHeader());
                        UaTcpClientMessageHandler.this.handshakeFuture.completeExceptionally((Throwable)new UaServiceFaultException(serviceFault));
                        ctx.close();
                    }
                }
                catch (Throwable t) {
                    UaTcpClientMessageHandler.this.logger.error("Error decoding OpenSecureChannelResponse", t);
                    UaTcpClientMessageHandler.this.handshakeFuture.completeExceptionally(t);
                    ctx.close();
                }
                finally {
                    message.release();
                }
            }
        });
    }
}

