/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ClientSecureChannel;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientChannelManager {
    private static final int MAX_RECONNECT_DELAY_SECONDS = 16;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService scheduledExecutor = Stack.sharedScheduledExecutor();
    private final AtomicReference<State> state = new AtomicReference<NotConnected>(new NotConnected());
    private final AtomicReference<ScheduledFuture<?>> reconnectFuture = new AtomicReference();
    private final UaTcpStackClient client;

    ClientChannelManager(UaTcpStackClient client) {
        this.client = client;
    }

    public CompletableFuture<ClientSecureChannel> connect() {
        State currentState = this.state.get();
        this.logger.debug("connect(), currentState={}", (Object)currentState.getClass().getSimpleName());
        if (currentState instanceof NotConnected) {
            Connecting nextState = new Connecting();
            if (this.state.compareAndSet(currentState, nextState)) {
                this.logger.debug("connect() while NotConnected", (Throwable)new Exception());
                CompletableFuture<ClientSecureChannel> connected = nextState.connected;
                this.connect(connected);
                return connected.whenCompleteAsync((chan, ex) -> {
                    if (chan != null) {
                        if (this.state.compareAndSet(nextState, new Connected(connected))) {
                            chan.getChannel().pipeline().addLast(new ChannelHandler[]{new InactivityHandler()});
                        }
                    } else {
                        this.state.compareAndSet(nextState, new NotConnected());
                    }
                }, (Executor)this.client.getExecutorService());
            }
            return this.connect();
        }
        if (currentState instanceof Connecting) {
            return ((Connecting)currentState).connected;
        }
        if (currentState instanceof Connected) {
            return ((Connected)currentState).connected;
        }
        if (currentState instanceof Reconnecting) {
            return ((Reconnecting)currentState).reconnected;
        }
        if (currentState instanceof Disconnecting) {
            CompletableFuture<ClientSecureChannel> future = new CompletableFuture<ClientSecureChannel>();
            CompletableFuture<Unit> disconnectFuture = ((Disconnecting)currentState).disconnectFuture;
            disconnectFuture.whenCompleteAsync((unit, ex) -> this.connect().whenCompleteAsync((chan, ex2) -> {
                if (chan != null) {
                    future.complete((ClientSecureChannel)chan);
                } else {
                    future.completeExceptionally((Throwable)ex2);
                }
            }, (Executor)this.client.getExecutorService()), (Executor)this.client.getExecutorService());
            return future;
        }
        throw new IllegalStateException(currentState.getClass().getSimpleName());
    }

    public CompletableFuture<Unit> disconnect() {
        State currentState = this.state.get();
        this.logger.debug("disconnect(), currentState={}", (Object)currentState.getClass().getSimpleName());
        if (currentState instanceof NotConnected) {
            CompletableFuture<Unit> f = new CompletableFuture<Unit>();
            f.complete(Unit.VALUE);
            return f;
        }
        if (currentState instanceof Connected) {
            Disconnecting disconnecting = new Disconnecting();
            if (this.state.compareAndSet(currentState, disconnecting)) {
                ((Connected)currentState).connected.whenCompleteAsync((chan, ex) -> {
                    if (chan != null) {
                        this.disconnect((ClientSecureChannel)chan, disconnecting.disconnectFuture);
                    } else {
                        disconnecting.disconnectFuture.complete(null);
                    }
                    disconnecting.disconnectFuture.whenComplete((unit, ex2) -> {
                        if (this.state.compareAndSet(disconnecting, new NotConnected())) {
                            this.logger.debug("disconnect complete, state set to Idle");
                        }
                    });
                }, (Executor)this.client.getExecutorService());
                return disconnecting.disconnectFuture;
            }
            return this.disconnect();
        }
        if (currentState instanceof Connecting) {
            Disconnecting disconnecting = new Disconnecting();
            if (this.state.compareAndSet(currentState, disconnecting)) {
                ((Connecting)currentState).connected.whenCompleteAsync((chan, ex) -> {
                    if (chan != null) {
                        this.disconnect((ClientSecureChannel)chan, disconnecting.disconnectFuture);
                    } else {
                        disconnecting.disconnectFuture.complete(Unit.VALUE);
                    }
                    disconnecting.disconnectFuture.whenComplete((unit, ex2) -> {
                        if (this.state.compareAndSet(disconnecting, new NotConnected())) {
                            this.logger.debug("disconnect complete, state set to Idle");
                        }
                    });
                }, (Executor)this.client.getExecutorService());
                return disconnecting.disconnectFuture;
            }
            return this.disconnect();
        }
        if (currentState instanceof Reconnecting) {
            Disconnecting disconnecting = new Disconnecting();
            if (this.state.compareAndSet(currentState, disconnecting)) {
                Reconnecting reconnecting = (Reconnecting)currentState;
                ScheduledFuture<?> future = this.reconnectFuture.get();
                if (future != null && future.cancel(false)) {
                    reconnecting.reconnected.completeExceptionally(new UaException(2158886912L));
                    disconnecting.disconnectFuture.complete(Unit.VALUE);
                } else {
                    reconnecting.reconnected.whenCompleteAsync((chan, ex) -> {
                        if (chan != null) {
                            this.disconnect((ClientSecureChannel)chan, disconnecting.disconnectFuture);
                        } else {
                            disconnecting.disconnectFuture.complete(Unit.VALUE);
                        }
                        disconnecting.disconnectFuture.whenComplete((unit, ex2) -> {
                            if (this.state.compareAndSet(disconnecting, new NotConnected())) {
                                this.logger.debug("disconnect complete, state set to Idle");
                            }
                        });
                    }, (Executor)this.client.getExecutorService());
                }
                return disconnecting.disconnectFuture;
            }
            return this.disconnect();
        }
        if (currentState instanceof Disconnecting) {
            return ((Disconnecting)currentState).disconnectFuture;
        }
        throw new IllegalStateException(currentState.getClass().getSimpleName());
    }

    CompletableFuture<ClientSecureChannel> getChannel() {
        State currentState = this.state.get();
        this.logger.trace("getChannel(), currentState={}", (Object)currentState.getClass().getSimpleName());
        if (currentState instanceof NotConnected) {
            return FutureUtils.failedUaFuture((long)0x800D0000L);
        }
        if (currentState instanceof Connecting) {
            return ((Connecting)currentState).connected;
        }
        if (currentState instanceof Connected) {
            return ((Connected)currentState).connected;
        }
        if (currentState instanceof Reconnecting) {
            return ((Reconnecting)currentState).reconnected;
        }
        if (currentState instanceof Disconnecting) {
            CompletableFuture<Unit> disconnectFuture = ((Disconnecting)currentState).disconnectFuture;
            return ((CompletableFuture)disconnectFuture.exceptionally(ex -> Unit.VALUE)).thenComposeAsync(u -> this.getChannel(), (Executor)this.client.getExecutorService());
        }
        throw new IllegalStateException(currentState.getClass().getSimpleName());
    }

    private void connect(CompletableFuture<ClientSecureChannel> future) {
        try {
            CompletableFuture<ClientSecureChannel> bootstrap = UaTcpStackClient.bootstrap(this.client);
            bootstrap.whenCompleteAsync((chan, ex) -> {
                if (chan != null) {
                    this.logger.debug("Channel bootstrap succeeded: localAddress={}, remoteAddress={}", (Object)chan.getChannel().localAddress(), (Object)chan.getChannel().remoteAddress());
                    future.complete((ClientSecureChannel)chan);
                } else {
                    this.logger.debug("Channel bootstrap failed: {}", (Object)ex.getMessage(), ex);
                    future.completeExceptionally((Throwable)ex);
                }
            }, (Executor)this.client.getExecutorService());
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
    }

    private void reconnect(Reconnecting reconnectState, long delaySeconds, ClientSecureChannel previousChannel) {
        this.logger.debug("Scheduling reconnect for +{} seconds...", (Object)delaySeconds);
        try {
            ScheduledFuture<?> future = this.scheduledExecutor.schedule(() -> {
                this.logger.debug("{} seconds elapsed; reconnecting...", (Object)delaySeconds);
                CompletableFuture<ClientSecureChannel> reconnected = reconnectState.reconnected;
                this.connect(reconnected);
                reconnected.whenCompleteAsync((chan, ex) -> {
                    this.reconnectFuture.set(null);
                    if (chan != null) {
                        this.logger.debug("Reconnect succeeded, channelId={}", (Object)chan.getChannelId());
                        if (this.state.compareAndSet(reconnectState, new Connected(reconnected))) {
                            chan.getChannel().pipeline().addLast(new ChannelHandler[]{new InactivityHandler()});
                        }
                    } else {
                        this.logger.debug("Reconnect failed: {}", (Object)ex.getMessage(), ex);
                        Reconnecting nextState = new Reconnecting();
                        if (this.state.compareAndSet(reconnectState, nextState)) {
                            this.reconnect(nextState, ClientChannelManager.nextDelay(delaySeconds), previousChannel);
                        }
                    }
                }, (Executor)this.client.getExecutorService());
            }, delaySeconds, TimeUnit.SECONDS);
            this.reconnectFuture.set(future);
        }
        catch (RejectedExecutionException e) {
            this.logger.debug("Reconnect task execution was rejected: {}", (Object)e.getMessage(), (Object)e);
            reconnectState.reconnected.completeExceptionally(e);
            this.state.compareAndSet(reconnectState, new NotConnected());
        }
    }

    private void disconnect(ClientSecureChannel secureChannel, final CompletableFuture<Unit> disconnected) {
        RequestHeader requestHeader = new RequestHeader(NodeId.NULL_VALUE, DateTime.now(), Unsigned.uint((int)0), Unsigned.uint((int)0), null, Unsigned.uint((int)0), null);
        secureChannel.getChannel().pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                ClientChannelManager.this.logger.debug("channelInactive(), disconnect complete");
                disconnected.complete(Unit.VALUE);
                super.channelInactive(ctx);
            }
        }});
        this.logger.debug("Sending CloseSecureChannelRequest...");
        CloseSecureChannelRequest request = new CloseSecureChannelRequest(requestHeader);
        secureChannel.getChannel().pipeline().fireUserEventTriggered((Object)request);
        this.client.getConfig().getWheelTimer().newTimeout(timeout -> disconnected.completeExceptionally(new UaException(0x800A0000L)), 5L, TimeUnit.SECONDS);
    }

    private static long nextDelay(long delaySeconds) {
        if (delaySeconds == 0L) {
            return 1L;
        }
        return Math.min(delaySeconds << 1, 16L);
    }

    private static class Disconnecting
    implements State {
        final CompletableFuture<Unit> disconnectFuture = new CompletableFuture();

        private Disconnecting() {
        }
    }

    private static class Reconnecting
    implements State {
        final CompletableFuture<ClientSecureChannel> reconnected = new CompletableFuture();

        private Reconnecting() {
        }
    }

    private static class Connected
    implements State {
        final CompletableFuture<ClientSecureChannel> connected;

        Connected(CompletableFuture<ClientSecureChannel> connected) {
            this.connected = connected;
        }
    }

    private static class Connecting
    implements State {
        final CompletableFuture<ClientSecureChannel> connected = new CompletableFuture();

        private Connecting() {
        }
    }

    private static class NotConnected
    implements State {
        private NotConnected() {
        }
    }

    private static interface State {
    }

    private class InactivityHandler
    extends ChannelInboundHandlerAdapter {
        private InactivityHandler() {
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            State currentState = (State)ClientChannelManager.this.state.get();
            if (currentState instanceof Connected) {
                Reconnecting nextState = new Reconnecting();
                if (ClientChannelManager.this.state.compareAndSet(currentState, nextState)) {
                    ClientSecureChannel channel = ((Connected)currentState).connected.get();
                    ClientChannelManager.this.reconnect(nextState, 0L, channel);
                }
            }
            super.channelInactive(ctx);
        }
    }
}

