/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfigBuilder;
import org.eclipse.milo.opcua.stack.core.channel.MessageLimits;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.serialization.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public interface UaStackClientConfig {
    public EndpointDescription getEndpoint();

    public Optional<KeyPair> getKeyPair();

    public Optional<X509Certificate> getCertificate();

    public Optional<X509Certificate[]> getCertificateChain();

    public CertificateValidator getCertificateValidator();

    public EncodingLimits getEncodingLimits();

    public ExecutorService getExecutor();

    public NioEventLoopGroup getEventLoop();

    public HashedWheelTimer getWheelTimer();

    public UInteger getConnectTimeout();

    public UInteger getAcknowledgeTimeout();

    public UInteger getRequestTimeout();

    public MessageLimits getMessageLimits();

    public UInteger getChannelLifetime();

    public static UaStackClientConfigBuilder builder() {
        return new UaStackClientConfigBuilder();
    }

    public static UaStackClientConfigBuilder copy(UaStackClientConfig config) {
        UaStackClientConfigBuilder builder = new UaStackClientConfigBuilder();
        builder.setEndpoint(config.getEndpoint());
        config.getKeyPair().ifPresent(builder::setKeyPair);
        config.getCertificate().ifPresent(builder::setCertificate);
        config.getCertificateChain().ifPresent(builder::setCertificateChain);
        builder.setCertificateValidator(config.getCertificateValidator());
        builder.setMessageLimits(config.getMessageLimits());
        builder.setChannelLifetime(config.getChannelLifetime());
        builder.setExecutor(config.getExecutor());
        builder.setEventLoop(config.getEventLoop());
        builder.setWheelTimer(config.getWheelTimer());
        builder.setConnectTimeout(config.getConnectTimeout());
        builder.setAcknowledgeTimeout(config.getAcknowledgeTimeout());
        builder.setRequestTimeout(config.getRequestTimeout());
        return builder;
    }

    public static UaStackClientConfig copy(UaStackClientConfig config, Consumer<UaStackClientConfigBuilder> consumer) {
        UaStackClientConfigBuilder builder = UaStackClientConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

