/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client.security;

import com.google.common.collect.ImmutableSet;
import java.security.cert.CertPath;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.milo.opcua.stack.client.security.ClientCertificateValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.util.validation.CertificateValidationUtil;
import org.eclipse.milo.opcua.stack.core.util.validation.ValidationCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientCertificateValidator
implements ClientCertificateValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientCertificateValidator.class);
    private final TrustListManager trustListManager;
    private final ImmutableSet<ValidationCheck> validationChecks;

    public DefaultClientCertificateValidator(TrustListManager trustListManager) {
        this(trustListManager, (Set<ValidationCheck>)ValidationCheck.NO_OPTIONAL_CHECKS);
    }

    public DefaultClientCertificateValidator(TrustListManager trustListManager, Set<ValidationCheck> validationChecks) {
        this.trustListManager = trustListManager;
        this.validationChecks = ImmutableSet.copyOf(validationChecks);
    }

    public void validateCertificateChain(List<X509Certificate> certificateChain) throws UaException {
        PKIXCertPathBuilderResult certPathResult;
        try {
            certPathResult = CertificateValidationUtil.buildTrustedCertPath(certificateChain, (Collection)this.trustListManager.getTrustedCertificates(), (Collection)this.trustListManager.getIssuerCertificates());
        }
        catch (UaException e) {
            certificateChain.forEach(arg_0 -> ((TrustListManager)this.trustListManager).addRejectedCertificate(arg_0));
            throw e;
        }
        ArrayList crls = new ArrayList();
        crls.addAll(this.trustListManager.getTrustedCrls());
        crls.addAll(this.trustListManager.getIssuerCrls());
        CertificateValidationUtil.validateTrustedCertPath((CertPath)certPathResult.getCertPath(), (TrustAnchor)certPathResult.getTrustAnchor(), crls, this.validationChecks, (boolean)false);
    }

    @Override
    public void validateCertificateChain(List<X509Certificate> certificateChain, String applicationUri, String ... validHostNames) throws UaException {
        this.validateCertificateChain(certificateChain);
        X509Certificate certificate = certificateChain.get(0);
        CertificateValidationUtil.checkApplicationUri((X509Certificate)certificate, (String)applicationUri);
        try {
            CertificateValidationUtil.checkHostnameOrIpAddress((X509Certificate)certificate, (String[])validHostNames);
        }
        catch (UaException e) {
            if (this.validationChecks.contains((Object)ValidationCheck.HOSTNAME)) {
                throw e;
            }
            LOGGER.warn("check suppressed: certificate failed hostname check: {}", (Object)certificate.getSubjectX500Principal().getName());
        }
    }
}

