/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.examples.server;

import java.io.File;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.application.DefaultCertificateManager;
import org.eclipse.milo.opcua.stack.core.application.DefaultCertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.TestStackRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TestStackResponse;
import org.eclipse.milo.opcua.stack.server.config.UaTcpStackServerConfig;
import org.eclipse.milo.opcua.stack.server.tcp.UaTcpStackServer;

public class ServerExample {
    private final UaTcpStackServer server;

    public ServerExample(X509Certificate certificate, KeyPair keyPair) throws Exception {
        File securityDir = new File("./security/");
        if (!securityDir.exists() && !securityDir.mkdirs()) {
            throw new Exception("unable to create security directory");
        }
        DefaultCertificateManager certificateManager = new DefaultCertificateManager(keyPair, certificate);
        DefaultCertificateValidator certificateValidator = new DefaultCertificateValidator(securityDir);
        UaTcpStackServerConfig config = UaTcpStackServerConfig.builder().setServerName("example").setApplicationName(LocalizedText.english((String)"Stack Example Server")).setApplicationUri(String.format("urn:example-server:%s", UUID.randomUUID())).setCertificateManager((CertificateManager)certificateManager).setCertificateValidator((CertificateValidator)certificateValidator).build();
        this.server = new UaTcpStackServer(config);
        this.server.addEndpoint("opc.tcp://localhost:12685/example", null, certificate, SecurityPolicy.None, MessageSecurityMode.None);
        this.server.addEndpoint("opc.tcp://localhost:12685/example", null, certificate, SecurityPolicy.Basic128Rsa15, MessageSecurityMode.SignAndEncrypt);
        this.server.addRequestHandler(TestStackRequest.class, service -> {
            TestStackRequest request = (TestStackRequest)service.getRequest();
            ResponseHeader header = service.createResponseHeader();
            service.setResponse((UaResponseMessage)new TestStackResponse(header, request.getInput()));
        });
    }

    public void startup() throws ExecutionException, InterruptedException {
        this.server.startup().get();
    }

    public void shutdown() throws ExecutionException, InterruptedException {
        this.server.shutdown().get();
    }
}

