/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.examples.client;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.milo.opcua.stack.client.UaTcpStackClient;
import org.eclipse.milo.opcua.stack.client.config.UaTcpStackClientConfig;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.application.UaStackClient;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;

public class ClientExample {
    private final AtomicLong requestHandle = new AtomicLong(1L);
    private final UaTcpStackClient client;

    public ClientExample(X509Certificate certificate, KeyPair keyPair) throws Exception {
        EndpointDescription[] endpoints = (EndpointDescription[])UaTcpStackClient.getEndpoints((String)"opc.tcp://localhost:12685/example").get();
        EndpointDescription endpoint = Arrays.stream(endpoints).sorted((e1, e2) -> e2.getSecurityLevel().intValue() - e1.getSecurityLevel().intValue()).findFirst().orElseThrow(() -> new Exception("no endpoints returned"));
        UaTcpStackClientConfig config = UaTcpStackClientConfig.builder().setApplicationName(LocalizedText.english((String)"Stack Example Client")).setApplicationUri(String.format("urn:example-client:%s", UUID.randomUUID())).setCertificate(certificate).setKeyPair(keyPair).setEndpoint(endpoint).build();
        this.client = new UaTcpStackClient(config);
    }

    public CompletableFuture<ReadResponse> testStack(NodeId nodeId) {
        RequestHeader header = new RequestHeader(NodeId.NULL_VALUE, DateTime.now(), Unsigned.uint((long)this.requestHandle.getAndIncrement()), Unsigned.uint((int)0), null, Unsigned.uint((int)60000), null);
        ReadRequest request = new ReadRequest(header, Double.valueOf(0.0), TimestampsToReturn.Neither, new ReadValueId[]{new ReadValueId(nodeId, AttributeId.Value.uid(), null, null)});
        return this.client.sendRequest((UaRequestMessage)request);
    }

    public CompletableFuture<UaStackClient> disconnect() {
        return this.client.disconnect();
    }
}

