/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.examples.server;

import java.io.File;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.application.DefaultCertificateManager;
import org.eclipse.milo.opcua.stack.core.application.DefaultCertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.server.config.UaTcpStackServerConfig;
import org.eclipse.milo.opcua.stack.server.tcp.UaTcpStackServer;

public class ServerExample {
    private final UaTcpStackServer server;

    public ServerExample(X509Certificate certificate, KeyPair keyPair) throws Exception {
        File securityDir = new File("./security/");
        if (!securityDir.exists() && !securityDir.mkdirs()) {
            throw new Exception("unable to create security directory");
        }
        DefaultCertificateManager certificateManager = new DefaultCertificateManager(keyPair, certificate);
        DefaultCertificateValidator certificateValidator = new DefaultCertificateValidator(securityDir);
        UaTcpStackServerConfig config = UaTcpStackServerConfig.builder().setServerName("example").setApplicationName(LocalizedText.english((String)"Stack Example Server")).setApplicationUri(String.format("urn:example-server:%s", UUID.randomUUID())).setCertificateManager((CertificateManager)certificateManager).setCertificateValidator((CertificateValidator)certificateValidator).build();
        this.server = new UaTcpStackServer(config);
        this.server.addEndpoint("opc.tcp://localhost:12685/example", null, certificate, SecurityPolicy.None, MessageSecurityMode.None);
        this.server.addEndpoint("opc.tcp://localhost:12685/example", null, certificate, SecurityPolicy.Basic128Rsa15, MessageSecurityMode.SignAndEncrypt);
        this.server.addRequestHandler(ReadRequest.class, service -> {
            ReadRequest request = (ReadRequest)service.getRequest();
            ResponseHeader header = new ResponseHeader(DateTime.now(), request.getRequestHeader().getRequestHandle(), StatusCode.GOOD, null, null, null);
            List nodesToRead = ConversionUtil.l((Object[])request.getNodesToRead());
            List<DataValue> results = Collections.nCopies(nodesToRead.size(), new DataValue(42L));
            ReadResponse response = new ReadResponse(header, (DataValue[])ConversionUtil.a(results, DataValue.class), null);
            service.setResponse((UaResponseMessage)response);
        });
    }

    public void startup() throws ExecutionException, InterruptedException {
        this.server.startup().get();
    }

    public void shutdown() throws ExecutionException, InterruptedException {
        this.server.shutdown().get();
    }
}

