/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.examples;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.examples.client.ClientExample;
import org.eclipse.milo.opcua.stack.examples.server.ServerExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientServerExample {
    private static final String CLIENT_ALIAS = "client-certificate";
    private static final String SERVER_ALIAS = "server-certificate";
    private static final char[] PASSWORD = "test".toCharArray();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static void main(String[] args) throws Exception {
        new ClientServerExample();
    }

    public ClientServerExample() throws Exception {
        KeyStoreLoader loader = new KeyStoreLoader().load();
        ServerExample serverExample = new ServerExample(loader.getServerCertificate(), loader.getServerKeyPair());
        serverExample.startup();
        ClientExample client = new ClientExample(loader.getClientCertificate(), loader.getClientKeyPair());
        for (int i = 0; i < 5; ++i) {
            NodeId nodeId = new NodeId(2, i);
            this.logger.info("Sending synchronous TestStackRequest NodeId={}", (Object)i);
            ReadResponse response2 = client.testStack(nodeId).get();
            this.logger.info("Received TestStackResponse value={}", (Object)((DataValue)ConversionUtil.l((Object[])response2.getResults()).get(0)).getValue());
        }
        ArrayList<CompletableFuture<ReadResponse>> futures = new ArrayList<CompletableFuture<ReadResponse>>();
        for (int i = 0; i < 5; ++i) {
            NodeId nodeId = new NodeId(2, i);
            this.logger.info("Sending asynchronous TestStackRequest NodeId={}", (Object)nodeId);
            CompletableFuture<ReadResponse> future = client.testStack(nodeId);
            future.whenComplete((response, ex) -> {
                if (response != null) {
                    this.logger.info("Received TestStackResponse value={}", (Object)((DataValue)ConversionUtil.l((Object[])response.getResults()).get(0)).getValue());
                } else {
                    this.logger.error("Error: {}", (Object)ex.getMessage(), ex);
                }
            });
            futures.add(future);
        }
        CompletableFuture<Void> all = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        all.whenComplete((r, ex) -> {
            try {
                client.disconnect().get();
                serverExample.shutdown();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            Stack.releaseSharedResources();
        });
    }

    private static class KeyStoreLoader {
        private X509Certificate serverCertificate;
        private KeyPair serverKeyPair;
        private X509Certificate clientCertificate;
        private KeyPair clientKeyPair;

        private KeyStoreLoader() {
        }

        public KeyStoreLoader load() throws Exception {
            Key clientPrivateKey;
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(this.getClass().getClassLoader().getResourceAsStream("example-keystore.pfx"), PASSWORD);
            Key serverPrivateKey = keyStore.getKey(ClientServerExample.SERVER_ALIAS, PASSWORD);
            if (serverPrivateKey instanceof PrivateKey) {
                this.serverCertificate = (X509Certificate)keyStore.getCertificate(ClientServerExample.SERVER_ALIAS);
                PublicKey serverPublicKey = this.serverCertificate.getPublicKey();
                this.serverKeyPair = new KeyPair(serverPublicKey, (PrivateKey)serverPrivateKey);
            }
            if ((clientPrivateKey = keyStore.getKey(ClientServerExample.CLIENT_ALIAS, PASSWORD)) instanceof PrivateKey) {
                this.clientCertificate = (X509Certificate)keyStore.getCertificate(ClientServerExample.CLIENT_ALIAS);
                PublicKey clientPublicKey = this.clientCertificate.getPublicKey();
                this.clientKeyPair = new KeyPair(clientPublicKey, (PrivateKey)clientPrivateKey);
            }
            return this;
        }

        public X509Certificate getServerCertificate() {
            return this.serverCertificate;
        }

        public KeyPair getServerKeyPair() {
            return this.serverKeyPair;
        }

        public X509Certificate getClientCertificate() {
            return this.clientCertificate;
        }

        public KeyPair getClientKeyPair() {
            return this.clientKeyPair;
        }
    }
}

