/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteOrder;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.channel.ExceptionHandler;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.headers.AsymmetricSecurityHeader;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.SecurityTokenRequestType;
import org.eclipse.milo.opcua.stack.core.types.structured.ChannelSecurityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.OpenSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.OpenSecureChannelResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.server.handlers.UaTcpServerHelloHandler;
import org.eclipse.milo.opcua.stack.server.handlers.UaTcpServerSymmetricHandler;
import org.eclipse.milo.opcua.stack.server.tcp.UaTcpStackServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTcpServerAsymmetricHandler
extends ByteToMessageDecoder
implements HeaderDecoder {
    private static final long SecureChannelLifetimeMin = 3600000L;
    private static final long SecureChannelLifetimeMax = 86400000L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServerSecureChannel secureChannel;
    private volatile boolean symmetricHandlerAdded = false;
    private List<ByteBuf> chunkBuffers = new ArrayList<ByteBuf>();
    private final AtomicReference<AsymmetricSecurityHeader> headerRef = new AtomicReference();
    private final int maxChunkCount;
    private final int maxChunkSize;
    private final UaTcpStackServer server;
    private final SerializationQueue serializationQueue;

    public UaTcpServerAsymmetricHandler(UaTcpStackServer server, SerializationQueue serializationQueue) {
        this.server = server;
        this.serializationQueue = serializationQueue;
        this.maxChunkCount = serializationQueue.getParameters().getLocalMaxChunkCount();
        this.maxChunkSize = serializationQueue.getParameters().getLocalReceiveBufferSize();
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        block4: while (buffer.readableBytes() >= 8 && buffer.readableBytes() >= this.getMessageLength(buffer)) {
            int messageLength = this.getMessageLength(buffer);
            MessageType messageType = MessageType.fromMediumInt((int)buffer.getMedium(buffer.readerIndex()));
            switch (messageType) {
                case OpenSecureChannel: {
                    this.onOpenSecureChannel(ctx, buffer.readSlice(messageLength));
                    continue block4;
                }
                case CloseSecureChannel: {
                    this.logger.debug("Received CloseSecureChannelRequest");
                    if (this.secureChannel != null) {
                        this.server.closeSecureChannel(this.secureChannel);
                    }
                    buffer.skipBytes(messageLength);
                    continue block4;
                }
            }
            throw new UaException(2155741184L, "unexpected MessageType: " + messageType);
        }
    }

    private void onOpenSecureChannel(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        buffer.skipBytes(3);
        char chunkType = (char)buffer.readByte();
        if (chunkType == 'A') {
            this.chunkBuffers.forEach(ReferenceCounted::release);
            this.chunkBuffers.clear();
            this.headerRef.set(null);
        } else {
            int chunkSize;
            buffer.skipBytes(4);
            long secureChannelId = buffer.readUnsignedInt();
            AsymmetricSecurityHeader securityHeader = AsymmetricSecurityHeader.decode((ByteBuf)buffer);
            if (secureChannelId == 0L) {
                String endpointUrl = (String)ctx.channel().attr(UaTcpServerHelloHandler.ENDPOINT_URL_KEY).get();
                String securityPolicyUri = securityHeader.getSecurityPolicyUri();
                EndpointDescription endpointDescription = Arrays.stream(this.server.getEndpointDescriptions()).filter(e -> {
                    String s1 = this.pathOrUrl(endpointUrl);
                    String s2 = this.pathOrUrl(e.getEndpointUrl());
                    boolean uriMatch = s1.equals(s2);
                    boolean policyMatch = e.getSecurityPolicyUri().equals(securityPolicyUri);
                    return uriMatch && policyMatch;
                }).findFirst().orElse(null);
                if (endpointDescription == null && !this.server.getConfig().isStrictEndpointUrlsEnabled()) {
                    endpointDescription = Arrays.stream(this.server.getEndpointDescriptions()).filter(e -> e.getSecurityPolicyUri().equals(securityPolicyUri)).findFirst().orElse(null);
                }
                if (endpointDescription == null) {
                    throw new UaException(2148728832L, "SecurityPolicy URI did not match");
                }
                this.secureChannel = this.server.openSecureChannel();
                this.secureChannel.setEndpointDescription(endpointDescription);
            } else {
                this.secureChannel = this.server.getSecureChannel(secureChannelId);
                if (this.secureChannel == null) {
                    throw new UaException(2155806720L, "unknown secure channel id: " + secureChannelId);
                }
                if (!this.secureChannel.getRemoteCertificateBytes().equals((Object)securityHeader.getSenderCertificate())) {
                    throw new UaException(2148728832L, "certificate requesting renewal did not match existing certificate.");
                }
                Channel boundChannel = (Channel)this.secureChannel.attr(UaTcpStackServer.BoundChannelKey).get();
                if (boundChannel != null && boundChannel != ctx.channel()) {
                    throw new UaException(2148728832L, "received a renewal request from channel other than the bound channel.");
                }
            }
            if (!this.headerRef.compareAndSet(null, securityHeader) && !securityHeader.equals((Object)this.headerRef.get())) {
                throw new UaException(2148728832L, "subsequent AsymmetricSecurityHeader did not match");
            }
            SecurityPolicy securityPolicy = SecurityPolicy.fromUri((String)securityHeader.getSecurityPolicyUri());
            this.secureChannel.setSecurityPolicy(securityPolicy);
            if (!securityHeader.getSenderCertificate().isNull() && securityPolicy != SecurityPolicy.None) {
                this.secureChannel.setRemoteCertificate(securityHeader.getSenderCertificate().bytes());
                try {
                    CertificateValidator certificateValidator = this.server.getCertificateValidator();
                    certificateValidator.validate(this.secureChannel.getRemoteCertificate());
                    certificateValidator.verifyTrustChain(this.secureChannel.getRemoteCertificate(), this.secureChannel.getRemoteCertificateChain());
                }
                catch (UaException e2) {
                    try {
                        UaException cause = new UaException(e2.getStatusCode(), "security checks failed");
                        ErrorMessage errorMessage = ExceptionHandler.sendErrorMessage((ChannelHandlerContext)ctx, (Throwable)cause);
                        this.logger.debug("[remote={}] {}.", new Object[]{ctx.channel().remoteAddress(), errorMessage.getReason(), cause});
                    }
                    catch (Exception inner) {
                        this.logger.error("Error sending ErrorMessage: {}", (Object)inner.getMessage(), (Object)inner);
                    }
                }
            }
            if (!securityHeader.getReceiverThumbprint().isNull()) {
                CertificateManager certificateManager = this.server.getCertificateManager();
                Optional localCertificate = certificateManager.getCertificate(securityHeader.getReceiverThumbprint());
                Optional keyPair = certificateManager.getKeyPair(securityHeader.getReceiverThumbprint());
                if (localCertificate.isPresent() && keyPair.isPresent()) {
                    this.secureChannel.setLocalCertificate((X509Certificate)localCertificate.get());
                    this.secureChannel.setKeyPair((KeyPair)keyPair.get());
                } else {
                    throw new UaException(2148728832L, "no certificate for provided thumbprint");
                }
            }
            if ((chunkSize = buffer.readerIndex(0).readableBytes()) > this.maxChunkSize) {
                throw new UaException(0x80800000L, String.format("max chunk size exceeded (%s)", this.maxChunkSize));
            }
            this.chunkBuffers.add(buffer.retain());
            if (this.chunkBuffers.size() > this.maxChunkCount) {
                throw new UaException(0x80800000L, String.format("max chunk count exceeded (%s)", this.maxChunkCount));
            }
            if (chunkType == 'F') {
                List<ByteBuf> buffersToDecode = this.chunkBuffers;
                this.chunkBuffers = new ArrayList<ByteBuf>(this.maxChunkCount);
                this.headerRef.set(null);
                this.serializationQueue.decode((binaryDecoder, chunkDecoder) -> {
                    ByteBuf messageBuffer = null;
                    try {
                        messageBuffer = chunkDecoder.decodeAsymmetric((SecureChannel)this.secureChannel, buffersToDecode);
                        OpenSecureChannelRequest request = (OpenSecureChannelRequest)binaryDecoder.setBuffer(messageBuffer).decodeMessage(null);
                        this.logger.debug("Received OpenSecureChannelRequest ({}, id={}).", (Object)request.getRequestType(), (Object)secureChannelId);
                        long requestId = chunkDecoder.getLastRequestId();
                        this.installSecurityToken(ctx, request, requestId);
                    }
                    catch (UaException e) {
                        this.logger.error("Error decoding asymmetric message: {}", (Object)e.getMessage(), (Object)e);
                        ctx.close();
                    }
                    finally {
                        if (messageBuffer != null) {
                            messageBuffer.release();
                        }
                        buffersToDecode.clear();
                    }
                });
            }
        }
    }

    private String pathOrUrl(String endpointUrl) {
        try {
            URI uri = new URI(endpointUrl).parseServerAuthority();
            return uri.getPath();
        }
        catch (Throwable e) {
            this.logger.warn("Endpoint URL '{}' is not a valid URI: {}", (Object)e.getMessage(), (Object)e);
            return endpointUrl;
        }
    }

    private void installSecurityToken(ChannelHandlerContext ctx, OpenSecureChannelRequest request, long requestId) throws UaException {
        ChannelSecurity oldSecrets;
        SecurityTokenRequestType requestType = request.getRequestType();
        if (requestType == SecurityTokenRequestType.Issue) {
            this.secureChannel.setMessageSecurityMode(request.getSecurityMode());
        } else if (requestType == SecurityTokenRequestType.Renew && this.secureChannel.getMessageSecurityMode() != request.getSecurityMode()) {
            throw new UaException(2148728832L, "secure channel renewal requested a different MessageSecurityMode.");
        }
        long channelLifetime = request.getRequestedLifetime().longValue();
        channelLifetime = Math.min(86400000L, channelLifetime);
        channelLifetime = Math.max(3600000L, channelLifetime);
        ChannelSecurityToken newToken = new ChannelSecurityToken(Unsigned.uint((long)this.secureChannel.getChannelId()), Unsigned.uint((long)this.server.nextTokenId()), DateTime.now(), Unsigned.uint((long)channelLifetime));
        ChannelSecurity.SecuritySecrets newKeys = null;
        if (this.secureChannel.isSymmetricSigningEnabled()) {
            SecurityAlgorithm algorithm = this.secureChannel.getSecurityPolicy().getSymmetricEncryptionAlgorithm();
            ByteString remoteNonce = request.getClientNonce();
            if (remoteNonce == null || remoteNonce.isNull()) {
                throw new UaException(2148728832L, "remote nonce must be non-null");
            }
            if (remoteNonce.length() < NonceUtil.getNonceLength((SecurityAlgorithm)algorithm)) {
                String message = String.format("remote nonce length must be at least %d bytes", NonceUtil.getNonceLength((SecurityAlgorithm)algorithm));
                throw new UaException(2148728832L, message);
            }
            ByteString localNonce = NonceUtil.generateNonce((int)NonceUtil.getNonceLength((SecurityAlgorithm)algorithm));
            this.secureChannel.setLocalNonce(localNonce);
            this.secureChannel.setRemoteNonce(remoteNonce);
            newKeys = ChannelSecurity.generateKeyPair((SecureChannel)this.secureChannel, (ByteString)this.secureChannel.getRemoteNonce(), (ByteString)this.secureChannel.getLocalNonce());
        }
        ChannelSecurity.SecuritySecrets oldKeys = (oldSecrets = this.secureChannel.getChannelSecurity()) != null ? oldSecrets.getCurrentKeys() : null;
        ChannelSecurityToken oldToken = oldSecrets != null ? oldSecrets.getCurrentToken() : null;
        ChannelSecurity newSecrets = new ChannelSecurity(newKeys, newToken, oldKeys, oldToken);
        this.secureChannel.setChannelSecurity(newSecrets);
        ResponseHeader responseHeader = new ResponseHeader(DateTime.now(), request.getRequestHeader().getRequestHandle(), StatusCode.GOOD, null, null, null);
        OpenSecureChannelResponse response = new OpenSecureChannelResponse(responseHeader, Unsigned.uint((long)0L), newToken, this.secureChannel.getLocalNonce());
        this.sendOpenSecureChannelResponse(ctx, requestId, response);
    }

    private void sendOpenSecureChannelResponse(ChannelHandlerContext ctx, long requestId, OpenSecureChannelResponse response) {
        this.serializationQueue.encode((binaryEncoder, chunkEncoder) -> {
            ByteBuf messageBuffer = BufferUtil.buffer();
            try {
                binaryEncoder.setBuffer(messageBuffer);
                binaryEncoder.encodeMessage(null, (UaStructure)response);
                List chunks = chunkEncoder.encodeAsymmetric((SecureChannel)this.secureChannel, MessageType.OpenSecureChannel, messageBuffer, requestId);
                if (!this.symmetricHandlerAdded) {
                    ctx.pipeline().addFirst(new ChannelHandler[]{new UaTcpServerSymmetricHandler(this.server, this.serializationQueue, this.secureChannel)});
                    this.symmetricHandlerAdded = true;
                }
                chunks.forEach(c -> ctx.write(c, ctx.voidPromise()));
                ctx.flush();
                long lifetime = response.getSecurityToken().getRevisedLifetime().longValue();
                this.server.secureChannelIssuedOrRenewed(this.secureChannel, lifetime);
                this.logger.debug("Sent OpenSecureChannelResponse.");
            }
            catch (UaException e) {
                this.logger.error("Error encoding OpenSecureChannelResponse: {}", (Object)e.getMessage(), (Object)e);
                ctx.close();
            }
            finally {
                messageBuffer.release();
            }
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.chunkBuffers.forEach(ReferenceCounted::release);
        this.chunkBuffers.clear();
        if (cause instanceof IOException) {
            ctx.close();
            this.logger.debug("[remote={}] IOException caught; channel closed");
        } else {
            ErrorMessage errorMessage = ExceptionHandler.sendErrorMessage((ChannelHandlerContext)ctx, (Throwable)cause);
            if (cause instanceof UaException) {
                this.logger.debug("[remote={}] UaException caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            } else {
                this.logger.error("[remote={}] Exception caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            }
        }
    }
}

