/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.UaStackServer;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceResponse;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.channel.ExceptionHandler;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.headers.SymmetricSecurityHeader;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.server.tcp.UaTcpStackServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTcpServerSymmetricHandler
extends ByteToMessageCodec<ServiceResponse>
implements HeaderDecoder {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<ByteBuf> chunkBuffers;
    private final int maxChunkCount;
    private final int maxChunkSize;
    private final UaTcpStackServer server;
    private final SerializationQueue serializationQueue;
    private final ServerSecureChannel secureChannel;

    public UaTcpServerSymmetricHandler(UaTcpStackServer server, SerializationQueue serializationQueue, ServerSecureChannel secureChannel) {
        this.server = server;
        this.serializationQueue = serializationQueue;
        this.secureChannel = secureChannel;
        this.maxChunkCount = serializationQueue.getParameters().getLocalMaxChunkCount();
        this.maxChunkSize = serializationQueue.getParameters().getLocalReceiveBufferSize();
        this.chunkBuffers = new ArrayList<ByteBuf>(this.maxChunkCount);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.secureChannel != null) {
            this.secureChannel.attr(UaTcpStackServer.BoundChannelKey).set((Object)ctx.channel());
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.secureChannel != null) {
            this.secureChannel.attr(UaTcpStackServer.BoundChannelKey).remove();
        }
        super.channelInactive(ctx);
    }

    protected void encode(ChannelHandlerContext ctx, ServiceResponse message, ByteBuf out) throws Exception {
        this.serializationQueue.encode((binaryEncoder, chunkEncoder) -> {
            ByteBuf messageBuffer = BufferUtil.buffer();
            try {
                binaryEncoder.setBuffer(messageBuffer);
                binaryEncoder.encodeMessage(null, (UaStructure)message.getResponse());
                List chunks = chunkEncoder.encodeSymmetric((SecureChannel)this.secureChannel, MessageType.SecureMessage, messageBuffer, message.getRequestId());
                ctx.executor().execute(() -> {
                    chunks.forEach(c -> ctx.write(c, ctx.voidPromise()));
                    ctx.flush();
                });
            }
            catch (UaException e) {
                this.logger.error("Error encoding {}: {}", new Object[]{message.getResponse().getClass(), e.getMessage(), e});
                ctx.close();
            }
            finally {
                messageBuffer.release();
            }
        });
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        block3: while (buffer.readableBytes() >= 8 && buffer.readableBytes() >= this.getMessageLength(buffer)) {
            int messageLength = this.getMessageLength(buffer);
            MessageType messageType = MessageType.fromMediumInt((int)buffer.getMedium(buffer.readerIndex()));
            switch (messageType) {
                case SecureMessage: {
                    this.onSecureMessage(ctx, buffer.readSlice(messageLength), out);
                    continue block3;
                }
            }
            out.add(buffer.readSlice(messageLength).retain());
        }
    }

    private void onSecureMessage(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws UaException {
        buffer.skipBytes(3);
        char chunkType = (char)buffer.readByte();
        if (chunkType == 'A') {
            this.chunkBuffers.forEach(ReferenceCounted::release);
            this.chunkBuffers.clear();
        } else {
            buffer.skipBytes(4);
            long secureChannelId = buffer.readUnsignedInt();
            if (secureChannelId != this.secureChannel.getChannelId()) {
                throw new UaException(0x80220000L, "invalid secure channel id: " + secureChannelId);
            }
            int chunkSize = buffer.readerIndex(0).readableBytes();
            if (chunkSize > this.maxChunkSize) {
                throw new UaException(0x80800000L, String.format("max chunk size exceeded (%s)", this.maxChunkSize));
            }
            this.chunkBuffers.add(buffer.retain());
            if (this.chunkBuffers.size() > this.maxChunkCount) {
                throw new UaException(0x80800000L, String.format("max chunk count exceeded (%s)", this.maxChunkCount));
            }
            if (chunkType == 'F') {
                List<ByteBuf> buffersToDecode = this.chunkBuffers;
                this.chunkBuffers = new ArrayList<ByteBuf>(this.maxChunkCount);
                this.serializationQueue.decode((binaryDecoder, chunkDecoder) -> {
                    try {
                        this.validateChunkHeaders(buffersToDecode);
                        ByteBuf messageBuffer = chunkDecoder.decodeSymmetric((SecureChannel)this.secureChannel, buffersToDecode);
                        binaryDecoder.setBuffer(messageBuffer);
                        UaRequestMessage request = (UaRequestMessage)binaryDecoder.decodeMessage(null);
                        ServiceRequest serviceRequest = new ServiceRequest(request, chunkDecoder.getLastRequestId(), (UaStackServer)this.server, this.secureChannel);
                        this.server.getExecutorService().execute(() -> this.server.receiveRequest((ServiceRequest<UaRequestMessage, UaResponseMessage>)serviceRequest));
                        messageBuffer.release();
                        buffersToDecode.clear();
                    }
                    catch (UaException e) {
                        this.logger.error("Error decoding symmetric message: {}", (Object)e.getMessage(), (Object)e);
                        ctx.close();
                    }
                });
            }
        }
    }

    private void validateChunkHeaders(List<ByteBuf> chunkBuffers) throws UaException {
        ChannelSecurity channelSecurity = this.secureChannel.getChannelSecurity();
        long currentTokenId = channelSecurity.getCurrentToken().getTokenId().longValue();
        long previousTokenId = channelSecurity.getPreviousToken().map(t -> t.getTokenId().longValue()).orElse(-1L);
        for (ByteBuf chunkBuffer : chunkBuffers) {
            chunkBuffer.skipBytes(12);
            SymmetricSecurityHeader securityHeader = SymmetricSecurityHeader.decode((ByteBuf)chunkBuffer);
            if (securityHeader.getTokenId() != currentTokenId && securityHeader.getTokenId() != previousTokenId) {
                String message = String.format("received unknown secure channel token. tokenId=%s, currentTokenId=%s, previousTokenId=%s", securityHeader.getTokenId(), currentTokenId, previousTokenId);
                throw new UaException(0x80870000L, message);
            }
            chunkBuffer.readerIndex(0);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.chunkBuffers.forEach(ReferenceCounted::release);
        this.chunkBuffers.clear();
        if (cause instanceof IOException) {
            ctx.close();
            this.logger.debug("[remote={}] IOException caught; channel closed");
        } else {
            ErrorMessage errorMessage = ExceptionHandler.sendErrorMessage((ChannelHandlerContext)ctx, (Throwable)cause);
            if (cause instanceof UaException) {
                this.logger.debug("[remote={}] UaException caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            } else {
                this.logger.error("[remote={}] Exception caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            }
        }
    }
}

