/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.tcp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.util.AsyncSemaphore;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.eclipse.milo.opcua.stack.server.handlers.UaTcpServerHelloHandler;
import org.eclipse.milo.opcua.stack.server.tcp.UaTcpStackServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketServers {
    private static final AsyncSemaphore SEMAPHORE = new AsyncSemaphore(1);
    static final ConcurrentMap<InetSocketAddress, SocketServer> SERVERS = Maps.newConcurrentMap();

    public static CompletableFuture<Unit> bindServer(UaTcpStackServer stackServer, String address, int port) {
        return SEMAPHORE.acquire().thenCompose(permit -> SocketServers.doBindServer(stackServer, address, port).whenComplete((u, ex) -> permit.release()));
    }

    private static CompletableFuture<Unit> doBindServer(UaTcpStackServer stackServer, String address, int port) {
        InetSocketAddress isa = SocketServers.isa(address, port);
        if (SERVERS.containsKey(isa)) {
            SocketServer server = (SocketServer)SERVERS.get(isa);
            server.addServer(stackServer);
            return CompletableFuture.completedFuture(Unit.VALUE);
        }
        return SocketServer.bootstrap(isa).thenApply(s -> {
            SERVERS.putIfAbsent(isa, (SocketServer)s);
            return Unit.VALUE;
        });
    }

    public static CompletableFuture<Unit> unbindServer(UaTcpStackServer stackServer, String address, int port) {
        return SEMAPHORE.acquire().thenCompose(permit -> SocketServers.doUnbindServer(stackServer, address, port).whenComplete((u, ex) -> permit.release()));
    }

    private static CompletableFuture<Unit> doUnbindServer(UaTcpStackServer stackServer, String address, int port) {
        InetSocketAddress isa = SocketServers.isa(address, port);
        if (SERVERS.containsKey(isa)) {
            SocketServer socketServer = (SocketServer)SERVERS.get(isa);
            socketServer.removeServer(stackServer);
            if (socketServer.isEmpty()) {
                SERVERS.remove(isa);
                return socketServer.shutdown();
            }
        }
        return CompletableFuture.completedFuture(Unit.VALUE);
    }

    public static CompletableFuture<Unit> shutdownAll() {
        return SEMAPHORE.acquire().thenCompose(permit -> SocketServers.doShutdownAll().whenComplete((u, ex) -> permit.release()));
    }

    private static CompletableFuture<Unit> doShutdownAll() {
        ArrayList servers = Lists.newArrayList(SERVERS.values());
        SERVERS.clear();
        List futures = servers.stream().map(rec$ -> ((SocketServer)rec$).shutdown()).collect(Collectors.toList());
        return FutureUtils.sequence(futures).thenApply(v -> Unit.VALUE);
    }

    private static InetSocketAddress isa(String address, int port) {
        return new InetSocketAddress(address, port);
    }

    private static class SocketServer {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final Map<String, UaTcpStackServer> boundServers = Maps.newConcurrentMap();
        private final InetSocketAddress address;
        private final Channel channel;

        private SocketServer(InetSocketAddress address, Channel channel) {
            this.address = address;
            this.channel = channel;
        }

        private UaTcpStackServer getServer(String endpointUrl) {
            String path = EndpointUtil.getPath((String)endpointUrl);
            return this.boundServers.get(path);
        }

        private void addServer(UaTcpStackServer server) {
            Stream endpointUrls = server.getEndpointUrls().stream();
            Stream discoveryUrls = server.getDiscoveryUrls().stream();
            Stream.concat(endpointUrls, discoveryUrls).forEach(url -> {
                String serverName;
                String serverKey = EndpointUtil.getPath((String)url);
                String string = serverName = serverKey.startsWith("/") ? serverKey.substring(1) : serverKey;
                if (!this.boundServers.containsKey(serverKey) && serverName.equals(server.getConfig().getServerName())) {
                    this.boundServers.put(serverKey, server);
                    this.logger.debug("Added server at path: \"{}\"", (Object)serverName);
                }
            });
        }

        private void removeServer(UaTcpStackServer server) {
            Stream endpointUrls = server.getEndpointUrls().stream();
            Stream discoveryUrls = server.getDiscoveryUrls().stream();
            Stream.concat(endpointUrls, discoveryUrls).forEach(url -> {
                String key = EndpointUtil.getPath((String)url);
                if (this.boundServers.get(key) == server) {
                    this.boundServers.remove(key);
                    this.logger.debug("Removed server at path: \"{}\"", (Object)key);
                }
            });
        }

        private boolean isEmpty() {
            return this.boundServers.isEmpty();
        }

        private CompletableFuture<Unit> shutdown() {
            CompletableFuture<Unit> shutdownFuture = new CompletableFuture<Unit>();
            this.boundServers.clear();
            this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> shutdownFuture.complete(Unit.VALUE)));
            return shutdownFuture;
        }

        static CompletableFuture<SocketServer> bootstrap(final InetSocketAddress address) {
            CompletableFuture<SocketServer> serverFuture = new CompletableFuture<SocketServer>();
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)Stack.sharedEventLoop()).handler((ChannelHandler)new LoggingHandler(SocketServer.class))).channel(NioServerSocketChannel.class)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel channel) throws Exception {
                    Function<String, Optional<UaTcpStackServer>> serverLookup = endpointUrl -> SocketServer.getServerByEndpointUrl(address, endpointUrl);
                    channel.pipeline().addLast(new ChannelHandler[]{new UaTcpServerHelloHandler(serverLookup)});
                }
            });
            bootstrap.bind((SocketAddress)address).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    SocketServer socketServer = new SocketServer(address, future.channel());
                    serverFuture.complete(socketServer);
                } else {
                    serverFuture.completeExceptionally(future.cause());
                }
            }));
            return serverFuture;
        }

        static Optional<UaTcpStackServer> getServerByEndpointUrl(InetSocketAddress address, String endpointUrl) {
            SocketServer socketServer = (SocketServer)SERVERS.get(address);
            if (socketServer != null) {
                return Optional.ofNullable(socketServer.getServer(endpointUrl));
            }
            return Optional.empty();
        }
    }
}

