/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.ByteOrder;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.channel.ChannelSecurity;
import org.eclipse.milo.opcua.stack.core.channel.ChunkDecoder;
import org.eclipse.milo.opcua.stack.core.channel.ChunkEncoder;
import org.eclipse.milo.opcua.stack.core.channel.ExceptionHandler;
import org.eclipse.milo.opcua.stack.core.channel.MessageAbortedException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.headers.AsymmetricSecurityHeader;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.SecurityTokenRequestType;
import org.eclipse.milo.opcua.stack.core.types.structured.ChannelSecurityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.OpenSecureChannelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.OpenSecureChannelResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.server.handlers.UaTcpServerHelloHandler;
import org.eclipse.milo.opcua.stack.server.handlers.UaTcpServerSymmetricHandler;
import org.eclipse.milo.opcua.stack.server.tcp.UaTcpStackServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTcpServerAsymmetricHandler
extends ByteToMessageDecoder
implements HeaderDecoder {
    private static final long SecureChannelLifetimeMin = 3600000L;
    private static final long SecureChannelLifetimeMax = 86400000L;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ServerSecureChannel secureChannel;
    private volatile boolean symmetricHandlerAdded = false;
    private List<ByteBuf> chunkBuffers = new ArrayList<ByteBuf>();
    private final AtomicReference<AsymmetricSecurityHeader> headerRef = new AtomicReference();
    private final int maxChunkCount;
    private final int maxChunkSize;
    private final UaTcpStackServer server;
    private final SerializationQueue serializationQueue;

    public UaTcpServerAsymmetricHandler(UaTcpStackServer server, SerializationQueue serializationQueue) {
        this.server = server;
        this.serializationQueue = serializationQueue;
        this.maxChunkCount = serializationQueue.getParameters().getLocalMaxChunkCount();
        this.maxChunkSize = serializationQueue.getParameters().getLocalReceiveBufferSize();
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        block4: while (buffer.readableBytes() >= 8 && buffer.readableBytes() >= this.getMessageLength(buffer)) {
            int messageLength = this.getMessageLength(buffer);
            MessageType messageType = MessageType.fromMediumInt((int)buffer.getMedium(buffer.readerIndex()));
            switch (messageType) {
                case OpenSecureChannel: {
                    this.onOpenSecureChannel(ctx, buffer.readSlice(messageLength));
                    continue block4;
                }
                case CloseSecureChannel: {
                    this.logger.debug("Received CloseSecureChannelRequest");
                    if (this.secureChannel != null) {
                        this.server.closeSecureChannel(this.secureChannel);
                    }
                    buffer.skipBytes(messageLength);
                    continue block4;
                }
            }
            throw new UaException(2155741184L, "unexpected MessageType: " + messageType);
        }
    }

    private void onOpenSecureChannel(final ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        buffer.skipBytes(3);
        char chunkType = (char)buffer.readByte();
        if (chunkType == 'A') {
            this.chunkBuffers.forEach(ReferenceCounted::release);
            this.chunkBuffers.clear();
            this.headerRef.set(null);
        } else {
            int chunkSize;
            buffer.skipBytes(4);
            final long secureChannelId = buffer.readUnsignedInt();
            AsymmetricSecurityHeader securityHeader = AsymmetricSecurityHeader.decode((ByteBuf)buffer);
            if (secureChannelId == 0L) {
                String endpointUrl = (String)ctx.channel().attr(UaTcpServerHelloHandler.ENDPOINT_URL_KEY).get();
                String securityPolicyUri = securityHeader.getSecurityPolicyUri();
                EndpointDescription endpointDescription = Arrays.stream(this.server.getEndpointDescriptions()).filter(e -> {
                    String s1 = EndpointUtil.getPath((String)endpointUrl);
                    String s2 = EndpointUtil.getPath((String)e.getEndpointUrl());
                    boolean uriMatch = s1.equals(s2);
                    boolean policyMatch = e.getSecurityPolicyUri().equals(securityPolicyUri);
                    return uriMatch && policyMatch;
                }).findFirst().orElse(null);
                if (endpointDescription == null && !this.server.getConfig().isStrictEndpointUrlsEnabled()) {
                    endpointDescription = Arrays.stream(this.server.getEndpointDescriptions()).filter(e -> e.getSecurityPolicyUri().equals(securityPolicyUri)).findFirst().orElse(null);
                }
                if (endpointDescription == null) {
                    throw new UaException(2148728832L, "SecurityPolicy URI did not match");
                }
                this.secureChannel = this.server.openSecureChannel();
                this.secureChannel.setEndpointDescription(endpointDescription);
            } else {
                this.secureChannel = this.server.getSecureChannel(secureChannelId);
                if (this.secureChannel == null) {
                    throw new UaException(2155806720L, "unknown secure channel id: " + secureChannelId);
                }
                if (!this.secureChannel.getRemoteCertificateChainBytes().equals((Object)securityHeader.getSenderCertificate())) {
                    throw new UaException(2148728832L, "certificate requesting renewal did not match existing certificate.");
                }
                Channel boundChannel = (Channel)this.secureChannel.attr(UaTcpStackServer.BoundChannelKey).get();
                if (boundChannel != null && boundChannel != ctx.channel()) {
                    throw new UaException(2148728832L, "received a renewal request from channel other than the bound channel.");
                }
            }
            if (!this.headerRef.compareAndSet(null, securityHeader) && !securityHeader.equals((Object)this.headerRef.get())) {
                throw new UaException(2148728832L, "subsequent AsymmetricSecurityHeader did not match");
            }
            SecurityPolicy securityPolicy = SecurityPolicy.fromUri((String)securityHeader.getSecurityPolicyUri());
            this.secureChannel.setSecurityPolicy(securityPolicy);
            if (securityPolicy != SecurityPolicy.None) {
                this.secureChannel.setRemoteCertificate(securityHeader.getSenderCertificate().bytesOrEmpty());
                CertificateValidator certificateValidator = this.server.getCertificateValidator();
                certificateValidator.validate(this.secureChannel.getRemoteCertificate());
                certificateValidator.verifyTrustChain(this.secureChannel.getRemoteCertificateChain());
                CertificateManager certificateManager = this.server.getCertificateManager();
                Optional localCertificateChain = certificateManager.getCertificateChain(securityHeader.getReceiverThumbprint());
                Optional keyPair = certificateManager.getKeyPair(securityHeader.getReceiverThumbprint());
                if (localCertificateChain.isPresent() && keyPair.isPresent()) {
                    X509Certificate[] chain = (X509Certificate[])localCertificateChain.get();
                    this.secureChannel.setLocalCertificate(chain[0]);
                    this.secureChannel.setLocalCertificateChain(chain);
                    this.secureChannel.setKeyPair((KeyPair)keyPair.get());
                } else {
                    throw new UaException(2148728832L, "no certificate for provided thumbprint");
                }
            }
            if ((chunkSize = buffer.readerIndex(0).readableBytes()) > this.maxChunkSize) {
                throw new UaException(0x80800000L, String.format("max chunk size exceeded (%s)", this.maxChunkSize));
            }
            this.chunkBuffers.add(buffer.retain());
            if (this.maxChunkCount > 0 && this.chunkBuffers.size() > this.maxChunkCount) {
                throw new UaException(0x80800000L, String.format("max chunk count exceeded (%s)", this.maxChunkCount));
            }
            if (chunkType == 'F') {
                final List<ByteBuf> buffersToDecode = this.chunkBuffers;
                this.chunkBuffers = new ArrayList<ByteBuf>();
                this.headerRef.set(null);
                this.serializationQueue.decode((binaryDecoder, chunkDecoder) -> chunkDecoder.decodeAsymmetric((SecureChannel)this.secureChannel, buffersToDecode, new ChunkDecoder.Callback(){

                    public void onDecodingError(UaException ex) {
                        UaTcpServerAsymmetricHandler.this.logger.error("Error decoding asymmetric message: {}", (Object)ex.getMessage(), (Object)ex);
                        ctx.close();
                    }

                    public void onMessageAborted(MessageAbortedException ex) {
                        UaTcpServerAsymmetricHandler.this.logger.warn("Asymmetric message aborted. error={} reason={}", (Object)ex.getStatusCode(), (Object)ex.getMessage());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onMessageDecoded(ByteBuf message, long requestId) {
                        try {
                            OpenSecureChannelRequest request = (OpenSecureChannelRequest)binaryDecoder.setBuffer(message).readMessage(null);
                            UaTcpServerAsymmetricHandler.this.logger.debug("Received OpenSecureChannelRequest ({}, id={}).", (Object)request.getRequestType(), (Object)secureChannelId);
                            UaTcpServerAsymmetricHandler.this.installSecurityToken(ctx, request, requestId);
                        }
                        catch (UaException e) {
                            UaTcpServerAsymmetricHandler.this.logger.error("Error installing security token: {}", (Object)e.getStatusCode(), (Object)e);
                            ctx.close();
                        }
                        catch (Throwable t) {
                            UaTcpServerAsymmetricHandler.this.logger.error("Error decoding OpenSecureChannelRequest", t);
                            ctx.close();
                        }
                        finally {
                            message.release();
                            buffersToDecode.clear();
                        }
                    }
                }));
            }
        }
    }

    private void installSecurityToken(ChannelHandlerContext ctx, OpenSecureChannelRequest request, long requestId) throws UaException {
        ChannelSecurity oldSecrets;
        SecurityTokenRequestType requestType = request.getRequestType();
        if (requestType == SecurityTokenRequestType.Issue) {
            this.secureChannel.setMessageSecurityMode(request.getSecurityMode());
        } else if (requestType == SecurityTokenRequestType.Renew && this.secureChannel.getMessageSecurityMode() != request.getSecurityMode()) {
            throw new UaException(2148728832L, "secure channel renewal requested a different MessageSecurityMode.");
        }
        long channelLifetime = request.getRequestedLifetime().longValue();
        channelLifetime = Math.min(86400000L, channelLifetime);
        channelLifetime = Math.max(3600000L, channelLifetime);
        ChannelSecurityToken newToken = new ChannelSecurityToken(Unsigned.uint((long)this.secureChannel.getChannelId()), Unsigned.uint((long)this.server.nextTokenId()), DateTime.now(), Unsigned.uint((long)channelLifetime));
        ChannelSecurity.SecuritySecrets newKeys = null;
        if (this.secureChannel.isSymmetricSigningEnabled()) {
            ByteString remoteNonce = request.getClientNonce();
            if (remoteNonce == null || remoteNonce.isNull()) {
                throw new UaException(2148728832L, "remote nonce must be non-null");
            }
            if (remoteNonce.length() < NonceUtil.getNonceLength((SecurityPolicy)this.secureChannel.getSecurityPolicy())) {
                String message = String.format("remote nonce length must be at least %d bytes", NonceUtil.getNonceLength((SecurityPolicy)this.secureChannel.getSecurityPolicy()));
                throw new UaException(2148728832L, message);
            }
            ByteString localNonce = NonceUtil.generateNonce((SecurityPolicy)this.secureChannel.getSecurityPolicy());
            this.secureChannel.setLocalNonce(localNonce);
            this.secureChannel.setRemoteNonce(remoteNonce);
            newKeys = ChannelSecurity.generateKeyPair((SecureChannel)this.secureChannel, (ByteString)this.secureChannel.getRemoteNonce(), (ByteString)this.secureChannel.getLocalNonce());
        }
        ChannelSecurity.SecuritySecrets oldKeys = (oldSecrets = this.secureChannel.getChannelSecurity()) != null ? oldSecrets.getCurrentKeys() : null;
        ChannelSecurityToken oldToken = oldSecrets != null ? oldSecrets.getCurrentToken() : null;
        ChannelSecurity newSecrets = new ChannelSecurity(newKeys, newToken, oldKeys, oldToken);
        this.secureChannel.setChannelSecurity(newSecrets);
        ResponseHeader responseHeader = new ResponseHeader(DateTime.now(), request.getRequestHeader().getRequestHandle(), StatusCode.GOOD, null, null, null);
        OpenSecureChannelResponse response = new OpenSecureChannelResponse(responseHeader, Unsigned.uint((long)0L), newToken, this.secureChannel.getLocalNonce());
        this.sendOpenSecureChannelResponse(ctx, requestId, response);
    }

    private void sendOpenSecureChannelResponse(final ChannelHandlerContext ctx, long requestId, final OpenSecureChannelResponse response) {
        this.serializationQueue.encode((writer, chunkEncoder) -> {
            ByteBuf messageBuffer = BufferUtil.buffer();
            try {
                writer.setBuffer(messageBuffer);
                writer.writeMessage(null, (UaMessage)response);
                this.checkMessageSize(messageBuffer);
                chunkEncoder.encodeAsymmetric((SecureChannel)this.secureChannel, requestId, messageBuffer, MessageType.OpenSecureChannel, new ChunkEncoder.Callback(){

                    public void onEncodingError(UaException ex) {
                        UaTcpServerAsymmetricHandler.this.logger.error("Error encoding OpenSecureChannelResponse: {}", (Object)ex.getMessage(), (Object)ex);
                        ctx.fireExceptionCaught((Throwable)ex);
                    }

                    public void onMessageEncoded(List<ByteBuf> messageChunks, long requestId) {
                        if (!UaTcpServerAsymmetricHandler.this.symmetricHandlerAdded) {
                            UaTcpServerSymmetricHandler symmetricHandler = new UaTcpServerSymmetricHandler(UaTcpServerAsymmetricHandler.this.server, UaTcpServerAsymmetricHandler.this.serializationQueue, UaTcpServerAsymmetricHandler.this.secureChannel);
                            ctx.pipeline().addFirst(new ChannelHandler[]{symmetricHandler});
                            UaTcpServerAsymmetricHandler.this.symmetricHandlerAdded = true;
                        }
                        CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
                        for (ByteBuf chunk : messageChunks) {
                            chunkComposite.addComponent(chunk);
                            chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
                        }
                        ctx.writeAndFlush((Object)chunkComposite, ctx.voidPromise());
                        long lifetime = response.getSecurityToken().getRevisedLifetime().longValue();
                        UaTcpServerAsymmetricHandler.this.server.secureChannelIssuedOrRenewed(UaTcpServerAsymmetricHandler.this.secureChannel, lifetime);
                        UaTcpServerAsymmetricHandler.this.logger.debug("Sent OpenSecureChannelResponse.");
                    }
                });
            }
            catch (UaSerializationException e) {
                ctx.fireExceptionCaught((Throwable)e);
            }
            finally {
                messageBuffer.release();
            }
        });
    }

    private void checkMessageSize(ByteBuf messageBuffer) throws UaSerializationException {
        int messageSize = messageBuffer.readableBytes();
        int remoteMaxMessageSize = this.serializationQueue.getParameters().getRemoteMaxMessageSize();
        if (remoteMaxMessageSize > 0 && messageSize > remoteMaxMessageSize) {
            throw new UaSerializationException(2159607808L, "response exceeds remote max message size: " + messageSize + " > " + remoteMaxMessageSize);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.chunkBuffers.forEach(ReferenceCountUtil::safeRelease);
        this.chunkBuffers.clear();
        if (cause instanceof IOException) {
            ctx.close();
            this.logger.debug("[remote={}] IOException caught; channel closed");
        } else {
            ErrorMessage errorMessage = ExceptionHandler.sendErrorMessage((ChannelHandlerContext)ctx, (Throwable)cause);
            if (cause instanceof UaException) {
                this.logger.debug("[remote={}] UaException caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            } else {
                this.logger.error("[remote={}] Exception caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            }
        }
    }
}

