/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.handlers;

import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.ExceptionHandler;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.AcknowledgeMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.ErrorMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.HelloMessage;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.TcpMessageEncoder;
import org.eclipse.milo.opcua.stack.server.handlers.UaTcpServerAsymmetricHandler;
import org.eclipse.milo.opcua.stack.server.tcp.UaTcpStackServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTcpServerHelloHandler
extends ByteToMessageDecoder
implements HeaderDecoder {
    public static final AttributeKey<String> ENDPOINT_URL_KEY = AttributeKey.valueOf((String)"endpoint-url");
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final Function<String, Optional<UaTcpStackServer>> serverLookup;

    public UaTcpServerHelloHandler(Function<String, Optional<UaTcpStackServer>> serverLookup) {
        this.serverLookup = serverLookup;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        block3: while (buffer.readableBytes() >= 8 && buffer.readableBytes() >= this.getMessageLength(buffer)) {
            int messageLength = this.getMessageLength(buffer);
            MessageType messageType = MessageType.fromMediumInt((int)buffer.getMedium(buffer.readerIndex()));
            switch (messageType) {
                case Hello: {
                    this.onHello(ctx, buffer.readSlice(messageLength));
                    continue block3;
                }
            }
            throw new UaException(2155741184L, "unexpected MessageType: " + messageType);
        }
    }

    private void onHello(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        this.logger.debug("[remote={}] Received Hello message.", (Object)ctx.channel().remoteAddress());
        HelloMessage hello = TcpMessageDecoder.decodeHello((ByteBuf)buffer);
        UaTcpStackServer server = this.serverLookup.apply(hello.getEndpointUrl()).orElseThrow(() -> new UaException(0x80830000L, "unrecognized endpoint url: " + hello.getEndpointUrl()));
        ctx.channel().attr(ENDPOINT_URL_KEY).set((Object)hello.getEndpointUrl());
        long remoteProtocolVersion = hello.getProtocolVersion();
        long remoteReceiveBufferSize = hello.getReceiveBufferSize();
        long remoteSendBufferSize = hello.getSendBufferSize();
        long remoteMaxMessageSize = hello.getMaxMessageSize();
        long remoteMaxChunkCount = hello.getMaxChunkCount();
        if (remoteProtocolVersion < 0L) {
            throw new UaException(2159935488L, "unsupported protocol version: " + remoteProtocolVersion);
        }
        ChannelConfig config = server.getChannelConfig();
        long localReceiveBufferSize = Math.min(remoteSendBufferSize, (long)config.getMaxChunkSize());
        long localSendBufferSize = Math.min(remoteReceiveBufferSize, (long)config.getMaxChunkSize());
        long localMaxChunkCount = config.getMaxChunkCount();
        long localMaxMessageSize = Math.min(localReceiveBufferSize * localMaxChunkCount, (long)config.getMaxMessageSize());
        ChannelParameters parameters = new ChannelParameters(Ints.saturatedCast((long)localMaxMessageSize), Ints.saturatedCast((long)localReceiveBufferSize), Ints.saturatedCast((long)localSendBufferSize), Ints.saturatedCast((long)localMaxChunkCount), Ints.saturatedCast((long)remoteMaxMessageSize), Ints.saturatedCast((long)remoteReceiveBufferSize), Ints.saturatedCast((long)remoteSendBufferSize), Ints.saturatedCast((long)remoteMaxChunkCount));
        int maxArrayLength = config.getMaxArrayLength();
        int maxStringLength = config.getMaxStringLength();
        SerializationQueue serializationQueue = new SerializationQueue(server.getConfig().getExecutor(), parameters, maxArrayLength, maxStringLength);
        ctx.pipeline().addLast(new ChannelHandler[]{new UaTcpServerAsymmetricHandler(server, serializationQueue)});
        ctx.pipeline().remove((ChannelHandler)this);
        this.logger.debug("[remote={}] Removed HelloHandler, added AsymmetricHandler.", (Object)ctx.channel().remoteAddress());
        AcknowledgeMessage acknowledge = new AcknowledgeMessage(0L, localReceiveBufferSize, localSendBufferSize, localMaxMessageSize, localMaxChunkCount);
        ByteBuf messageBuffer = TcpMessageEncoder.encode((AcknowledgeMessage)acknowledge);
        ctx.executor().execute(() -> ctx.writeAndFlush((Object)messageBuffer));
        this.logger.debug("[remote={}] Sent Acknowledge message.", (Object)ctx.channel().remoteAddress());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof IOException) {
            ctx.close();
            this.logger.debug("[remote={}] IOException caught; channel closed");
        } else {
            ErrorMessage errorMessage = ExceptionHandler.sendErrorMessage((ChannelHandlerContext)ctx, (Throwable)cause);
            if (cause instanceof UaException) {
                this.logger.debug("[remote={}] UaException caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            } else {
                this.logger.error("[remote={}] Exception caught; sent {}", new Object[]{ctx.channel().remoteAddress(), errorMessage, cause});
            }
        }
    }
}

