/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.tcp;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import java.net.InetAddress;
import java.net.URI;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.application.CertificateManager;
import org.eclipse.milo.opcua.stack.core.application.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.application.UaStackServer;
import org.eclipse.milo.opcua.stack.core.application.services.AttributeServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.DiscoveryServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.MethodServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.MonitoredItemServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.QueryServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceRequestHandler;
import org.eclipse.milo.opcua.stack.core.application.services.ServiceResponse;
import org.eclipse.milo.opcua.stack.core.application.services.SessionServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.SubscriptionServiceSet;
import org.eclipse.milo.opcua.stack.core.application.services.ViewServiceSet;
import org.eclipse.milo.opcua.stack.core.channel.ChannelConfig;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.eclipse.milo.opcua.stack.server.Endpoint;
import org.eclipse.milo.opcua.stack.server.config.UaTcpStackServerConfig;
import org.eclipse.milo.opcua.stack.server.tcp.SocketServers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTcpStackServer
implements UaStackServer {
    public static final AttributeKey<Channel> BoundChannelKey = AttributeKey.valueOf((String)"bound-channel");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicLong channelIds = new AtomicLong();
    private final AtomicLong tokenIds = new AtomicLong();
    private final Map<Class<? extends UaRequestMessage>, ServiceRequestHandler<UaRequestMessage, UaResponseMessage>> handlers = Maps.newConcurrentMap();
    private final Map<Long, ServerSecureChannel> secureChannels = Maps.newConcurrentMap();
    private final ListMultimap<Long, ServiceResponse> responseQueues = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final List<Endpoint> endpoints = Lists.newCopyOnWriteArrayList();
    private final Set<String> discoveryUrls = Sets.newConcurrentHashSet();
    private final HashedWheelTimer wheelTimer = Stack.sharedWheelTimer();
    private final Map<Long, Timeout> timeouts = Maps.newConcurrentMap();
    private final UaTcpStackServerConfig config;

    public UaTcpStackServer(UaTcpStackServerConfig config) {
        this.config = config;
        this.addServiceSet(new DefaultDiscoveryServiceSet());
        this.addServiceSet(new AttributeServiceSet(){});
        this.addServiceSet(new MethodServiceSet(){});
        this.addServiceSet(new MonitoredItemServiceSet(){});
        this.addServiceSet(new NodeManagementServiceSet(){});
        this.addServiceSet(new QueryServiceSet(){});
        this.addServiceSet(new SessionServiceSet(){});
        this.addServiceSet(new SubscriptionServiceSet(){});
        this.addServiceSet(new ViewServiceSet(){});
    }

    public UaTcpStackServerConfig getConfig() {
        return this.config;
    }

    public CompletableFuture<UaTcpStackServer> startup() {
        Stream<CompletableFuture> stream = this.endpoints.stream().map(endpoint -> {
            URI endpointUri = endpoint.getEndpointUri();
            String bindAddress = endpoint.getBindAddress().orElse(endpointUri.getHost());
            int bindPort = endpointUri.getPort();
            CompletableFuture<Unit> future = SocketServers.bindServer(this, bindAddress, bindPort);
            future.thenRun(() -> {
                this.logger.info("{} bound to {}:{} [{}/{}]", new Object[]{endpoint.getEndpointUri(), bindAddress, bindPort, endpoint.getSecurityPolicy(), endpoint.getMessageSecurity()});
                this.addDiscoveryUrl(endpointUri);
            });
            return future;
        });
        return FutureUtils.sequence(stream).thenApply(v -> this);
    }

    private void addDiscoveryUrl(URI endpointUri) {
        String serverName = this.config.getServerName();
        StringBuilder discoveryUrl = new StringBuilder();
        discoveryUrl.append("opc.tcp://").append(endpointUri.getHost()).append(":").append(endpointUri.getPort());
        if (!serverName.isEmpty()) {
            discoveryUrl.append("/").append(serverName);
        }
        this.discoveryUrls.add(discoveryUrl.toString());
    }

    public CompletableFuture<UaTcpStackServer> shutdown() {
        Stream<CompletableFuture> stream = this.endpoints.stream().map(endpoint -> {
            URI endpointUri = endpoint.getEndpointUri();
            String bindAddress = endpoint.getBindAddress().orElse(endpointUri.getHost());
            int bindPort = endpointUri.getPort();
            return SocketServers.unbindServer(this, bindAddress, bindPort);
        });
        return ((CompletableFuture)FutureUtils.sequence(stream).thenCompose(ignored -> {
            ArrayList channels = Lists.newArrayList(this.secureChannels.values());
            Stream<CompletableFuture> futures = channels.stream().map(this::closeSecureChannel);
            return FutureUtils.sequence(futures);
        })).thenApply(ignored -> this);
    }

    public void receiveRequest(ServiceRequest<UaRequestMessage, UaResponseMessage> serviceRequest) {
        this.logger.trace("Received {} on {}.", serviceRequest, (Object)serviceRequest.getSecureChannel());
        serviceRequest.getFuture().whenComplete((response, throwable) -> {
            long requestId = serviceRequest.getRequestId();
            UaRequestMessage request = serviceRequest.getRequest();
            ServiceResponse serviceResponse = response != null ? new ServiceResponse(request, requestId, response) : new ServiceResponse(request, requestId, serviceRequest.createServiceFault(throwable));
            ServerSecureChannel secureChannel = serviceRequest.getSecureChannel();
            boolean secureChannelValid = this.secureChannels.containsKey(secureChannel.getChannelId());
            if (secureChannelValid) {
                Channel channel = (Channel)secureChannel.attr(BoundChannelKey).get();
                if (channel != null) {
                    if (serviceResponse.isServiceFault()) {
                        this.logger.debug("Sending {} on {}.", (Object)serviceResponse, (Object)secureChannel);
                    } else {
                        this.logger.trace("Sending {} on {}.", (Object)serviceResponse, (Object)secureChannel);
                    }
                    channel.writeAndFlush((Object)serviceResponse, channel.voidPromise());
                } else {
                    this.logger.trace("Queueing {} for unbound {}.", (Object)serviceResponse, (Object)secureChannel);
                    this.responseQueues.put((Object)secureChannel.getChannelId(), (Object)serviceResponse);
                }
            }
        });
        Class<?> requestClass = serviceRequest.getRequest().getClass();
        ServiceRequestHandler<UaRequestMessage, UaResponseMessage> handler = this.handlers.get(requestClass);
        try {
            if (handler != null) {
                handler.handle(serviceRequest);
            } else {
                serviceRequest.setServiceFault(0x800B0000L);
            }
        }
        catch (UaException e) {
            serviceRequest.setServiceFault(e);
        }
        catch (Throwable t) {
            this.logger.error("Uncaught Throwable executing ServiceRequestHandler: {}", handler, (Object)t);
            serviceRequest.setServiceFault(0x80020000L);
        }
    }

    public ApplicationDescription getApplicationDescription() {
        return new ApplicationDescription(this.config.getApplicationUri(), this.config.getProductUri(), this.config.getApplicationName(), ApplicationType.Server, null, null, (String[])ConversionUtil.a((List)Lists.newArrayList(this.discoveryUrls), String.class));
    }

    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public EndpointDescription[] getEndpointDescriptions() {
        return (EndpointDescription[])this.getEndpoints().stream().map(this::mapEndpoint).toArray(EndpointDescription[]::new);
    }

    public SignedSoftwareCertificate[] getSoftwareCertificates() {
        List<SignedSoftwareCertificate> softwareCertificates = this.config.getSoftwareCertificates();
        return softwareCertificates.toArray(new SignedSoftwareCertificate[softwareCertificates.size()]);
    }

    public List<UserTokenPolicy> getUserTokenPolicies() {
        return this.config.getUserTokenPolicies();
    }

    public List<String> getEndpointUrls() {
        return this.endpoints.stream().map(e -> e.getEndpointUri().toString()).collect(Collectors.toList());
    }

    public Set<String> getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    public CertificateManager getCertificateManager() {
        return this.config.getCertificateManager();
    }

    public CertificateValidator getCertificateValidator() {
        return this.config.getCertificateValidator();
    }

    public ExecutorService getExecutorService() {
        return this.config.getExecutor();
    }

    public ChannelConfig getChannelConfig() {
        return this.config.getChannelConfig();
    }

    private long nextChannelId() {
        return this.channelIds.incrementAndGet();
    }

    public long nextTokenId() {
        return this.tokenIds.incrementAndGet();
    }

    public ServerSecureChannel openSecureChannel() {
        ServerSecureChannel channel = new ServerSecureChannel();
        channel.setChannelId(this.nextChannelId());
        long channelId = channel.getChannelId();
        this.secureChannels.put(channelId, channel);
        return channel;
    }

    public CompletableFuture<Unit> closeSecureChannel(ServerSecureChannel secureChannel) {
        Channel channel;
        long channelId = secureChannel.getChannelId();
        if (this.secureChannels.remove(channelId) != null) {
            this.logger.debug("Removed secure channel id={}", (Object)channelId);
        }
        if ((channel = (Channel)secureChannel.attr(BoundChannelKey).get()) != null) {
            this.logger.debug("Closing secure channel id={}, bound channel: {}", (Object)channelId, (Object)channel);
            CompletableFuture<Unit> closeFuture = new CompletableFuture<Unit>();
            channel.close().addListener(future -> closeFuture.complete(Unit.VALUE));
            return closeFuture;
        }
        return CompletableFuture.completedFuture(Unit.VALUE);
    }

    public void secureChannelIssuedOrRenewed(ServerSecureChannel secureChannel, long lifetimeMillis) {
        boolean cancelled;
        long channelId = secureChannel.getChannelId();
        Timeout timeout = this.timeouts.remove(channelId);
        boolean bl = cancelled = timeout == null || timeout.cancel();
        if (cancelled) {
            timeout = this.wheelTimer.newTimeout(t -> this.closeSecureChannel(secureChannel), lifetimeMillis, TimeUnit.MILLISECONDS);
            this.timeouts.put(channelId, timeout);
            Channel channel = (Channel)secureChannel.attr(BoundChannelKey).get();
            if (channel != null) {
                List responses = this.responseQueues.removeAll((Object)channelId);
                responses.forEach(arg_0 -> ((Channel)channel).write(arg_0));
                channel.flush();
            }
        }
    }

    public ServerSecureChannel getSecureChannel(long channelId) {
        return this.secureChannels.get(channelId);
    }

    public <T extends UaRequestMessage, U extends UaResponseMessage> void addRequestHandler(Class<T> requestClass, ServiceRequestHandler<T, U> requestHandler) {
        ServiceRequestHandler<T, U> handler = requestHandler;
        this.handlers.put(requestClass, handler);
    }

    public UaTcpStackServer addEndpoint(String endpointUri, String bindAddress, X509Certificate certificate, SecurityPolicy securityPolicy, MessageSecurityMode messageSecurity) {
        boolean invalidConfiguration;
        boolean bl = invalidConfiguration = messageSecurity == MessageSecurityMode.Invalid || securityPolicy == SecurityPolicy.None && messageSecurity != MessageSecurityMode.None || securityPolicy != SecurityPolicy.None && messageSecurity == MessageSecurityMode.None;
        if (invalidConfiguration) {
            this.logger.warn("Invalid configuration, ignoring: {} + {}", (Object)securityPolicy, (Object)messageSecurity);
        } else {
            try {
                URI uri = new URI(endpointUri);
                this.endpoints.add(new Endpoint(uri, bindAddress, certificate, securityPolicy, messageSecurity));
            }
            catch (Throwable e) {
                this.logger.warn("Invalid endpoint URI, ignoring: {}", (Object)endpointUri);
            }
        }
        return this;
    }

    private EndpointDescription mapEndpoint(Endpoint endpoint) {
        List<UserTokenPolicy> userTokenPolicies = this.config.getUserTokenPolicies();
        return new EndpointDescription(endpoint.getEndpointUri().toString(), this.getApplicationDescription(), this.certificateByteString(endpoint.getCertificate()), endpoint.getMessageSecurity(), endpoint.getSecurityPolicy().getSecurityPolicyUri(), userTokenPolicies.toArray(new UserTokenPolicy[userTokenPolicies.size()]), "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary", Unsigned.ubyte((short)endpoint.getSecurityLevel()));
    }

    private ByteString certificateByteString(Optional<X509Certificate> certificate) {
        if (certificate.isPresent()) {
            try {
                return ByteString.of((byte[])certificate.get().getEncoded());
            }
            catch (CertificateEncodingException e) {
                this.logger.error("Error decoding certificate.", (Throwable)e);
                return ByteString.NULL_VALUE;
            }
        }
        return ByteString.NULL_VALUE;
    }

    private class DefaultDiscoveryServiceSet
    implements DiscoveryServiceSet {
        private DefaultDiscoveryServiceSet() {
        }

        public void onGetEndpoints(ServiceRequest<GetEndpointsRequest, GetEndpointsResponse> serviceRequest) {
            GetEndpointsRequest request = (GetEndpointsRequest)serviceRequest.getRequest();
            ArrayList profileUris = request.getProfileUris() != null ? Lists.newArrayList((Object[])request.getProfileUris()) : new ArrayList();
            List allEndpoints = UaTcpStackServer.this.endpoints.stream().map(endpoint -> {
                List<UserTokenPolicy> userTokenPolicies = UaTcpStackServer.this.config.getUserTokenPolicies();
                return new EndpointDescription(endpoint.getEndpointUri().toString(), this.getFilteredApplicationDescription(request.getEndpointUrl()), UaTcpStackServer.this.certificateByteString(endpoint.getCertificate()), endpoint.getMessageSecurity(), endpoint.getSecurityPolicy().getSecurityPolicyUri(), userTokenPolicies.toArray(new UserTokenPolicy[userTokenPolicies.size()]), "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary", Unsigned.ubyte((short)endpoint.getSecurityLevel()));
            }).filter(ed -> this.filterProfileUris((EndpointDescription)ed, profileUris)).collect(Collectors.toList());
            List matchingEndpoints = allEndpoints.stream().filter(ed -> this.filterEndpointUrls((EndpointDescription)ed, request.getEndpointUrl())).collect(Collectors.toList());
            GetEndpointsResponse response = new GetEndpointsResponse(serviceRequest.createResponseHeader(), matchingEndpoints.isEmpty() ? (EndpointDescription[])ConversionUtil.a(allEndpoints, EndpointDescription.class) : (EndpointDescription[])ConversionUtil.a(matchingEndpoints, EndpointDescription.class));
            serviceRequest.setResponse((UaResponseMessage)response);
        }

        private boolean filterProfileUris(EndpointDescription endpoint, List<String> profileUris) {
            return profileUris.size() == 0 || profileUris.contains(endpoint.getTransportProfileUri());
        }

        private boolean filterEndpointUrls(EndpointDescription endpoint, String endpointUrl) {
            try {
                String requestedHost = new URI(endpointUrl).parseServerAuthority().getHost();
                String endpointHost = new URI(endpoint.getEndpointUrl()).parseServerAuthority().getHost();
                return requestedHost.equalsIgnoreCase(endpointHost);
            }
            catch (Throwable e) {
                UaTcpStackServer.this.logger.debug("Unable to create URI.", e);
                return false;
            }
        }

        public void onFindServers(ServiceRequest<FindServersRequest, FindServersResponse> serviceRequest) {
            FindServersRequest request = (FindServersRequest)serviceRequest.getRequest();
            ArrayList serverUris = request.getServerUris() != null ? Lists.newArrayList((Object[])request.getServerUris()) : new ArrayList();
            List<Object> applicationDescriptions = Lists.newArrayList((Object[])new ApplicationDescription[]{this.getFilteredApplicationDescription(request.getEndpointUrl())});
            applicationDescriptions = applicationDescriptions.stream().filter(ad -> this.filterServerUris((ApplicationDescription)ad, serverUris)).collect(Collectors.toList());
            FindServersResponse response = new FindServersResponse(serviceRequest.createResponseHeader(), (ApplicationDescription[])ConversionUtil.a((List)applicationDescriptions, ApplicationDescription.class));
            serviceRequest.setResponse((UaResponseMessage)response);
        }

        private ApplicationDescription getFilteredApplicationDescription(String endpointUrl) {
            ArrayList allDiscoveryUrls = Lists.newArrayList((Iterable)UaTcpStackServer.this.discoveryUrls);
            List matchingDiscoveryUrls = allDiscoveryUrls.stream().filter(discoveryUrl -> {
                try {
                    String requestedHost = new URI(endpointUrl).parseServerAuthority().getHost();
                    String discoveryHost = new URI((String)discoveryUrl).parseServerAuthority().getHost();
                    UaTcpStackServer.this.logger.debug("requestedHost={}, discoveryHost={}", (Object)requestedHost, (Object)discoveryHost);
                    return requestedHost.equalsIgnoreCase(discoveryHost);
                }
                catch (Throwable e) {
                    UaTcpStackServer.this.logger.debug("Unable to create URI.", e);
                    return false;
                }
            }).collect(Collectors.toList());
            if (matchingDiscoveryUrls.isEmpty()) {
                matchingDiscoveryUrls = allDiscoveryUrls.stream().filter(discoveryUrl -> {
                    try {
                        String requestedHost = new URI(endpointUrl).parseServerAuthority().getHost();
                        String discoveryHost = new URI((String)discoveryUrl).parseServerAuthority().getHost();
                        InetAddress requestedHostAddress = InetAddress.getByName(requestedHost);
                        InetAddress discoveryHostAddress = InetAddress.getByName(discoveryHost);
                        UaTcpStackServer.this.logger.debug("requestedHostAddress={}, discoveryHostAddress={}", (Object)requestedHost, (Object)discoveryHost);
                        return requestedHostAddress.equals(discoveryHostAddress);
                    }
                    catch (Throwable e) {
                        UaTcpStackServer.this.logger.debug("Unable to create URI.", e);
                        return false;
                    }
                }).collect(Collectors.toList());
            }
            UaTcpStackServer.this.logger.debug("Matching discovery URLs: {}", matchingDiscoveryUrls);
            return new ApplicationDescription(UaTcpStackServer.this.config.getApplicationUri(), UaTcpStackServer.this.config.getProductUri(), UaTcpStackServer.this.config.getApplicationName(), ApplicationType.Server, null, null, matchingDiscoveryUrls.isEmpty() ? (String[])ConversionUtil.a((List)allDiscoveryUrls, String.class) : (String[])ConversionUtil.a(matchingDiscoveryUrls, String.class));
        }

        private boolean filterServerUris(ApplicationDescription ad, List<String> serverUris) {
            return serverUris.size() == 0 || serverUris.contains(ad.getApplicationUri());
        }
    }
}

