/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server;

import com.google.common.base.Strings;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import io.netty.channel.Channel;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.NamespaceTable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.DataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.DefaultDataTypeManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.AddReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CallRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CancelRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteReferencesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.DeleteSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.FindServersResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.GetEndpointsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifyMonitoredItemsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ModifySubscriptionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.PublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryFirstRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.QueryNextRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RegisterServerRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.RepublishRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetMonitoringModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetPublishingModeRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.SetTriggeringRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TranslateBrowsePathsToNodeIdsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UnregisterNodesRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.UserTokenPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteRequest;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.Lazy;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.UaStackServerConfig;
import org.eclipse.milo.opcua.stack.server.services.AttributeHistoryServiceSet;
import org.eclipse.milo.opcua.stack.server.services.AttributeServiceSet;
import org.eclipse.milo.opcua.stack.server.services.DiscoveryServiceSet;
import org.eclipse.milo.opcua.stack.server.services.MethodServiceSet;
import org.eclipse.milo.opcua.stack.server.services.MonitoredItemServiceSet;
import org.eclipse.milo.opcua.stack.server.services.NodeManagementServiceSet;
import org.eclipse.milo.opcua.stack.server.services.QueryServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequestHandler;
import org.eclipse.milo.opcua.stack.server.services.SessionServiceSet;
import org.eclipse.milo.opcua.stack.server.services.SubscriptionServiceSet;
import org.eclipse.milo.opcua.stack.server.services.ViewServiceSet;
import org.eclipse.milo.opcua.stack.server.transport.ServerChannelManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaStackServer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ServiceHandlerTable serviceHandlerTable = new ServiceHandlerTable();
    private final Lazy<ApplicationDescription> applicationDescription = new Lazy();
    private final DataTypeManager dataTypeManager = new DefaultDataTypeManager();
    private final NamespaceTable namespaceTable = new NamespaceTable();
    private final AtomicLong channelIds = new AtomicLong();
    private final AtomicLong tokenIds = new AtomicLong();
    private final List<Channel> channels = new CopyOnWriteArrayList<Channel>();
    private final ServerChannelManager channelManager;
    private final SerializationContext serializationContext;
    private final UaStackServerConfig config;

    public UaStackServer(final UaStackServerConfig config) {
        this.config = config;
        this.channelManager = new ServerChannelManager(this);
        this.serializationContext = new SerializationContext(){

            public EncodingLimits getEncodingLimits() {
                return config.getEncodingLimits();
            }

            public NamespaceTable getNamespaceTable() {
                return UaStackServer.this.namespaceTable;
            }

            public DataTypeManager getDataTypeManager() {
                return UaStackServer.this.dataTypeManager;
            }
        };
        config.getEndpoints().forEach(endpoint -> {
            String path = EndpointUtil.getPath((String)endpoint.getEndpointUrl());
            this.addServiceSet(path, new DefaultDiscoveryServiceSet());
        });
    }

    public UaStackServerConfig getConfig() {
        return this.config;
    }

    public CompletableFuture<UaStackServer> startup() {
        ArrayList futures = new ArrayList();
        this.config.getEndpoints().stream().sorted(Comparator.comparing(EndpointConfiguration::getTransportProfile)).forEach(endpoint -> {
            this.logger.info("Binding endpoint {} to {}:{} [{}/{}]", new Object[]{endpoint.getEndpointUrl(), endpoint.getBindAddress(), endpoint.getBindPort(), endpoint.getSecurityPolicy(), endpoint.getSecurityMode()});
            futures.add(this.channelManager.bind((EndpointConfiguration)endpoint).exceptionally(ex -> {
                this.logger.warn("Bind failed for endpoint {}", (Object)endpoint.getEndpointUrl(), ex);
                return Unit.VALUE;
            }));
        });
        return FutureUtils.sequence(futures).thenApply(u -> this);
    }

    public CompletableFuture<UaStackServer> shutdown() {
        ArrayList futures = new ArrayList();
        this.config.getEndpoints().forEach(endpoint -> futures.add(this.channelManager.unbind((EndpointConfiguration)endpoint).exceptionally(ex -> {
            this.logger.warn("Unbind failed for endpoint {}", (Object)endpoint.getEndpointUrl(), ex);
            return Unit.VALUE;
        })));
        return FutureUtils.sequence(futures).thenApply(u -> this);
    }

    public NamespaceTable getNamespaceTable() {
        return this.namespaceTable;
    }

    public DataTypeManager getDataTypeManager() {
        return this.dataTypeManager;
    }

    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    public void registerConnectedChannel(Channel channel) {
        this.channels.add(channel);
    }

    public void unregisterConnectedChannel(Channel channel) {
        this.channels.remove(channel);
    }

    public List<Channel> getConnectedChannels() {
        return this.channels;
    }

    public void onServiceRequest(String path, ServiceRequest serviceRequest) {
        this.logger.trace("onServiceRequest(path={}, request={})", (Object)path, (Object)serviceRequest);
        Class<?> requestClass = serviceRequest.getRequest().getClass();
        ServiceRequestHandler serviceHandler = (ServiceRequestHandler)this.serviceHandlerTable.get(path, requestClass);
        try {
            if (serviceHandler != null) {
                serviceHandler.handle(serviceRequest);
            } else {
                serviceRequest.setServiceFault(0x800B0000L);
            }
        }
        catch (UaException e) {
            serviceRequest.setServiceFault(e);
        }
        catch (Throwable t) {
            this.logger.error("Uncaught Throwable executing handler: {}", (Object)serviceHandler, (Object)t);
            serviceRequest.setServiceFault(0x80020000L);
        }
    }

    public long getNextChannelId() {
        return this.channelIds.incrementAndGet();
    }

    public long getNextTokenId() {
        return this.tokenIds.incrementAndGet();
    }

    private ApplicationDescription getApplicationDescription() {
        return (ApplicationDescription)this.applicationDescription.getOrCompute(() -> {
            List discoveryUrls = this.config.getEndpoints().stream().map(EndpointConfiguration::getEndpointUrl).filter(url -> url.endsWith("/discovery")).collect(Collectors.toList());
            if (discoveryUrls.isEmpty()) {
                discoveryUrls = this.config.getEndpoints().stream().map(EndpointConfiguration::getEndpointUrl).collect(Collectors.toList());
            }
            return new ApplicationDescription(this.config.getApplicationUri(), this.config.getProductUri(), this.config.getApplicationName(), ApplicationType.Server, null, null, (String[])ConversionUtil.a(discoveryUrls, String.class));
        });
    }

    public ImmutableList<EndpointDescription> getEndpointDescriptions() {
        return ImmutableList.builder().addAll(this.config.getEndpoints().stream().map(this::transformEndpoint).iterator()).build();
    }

    private EndpointDescription transformEndpoint(EndpointConfiguration endpoint) {
        return new EndpointDescription(endpoint.getEndpointUrl(), this.getApplicationDescription(), this.certificateByteString(endpoint.getCertificate()), endpoint.getSecurityMode(), endpoint.getSecurityPolicy().getUri(), (UserTokenPolicy[])ConversionUtil.a(endpoint.getTokenPolicies(), UserTokenPolicy.class), endpoint.getTransportProfile().getUri(), Unsigned.ubyte((short)UaStackServer.getSecurityLevel(endpoint.getSecurityPolicy(), endpoint.getSecurityMode())));
    }

    private ByteString certificateByteString(@Nullable X509Certificate certificate) {
        if (certificate != null) {
            try {
                return ByteString.of((byte[])certificate.getEncoded());
            }
            catch (CertificateEncodingException e) {
                this.logger.error("Error decoding certificate.", (Throwable)e);
                return ByteString.NULL_VALUE;
            }
        }
        return ByteString.NULL_VALUE;
    }

    private static short getSecurityLevel(SecurityPolicy securityPolicy, MessageSecurityMode securityMode) {
        short securityLevel = 0;
        switch (securityPolicy) {
            case Aes256_Sha256_RsaPss: 
            case Basic256Sha256: {
                securityLevel = (short)(securityLevel | 8);
                break;
            }
            case Aes128_Sha256_RsaOaep: {
                securityLevel = (short)(securityLevel | 4);
                break;
            }
            case Basic256: 
            case Basic128Rsa15: {
                securityLevel = (short)(securityLevel | 1);
                break;
            }
        }
        switch (securityMode) {
            case SignAndEncrypt: {
                securityLevel = (short)(securityLevel | 0x80);
                break;
            }
            case Sign: {
                securityLevel = (short)(securityLevel | 0x40);
                break;
            }
            default: {
                securityLevel = (short)(securityLevel | 0x20);
            }
        }
        return securityLevel;
    }

    public <T extends UaRequestMessage> void addServiceHandler(String path, Class<T> requestClass, ServiceRequestHandler serviceHandler) {
        this.logger.debug("Adding ServiceHandler for {} at {}", (Object)requestClass.getSimpleName(), (Object)path);
        this.serviceHandlerTable.put(path, requestClass, serviceHandler);
    }

    public <T extends UaRequestMessage> void removeServiceHandler(String path, Class<T> requestClass) {
        this.logger.debug("Removing ServiceHandler for {} at {}", (Object)requestClass.getSimpleName(), (Object)path);
        this.serviceHandlerTable.remove(path, requestClass);
    }

    public void addServiceSet(String path, AttributeServiceSet serviceSet) {
        this.addServiceHandler(path, ReadRequest.class, serviceSet::onRead);
        this.addServiceHandler(path, WriteRequest.class, serviceSet::onWrite);
    }

    public void addServiceSet(String path, AttributeHistoryServiceSet serviceSet) {
        this.addServiceHandler(path, HistoryReadRequest.class, serviceSet::onHistoryRead);
        this.addServiceHandler(path, HistoryUpdateRequest.class, serviceSet::onHistoryUpdate);
    }

    public void addServiceSet(String path, DiscoveryServiceSet serviceSet) {
        this.addServiceHandler(path, GetEndpointsRequest.class, serviceSet::onGetEndpoints);
        this.addServiceHandler(path, FindServersRequest.class, serviceSet::onFindServers);
        this.addServiceHandler(path, RegisterServerRequest.class, serviceSet::onRegisterServer);
    }

    public void addServiceSet(String path, QueryServiceSet serviceSet) {
        this.addServiceHandler(path, QueryFirstRequest.class, serviceSet::onQueryFirst);
        this.addServiceHandler(path, QueryNextRequest.class, serviceSet::onQueryNext);
    }

    public void addServiceSet(String path, MethodServiceSet serviceSet) {
        this.addServiceHandler(path, CallRequest.class, serviceSet::onCall);
    }

    public void addServiceSet(String path, MonitoredItemServiceSet serviceSet) {
        this.addServiceHandler(path, CreateMonitoredItemsRequest.class, serviceSet::onCreateMonitoredItems);
        this.addServiceHandler(path, ModifyMonitoredItemsRequest.class, serviceSet::onModifyMonitoredItems);
        this.addServiceHandler(path, DeleteMonitoredItemsRequest.class, serviceSet::onDeleteMonitoredItems);
        this.addServiceHandler(path, SetMonitoringModeRequest.class, serviceSet::onSetMonitoringMode);
        this.addServiceHandler(path, SetTriggeringRequest.class, serviceSet::onSetTriggering);
    }

    public void addServiceSet(String path, NodeManagementServiceSet serviceSet) {
        this.addServiceHandler(path, AddNodesRequest.class, serviceSet::onAddNodes);
        this.addServiceHandler(path, DeleteNodesRequest.class, serviceSet::onDeleteNodes);
        this.addServiceHandler(path, AddReferencesRequest.class, serviceSet::onAddReferences);
        this.addServiceHandler(path, DeleteReferencesRequest.class, serviceSet::onDeleteReferences);
    }

    public void addServiceSet(String path, SessionServiceSet serviceSet) {
        this.addServiceHandler(path, CreateSessionRequest.class, serviceSet::onCreateSession);
        this.addServiceHandler(path, ActivateSessionRequest.class, serviceSet::onActivateSession);
        this.addServiceHandler(path, CloseSessionRequest.class, serviceSet::onCloseSession);
        this.addServiceHandler(path, CancelRequest.class, serviceSet::onCancel);
    }

    public void addServiceSet(String path, SubscriptionServiceSet serviceSet) {
        this.addServiceHandler(path, CreateSubscriptionRequest.class, serviceSet::onCreateSubscription);
        this.addServiceHandler(path, ModifySubscriptionRequest.class, serviceSet::onModifySubscription);
        this.addServiceHandler(path, DeleteSubscriptionsRequest.class, serviceSet::onDeleteSubscriptions);
        this.addServiceHandler(path, TransferSubscriptionsRequest.class, serviceSet::onTransferSubscriptions);
        this.addServiceHandler(path, SetPublishingModeRequest.class, serviceSet::onSetPublishingMode);
        this.addServiceHandler(path, PublishRequest.class, serviceSet::onPublish);
        this.addServiceHandler(path, RepublishRequest.class, serviceSet::onRepublish);
    }

    public void addServiceSet(String path, ViewServiceSet serviceSet) {
        this.addServiceHandler(path, BrowseRequest.class, serviceSet::onBrowse);
        this.addServiceHandler(path, BrowseNextRequest.class, serviceSet::onBrowseNext);
        this.addServiceHandler(path, TranslateBrowsePathsToNodeIdsRequest.class, serviceSet::onTranslateBrowsePaths);
        this.addServiceHandler(path, RegisterNodesRequest.class, serviceSet::onRegisterNodes);
        this.addServiceHandler(path, UnregisterNodesRequest.class, serviceSet::onUnregisterNodes);
    }

    private static class ServiceHandlerTable
    extends ForwardingTable<String, Class<? extends UaRequestMessage>, ServiceRequestHandler> {
        private final Table<String, Class<? extends UaRequestMessage>, ServiceRequestHandler> delegate = Tables.synchronizedTable((Table)HashBasedTable.create());

        private ServiceHandlerTable() {
        }

        protected Table<String, Class<? extends UaRequestMessage>, ServiceRequestHandler> delegate() {
            return this.delegate;
        }
    }

    private class DefaultDiscoveryServiceSet
    implements DiscoveryServiceSet {
        private DefaultDiscoveryServiceSet() {
        }

        @Override
        public void onGetEndpoints(ServiceRequest serviceRequest) {
            GetEndpointsRequest request = (GetEndpointsRequest)serviceRequest.getRequest();
            ArrayList profileUris = request.getProfileUris() != null ? Lists.newArrayList((Object[])request.getProfileUris()) : new ArrayList();
            List allEndpoints = UaStackServer.this.getEndpointDescriptions().stream().filter(ed -> !ed.getEndpointUrl().endsWith("/discovery")).filter(ed -> this.filterProfileUris((EndpointDescription)ed, profileUris)).collect(Collectors.toList());
            List matchingEndpoints = allEndpoints.stream().filter(endpoint -> this.filterEndpointUrls((EndpointDescription)endpoint, request.getEndpointUrl())).map(endpoint -> this.replaceApplicationDescription((EndpointDescription)endpoint, this.getFilteredApplicationDescription(request.getEndpointUrl()))).collect(Collectors.toList());
            GetEndpointsResponse response = new GetEndpointsResponse(serviceRequest.createResponseHeader(), matchingEndpoints.isEmpty() ? (EndpointDescription[])ConversionUtil.a(allEndpoints, EndpointDescription.class) : (EndpointDescription[])ConversionUtil.a(matchingEndpoints, EndpointDescription.class));
            serviceRequest.setResponse((UaResponseMessage)response);
        }

        private boolean filterProfileUris(EndpointDescription endpoint, List<String> profileUris) {
            return profileUris.size() == 0 || profileUris.contains(endpoint.getTransportProfileUri());
        }

        private boolean filterEndpointUrls(EndpointDescription endpoint, String endpointUrl) {
            try {
                String requestedHost = EndpointUtil.getHost((String)endpointUrl);
                String endpointHost = EndpointUtil.getHost((String)endpoint.getEndpointUrl());
                return Strings.nullToEmpty((String)requestedHost).equalsIgnoreCase(endpointHost);
            }
            catch (Throwable e) {
                UaStackServer.this.logger.debug("Unable to create URI.", e);
                return false;
            }
        }

        private EndpointDescription replaceApplicationDescription(EndpointDescription endpoint, ApplicationDescription applicationDescription) {
            return new EndpointDescription(endpoint.getEndpointUrl(), applicationDescription, endpoint.getServerCertificate(), endpoint.getSecurityMode(), endpoint.getSecurityPolicyUri(), endpoint.getUserIdentityTokens(), endpoint.getTransportProfileUri(), endpoint.getSecurityLevel());
        }

        @Override
        public void onFindServers(ServiceRequest serviceRequest) {
            FindServersRequest request = (FindServersRequest)serviceRequest.getRequest();
            ArrayList serverUris = request.getServerUris() != null ? Lists.newArrayList((Object[])request.getServerUris()) : new ArrayList();
            List<Object> applicationDescriptions = Lists.newArrayList((Object[])new ApplicationDescription[]{this.getFilteredApplicationDescription(request.getEndpointUrl())});
            applicationDescriptions = applicationDescriptions.stream().filter(ad -> this.filterServerUris((ApplicationDescription)ad, serverUris)).collect(Collectors.toList());
            FindServersResponse response = new FindServersResponse(serviceRequest.createResponseHeader(), (ApplicationDescription[])ConversionUtil.a((List)applicationDescriptions, ApplicationDescription.class));
            serviceRequest.setResponse((UaResponseMessage)response);
        }

        private ApplicationDescription getFilteredApplicationDescription(String endpointUrl) {
            List allDiscoveryUrls = UaStackServer.this.config.getEndpoints().stream().map(EndpointConfiguration::getEndpointUrl).filter(url -> url.endsWith("/discovery")).collect(Collectors.toList());
            if (allDiscoveryUrls.isEmpty()) {
                allDiscoveryUrls = UaStackServer.this.config.getEndpoints().stream().map(EndpointConfiguration::getEndpointUrl).collect(Collectors.toList());
            }
            List matchingDiscoveryUrls = allDiscoveryUrls.stream().filter(discoveryUrl -> {
                try {
                    String requestedHost = EndpointUtil.getHost((String)endpointUrl);
                    String discoveryHost = EndpointUtil.getHost((String)discoveryUrl);
                    UaStackServer.this.logger.debug("requestedHost={}, discoveryHost={}", (Object)requestedHost, (Object)discoveryHost);
                    return Strings.nullToEmpty((String)requestedHost).equalsIgnoreCase(discoveryHost);
                }
                catch (Throwable e) {
                    UaStackServer.this.logger.debug("Unable to create URI.", e);
                    return false;
                }
            }).collect(Collectors.toList());
            UaStackServer.this.logger.debug("Matching discovery URLs: {}", matchingDiscoveryUrls);
            return new ApplicationDescription(UaStackServer.this.config.getApplicationUri(), UaStackServer.this.config.getProductUri(), UaStackServer.this.config.getApplicationName(), ApplicationType.Server, null, null, matchingDiscoveryUrls.isEmpty() ? (String[])ConversionUtil.a(allDiscoveryUrls, String.class) : (String[])ConversionUtil.a(matchingDiscoveryUrls, String.class));
        }

        private boolean filterServerUris(ApplicationDescription ad, List<String> serverUris) {
            return serverUris.size() == 0 || serverUris.contains(ad.getApplicationUri());
        }
    }
}

