/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.core.channel.MessageLimits;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.serialization.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.UaStackServerConfigBuilder;
import org.eclipse.milo.opcua.stack.server.security.ServerCertificateValidator;

public interface UaStackServerConfig {
    public Set<EndpointConfiguration> getEndpoints();

    public LocalizedText getApplicationName();

    public String getApplicationUri();

    public String getProductUri();

    public MessageLimits getMessageLimits();

    public EncodingLimits getEncodingLimits();

    public CertificateManager getCertificateManager();

    public TrustListManager getTrustListManager();

    public ServerCertificateValidator getCertificateValidator();

    public Optional<KeyPair> getHttpsKeyPair();

    public Optional<X509Certificate> getHttpsCertificate();

    public ExecutorService getExecutor();

    public static UaStackServerConfigBuilder builder() {
        return new UaStackServerConfigBuilder();
    }

    public static UaStackServerConfigBuilder copy(UaStackServerConfig config) {
        UaStackServerConfigBuilder builder = UaStackServerConfig.builder();
        builder.setEndpoints(config.getEndpoints());
        builder.setApplicationName(config.getApplicationName());
        builder.setApplicationUri(config.getApplicationUri());
        builder.setProductUri(config.getProductUri());
        builder.setMessageLimits(config.getMessageLimits());
        builder.setEncodingLimits(config.getEncodingLimits());
        builder.setCertificateManager(config.getCertificateManager());
        builder.setTrustListManager(config.getTrustListManager());
        builder.setCertificateValidator(config.getCertificateValidator());
        builder.setHttpsKeyPair(config.getHttpsKeyPair().orElse(null));
        builder.setHttpsCertificate(config.getHttpsCertificate().orElse(null));
        builder.setExecutor(config.getExecutor());
        return builder;
    }

    public static UaStackServerConfig copy(UaStackServerConfig config, Consumer<UaStackServerConfigBuilder> consumer) {
        UaStackServerConfigBuilder builder = UaStackServerConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

