/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.transport.uasc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.ReferenceCounted;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.channel.ChunkDecoder;
import org.eclipse.milo.opcua.stack.core.channel.ChunkEncoder;
import org.eclipse.milo.opcua.stack.core.channel.MessageAbortException;
import org.eclipse.milo.opcua.stack.core.channel.MessageDecodeException;
import org.eclipse.milo.opcua.stack.core.channel.SecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.SerializationQueue;
import org.eclipse.milo.opcua.stack.core.channel.ServerSecureChannel;
import org.eclipse.milo.opcua.stack.core.channel.headers.HeaderDecoder;
import org.eclipse.milo.opcua.stack.core.channel.messages.MessageType;
import org.eclipse.milo.opcua.stack.core.serialization.UaMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.util.BufferUtil;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.server.UaStackServer;
import org.eclipse.milo.opcua.stack.server.services.ServiceRequest;
import org.eclipse.milo.opcua.stack.server.transport.uasc.UascServerAsymmetricHandler;
import org.eclipse.milo.opcua.stack.server.transport.uasc.UascServerHelloHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UascServerSymmetricHandler
extends ByteToMessageDecoder
implements HeaderDecoder {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private List<ByteBuf> chunkBuffers;
    private final int maxChunkCount;
    private final int maxChunkSize;
    private final UaStackServer stackServer;
    private final SerializationQueue serializationQueue;
    private final ServerSecureChannel secureChannel;

    UascServerSymmetricHandler(UaStackServer stackServer, SerializationQueue serializationQueue, ServerSecureChannel secureChannel) {
        this.stackServer = stackServer;
        this.serializationQueue = serializationQueue;
        this.secureChannel = secureChannel;
        this.maxChunkCount = serializationQueue.getParameters().getLocalMaxChunkCount();
        this.maxChunkSize = serializationQueue.getParameters().getLocalReceiveBufferSize();
        this.chunkBuffers = new ArrayList<ByteBuf>(this.maxChunkCount);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        if (buffer.readableBytes() >= 8) {
            int messageLength = this.getMessageLength(buffer, this.maxChunkSize);
            if (buffer.readableBytes() >= messageLength) {
                MessageType messageType = MessageType.fromMediumInt((int)buffer.getMediumLE(buffer.readerIndex()));
                if (messageType == MessageType.SecureMessage) {
                    this.onSecureMessage(ctx, buffer.readSlice(messageLength));
                } else {
                    ctx.fireChannelRead((Object)buffer.readRetainedSlice(messageLength));
                }
            }
        }
    }

    private void onSecureMessage(ChannelHandlerContext ctx, ByteBuf buffer) throws UaException {
        buffer.skipBytes(3);
        char chunkType = (char)buffer.readByte();
        if (chunkType == 'A') {
            this.chunkBuffers.forEach(ReferenceCounted::release);
            this.chunkBuffers.clear();
        } else {
            buffer.skipBytes(4);
            long secureChannelId = buffer.readUnsignedIntLE();
            if (secureChannelId != this.secureChannel.getChannelId()) {
                throw new UaException(0x80220000L, "invalid secure channel id: " + secureChannelId);
            }
            int chunkSize = buffer.readerIndex(0).readableBytes();
            if (chunkSize > this.maxChunkSize) {
                throw new UaException(0x80800000L, String.format("max chunk size exceeded (%s)", this.maxChunkSize));
            }
            this.chunkBuffers.add(buffer.retain());
            if (this.maxChunkCount > 0 && this.chunkBuffers.size() > this.maxChunkCount) {
                throw new UaException(0x80800000L, String.format("max chunk count exceeded (%s)", this.maxChunkCount));
            }
            if (chunkType == 'F') {
                List<ByteBuf> buffersToDecode = this.chunkBuffers;
                this.chunkBuffers = new ArrayList<ByteBuf>();
                this.serializationQueue.decode((binaryDecoder, chunkDecoder) -> {
                    long requestId;
                    ByteBuf message;
                    try {
                        ChunkDecoder.DecodedMessage decodedMessage = chunkDecoder.decodeSymmetric((SecureChannel)this.secureChannel, buffersToDecode);
                        message = decodedMessage.getMessage();
                        requestId = decodedMessage.getRequestId();
                    }
                    catch (MessageAbortException e) {
                        this.logger.warn("Received message abort chunk; error={}, reason={}", (Object)e.getStatusCode(), (Object)e.getMessage());
                        return;
                    }
                    catch (MessageDecodeException e) {
                        this.logger.error("Error decoding symmetric message", (Throwable)e);
                        ctx.close();
                        return;
                    }
                    try {
                        UaRequestMessage request = (UaRequestMessage)binaryDecoder.setBuffer(message).readMessage(null);
                        String endpointUrl = (String)ctx.channel().attr(UascServerHelloHandler.ENDPOINT_URL_KEY).get();
                        EndpointDescription endpoint = (EndpointDescription)ctx.channel().attr(UascServerAsymmetricHandler.ENDPOINT_KEY).get();
                        String path = EndpointUtil.getPath((String)endpointUrl);
                        InetSocketAddress remoteSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
                        ServiceRequest serviceRequest = new ServiceRequest(this.stackServer, request, endpoint, this.secureChannel.getChannelId(), remoteSocketAddress.getAddress(), this.secureChannel.getRemoteCertificateBytes());
                        serviceRequest.getFuture().whenComplete((response, fault) -> {
                            if (response != null) {
                                this.sendServiceResponse(ctx, requestId, request, (UaResponseMessage)response);
                            } else {
                                UInteger requestHandle = request.getRequestHeader().getRequestHandle();
                                this.sendServiceFault(ctx, requestId, requestHandle, (Throwable)fault);
                            }
                        });
                        this.stackServer.onServiceRequest(path, serviceRequest);
                    }
                    catch (UaSerializationException e) {
                        this.logger.error("Error decoding UaRequestMessage", (Throwable)e);
                        this.sendServiceFault(ctx, requestId, Unsigned.uint((int)0), e);
                    }
                    catch (Throwable t) {
                        this.logger.error("Unexpected error servicing UaRequestMessage", t);
                        long statusCode = UaException.extractStatusCode((Throwable)t).map(StatusCode::getValue).orElse(0x80010000L);
                        this.sendServiceFault(ctx, requestId, Unsigned.uint((int)0), new UaException(statusCode, t));
                    }
                    finally {
                        message.release();
                        buffersToDecode.clear();
                    }
                });
            }
        }
    }

    private void sendServiceResponse(final ChannelHandlerContext ctx, final long requestId, final UaRequestMessage request, final UaResponseMessage response) {
        this.serializationQueue.encode((binaryEncoder, chunkEncoder) -> {
            ByteBuf messageBuffer = BufferUtil.pooledBuffer();
            try {
                binaryEncoder.setBuffer(messageBuffer);
                binaryEncoder.writeMessage(null, (UaMessage)response);
                this.checkMessageSize(messageBuffer);
                chunkEncoder.encodeSymmetric((SecureChannel)this.secureChannel, requestId, messageBuffer, MessageType.SecureMessage, new ChunkEncoder.Callback(){

                    public void onEncodingError(UaException ex) {
                        UascServerSymmetricHandler.this.logger.error("Error encoding {}: {}", new Object[]{response, ex.getMessage(), ex});
                        UInteger requestHandle = request.getRequestHeader().getRequestHandle();
                        UascServerSymmetricHandler.this.sendServiceFault(ctx, requestId, requestHandle, ex);
                    }

                    public void onMessageEncoded(List<ByteBuf> messageChunks, long requestId2) {
                        CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
                        for (ByteBuf chunk : messageChunks) {
                            chunkComposite.addComponent(chunk);
                            chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
                        }
                        ctx.writeAndFlush((Object)chunkComposite, ctx.voidPromise());
                    }
                });
            }
            catch (UaSerializationException ex) {
                this.logger.error("Error encoding response: {}", (Object)ex.getStatusCode(), (Object)ex);
                UInteger requestHandle = request.getRequestHeader().getRequestHandle();
                this.sendServiceFault(ctx, requestId, requestHandle, ex);
            }
            finally {
                messageBuffer.release();
            }
        });
    }

    private void sendServiceFault(final ChannelHandlerContext ctx, long requestId, UInteger requestHandle, Throwable fault) {
        StatusCode statusCode = UaException.extract((Throwable)fault).map(UaException::getStatusCode).orElse(StatusCode.BAD);
        final ServiceFault serviceFault = new ServiceFault(new ResponseHeader(DateTime.now(), requestHandle, statusCode, null, null, null));
        this.serializationQueue.encode((binaryEncoder, chunkEncoder) -> {
            ByteBuf messageBuffer = BufferUtil.pooledBuffer();
            try {
                binaryEncoder.setBuffer(messageBuffer);
                binaryEncoder.writeMessage(null, (UaMessage)serviceFault);
                this.checkMessageSize(messageBuffer);
                chunkEncoder.encodeSymmetric((SecureChannel)this.secureChannel, requestId, messageBuffer, MessageType.SecureMessage, new ChunkEncoder.Callback(){

                    public void onEncodingError(UaException ex) {
                        UascServerSymmetricHandler.this.logger.error("Error encoding {}: {}", new Object[]{serviceFault, ex.getMessage(), ex});
                    }

                    public void onMessageEncoded(List<ByteBuf> messageChunks, long requestId) {
                        CompositeByteBuf chunkComposite = BufferUtil.compositeBuffer();
                        for (ByteBuf chunk : messageChunks) {
                            chunkComposite.addComponent(chunk);
                            chunkComposite.writerIndex(chunkComposite.writerIndex() + chunk.readableBytes());
                        }
                        ctx.writeAndFlush((Object)chunkComposite, ctx.voidPromise());
                    }
                });
            }
            catch (UaSerializationException ex) {
                this.logger.error("Error encoding ServiceFault: {}", (Object)ex.getStatusCode(), (Object)ex);
            }
            finally {
                messageBuffer.release();
            }
        });
    }

    private void checkMessageSize(ByteBuf messageBuffer) throws UaSerializationException {
        int messageSize = messageBuffer.readableBytes();
        int remoteMaxMessageSize = this.serializationQueue.getParameters().getRemoteMaxMessageSize();
        if (remoteMaxMessageSize > 0 && messageSize > remoteMaxMessageSize) {
            throw new UaSerializationException(2159607808L, "response exceeds remote max message size: " + messageSize + " > " + remoteMaxMessageSize);
        }
    }
}

