/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server.services;

import com.google.common.base.MoreObjects;
import io.netty.util.DefaultAttributeMap;
import java.net.InetAddress;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.server.UaStackServer;

public class ServiceRequest
extends DefaultAttributeMap {
    private final CompletableFuture<UaResponseMessage> future = new CompletableFuture();
    private final long receivedAtNanos = System.nanoTime();
    private final UaStackServer server;
    private final UaRequestMessage request;
    private final EndpointDescription endpoint;
    private final long secureChannelId;
    private final InetAddress clientAddress;
    private final ByteString clientCertificateBytes;

    public ServiceRequest(UaStackServer server, UaRequestMessage request, EndpointDescription endpoint, long secureChannelId, InetAddress clientAddress, @Nullable ByteString clientCertificateBytes) {
        this.server = server;
        this.request = request;
        this.endpoint = endpoint;
        this.secureChannelId = secureChannelId;
        this.clientAddress = clientAddress;
        this.clientCertificateBytes = clientCertificateBytes;
        this.future.whenComplete(this::updateDiagnosticCounters);
    }

    public UaStackServer getServer() {
        return this.server;
    }

    public EndpointDescription getEndpoint() {
        return this.endpoint;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    @Nullable
    public ByteString getClientCertificateBytes() {
        return this.clientCertificateBytes;
    }

    public long getSecureChannelId() {
        return this.secureChannelId;
    }

    public UaRequestMessage getRequest() {
        return this.request;
    }

    public CompletableFuture<UaResponseMessage> getFuture() {
        return this.future;
    }

    public long getReceivedAtNanos() {
        return this.receivedAtNanos;
    }

    public void setResponse(UaResponseMessage response) {
        this.future.complete(response);
    }

    public void setServiceFault(UaException exception) {
        this.future.completeExceptionally(exception);
    }

    public void setServiceFault(long statusCode) {
        this.setServiceFault(new StatusCode(statusCode));
    }

    public void setServiceFault(StatusCode statusCode) {
        this.future.completeExceptionally(new UaException(statusCode, "ServiceFault"));
    }

    public ResponseHeader createResponseHeader() {
        return this.createResponseHeader(StatusCode.GOOD);
    }

    public ResponseHeader createResponseHeader(long statusCode) {
        return this.createResponseHeader(new StatusCode(statusCode));
    }

    public ResponseHeader createResponseHeader(StatusCode serviceResult) {
        return new ResponseHeader(DateTime.now(), this.request.getRequestHeader().getRequestHandle(), serviceResult, null, null, null);
    }

    public ServiceFault createServiceFault(long statusCode) {
        ResponseHeader responseHeader = new ResponseHeader(DateTime.now(), this.request.getRequestHeader().getRequestHandle(), new StatusCode(statusCode), null, null, null);
        return new ServiceFault(responseHeader);
    }

    public ServiceFault createServiceFault(Throwable throwable) {
        UaException exception = throwable instanceof UaException ? (UaException)throwable : new UaException(throwable);
        ResponseHeader responseHeader = new ResponseHeader(DateTime.now(), this.request.getRequestHeader().getRequestHandle(), exception.getStatusCode(), null, null, null);
        return new ServiceFault(responseHeader);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("request", (Object)this.request.getClass().getSimpleName()).toString();
    }

    private void updateDiagnosticCounters(@Nullable UaResponseMessage r, @Nullable Throwable ex) {
        if (ex != null) {
            StatusCode statusCode = UaException.extractStatusCode((Throwable)ex).orElse(new StatusCode(0x80020000L));
            if (statusCode.isSecurityError()) {
                this.server.getSecurityRejectedRequestCount().increment();
            }
            this.server.getRejectedRequestCount().increment();
        }
    }
}

