/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ExpathCryptoModule {
    public static final Properties libProperties = new Properties();
    public static final String NAMESPACE_URI = "http://expath.org/ns/crypto";
    public static final String PREFIX = "crypto";
    public static final String VERSION;
    public static final String MODULE_DESCRIPTION = "A module for providing cryptographic services.";
    public static final String MODULE_NAME = "EXPath Cryptographic";
    public static final Map<String, String> javaStandardAlgorithmNames;
    public static final String canonicalization_algorithm = "The canonicalization algorithm applied to the SignedInfo element prior to performing signature calculations. Possible values are: 'exclusive', 'exclusive-with-comments', 'inclusive', and 'inclusive-with-comments'. The default value is 'inclusive-with-comments'.";
    public static final String DIGEST_ALGORITHM = "The digest algorithm to be applied to the signed object. Possible values are: 'SHA1', 'SHA256', and 'SHA512'. The default value is 'SHA1'.";
    public static final String SIGNATURE_ALGORITHM = "The algorithm used for signature generation and validation. Possible values are: 'DSA_SHA1', and 'RSA_SHA1'. The default value is 'RSA_SHA1'.";
    public static final String SIGNATURE_TYPE = "The method used for signing the content of signature. Possible values are: 'enveloping', 'enveloped', and 'detached'. The default value is 'enveloped'.";
    public static final String digitalCertificateDetailsDescription = "Details about the digital certificate to be used for signing the input document or document subset. The structure of this parameter is as follows (this is an example): <digital-certificate><keystore-type>JKS</keystore-type><keystore-password>ab987c</keystore-password><key-alias>eXist</key-alias><private-key-password>kpi135</private-key-password><keystore-uri>/db/mykeystoreEXist.ks</keystore-uri></digital-certificate>.";

    static {
        try (InputStream propertiesIs = ExpathCryptoModule.class.getResourceAsStream("lib.properties");){
            libProperties.load(propertiesIs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        VERSION = libProperties.getProperty("lib-version");
        javaStandardAlgorithmNames = new HashMap<String, String>();
        javaStandardAlgorithmNames.put("HMAC-MD5", "HmacMD5");
        javaStandardAlgorithmNames.put("HMAC-SHA-1", "HmacSHA1");
        javaStandardAlgorithmNames.put("HMAC-SHA-256", "HmacSHA256");
        javaStandardAlgorithmNames.put("HMAC-SHA-384", "HmacSHA384");
        javaStandardAlgorithmNames.put("HMAC-SHA-512", "HmacSHA512");
    }
}

