/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.digest;

import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.kuberam.libs.java.crypto.CryptoException;
import ro.kuberam.libs.java.crypto.ExpathCryptoModule;

public class Hmac {
    private static final Logger LOG = LoggerFactory.getLogger(Hmac.class);

    public static String hmac(byte[] data, byte[] secretKey, String algorithm, @Nullable String format) throws CryptoException {
        String actualFormat = Optional.ofNullable(format).filter(str -> !str.isEmpty()).orElse("base64");
        LOG.debug("secretKey = {}", (Object)secretKey);
        byte[] resultBytes = Hmac.hmac(data, secretKey, algorithm);
        String result = actualFormat.equals("base64") ? Base64.getEncoder().encodeToString(resultBytes) : DatatypeConverter.printHexBinary((byte[])resultBytes).toLowerCase();
        LOG.debug("result = {}", (Object)result);
        return result;
    }

    public static String hmac(InputStream data, byte[] secretKey, String algorithm, @Nullable String format) throws CryptoException, IOException {
        String actualFormat = Optional.ofNullable(format).filter(str -> !str.isEmpty()).orElse("base64");
        LOG.debug("secretKey = {}", (Object)secretKey);
        byte[] resultBytes = Hmac.hmac(data, secretKey, algorithm);
        String result = actualFormat.equals("base64") ? Base64.getEncoder().encodeToString(resultBytes) : DatatypeConverter.printHexBinary((byte[])resultBytes).toLowerCase();
        LOG.debug("result = {}", (Object)result);
        return result;
    }

    public static byte[] hmac(byte[] data, byte[] secretKey, String algorithm) throws CryptoException {
        Map<String, String> javaStandardAlgorithmNames = ExpathCryptoModule.javaStandardAlgorithmNames;
        if (javaStandardAlgorithmNames.containsKey(algorithm)) {
            algorithm = javaStandardAlgorithmNames.get(algorithm);
        }
        SecretKeySpec signingKey = new SecretKeySpec(secretKey, algorithm);
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(signingKey);
            return mac.doFinal(data);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw CryptoException.fromCause(e);
        }
    }

    public static byte[] hmac(InputStream data, byte[] secretKey, String algorithm) throws CryptoException, IOException {
        Map<String, String> javaStandardAlgorithmNames = ExpathCryptoModule.javaStandardAlgorithmNames;
        if (javaStandardAlgorithmNames.containsKey(algorithm)) {
            algorithm = javaStandardAlgorithmNames.get(algorithm);
        }
        SecretKeySpec signingKey = new SecretKeySpec(secretKey, algorithm);
        try {
            Mac mac = Mac.getInstance(algorithm);
            mac.init(signingKey);
            byte[] buf = new byte[16384];
            int read = -1;
            while ((read = data.read(buf)) > -1) {
                mac.update(buf, 0, read);
            }
            return mac.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw CryptoException.fromCause(e);
        }
    }
}

