/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.digitalSignature;

import java.io.IOException;
import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ro.kuberam.libs.java.crypto.CryptoException;

public class ValidateXmlSignature {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateXmlSignature.class);

    public static Boolean validate(Document inputDoc) throws CryptoException, IOException, XMLSignatureException {
        LOG.debug("Claudius test: {}", (Object)inputDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").getLength());
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            XPathExpression expr = xpath.compile("//*[local-name() = 'Signature' and namespace-uri() = 'http://www.w3.org/2000/09/xmldsig#']");
            Node nl = (Node)expr.evaluate(inputDoc, XPathConstants.NODE);
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            LOG.debug("Claudius test: {}", (Object)nl.getNodeName());
            DOMValidateContext valContext = new DOMValidateContext(new KeyValueKeySelector(), nl);
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            boolean coreValidity = signature.validate(valContext);
            if (!coreValidity) {
                System.err.println("Signature failed core validation");
                boolean sv = signature.getSignatureValue().validate(valContext);
                System.out.println("signature validation status: " + sv);
                Iterator<Reference> iterator = signature.getSignedInfo().getReferences().iterator();
                int j = 0;
                while (iterator.hasNext()) {
                    boolean refValid = iterator.next().validate(valContext);
                    System.out.println("ref[" + j + "] validity status: " + refValid);
                    ++j;
                }
            }
            return coreValidity;
        }
        catch (MarshalException | XPathExpressionException e) {
            throw new IOException(e);
        }
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private PublicKey pk;

        SimpleKeySelectorResult(PublicKey pk) {
            this.pk = pk;
        }

        @Override
        public Key getKey() {
            return this.pk;
        }
    }

    private static class KeyValueKeySelector
    extends KeySelector {
        private KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("Null KeyInfo object!");
            }
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                XMLStructure xmlStructure = list.get(i);
                if (!(xmlStructure instanceof KeyValue)) continue;
                PublicKey pk = null;
                try {
                    pk = ((KeyValue)xmlStructure).getPublicKey();
                }
                catch (KeyException ke) {
                    throw new KeySelectorException(ke);
                }
                if (!KeyValueKeySelector.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                return new SimpleKeySelectorResult(pk);
            }
            throw new KeySelectorException("No KeyValue element found!");
        }

        static boolean algEquals(String algURI, String algName) {
            if (algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                return true;
            }
            return algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

