/*
 * Decompiled with CFR 0.152.
 */
package ro.kuberam.libs.java.crypto.toDo;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Rfc2898DeriveBytes {
    private final Mac _hmacSha1;
    private final byte[] _salt;
    private final int _iterationCount;
    private byte[] _buffer = new byte[20];
    private int _bufferStartIndex = 0;
    private int _bufferEndIndex = 0;
    private int _block = 1;

    public Rfc2898DeriveBytes(byte[] password, byte[] salt, int iterations) throws NoSuchAlgorithmException, InvalidKeyException {
        if (salt == null || salt.length < 8) {
            throw new InvalidKeyException("Salt must be 8 bytes or more.");
        }
        if (password == null) {
            throw new InvalidKeyException("Password cannot be null.");
        }
        this._salt = salt;
        this._iterationCount = iterations;
        this._hmacSha1 = Mac.getInstance("HmacSHA1");
        this._hmacSha1.init(new SecretKeySpec(password, "HmacSHA1"));
    }

    public Rfc2898DeriveBytes(String password, byte[] salt, int iterations) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException {
        this(password.getBytes(StandardCharsets.UTF_8), salt, iterations);
    }

    public Rfc2898DeriveBytes(String password, byte[] salt) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException {
        this(password, salt, 1000);
    }

    public byte[] getBytes(int count) {
        byte[] result = new byte[count];
        int resultOffset = 0;
        int bufferCount = this._bufferEndIndex - this._bufferStartIndex;
        if (bufferCount > 0) {
            if (count < bufferCount) {
                System.arraycopy(this._buffer, this._bufferStartIndex, result, 0, count);
                this._bufferStartIndex += count;
                return result;
            }
            System.arraycopy(this._buffer, this._bufferStartIndex, result, 0, bufferCount);
            this._bufferEndIndex = 0;
            this._bufferStartIndex = 0;
            resultOffset += bufferCount;
        }
        while (resultOffset < count) {
            int needCount = count - resultOffset;
            this._buffer = this.func();
            if (needCount > 20) {
                System.arraycopy(this._buffer, 0, result, resultOffset, 20);
                resultOffset += 20;
                continue;
            }
            System.arraycopy(this._buffer, 0, result, resultOffset, needCount);
            this._bufferStartIndex = needCount;
            this._bufferEndIndex = 20;
            return result;
        }
        return result;
    }

    private byte[] func() {
        this._hmacSha1.update(this._salt, 0, this._salt.length);
        byte[] tempHash = this._hmacSha1.doFinal(Rfc2898DeriveBytes.getBytesFromInt(this._block));
        this._hmacSha1.reset();
        byte[] finalHash = tempHash;
        for (int i = 2; i <= this._iterationCount; ++i) {
            tempHash = this._hmacSha1.doFinal(tempHash);
            for (int j = 0; j < 20; ++j) {
                finalHash[j] = (byte)(finalHash[j] ^ tempHash[j]);
            }
        }
        this._block = this._block == Integer.MAX_VALUE ? Integer.MIN_VALUE : ++this._block;
        return finalHash;
    }

    private static byte[] getBytesFromInt(int i) {
        return new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
    }
}

